/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.launcher.tagexpression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.internal.impldep.org.junit.platform.launcher.tagexpression.Token;

class Tokenizer {
    Tokenizer() {
    }

    List<Token> tokenize(String infixTagExpression) {
        if (infixTagExpression == null) {
            return Collections.emptyList();
        }
        return this.deriveTokensFrom(infixTagExpression, this.trimmedTokenStringsFrom(infixTagExpression));
    }

    private List<String> trimmedTokenStringsFrom(String infixTagExpression) {
        String[] parts = infixTagExpression.replaceAll("([()!|&])", " $1 ").split("\\s");
        return Arrays.stream(parts).filter(part -> !part.isEmpty()).collect(Collectors.toList());
    }

    private List<Token> deriveTokensFrom(String infixTagExpression, List<String> trimmedTokens) {
        int startIndex = 0;
        ArrayList<Token> tokens = new ArrayList<Token>(trimmedTokens.size());
        for (String trimmedToken : trimmedTokens) {
            Token token = this.extractTokenStartingAt(infixTagExpression, startIndex, trimmedToken);
            startIndex = token.endIndexExclusive();
            tokens.add(token);
        }
        return tokens;
    }

    private Token extractTokenStartingAt(String infixTagExpression, int startIndex, String trimmedToken) {
        int foundAt = infixTagExpression.indexOf(trimmedToken, startIndex);
        int endIndex = foundAt + trimmedToken.length();
        String rawToken = infixTagExpression.substring(startIndex, endIndex);
        return new Token(startIndex, rawToken);
    }
}

