/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.launcher.core;

import java.util.ArrayDeque;
import java.util.HashSet;
import org.gradle.internal.impldep.org.junit.platform.commons.util.Preconditions;
import org.gradle.internal.impldep.org.junit.platform.engine.TestDescriptor;
import org.gradle.internal.impldep.org.junit.platform.engine.TestEngine;
import org.gradle.internal.impldep.org.junit.platform.engine.UniqueId;

class EngineDiscoveryResultValidator {
    EngineDiscoveryResultValidator() {
    }

    void validate(TestEngine testEngine, TestDescriptor root) {
        Preconditions.notNull(root, () -> String.format("The discover() method for TestEngine with ID '%s' must return a non-null root TestDescriptor.", testEngine.getId()));
        Preconditions.condition(this.isAcyclic(root), () -> String.format("The discover() method for TestEngine with ID '%s' returned a cyclic graph.", testEngine.getId()));
    }

    boolean isAcyclic(TestDescriptor root) {
        HashSet<UniqueId> visited = new HashSet<UniqueId>();
        visited.add(root.getUniqueId());
        ArrayDeque<TestDescriptor> queue = new ArrayDeque<TestDescriptor>();
        queue.add(root);
        while (!queue.isEmpty()) {
            for (TestDescriptor testDescriptor : ((TestDescriptor)queue.remove()).getChildren()) {
                if (!visited.add(testDescriptor.getUniqueId())) {
                    return false;
                }
                if (!testDescriptor.isContainer()) continue;
                queue.add(testDescriptor);
            }
        }
        return true;
    }
}

