/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImplUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HintHint;
import com.intellij.util.SmartList;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubstitutionShortInfoHandler
implements DocumentListener,
EditorMouseMotionListener,
CaretListener {
    private static final Key<SubstitutionShortInfoHandler> LISTENER_KEY = Key.create((String)"sslistener.key");
    private static final TooltipGroup SS_INFO_TOOLTIP_GROUP = new TooltipGroup("SS_INFO_TOOLTIP_GROUP", 0);
    private long modificationTimeStamp;
    private final List<String> variables;
    private final Editor editor;
    private final boolean myCanBeReplace;
    @Nullable
    private final Consumer<? super String> myCurrentVariableCallback;
    public static final Key<Configuration> CURRENT_CONFIGURATION_KEY = Key.create((String)"SS.CurrentConfiguration");
    private final Map<String, Inlay<FilterRenderer>> inlays;

    private SubstitutionShortInfoHandler(@NotNull Editor _editor, boolean canBeReplace, @Nullable Consumer<? super String> currentVariableCallback) {
        if (_editor == null) {
            SubstitutionShortInfoHandler.$$$reportNull$$$0(0);
        }
        this.variables = new SmartList();
        this.inlays = new HashMap<String, Inlay<FilterRenderer>>();
        this.editor = _editor;
        this.myCanBeReplace = canBeReplace;
        this.myCurrentVariableCallback = currentVariableCallback;
    }

    public void mouseMoved(@NotNull EditorMouseEvent e) {
        if (e == null) {
            SubstitutionShortInfoHandler.$$$reportNull$$$0(1);
        }
        LogicalPosition position = this.editor.xyToLogicalPosition(e.getMouseEvent().getPoint());
        this.handleInputFocusMovement(position, false);
    }

    private void handleInputFocusMovement(LogicalPosition position, boolean caret) {
        String currentVariableName;
        Configuration configuration = (Configuration)this.editor.getUserData(CURRENT_CONFIGURATION_KEY);
        if (configuration == null) {
            return;
        }
        Document document = this.editor.getDocument();
        int lineCount = document.getLineCount();
        if (position.line >= lineCount) {
            return;
        }
        int lineStart = document.getLineStartOffset(position.line);
        int lineEnd = document.getLineEndOffset(position.line);
        CharSequence patternText = document.getCharsSequence().subSequence(lineStart, lineEnd);
        TextRange variableRange = TemplateImplUtil.findVariableAtOffset((CharSequence)patternText, (int)position.column);
        if (variableRange == null) {
            if (caret) {
                if (this.myCurrentVariableCallback != null) {
                    this.myCurrentVariableCallback.accept("__context__");
                }
                configuration.setCurrentVariableName("__context__");
            }
            return;
        }
        String variableName = variableRange.subSequence(patternText).toString();
        NamedScriptableDefinition variable = configuration.findVariable(variableName);
        String filterText = StringUtil.escapeXmlEntities((String)SubstitutionShortInfoHandler.getShortParamString(variable, false));
        if (!this.editor.isViewer() && !variableName.equals(configuration.getCurrentVariableName())) {
            filterText = SubstitutionShortInfoHandler.appendLinkText(filterText, variableName);
        }
        boolean replacementVariable = variable instanceof ReplacementVariableDefinition || this.myCanBeReplace && variable == null && configuration instanceof ReplaceConfiguration;
        String string = currentVariableName = replacementVariable ? variableName + "$replacement" : variableName;
        if (caret) {
            if (this.myCurrentVariableCallback != null) {
                this.myCurrentVariableCallback.accept(currentVariableName);
            }
            configuration.setCurrentVariableName(currentVariableName);
        }
        if (!filterText.isEmpty()) {
            LogicalPosition toolTipPosition = new LogicalPosition(position.line, variableRange.getStartOffset() + (variableRange.getEndOffset() - variableRange.getStartOffset() >> 1));
            SubstitutionShortInfoHandler.showTooltip(this.editor, toolTipPosition, filterText);
        }
    }

    @NotNull
    static String appendLinkText(String text, String variableName) {
        String linkColor = ColorUtil.toHtmlColor((Color)JBUI.CurrentTheme.Link.linkColor());
        String string = text + "<br><a style=\"color:" + linkColor + "\" href=\"#ssr_edit_filters/" + variableName + "\">Edit filters</a>";
        if (string == null) {
            SubstitutionShortInfoHandler.$$$reportNull$$$0(2);
        }
        return string;
    }

    private void checkModelValidity() {
        Document document = this.editor.getDocument();
        if (this.modificationTimeStamp != document.getModificationStamp()) {
            this.variables.clear();
            this.variables.addAll(TemplateImplUtil.parseVariableNames((CharSequence)document.getCharsSequence()));
            this.modificationTimeStamp = document.getModificationStamp();
            this.updateEditorInlays();
        }
    }

    public void caretPositionChanged(@NotNull CaretEvent e) {
        if (e == null) {
            SubstitutionShortInfoHandler.$$$reportNull$$$0(3);
        }
        this.handleInputFocusMovement(e.getNewPosition(), true);
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        if (event == null) {
            SubstitutionShortInfoHandler.$$$reportNull$$$0(4);
        }
        if (event.getOldLength() == event.getNewLength()) {
            return;
        }
        this.handleInputFocusMovement(this.editor.getCaretModel().getLogicalPosition(), true);
        this.updateEditorInlays();
    }

    public List<String> getVariables() {
        this.checkModelValidity();
        return this.variables;
    }

    @NotNull
    static String getShortParamString(NamedScriptableDefinition namedScriptableDefinition, boolean verbose) {
        String script;
        if (namedScriptableDefinition == null) {
            return verbose ? SSRBundle.message("no.constraints.specified.tooltip.message", new Object[0]) : "";
        }
        StringBuilder buf = new StringBuilder();
        if (namedScriptableDefinition instanceof MatchVariableConstraint) {
            MatchVariableConstraint constraint = (MatchVariableConstraint)namedScriptableDefinition;
            String name = constraint.getName();
            if (!"__context__".equals(name)) {
                int maxCount = constraint.getMaxCount();
                int minCount = constraint.getMinCount();
                if (verbose || minCount != 1 || maxCount != 1) {
                    SubstitutionShortInfoHandler.append(buf, SSRBundle.message("min.occurs.tooltip.message", minCount, maxCount == Integer.MAX_VALUE ? "\u221e" : Integer.valueOf(maxCount)));
                }
            }
            if (constraint.isPartOfSearchResults() && verbose) {
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("target.tooltip.message", new Object[0]));
            }
            if (!constraint.getRegExp().isEmpty()) {
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("text.tooltip.message", constraint.isInvertRegExp() ? 1 : 0, constraint.getRegExp(), constraint.isWholeWordsOnly() ? 1 : 0, constraint.isWithinHierarchy() ? 1 : 0));
            } else if (constraint.isWithinHierarchy()) {
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("hierarchy.tooltip.message", new Object[0]));
            }
            if (!StringUtil.isEmpty((String)constraint.getReferenceConstraint())) {
                String text = StringUtil.unquoteString((String)constraint.getReferenceConstraint());
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("reference.target.tooltip.message", constraint.isInvertReference() ? 1 : 0, text));
            }
            if (!constraint.getNameOfExprType().isEmpty()) {
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("exprtype.tooltip.message", constraint.isInvertExprType() ? 1 : 0, constraint.isRegexExprType() ? constraint.getNameOfExprType() : constraint.getExpressionTypes(), constraint.isExprTypeWithinHierarchy() ? 1 : 0));
            }
            if (!constraint.getNameOfFormalArgType().isEmpty()) {
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("expected.type.tooltip.message", constraint.isInvertFormalType() ? 1 : 0, constraint.isRegexFormalType() ? constraint.getNameOfFormalArgType() : constraint.getExpectedTypes(), constraint.isFormalArgTypeWithinHierarchy() ? 1 : 0));
            }
            if (StringUtil.isNotEmpty((String)constraint.getWithinConstraint())) {
                String text = StringUtil.unquoteString((String)constraint.getWithinConstraint());
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("within.constraints.tooltip.message", constraint.isInvertWithinConstraint() ? 1 : 0, text));
            }
        }
        if ((script = namedScriptableDefinition.getScriptCodeConstraint()) != null && script.length() > 2) {
            SubstitutionShortInfoHandler.append(buf, SSRBundle.message("script.tooltip.message", new Object[0]));
        }
        if (buf.length() == 0 && verbose) {
            buf.append(SSRBundle.message("no.constraints.specified.tooltip.message", new Object[0]));
        }
        String string = buf.toString();
        if (string == null) {
            SubstitutionShortInfoHandler.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static void append(StringBuilder buf, String str) {
        if (buf.length() > 0) {
            buf.append(", ");
        }
        buf.append(str);
    }

    private static void showTooltip(@NotNull Editor editor, LogicalPosition position, @NotNull String text) {
        if (editor == null) {
            SubstitutionShortInfoHandler.$$$reportNull$$$0(6);
        }
        if (text == null) {
            SubstitutionShortInfoHandler.$$$reportNull$$$0(7);
        }
        if (Registry.is((String)"ssr.use.editor.inlays.instead.of.tool.tips")) {
            return;
        }
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        Point point = editor.logicalPositionToXY(position);
        point.y += editor.getLineHeight();
        Point p = SwingUtilities.convertPoint(editor.getContentComponent(), point, editor.getComponent().getRootPane().getLayeredPane());
        HintHint hint = new HintHint(editor, point).setAwtTooltip(true).setShowImmediately(true);
        TooltipController.getInstance().showTooltip(editor, p, text, visibleArea.width, false, SS_INFO_TOOLTIP_GROUP, hint);
    }

    static SubstitutionShortInfoHandler retrieve(Editor editor) {
        return editor == null ? null : (SubstitutionShortInfoHandler)editor.getUserData(LISTENER_KEY);
    }

    static void install(Editor editor, Disposable disposable) {
        SubstitutionShortInfoHandler.install(editor, null, disposable, false);
    }

    static void install(Editor editor, @Nullable Consumer<? super String> currentVariableCallback, Disposable disposable, boolean replace) {
        SubstitutionShortInfoHandler handler = new SubstitutionShortInfoHandler(editor, replace, currentVariableCallback);
        editor.addEditorMouseMotionListener((EditorMouseMotionListener)handler, disposable);
        editor.getDocument().addDocumentListener((DocumentListener)handler, disposable);
        editor.getCaretModel().addCaretListener((CaretListener)handler, disposable);
        editor.putUserData(LISTENER_KEY, (Object)handler);
    }

    static void updateEditorInlays(Editor editor) {
        SubstitutionShortInfoHandler handler = SubstitutionShortInfoHandler.retrieve(editor);
        if (handler != null) {
            handler.updateEditorInlays();
        }
    }

    void updateEditorInlays() {
        if (!Registry.is((String)"ssr.use.editor.inlays.instead.of.tool.tips")) {
            return;
        }
        String text = this.editor.getDocument().getText();
        Template template = TemplateManager.getInstance((Project)this.editor.getProject()).createTemplate("", "", text);
        int segmentsCount = template.getSegmentsCount();
        InlayModel inlayModel = this.editor.getInlayModel();
        HashSet<String> variables = new HashSet<String>(this.inlays.keySet());
        Configuration configuration = (Configuration)this.editor.getUserData(CURRENT_CONFIGURATION_KEY);
        if (configuration == null) {
            return;
        }
        int variableNameLength = 0;
        for (int i = 0; i < segmentsCount; ++i) {
            int offset = template.getSegmentOffset(i);
            String name = template.getSegmentName(i);
            variableNameLength += name.length() + 2;
            NamedScriptableDefinition namedScriptableDefinition = configuration.findVariable(name);
            String labelText = SubstitutionShortInfoHandler.getShortParamString(namedScriptableDefinition, false);
            if (labelText.isEmpty()) continue;
            variables.remove(name);
            Inlay<FilterRenderer> inlay = this.inlays.get(name);
            if (inlay == null) {
                this.inlays.put(name, (Inlay<FilterRenderer>)inlayModel.addInlineElement(offset + variableNameLength, (EditorCustomElementRenderer)new FilterRenderer(labelText)));
                continue;
            }
            FilterRenderer renderer = (FilterRenderer)inlay.getRenderer();
            renderer.setText(labelText);
            inlay.update();
        }
        NamedScriptableDefinition contextVariable = configuration.findVariable("__context__");
        String labelText = SubstitutionShortInfoHandler.getShortParamString(contextVariable, false);
        if (!labelText.isEmpty()) {
            variables.remove("__context__");
            Inlay<FilterRenderer> inlay = this.inlays.get("__context__");
            if (inlay == null) {
                this.inlays.put("__context__", (Inlay<FilterRenderer>)inlayModel.addBlockElement(text.length() + variableNameLength, true, false, 0, (EditorCustomElementRenderer)new FilterRenderer("whole template: " + labelText)));
            } else {
                FilterRenderer filterRenderer = (FilterRenderer)inlay.getRenderer();
                filterRenderer.setText("whole template: " + labelText);
                inlay.update();
            }
        }
        for (String string : variables) {
            Disposer.dispose((Disposable)((Disposable)this.inlays.remove(string)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_editor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/SubstitutionShortInfoHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/SubstitutionShortInfoHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "appendLinkText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortParamString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "mouseMoved";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "caretPositionChanged";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showTooltip";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FilterRenderer
    implements EditorCustomElementRenderer {
        private String myText;

        FilterRenderer(String text) {
            this.myText = text;
        }

        public void setText(String text) {
            this.myText = text;
        }

        public int calcWidthInPixels(@NotNull Editor editor) {
            if (editor == null) {
                FilterRenderer.$$$reportNull$$$0(0);
            }
            return FilterRenderer.getFontMetrics(editor).stringWidth(this.myText) + 12;
        }

        private static Font getFont() {
            return UIManager.getFont("Label.font");
        }

        private static FontMetrics getFontMetrics(Editor editor) {
            return editor.getContentComponent().getFontMetrics(FilterRenderer.getFont());
        }

        public void paint(@NotNull Inlay inlay, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
            Color foregroundColor;
            Editor editor;
            TextAttributes attributes;
            if (inlay == null) {
                FilterRenderer.$$$reportNull$$$0(1);
            }
            if (g == null) {
                FilterRenderer.$$$reportNull$$$0(2);
            }
            if (r == null) {
                FilterRenderer.$$$reportNull$$$0(3);
            }
            if (textAttributes == null) {
                FilterRenderer.$$$reportNull$$$0(4);
            }
            if ((attributes = (editor = inlay.getEditor()).getColorsScheme().getAttributes(DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT)) == null) {
                return;
            }
            FontMetrics metrics = FilterRenderer.getFontMetrics(editor);
            Color backgroundColor = attributes.getBackgroundColor();
            if (backgroundColor != null) {
                GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
                GraphicsUtil.paintWithAlpha((Graphics)g, (float)0.55f);
                g.setColor(backgroundColor);
                g.fillRoundRect(r.x + 2, r.y, r.width - 4, r.height, 8, 8);
                config.restore();
            }
            if ((foregroundColor = attributes.getForegroundColor()) != null) {
                g.setColor(foregroundColor);
                g.setFont(FilterRenderer.getFont());
                g.drawString(this.myText, r.x + 6, r.y + metrics.getAscent());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inlay";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textAttributes";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/SubstitutionShortInfoHandler$FilterRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calcWidthInPixels";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

