/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.UUID;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class Configuration
implements JDOMExternalizable,
Comparable<Configuration> {
    @NonNls
    public static final String CONTEXT_VAR_NAME = "__context__";
    public static final Configuration[] EMPTY_ARRAY = new Configuration[0];
    @NonNls
    protected static final String NAME_ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String CREATED_ATTRIBUTE_NAME = "created";
    @NonNls
    private static final String UUID_ATTRIBUTE_NAME = "uuid";
    @NonNls
    private static final String DESCRIPTION_ATTRIBUTE_NAME = "description";
    @NonNls
    private static final String SUPPRESS_ID_ATTRIBUTE_NAME = "suppressId";
    @NonNls
    private static final String PROBLEM_DESCRIPTOR_ATTRIBUTE_NAME = "problemDescriptor";
    @NonNls
    private static final String ORDER_ATTRIBUTE_NAME = "order";
    private String name;
    private String category;
    private boolean predefined;
    private long created;
    private UUID uuid;
    private String description;
    private String suppressId;
    private String newSuppressId;
    private String problemDescriptor;
    private int order;
    private transient String myCurrentVariableName = null;

    public Configuration() {
        this.name = "";
        this.category = "";
        this.created = -1L;
    }

    public Configuration(String name, String category) {
        this.name = name;
        this.category = category;
        this.created = -1L;
    }

    protected Configuration(Configuration configuration) {
        this.name = configuration.name;
        this.category = configuration.category;
        this.created = -1L;
        this.predefined = false;
        this.uuid = configuration.uuid;
        this.description = configuration.description;
        this.newSuppressId = configuration.newSuppressId;
        this.suppressId = configuration.suppressId;
        this.problemDescriptor = configuration.problemDescriptor;
        this.order = configuration.order;
    }

    public abstract Configuration copy();

    public void initialize() {
        if (!StringUtil.equals((CharSequence)this.suppressId, (CharSequence)this.newSuppressId)) {
            String shortName = this.uuid.toString();
            HighlightDisplayKey.unregister((String)shortName);
            HighlightDisplayKey.register((String)this.uuid.toString(), (String)this.name, (String)this.newSuppressId);
            this.suppressId = this.newSuppressId;
        }
    }

    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            Configuration.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void setName(@NotNull String value) {
        if (value == null) {
            Configuration.$$$reportNull$$$0(1);
        }
        this.name = value;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(@NotNull String category) {
        if (category == null) {
            Configuration.$$$reportNull$$$0(2);
        }
        this.category = category;
    }

    public long getCreated() {
        return this.created;
    }

    public void setCreated(long created) {
        if (this.predefined) {
            throw new AssertionError();
        }
        this.created = created;
    }

    @NotNull
    public UUID getUuid() {
        if (this.uuid == null) {
            this.uuid = UUID.nameUUIDFromBytes(this.name.getBytes(StandardCharsets.UTF_8));
            if (this.uuid == null) {
                Configuration.$$$reportNull$$$0(3);
            }
            return this.uuid;
        }
        UUID uUID = this.uuid;
        if (uUID == null) {
            Configuration.$$$reportNull$$$0(4);
        }
        return uUID;
    }

    public void setUuidFromName() {
        this.uuid = UUID.nameUUIDFromBytes(this.name.getBytes(StandardCharsets.UTF_8));
    }

    public void setUuid(@NotNull UUID uuid) {
        if (uuid == null) {
            Configuration.$$$reportNull$$$0(5);
        }
        this.uuid = uuid;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSuppressId() {
        return this.suppressId;
    }

    public String getNewSuppressId() {
        return this.newSuppressId;
    }

    public void setSuppressId(String suppressId) {
        this.newSuppressId = suppressId;
    }

    public String getProblemDescriptor() {
        return this.problemDescriptor;
    }

    public void setProblemDescriptor(String problemDescriptor) {
        this.problemDescriptor = problemDescriptor;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        if (order < 0) {
            throw new IllegalArgumentException();
        }
        this.order = order;
    }

    public void readExternal(Element element) {
        Attribute mainAttribute;
        Attribute problemDescriptorAttribute;
        Attribute suppressIdAttribute;
        Attribute descriptionAttribute;
        Attribute uuidAttribute;
        this.name = element.getAttributeValue(NAME_ATTRIBUTE_NAME);
        Attribute createdAttribute = element.getAttribute(CREATED_ATTRIBUTE_NAME);
        if (createdAttribute != null) {
            try {
                this.created = createdAttribute.getLongValue();
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
        if ((uuidAttribute = element.getAttribute(UUID_ATTRIBUTE_NAME)) != null) {
            try {
                this.uuid = UUID.fromString(uuidAttribute.getValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((descriptionAttribute = element.getAttribute(DESCRIPTION_ATTRIBUTE_NAME)) != null) {
            this.description = descriptionAttribute.getValue();
        }
        if ((suppressIdAttribute = element.getAttribute(SUPPRESS_ID_ATTRIBUTE_NAME)) != null) {
            this.newSuppressId = this.suppressId = suppressIdAttribute.getValue();
        }
        if ((problemDescriptorAttribute = element.getAttribute(PROBLEM_DESCRIPTOR_ATTRIBUTE_NAME)) != null) {
            this.problemDescriptor = problemDescriptorAttribute.getValue();
        }
        if ((mainAttribute = element.getAttribute(ORDER_ATTRIBUTE_NAME)) != null) {
            try {
                this.order = Math.max(0, mainAttribute.getIntValue());
            }
            catch (DataConversionException dataConversionException) {
                // empty catch block
            }
        }
    }

    public void writeExternal(Element element) {
        element.setAttribute(NAME_ATTRIBUTE_NAME, this.name);
        if (this.created > 0L) {
            element.setAttribute(CREATED_ATTRIBUTE_NAME, String.valueOf(this.created));
        }
        if (this.uuid != null && !this.uuid.equals(UUID.nameUUIDFromBytes(this.name.getBytes(StandardCharsets.UTF_8)))) {
            element.setAttribute(UUID_ATTRIBUTE_NAME, this.uuid.toString());
        }
        if (!StringUtil.isEmpty((String)this.description)) {
            element.setAttribute(DESCRIPTION_ATTRIBUTE_NAME, this.description);
        }
        if (!StringUtil.isEmpty((String)this.newSuppressId)) {
            element.setAttribute(SUPPRESS_ID_ATTRIBUTE_NAME, this.newSuppressId);
        }
        if (!StringUtil.isEmpty((String)this.problemDescriptor)) {
            element.setAttribute(PROBLEM_DESCRIPTOR_ATTRIBUTE_NAME, this.problemDescriptor);
        }
        if (this.order != 0) {
            element.setAttribute(ORDER_ATTRIBUTE_NAME, String.valueOf(this.order));
        }
    }

    public boolean isPredefined() {
        return this.predefined;
    }

    public void setPredefined(boolean predefined) {
        this.predefined = predefined;
    }

    public abstract MatchOptions getMatchOptions();

    public ReplaceOptions getReplaceOptions() {
        return null;
    }

    public abstract NamedScriptableDefinition findVariable(String var1);

    public abstract void removeUnusedVariables();

    public String getCurrentVariableName() {
        return this.myCurrentVariableName;
    }

    public void setCurrentVariableName(String variableName) {
        this.myCurrentVariableName = variableName;
    }

    @Override
    public int compareTo(Configuration other) {
        int result = StringUtil.naturalCompare((String)this.getCategory(), (String)other.getCategory());
        return result != 0 ? result : StringUtil.naturalCompare((String)this.getName(), (String)other.getName());
    }

    public boolean equals(Object configuration) {
        if (!(configuration instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)configuration;
        return Objects.equals(this.category, other.category) && this.name.equals(other.name);
    }

    public int hashCode() {
        return 31 * this.name.hashCode() + (this.category != null ? this.category.hashCode() : 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/Configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = UUID_ATTRIBUTE_NAME;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/Configuration";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUuid";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setCategory";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setUuid";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

