/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.inspection;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ui.InspectionProfileActionProvider;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.inspection.StructuralSearchInspectionToolWrapper;
import com.intellij.structuralsearch.inspection.highlightTemplate.SSBasedInspection;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.StructuralSearchDialog;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ui.FormBuilder;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructuralSearchProfileActionProvider
extends InspectionProfileActionProvider {
    @NotNull
    public List<AnAction> getActions(SingleInspectionProfilePanel panel) {
        if (!Registry.is((String)"ssr.separate.inspections")) {
            List<AnAction> list = Collections.emptyList();
            if (list == null) {
                StructuralSearchProfileActionProvider.$$$reportNull$$$0(0);
            }
            return list;
        }
        InspectionProfileModifiableModel profile = panel.getProfile();
        for (ScopeToolState tool : profile.getAllTools()) {
            InspectionToolWrapper wrapper = tool.getTool();
            if (!(wrapper instanceof StructuralSearchInspectionToolWrapper)) continue;
            ((StructuralSearchInspectionToolWrapper)wrapper).setProfile((InspectionProfileImpl)profile);
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup(new AnAction[]{new AddTemplateAction(panel, false), new AddTemplateAction(panel, true)});
        actionGroup.setPopup(true);
        actionGroup.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)panel);
        Presentation presentation = actionGroup.getTemplatePresentation();
        presentation.setIcon(AllIcons.General.Add);
        presentation.setText(SSRBundle.messagePointer("add.inspection.button", new Object[0]));
        List<AnAction> list = Arrays.asList(new AnAction[]{actionGroup, new RemoveTemplateAction(panel)});
        if (list == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(1);
        }
        return list;
    }

    public static boolean createNewInspection(Configuration configuration, InspectionProfileImpl profile, Project project) {
        InspectionToolWrapper wrapper = profile.getInspectionTool("SSBasedInspection", project);
        assert (wrapper != null);
        SSBasedInspection inspection = (SSBasedInspection)wrapper.getTool();
        configuration.setUuidFromName();
        if (!StructuralSearchProfileActionProvider.saveInspection(project, inspection, configuration)) {
            return false;
        }
        StructuralSearchProfileActionProvider.addConfigurationToProfile(project, profile, configuration);
        profile.getProfileManager().fireProfileChanged(profile);
        return true;
    }

    private static void addConfigurationToProfile(@NotNull Project project, InspectionProfileImpl profile, Configuration configuration) {
        String shortName;
        InspectionToolWrapper toolWrapper;
        if (project == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(2);
        }
        if ((toolWrapper = profile.getInspectionTool(shortName = configuration.getUuid().toString(), project)) != null) {
            return;
        }
        StructuralSearchInspectionToolWrapper wrapped = new StructuralSearchInspectionToolWrapper(configuration, true);
        wrapped.setProfile(profile);
        profile.addTool(project, (InspectionToolWrapper)wrapped, null);
        profile.setToolEnabled(shortName, true);
    }

    public static boolean saveInspection(Project project, SSBasedInspection inspection, Configuration configuration) {
        InspectionDataDialog dialog = new InspectionDataDialog(project, inspection, configuration);
        boolean result = dialog.showAndGet();
        if (result) {
            inspection.removeConfiguration(configuration);
            String name = dialog.getName();
            for (Configuration c : inspection.getConfigurationsWithUuid(configuration.getUuid())) {
                c.setName(name);
            }
            configuration.setName(name);
            configuration.setDescription(dialog.getDescription());
            configuration.setSuppressId(dialog.getSuppressId());
            configuration.setProblemDescriptor(dialog.getProblemDescriptor());
            inspection.addConfiguration(configuration);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/inspection/StructuralSearchProfileActionProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/inspection/StructuralSearchProfileActionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addConfigurationToProfile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InspectionDataDialog
    extends DialogWrapper {
        private final Pattern mySuppressIdPattern = Pattern.compile("[a-zA-Z_0-9.-]+");
        private final SSBasedInspection myInspection;
        @NotNull
        private final Configuration myConfiguration;
        private final JTextField myNameTextField;
        private final JTextField myProblemDescriptorTextField;
        private final EditorTextField myDescriptionTextArea;
        private final JTextField mySuppressIdTextField;

        InspectionDataDialog(Project project, SSBasedInspection inspection, Configuration configuration) {
            super(null);
            this.myInspection = inspection;
            this.myConfiguration = configuration;
            this.myNameTextField = new JTextField(configuration.getName());
            this.myProblemDescriptorTextField = new JTextField(configuration.getProblemDescriptor());
            this.myDescriptionTextArea = new EditorTextField((String)ObjectUtils.notNull((Object)configuration.getDescription(), (Object)""), project, (FileType)StdFileTypes.HTML);
            this.myDescriptionTextArea.setOneLineMode(false);
            EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
            this.myDescriptionTextArea.setFont(scheme.getFont(EditorFontType.PLAIN));
            this.myDescriptionTextArea.setPreferredSize(new Dimension(375, 125));
            this.myDescriptionTextArea.setMinimumSize(new Dimension(200, 50));
            this.mySuppressIdTextField = new JTextField(configuration.getNewSuppressId());
            this.setTitle(SSRBundle.message("meta.data.dialog.title", new Object[0]));
            this.init();
        }

        @NotNull
        protected List<ValidationInfo> doValidateAll() {
            SmartList result = new SmartList();
            List<Configuration> configurations = this.myInspection.getConfigurations();
            String name = this.getName();
            if (StringUtil.isEmpty((String)name)) {
                result.add(new ValidationInfo(SSRBundle.message("name.must.not.be.empty.warning", new Object[0]), (JComponent)this.myNameTextField));
            } else {
                for (Configuration configuration : configurations) {
                    if (configuration.getOrder() != 0 || configuration.equals(this.myConfiguration) || !configuration.getName().equals(name)) continue;
                    result.add(new ValidationInfo(SSRBundle.message("inspection.with.name.exists.warning", name), (JComponent)this.myNameTextField));
                    break;
                }
            }
            String suppressId = this.getSuppressId();
            if (!StringUtil.isEmpty((String)suppressId)) {
                if (!this.mySuppressIdPattern.matcher(suppressId).matches()) {
                    result.add(new ValidationInfo(SSRBundle.message("suppress.id.must.match.regex.warning", new Object[0]), (JComponent)this.mySuppressIdTextField));
                } else {
                    HighlightDisplayKey key = HighlightDisplayKey.findById((String)suppressId);
                    if (key != null && key != HighlightDisplayKey.find((String)this.myConfiguration.getUuid().toString())) {
                        result.add(new ValidationInfo(SSRBundle.message("suppress.id.in.use.warning", suppressId), (JComponent)this.mySuppressIdTextField));
                    } else {
                        for (Configuration configuration : configurations) {
                            if (!suppressId.equals(configuration.getNewSuppressId()) || this.myConfiguration.getUuid().equals(configuration.getUuid())) continue;
                            result.add(new ValidationInfo(SSRBundle.message("suppress.id.in.use.warning", suppressId), (JComponent)this.mySuppressIdTextField));
                            break;
                        }
                    }
                }
            }
            SmartList smartList = result;
            if (smartList == null) {
                InspectionDataDialog.$$$reportNull$$$0(0);
            }
            return smartList;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return new FormBuilder().addLabeledComponent(SSRBundle.message("inspection.name.label", new Object[0]), (JComponent)this.myNameTextField, true).addLabeledComponent(SSRBundle.message("problem.descriptor.label", new Object[0]), (JComponent)this.myProblemDescriptorTextField, true).addLabeledComponentFillVertically(SSRBundle.message("description.label", new Object[0]), (JComponent)this.myDescriptionTextArea).addLabeledComponent(SSRBundle.message("suppress.id.label", new Object[0]), (JComponent)this.mySuppressIdTextField).getPanel();
        }

        public String getName() {
            return InspectionDataDialog.convertEmptyToNull(this.myNameTextField.getText().trim());
        }

        public String getDescription() {
            return InspectionDataDialog.convertEmptyToNull(this.myDescriptionTextArea.getText().trim());
        }

        public String getSuppressId() {
            return InspectionDataDialog.convertEmptyToNull(this.mySuppressIdTextField.getText().trim());
        }

        public String getProblemDescriptor() {
            return InspectionDataDialog.convertEmptyToNull(this.myProblemDescriptorTextField.getText().trim());
        }

        private static String convertEmptyToNull(String s) {
            return StringUtil.isEmpty((String)s) ? null : s;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/inspection/StructuralSearchProfileActionProvider$InspectionDataDialog", "doValidateAll"));
        }
    }

    private static class AddTemplateAction
    extends DumbAwareAction {
        private final SingleInspectionProfilePanel myPanel;
        private final boolean myReplace;

        private AddTemplateAction(SingleInspectionProfilePanel panel, boolean replace) {
            super(replace ? SSRBundle.message("SSRInspection.add.replace.template.button", new Object[0]) : SSRBundle.message("SSRInspection.add.search.template.button", new Object[0]));
            this.myPanel = panel;
            this.myReplace = replace;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            SearchContext context;
            StructuralSearchDialog dialog;
            if (e == null) {
                AddTemplateAction.$$$reportNull$$$0(0);
            }
            if (!(dialog = new StructuralSearchDialog(context = new SearchContext(e.getDataContext()), this.myReplace, true)).showAndGet()) {
                return;
            }
            InspectionProfileModifiableModel profile = this.myPanel.getProfile();
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            assert (project != null);
            Configuration configuration = dialog.getConfiguration();
            if (!StructuralSearchProfileActionProvider.createNewInspection(configuration, (InspectionProfileImpl)profile, project)) {
                return;
            }
            this.myPanel.selectInspectionTool(configuration.getUuid().toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/inspection/StructuralSearchProfileActionProvider$AddTemplateAction", "actionPerformed"));
        }
    }

    private static class RemoveTemplateAction
    extends DumbAwareAction {
        private final SingleInspectionProfilePanel myPanel;

        private RemoveTemplateAction(SingleInspectionProfilePanel panel) {
            super(SSRBundle.message("remove.inspection.button", new Object[0]), null, AllIcons.General.Remove);
            this.myPanel = panel;
            this.registerCustomShortcutSet(CommonShortcuts.getDelete(), (JComponent)this.myPanel);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveTemplateAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(this.myPanel.getSelectedTool() instanceof StructuralSearchInspectionToolWrapper);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveTemplateAction.$$$reportNull$$$0(1);
            }
            InspectionToolWrapper selectedTool = this.myPanel.getSelectedTool();
            String shortName = selectedTool.getShortName();
            this.myPanel.removeSelectedRow();
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            InspectionProfileModifiableModel profile = this.myPanel.getProfile();
            InspectionToolWrapper wrapper = profile.getInspectionTool("SSBasedInspection", project);
            assert (wrapper != null);
            SSBasedInspection inspection = (SSBasedInspection)wrapper.getTool();
            inspection.removeConfigurationWithUuid(UUID.fromString(shortName));
            profile.removeTool(shortName);
            profile.getProfileManager().fireProfileChanged((InspectionProfileImpl)profile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/structuralsearch/inspection/StructuralSearchProfileActionProvider$RemoveTemplateAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

