/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.dupLocator.iterators.ArrayBackedNodeIterator;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SimpleHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.strategies.MatchingStrategy;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class CompiledPattern {
    public static final Key<Object> HANDLER_KEY = Key.create((String)"ss.handler");
    private final Map<Object, MatchingHandler> handlers = new THashMap();
    private final MultiMap<String, PsiElement> variableNodes = MultiMap.createSmart();
    private SearchScope scope;
    private NodeIterator nodes;
    private MatchingStrategy strategy;
    private PsiElement targetNode;
    private int nodeCount;
    private PsiElement last;
    private MatchingHandler lastHandler;

    public abstract String @NotNull [] getTypedVarPrefixes();

    public abstract boolean isTypedVar(@NotNull String var1);

    public void setTargetNode(PsiElement element) {
        this.targetNode = element;
    }

    public PsiElement getTargetNode() {
        return this.targetNode;
    }

    public MatchingStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(MatchingStrategy strategy) {
        this.strategy = strategy;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public NodeIterator getNodes() {
        return this.nodes;
    }

    public void setNodes(@NotNull List<? extends PsiElement> elements) {
        if (elements == null) {
            CompiledPattern.$$$reportNull$$$0(0);
        }
        this.nodes = new ArrayBackedNodeIterator(PsiUtilCore.toPsiElementArray(elements));
        this.nodeCount = elements.size();
    }

    @Contract(value="null -> false")
    public boolean isTypedVar(PsiElement element) {
        return element != null && this.isTypedVar(element.getText());
    }

    public boolean isRealTypedVar(PsiElement element) {
        if (element == null || element.getTextLength() <= 0) {
            return false;
        }
        String str = this.getTypedVarString(element);
        return !str.isEmpty() && this.isTypedVar(str);
    }

    @NotNull
    public String getTypedVarString(@NotNull PsiElement element) {
        StructuralSearchProfile profile;
        if (element == null) {
            CompiledPattern.$$$reportNull$$$0(1);
        }
        String typedVarString = (profile = StructuralSearchUtil.getProfileByPsiElement(element)) == null ? element.getText() : profile.getTypedVarString(element);
        String string = typedVarString.trim();
        if (string == null) {
            CompiledPattern.$$$reportNull$$$0(2);
        }
        return string;
    }

    public MatchingHandler getHandlerSimple(@NotNull PsiElement node) {
        if (node == null) {
            CompiledPattern.$$$reportNull$$$0(3);
        }
        return this.handlers.get(node);
    }

    @NotNull
    public MatchingHandler getHandler(@NotNull PsiElement node) {
        if (node == null) {
            CompiledPattern.$$$reportNull$$$0(4);
        }
        if (node == this.last) {
            MatchingHandler matchingHandler = this.lastHandler;
            if (matchingHandler == null) {
                CompiledPattern.$$$reportNull$$$0(5);
            }
            return matchingHandler;
        }
        MatchingHandler handler = this.handlers.get(node);
        if (handler == null) {
            handler = new SimpleHandler();
            this.setHandler(node, handler);
        }
        this.last = node;
        this.lastHandler = handler;
        MatchingHandler matchingHandler = handler;
        if (matchingHandler == null) {
            CompiledPattern.$$$reportNull$$$0(6);
        }
        return matchingHandler;
    }

    public MatchingHandler getHandler(String name) {
        return this.handlers.get(name);
    }

    public void setHandler(PsiElement node, MatchingHandler handler) {
        this.last = null;
        this.handlers.put(node, handler);
    }

    @NotNull
    public SubstitutionHandler createSubstitutionHandler(@NotNull String name, @NotNull String compiledName, boolean target, int minOccurs, int maxOccurs, boolean greedy) {
        SubstitutionHandler handler;
        if (name == null) {
            CompiledPattern.$$$reportNull$$$0(7);
        }
        if (compiledName == null) {
            CompiledPattern.$$$reportNull$$$0(8);
        }
        if ((handler = (SubstitutionHandler)this.handlers.get(compiledName)) != null) {
            SubstitutionHandler substitutionHandler = handler;
            if (substitutionHandler == null) {
                CompiledPattern.$$$reportNull$$$0(9);
            }
            return substitutionHandler;
        }
        handler = this.doCreateSubstitutionHandler(name, target, minOccurs, maxOccurs, greedy);
        this.handlers.put(compiledName, handler);
        SubstitutionHandler substitutionHandler = handler;
        if (substitutionHandler == null) {
            CompiledPattern.$$$reportNull$$$0(10);
        }
        return substitutionHandler;
    }

    @NotNull
    protected SubstitutionHandler doCreateSubstitutionHandler(@NotNull String name, boolean target, int minOccurs, int maxOccurs, boolean greedy) {
        if (name == null) {
            CompiledPattern.$$$reportNull$$$0(11);
        }
        return new SubstitutionHandler(name, target, minOccurs, maxOccurs, greedy);
    }

    public SearchScope getScope() {
        return this.scope;
    }

    public void setScope(SearchScope scope) {
        this.scope = scope;
    }

    public void clearHandlers() {
        this.handlers.clear();
        this.last = null;
        this.lastHandler = null;
    }

    void clearHandlersState() {
        for (MatchingHandler h : this.handlers.values()) {
            if (h == null) continue;
            h.reset();
        }
    }

    public boolean isToResetHandler(@NotNull PsiElement element) {
        if (element == null) {
            CompiledPattern.$$$reportNull$$$0(12);
        }
        return true;
    }

    @NotNull
    public List<PsiElement> getVariableNodes(@NotNull String name) {
        Collection elements;
        if (name == null) {
            CompiledPattern.$$$reportNull$$$0(13);
        }
        return (elements = this.variableNodes.get((Object)name)) instanceof List ? (List)elements : new SmartList(elements);
    }

    public void putVariableNode(@NotNull String name, @NotNull PsiElement node) {
        if (name == null) {
            CompiledPattern.$$$reportNull$$$0(14);
        }
        if (node == null) {
            CompiledPattern.$$$reportNull$$$0(15);
        }
        this.variableNodes.putValue((Object)name, (Object)node);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/impl/matcher/CompiledPattern";
                break;
            }
            case 3: 
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiledName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/CompiledPattern";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypedVarString";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createSubstitutionHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setNodes";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTypedVarString";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getHandlerSimple";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createSubstitutionHandler";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doCreateSubstitutionHandler";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isToResetHandler";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getVariableNodes";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "putVariableNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

