/*
 * Decompiled with CFR 0.152.
 */
package git4idea.vfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsVFSListener;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.util.GitFileUtils;
import git4idea.util.GitVcsConsoleWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GitVFSListener
extends VcsVFSListener {
    private GitVFSListener(@NotNull GitVcs vcs) {
        if (vcs == null) {
            GitVFSListener.$$$reportNull$$$0(0);
        }
        super((AbstractVcs)vcs);
    }

    @NotNull
    public static GitVFSListener createInstance(@NotNull GitVcs vcs) {
        if (vcs == null) {
            GitVFSListener.$$$reportNull$$$0(1);
        }
        GitVFSListener listener = new GitVFSListener(vcs);
        listener.installListeners();
        GitVFSListener gitVFSListener = listener;
        if (gitVFSListener == null) {
            GitVFSListener.$$$reportNull$$$0(2);
        }
        return gitVFSListener;
    }

    @NotNull
    protected String getAddTitle() {
        String string = GitBundle.getString("vfs.listener.add.title");
        if (string == null) {
            GitVFSListener.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    protected String getSingleFileAddTitle() {
        String string = GitBundle.getString("vfs.listener.add.single.title");
        if (string == null) {
            GitVFSListener.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    protected String getSingleFileAddPromptTemplate() {
        String string = GitBundle.getString("vfs.listener.add.single.prompt");
        if (string == null) {
            GitVFSListener.$$$reportNull$$$0(5);
        }
        return string;
    }

    protected void executeAdd(@NotNull List<VirtualFile> addedFiles, @NotNull Map<VirtualFile, VirtualFile> copiedFiles) {
        if (addedFiles == null) {
            GitVFSListener.$$$reportNull$$$0(6);
        }
        if (copiedFiles == null) {
            GitVFSListener.$$$reportNull$$$0(7);
        }
        this.executeAddWithoutIgnores(addedFiles, copiedFiles, (notIgnoredAddedFiles, copiedFilesMap) -> this.originalExecuteAdd(notIgnoredAddedFiles, copiedFilesMap));
    }

    protected void executeAddWithoutIgnores(final @NotNull List<VirtualFile> addedFiles, final @NotNull Map<VirtualFile, VirtualFile> copyFromMap, final @NotNull VcsVFSListener.ExecuteAddCallback executeAddCallback) {
        if (addedFiles == null) {
            GitVFSListener.$$$reportNull$$$0(8);
        }
        if (copyFromMap == null) {
            GitVFSListener.$$$reportNull$$$0(9);
        }
        if (executeAddCallback == null) {
            GitVFSListener.$$$reportNull$$$0(10);
        }
        this.saveUnsavedVcsIgnoreFiles();
        ProgressManager progressManager = ProgressManager.getInstance();
        progressManager.run((Task)new Task.Backgroundable(this.myProject, GitBundle.getString("vfs.listener.checking.ignored"), true){

            public void run(@NotNull ProgressIndicator pi) {
                if (pi == null) {
                    1.$$$reportNull$$$0(0);
                }
                Map<VirtualFile, List<VirtualFile>> sortedFiles = GitUtil.sortFilesByGitRootIgnoringMissing(this.myProject, addedFiles);
                HashSet<VirtualFile> retainedFiles = new HashSet<VirtualFile>();
                for (Map.Entry<VirtualFile, List<VirtualFile>> e : sortedFiles.entrySet()) {
                    VirtualFile root = e.getKey();
                    List<VirtualFile> files = e.getValue();
                    pi.setText(root.getPresentableUrl());
                    try {
                        retainedFiles.addAll(Git.getInstance().untrackedFiles(this.myProject, root, files));
                    }
                    catch (VcsException ex) {
                        GitVcsConsoleWriter.getInstance(this.myProject).showMessage(ex.getMessage());
                    }
                }
                addedFiles.retainAll(retainedFiles);
                AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, () -> executeAddCallback.executeAdd(addedFiles, copyFromMap));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "git4idea/vfs/GitVFSListener$1", "run"));
            }
        });
    }

    private void originalExecuteAdd(List<VirtualFile> addedFiles, Map<VirtualFile, VirtualFile> copiedFiles) {
        super.executeAdd(addedFiles, copiedFiles);
    }

    protected void performAdding(@NotNull Collection<VirtualFile> addedFiles, @NotNull Map<VirtualFile, VirtualFile> copyFromMap) {
        if (addedFiles == null) {
            GitVFSListener.$$$reportNull$$$0(11);
        }
        if (copyFromMap == null) {
            GitVFSListener.$$$reportNull$$$0(12);
        }
        this.performAdding(ContainerUtil.map(addedFiles, VcsUtil::getFilePath));
    }

    private void performAdding(Collection<? extends FilePath> filesToAdd) {
        this.performBackgroundOperation(filesToAdd, GitBundle.getString("add.adding"), new LongOperationPerRootExecutor(){

            @Override
            public void execute(@NotNull VirtualFile root, @NotNull List<? extends FilePath> files) throws VcsException {
                if (root == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (files == null) {
                    2.$$$reportNull$$$0(1);
                }
                GitVFSListener.this.executeAdding(root, files);
                if (!GitVFSListener.this.myProject.isDisposed()) {
                    VcsFileUtil.markFilesDirty((Project)GitVFSListener.this.myProject, files);
                }
            }

            @Override
            public Collection<File> getFilesToRefresh() {
                return Collections.emptyList();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "root";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "files";
                        break;
                    }
                }
                objectArray[1] = "git4idea/vfs/GitVFSListener$2";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    protected String getDeleteTitle() {
        String string = GitBundle.getString("vfs.listener.delete.title");
        if (string == null) {
            GitVFSListener.$$$reportNull$$$0(13);
        }
        return string;
    }

    protected String getSingleFileDeleteTitle() {
        return GitBundle.getString("vfs.listener.delete.single.title");
    }

    protected String getSingleFileDeletePromptTemplate() {
        return GitBundle.getString("vfs.listener.delete.single.prompt");
    }

    protected void performDeletion(@NotNull List<FilePath> filesToDelete) {
        if (filesToDelete == null) {
            GitVFSListener.$$$reportNull$$$0(14);
        }
        this.performBackgroundOperation(filesToDelete, GitBundle.getString("remove.removing"), new LongOperationPerRootExecutor(){
            final Set<File> filesToRefresh = new HashSet<File>();

            @Override
            public void execute(@NotNull VirtualFile root, @NotNull List<? extends FilePath> files) throws VcsException {
                if (root == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (files == null) {
                    3.$$$reportNull$$$0(1);
                }
                this.filesToRefresh.addAll(GitVFSListener.this.executeDeletion(root, files));
                if (!GitVFSListener.this.myProject.isDisposed()) {
                    VcsFileUtil.markFilesDirty((Project)GitVFSListener.this.myProject, files);
                }
            }

            @Override
            public Collection<File> getFilesToRefresh() {
                return this.filesToRefresh;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "root";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "files";
                        break;
                    }
                }
                objectArray[1] = "git4idea/vfs/GitVFSListener$3";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    protected void performMoveRename(@NotNull List<VcsVFSListener.MovedFileInfo> movedFiles) {
        if (movedFiles == null) {
            GitVFSListener.$$$reportNull$$$0(15);
        }
        final ArrayList<FilePath> toAdd = new ArrayList<FilePath>();
        final ArrayList<FilePath> toRemove = new ArrayList<FilePath>();
        final ArrayList<VcsVFSListener.MovedFileInfo> toForceMove = new ArrayList<VcsVFSListener.MovedFileInfo>();
        for (VcsVFSListener.MovedFileInfo movedInfo : movedFiles) {
            String oldPath = movedInfo.myOldPath;
            String newPath = movedInfo.myNewPath;
            if (!SystemInfo.isFileSystemCaseSensitive && GitUtil.isCaseOnlyChange(oldPath, newPath)) {
                toForceMove.add(movedInfo);
                continue;
            }
            toRemove.add(VcsUtil.getFilePath((String)oldPath));
            toAdd.add(VcsUtil.getFilePath((String)newPath));
        }
        LOG.debug("performMoveRename. \ntoAdd: " + toAdd + "\ntoRemove: " + toRemove + "\ntoForceMove: " + toForceMove);
        GitVcs.runInBackground(new Task.Backgroundable(this.myProject, "Moving Files..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                try {
                    ArrayList<FilePath> dirtyPaths = new ArrayList<FilePath>();
                    ArrayList toRefresh = new ArrayList();
                    for (Map.Entry<VirtualFile, List<FilePath>> toAddEntry : GitUtil.sortFilePathsByGitRootIgnoringMissing(this.myProject, toAdd).entrySet()) {
                        List<FilePath> files = toAddEntry.getValue();
                        GitVFSListener.this.executeAdding(toAddEntry.getKey(), files);
                        dirtyPaths.addAll(files);
                    }
                    for (Map.Entry<VirtualFile, List<FilePath>> toRemoveEntry : GitUtil.sortFilePathsByGitRootIgnoringMissing(this.myProject, toRemove).entrySet()) {
                        List<FilePath> paths = toRemoveEntry.getValue();
                        toRefresh.addAll(GitVFSListener.this.executeDeletion(toRemoveEntry.getKey(), paths));
                        dirtyPaths.addAll(paths);
                    }
                    Map filesToForceMove = ContainerUtil.map2Map((Collection)toForceMove, info -> Pair.create((Object)VcsUtil.getFilePath((String)info.myNewPath), (Object)info));
                    dirtyPaths.addAll(ContainerUtil.map((Collection)toForceMove, fileInfo -> VcsUtil.getFilePath((String)fileInfo.myOldPath)));
                    for (Map.Entry<VirtualFile, List<FilePath>> toForceMoveEntry : GitUtil.sortFilePathsByGitRootIgnoringMissing(this.myProject, filesToForceMove.keySet()).entrySet()) {
                        List<FilePath> paths = toForceMoveEntry.getValue();
                        toRefresh.addAll(GitVFSListener.this.executeForceMove(toForceMoveEntry.getKey(), paths, filesToForceMove));
                        dirtyPaths.addAll(paths);
                    }
                    VcsFileUtil.markFilesDirty((Project)this.myProject, dirtyPaths);
                    RefreshVFsSynchronously.refreshFiles(toRefresh);
                }
                catch (VcsException ex) {
                    GitVcsConsoleWriter.getInstance(this.myProject).showMessage(ex.getMessage());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/vfs/GitVFSListener$4", "run"));
            }
        });
    }

    private void executeAdding(@NotNull VirtualFile root, @NotNull List<? extends FilePath> files) throws VcsException {
        if (root == null) {
            GitVFSListener.$$$reportNull$$$0(16);
        }
        if (files == null) {
            GitVFSListener.$$$reportNull$$$0(17);
        }
        LOG.debug("Git: adding files: " + files);
        GitFileUtils.addPaths(this.myProject, root, files, false, false);
    }

    private Set<File> executeDeletion(@NotNull VirtualFile root, @NotNull List<? extends FilePath> files) throws VcsException {
        if (root == null) {
            GitVFSListener.$$$reportNull$$$0(18);
        }
        if (files == null) {
            GitVFSListener.$$$reportNull$$$0(19);
        }
        GitFileUtils.deletePaths(this.myProject, root, files, "--ignore-unmatch", "--cached", "-r");
        HashSet<File> filesToRefresh = new HashSet<File>();
        File rootFile = new File(root.getPath());
        for (FilePath filePath : files) {
            for (File f = filePath.getIOFile(); f != null && !FileUtil.filesEqual((File)f, (File)rootFile); f = f.getParentFile()) {
                filesToRefresh.add(f);
            }
        }
        return filesToRefresh;
    }

    private Set<File> executeForceMove(@NotNull VirtualFile root, @NotNull List<? extends FilePath> files, @NotNull Map<FilePath, VcsVFSListener.MovedFileInfo> filesToMove) {
        if (root == null) {
            GitVFSListener.$$$reportNull$$$0(20);
        }
        if (files == null) {
            GitVFSListener.$$$reportNull$$$0(21);
        }
        if (filesToMove == null) {
            GitVFSListener.$$$reportNull$$$0(22);
        }
        HashSet<File> toRefresh = new HashSet<File>();
        for (FilePath filePath : files) {
            VcsVFSListener.MovedFileInfo info = filesToMove.get(filePath);
            GitLineHandler h = new GitLineHandler(this.myProject, root, GitCommand.MV);
            h.addParameters("-f");
            h.addRelativePaths(VcsUtil.getFilePath((String)info.myOldPath), VcsUtil.getFilePath((String)info.myNewPath));
            Git.getInstance().runCommand(h);
            toRefresh.add(new File(info.myOldPath));
            toRefresh.add(new File(info.myNewPath));
        }
        return toRefresh;
    }

    protected boolean isDirectoryVersioningSupported() {
        return false;
    }

    protected boolean isRecursiveDeleteSupported() {
        return true;
    }

    protected boolean isFileCopyingFromTrackingSupported() {
        return false;
    }

    protected Collection<FilePath> selectFilePathsToDelete(@NotNull List<FilePath> deletedFiles) {
        if (deletedFiles == null) {
            GitVFSListener.$$$reportNull$$$0(23);
        }
        return deletedFiles;
    }

    private void performBackgroundOperation(@NotNull Collection<? extends FilePath> files, @NotNull String operationTitle, final @NotNull LongOperationPerRootExecutor executor) {
        if (files == null) {
            GitVFSListener.$$$reportNull$$$0(24);
        }
        if (operationTitle == null) {
            GitVFSListener.$$$reportNull$$$0(25);
        }
        if (executor == null) {
            GitVFSListener.$$$reportNull$$$0(26);
        }
        final Map<VirtualFile, List<FilePath>> sortedFiles = GitUtil.sortFilePathsByGitRootIgnoringMissing(this.myProject, files);
        GitVcs.runInBackground(new Task.Backgroundable(this.myProject, operationTitle){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                for (Map.Entry e : sortedFiles.entrySet()) {
                    try {
                        executor.execute((VirtualFile)e.getKey(), (List)e.getValue());
                    }
                    catch (VcsException ex) {
                        GitVcsConsoleWriter.getInstance(this.myProject).showMessage(ex.getMessage());
                    }
                }
                RefreshVFsSynchronously.refreshFiles(executor.getFilesToRefresh());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/vfs/GitVFSListener$5", "run"));
            }
        });
    }

    public void waitForAllEventsProcessedInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        ((ChangeListManagerImpl)this.myChangeListManager).waitEverythingDoneInTestMode();
        this.myExternalFilesProcessor.waitForEventsProcessedInTestMode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/vfs/GitVFSListener";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedFiles";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copiedFiles";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyFromMap";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executeAddCallback";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToDelete";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "movedFiles";
                break;
            }
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 17: 
            case 19: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToMove";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deletedFiles";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationTitle";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/vfs/GitVFSListener";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddTitle";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleFileAddTitle";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleFileAddPromptTemplate";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeleteTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "executeAdd";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "executeAddWithoutIgnores";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "performAdding";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "performDeletion";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "performMoveRename";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "executeAdding";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "executeDeletion";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "executeForceMove";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "selectFilePathsToDelete";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "performBackgroundOperation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface LongOperationPerRootExecutor {
        public void execute(@NotNull VirtualFile var1, @NotNull List<? extends FilePath> var2) throws VcsException;

        public Collection<File> getFilesToRefresh();
    }
}

