/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.util.Ref;
import git4idea.config.GitVersionIdentificationException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class CachingFileTester<T> {
    private static final int FILE_TEST_TIMEOUT_MS = 30000;
    private final ReentrantLock LOCK = new ReentrantLock();
    @NotNull
    private final ConcurrentMap<String, TestResult> myFileTestMap = new ConcurrentHashMap<String, TestResult>();

    CachingFileTester() {
    }

    @NotNull
    final TestResult getResultForFile(@NotNull String filePath) {
        if (filePath == null) {
            CachingFileTester.$$$reportNull$$$0(0);
        }
        TestResult testResult = (TestResult)ProgressIndicatorUtils.computeWithLockAndCheckingCanceled((Lock)this.LOCK, (int)50, (TimeUnit)TimeUnit.MILLISECONDS, () -> {
            TestResult result2 = (TestResult)this.myFileTestMap.get(filePath);
            long currentLastModificationDate = 0L;
            try {
                currentLastModificationDate = Files.getLastModifiedTime(Paths.get(CachingFileTester.resolveAgainstEnvPath(filePath), new String[0]), new LinkOption[0]).toMillis();
                if (result2 == null || result2.getFileLastModifiedTimestamp() != currentLastModificationDate) {
                    result2 = new TestResult(this.testFileOrAbort(filePath), currentLastModificationDate);
                }
                this.myFileTestMap.put(filePath, result2);
            }
            catch (ProcessCanceledException pce) {
                throw pce;
            }
            catch (Exception e) {
                result2 = new TestResult(e, currentLastModificationDate);
            }
            return result2;
        });
        if (testResult == null) {
            CachingFileTester.$$$reportNull$$$0(1);
        }
        return testResult;
    }

    @NotNull
    private static String resolveAgainstEnvPath(@NotNull String filePath) {
        File exeFile;
        if (filePath == null) {
            CachingFileTester.$$$reportNull$$$0(2);
        }
        if (!filePath.contains(File.separator) && (exeFile = PathEnvironmentVariableUtil.findInPath((String)filePath)) != null) {
            String string = exeFile.getPath();
            if (string == null) {
                CachingFileTester.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = filePath;
        if (string == null) {
            CachingFileTester.$$$reportNull$$$0(4);
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private T testFileOrAbort(@NotNull String filePath) throws Exception {
        if (filePath == null) {
            CachingFileTester.$$$reportNull$$$0(5);
        }
        EmptyProgressIndicator indicator = new EmptyProgressIndicator();
        Ref exceptionRef = new Ref();
        Ref resultRef = new Ref();
        Semaphore semaphore = new Semaphore(0);
        ApplicationManager.getApplication().executeOnPooledThread(() -> ProgressManager.getInstance().executeProcessUnderProgress(() -> {
            try {
                resultRef.set(this.testFile(filePath));
            }
            catch (Exception e) {
                exceptionRef.set((Object)e);
            }
            finally {
                semaphore.release();
            }
        }, (ProgressIndicator)indicator));
        try {
            long start = System.currentTimeMillis();
            do {
                ProgressManager.checkCanceled();
            } while (!semaphore.tryAcquire(50L, TimeUnit.MILLISECONDS) && System.currentTimeMillis() - start <= 30000L);
            if (!resultRef.isNull()) {
                Object object = resultRef.get();
                Object object2 = object;
                if (object2 == null) {
                    CachingFileTester.$$$reportNull$$$0(6);
                }
                return (T)object2;
            }
            if (!exceptionRef.isNull()) {
                throw (Exception)exceptionRef.get();
            }
            throw new GitVersionIdentificationException("Cannot identify version of git executable: no response", null);
        }
        finally {
            indicator.cancel();
        }
    }

    @Nullable
    public TestResult getCachedResultForFile(@NotNull String filePath) {
        if (filePath == null) {
            CachingFileTester.$$$reportNull$$$0(7);
        }
        return (TestResult)this.myFileTestMap.get(filePath);
    }

    public void dropCache(@NotNull String filePath) {
        if (filePath == null) {
            CachingFileTester.$$$reportNull$$$0(8);
        }
        this.myFileTestMap.remove(filePath);
    }

    @NotNull
    protected abstract T testFile(@NotNull String var1) throws Exception;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/config/CachingFileTester";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/config/CachingFileTester";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultForFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAgainstEnvPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "testFileOrAbort";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResultForFile";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveAgainstEnvPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "testFileOrAbort";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCachedResultForFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "dropCache";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class TestResult {
        @Nullable
        private final T myResult;
        @Nullable
        private final Exception myException;
        private final long myFileLastModifiedTimestamp;

        TestResult(T result2, long timestamp) {
            if (result2 == null) {
                TestResult.$$$reportNull$$$0(0);
            }
            this.myResult = result2;
            this.myFileLastModifiedTimestamp = timestamp;
            this.myException = null;
        }

        TestResult(Exception exception, long timestamp) {
            if (exception == null) {
                TestResult.$$$reportNull$$$0(1);
            }
            this.myFileLastModifiedTimestamp = timestamp;
            this.myResult = null;
            this.myException = exception;
        }

        @Nullable
        public T getResult() {
            return this.myResult;
        }

        @Nullable
        public Exception getException() {
            return this.myException;
        }

        private long getFileLastModifiedTimestamp() {
            return this.myFileLastModifiedTimestamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "exception";
                    break;
                }
            }
            objectArray[1] = "git4idea/config/CachingFileTester$TestResult";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

