/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.patch.BlobIndexUtil;
import com.intellij.openapi.vcs.history.ShortVcsRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import git4idea.commands.GitLineHandler;
import java.util.Date;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GitRevisionNumber
implements ShortVcsRevisionNumber {
    public static final String NOT_COMMITTED_HASH = BlobIndexUtil.NOT_COMMITTED_HASH;
    public static final GitRevisionNumber HEAD = new GitRevisionNumber("HEAD");
    @NotNull
    private final String myRevisionHash;
    @NotNull
    private final Date myTimestamp;
    private static final Logger LOG = Logger.getInstance(GitRevisionNumber.class);

    public GitRevisionNumber(@NonNls @NotNull String version) {
        if (version == null) {
            GitRevisionNumber.$$$reportNull$$$0(0);
        }
        this.myRevisionHash = version;
        this.myTimestamp = new Date();
    }

    public GitRevisionNumber(@NotNull String version, @NotNull Date timeStamp) {
        if (version == null) {
            GitRevisionNumber.$$$reportNull$$$0(1);
        }
        if (timeStamp == null) {
            GitRevisionNumber.$$$reportNull$$$0(2);
        }
        this.myTimestamp = timeStamp;
        this.myRevisionHash = version;
    }

    @NotNull
    public String asString() {
        String string = this.myRevisionHash;
        if (string == null) {
            GitRevisionNumber.$$$reportNull$$$0(3);
        }
        return string;
    }

    public String toShortString() {
        return this.asString().substring(0, 7);
    }

    @NotNull
    public Date getTimestamp() {
        Date date = this.myTimestamp;
        if (date == null) {
            GitRevisionNumber.$$$reportNull$$$0(4);
        }
        return date;
    }

    @NotNull
    public String getRev() {
        String string = this.myRevisionHash;
        if (string == null) {
            GitRevisionNumber.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getShortRev() {
        String string = DvcsUtil.getShortHash((String)this.myRevisionHash);
        if (string == null) {
            GitRevisionNumber.$$$reportNull$$$0(6);
        }
        return string;
    }

    public int compareTo(VcsRevisionNumber crev) {
        if (this == crev) {
            return 0;
        }
        if (crev instanceof GitRevisionNumber) {
            int tildeIndex;
            GitRevisionNumber other = (GitRevisionNumber)crev;
            if (this.myRevisionHash.equals(other.myRevisionHash)) {
                return 0;
            }
            if (other.myRevisionHash.indexOf("[") > 0) {
                return this.myTimestamp.compareTo(other.myTimestamp);
            }
            String otherName = null;
            String thisName = null;
            int otherParents = -1;
            int thisParent = -1;
            if (other.myRevisionHash.contains("~")) {
                tildeIndex = other.myRevisionHash.indexOf(126);
                otherName = other.myRevisionHash.substring(0, tildeIndex);
                otherParents = Integer.parseInt(other.myRevisionHash.substring(tildeIndex));
            }
            if (this.myRevisionHash.contains("~")) {
                tildeIndex = this.myRevisionHash.indexOf(126);
                thisName = this.myRevisionHash.substring(0, tildeIndex);
                thisParent = Integer.parseInt(this.myRevisionHash.substring(tildeIndex));
            }
            if (otherName == null && thisName == null) {
                int result2 = this.myTimestamp.compareTo(other.myTimestamp);
                if (result2 == 0) {
                    return this.myRevisionHash.compareTo(other.myRevisionHash);
                }
                return result2;
            }
            if (otherName == null) {
                return 1;
            }
            if (thisName == null) {
                return -1;
            }
            return thisParent - otherParents;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        GitRevisionNumber test = (GitRevisionNumber)obj;
        return this.myRevisionHash.equals(test.myRevisionHash);
    }

    public int hashCode() {
        return this.myRevisionHash.hashCode();
    }

    @NotNull
    public static GitRevisionNumber resolve(Project project, VirtualFile vcsRoot, @NonNls String rev) throws VcsException {
        GitLineHandler h = new GitLineHandler(project, vcsRoot, GitCommand.REV_LIST);
        h.setSilent(true);
        h.addParameters("--timestamp", "--max-count=1", rev);
        h.endOptions();
        String output = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        return GitRevisionNumber.parseRevlistOutputAsRevisionNumber(h, output);
    }

    @NotNull
    public static GitRevisionNumber parseRevlistOutputAsRevisionNumber(@NotNull GitHandler h, @NotNull String output) throws VcsException {
        if (h == null) {
            GitRevisionNumber.$$$reportNull$$$0(7);
        }
        if (output == null) {
            GitRevisionNumber.$$$reportNull$$$0(8);
        }
        try {
            StringTokenizer tokenizer = new StringTokenizer(output, "\n\r \t", false);
            LOG.assertTrue(tokenizer.hasMoreTokens(), (Object)("No required tokens in the output: \n" + output));
            Date timestamp = GitUtil.parseTimestampWithNFEReport(tokenizer.nextToken(), h, output);
            return new GitRevisionNumber(tokenizer.nextToken(), timestamp);
        }
        catch (Exception e) {
            throw new VcsException("Couldn't parse the output: [" + output + "]", (Throwable)e);
        }
    }

    public String toString() {
        return this.myRevisionHash;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeStamp";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/GitRevisionNumber";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "h";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/GitRevisionNumber";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "asString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimestamp";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRev";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortRev";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseRevlistOutputAsRevisionNumber";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

