/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade.bek;

import com.intellij.openapi.util.Pair;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.impl.facade.bek.BekBranch;
import com.intellij.vcs.log.graph.impl.facade.bek.BekBranchCreator;
import com.intellij.vcs.log.graph.impl.facade.bek.BekBranchMerger;
import com.intellij.vcs.log.graph.impl.facade.bek.BekEdgeRestrictions;
import com.intellij.vcs.log.graph.impl.facade.bek.BekIntMap;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutImpl;
import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.TimestampGetter;
import com.intellij.vcs.log.graph.utils.impl.CompressedIntList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BekSorter {
    @NotNull
    private final LinearGraph myPermanentGraph;
    @NotNull
    private final GraphLayoutImpl myGraphLayout;
    @NotNull
    private final TimestampGetter myTimestampGetter;

    @NotNull
    public static BekIntMap createBekMap(@NotNull LinearGraph permanentGraph, @NotNull GraphLayoutImpl graphLayout, @NotNull TimestampGetter timestampGetter) {
        if (permanentGraph == null) {
            BekSorter.$$$reportNull$$$0(0);
        }
        if (graphLayout == null) {
            BekSorter.$$$reportNull$$$0(1);
        }
        if (timestampGetter == null) {
            BekSorter.$$$reportNull$$$0(2);
        }
        BekSorter bekSorter = new BekSorter(permanentGraph, graphLayout, timestampGetter);
        List<Integer> result2 = bekSorter.getResult();
        assert (result2.size() == permanentGraph.nodesCount());
        BekIntMap bekIntMap = BekSorter.createBekIntMap(result2);
        if (bekIntMap == null) {
            BekSorter.$$$reportNull$$$0(3);
        }
        return bekIntMap;
    }

    private static BekIntMap createBekIntMap(final List<Integer> result2) {
        int[] reverseMap = new int[result2.size()];
        for (int i = 0; i < result2.size(); ++i) {
            reverseMap[result2.get((int)i).intValue()] = i;
        }
        final IntList compressedBekMap = CompressedIntList.newInstance(new IntList(){

            @Override
            public int size() {
                return result2.size();
            }

            @Override
            public int get(int index) {
                return (Integer)result2.get(index);
            }
        }, 30);
        final IntList compressedReverseMap = CompressedIntList.newInstance(reverseMap);
        return new BekIntMap(){

            @Override
            public int size() {
                return compressedBekMap.size();
            }

            @Override
            public int getBekIndex(int usualIndex) {
                return compressedReverseMap.get(usualIndex);
            }

            @Override
            public int getUsualIndex(int bekIndex) {
                return compressedBekMap.get(bekIndex);
            }
        };
    }

    private BekSorter(@NotNull LinearGraph permanentGraph, @NotNull GraphLayoutImpl graphLayout, @NotNull TimestampGetter timestampGetter) {
        if (permanentGraph == null) {
            BekSorter.$$$reportNull$$$0(4);
        }
        if (graphLayout == null) {
            BekSorter.$$$reportNull$$$0(5);
        }
        if (timestampGetter == null) {
            BekSorter.$$$reportNull$$$0(6);
        }
        this.myPermanentGraph = permanentGraph;
        this.myGraphLayout = graphLayout;
        this.myTimestampGetter = timestampGetter;
    }

    public List<Integer> getResult() {
        BekBranchCreator bekBranchCreator = new BekBranchCreator(this.myPermanentGraph, this.myGraphLayout);
        Pair<List<BekBranch>, BekEdgeRestrictions> branches = bekBranchCreator.getResult();
        BekBranchMerger bekBranchMerger = new BekBranchMerger((List)branches.first, (BekEdgeRestrictions)branches.second, this.myTimestampGetter);
        return bekBranchMerger.getResult();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permanentGraph";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphLayout";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timestampGetter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/impl/facade/bek/BekSorter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/impl/facade/bek/BekSorter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createBekMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createBekMap";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

