/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.history.VcsHistoryCache;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.update.UpdatedFilesListener;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;

public class VcsCacheManager {
    private final VcsHistoryCache myVcsHistoryCache;
    private final ContentRevisionCache myContentRevisionCache;

    public static VcsCacheManager getInstance(Project project) {
        return (VcsCacheManager)project.getService(VcsCacheManager.class);
    }

    public VcsCacheManager(@NotNull Project project) {
        if (project == null) {
            VcsCacheManager.$$$reportNull$$$0(0);
        }
        this.myVcsHistoryCache = new VcsHistoryCache();
        this.myContentRevisionCache = new ContentRevisionCache();
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, () -> ((VcsHistoryCache)this.myVcsHistoryCache).clearHistory());
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED_IN_PLUGIN, () -> ((VcsHistoryCache)this.myVcsHistoryCache).clearHistory());
        connection.subscribe(UpdatedFilesListener.UPDATED_FILES, arg_0 -> ((ContentRevisionCache)this.myContentRevisionCache).clearCurrent(arg_0));
    }

    public VcsHistoryCache getVcsHistoryCache() {
        return this.myVcsHistoryCache;
    }

    public ContentRevisionCache getContentRevisionCache() {
        return this.myContentRevisionCache;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/VcsCacheManager", "<init>"));
    }
}

