/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsTreeModelData {
    @NotNull
    public static VcsTreeModelData all(@NotNull JTree tree) {
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(0);
        }
        assert (tree.getModel().getRoot() instanceof ChangesBrowserNode);
        ChangesBrowserNode root = (ChangesBrowserNode)tree.getModel().getRoot();
        return new AllUnderData(root);
    }

    @NotNull
    public static VcsTreeModelData selected(@NotNull JTree tree) {
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(1);
        }
        assert (tree.getModel().getRoot() instanceof ChangesBrowserNode);
        return new SelectedData(tree);
    }

    @NotNull
    public static VcsTreeModelData exactlySelected(@NotNull JTree tree) {
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(2);
        }
        assert (tree.getModel().getRoot() instanceof ChangesBrowserNode);
        return new ExactlySelectedData(tree);
    }

    @NotNull
    public static VcsTreeModelData included(@NotNull ChangesTree tree) {
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(3);
        }
        assert (tree.getModel().getRoot() instanceof ChangesBrowserNode);
        ChangesBrowserNode root = (ChangesBrowserNode)tree.getModel().getRoot();
        return new IncludedUnderData(tree, root);
    }

    @NotNull
    public static VcsTreeModelData children(@NotNull ChangesBrowserNode<?> node) {
        if (node == null) {
            VcsTreeModelData.$$$reportNull$$$0(4);
        }
        return new AllUnderData(node);
    }

    @NotNull
    public static VcsTreeModelData allUnderTag(@NotNull JTree tree, @NotNull Object tag) {
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(5);
        }
        if (tag == null) {
            VcsTreeModelData.$$$reportNull$$$0(6);
        }
        assert (tree.getModel().getRoot() instanceof ChangesBrowserNode);
        ChangesBrowserNode<?> tagNode = VcsTreeModelData.findTagNode(tree, tag);
        if (tagNode == null) {
            return new EmptyData();
        }
        return new AllUnderData(tagNode);
    }

    @NotNull
    public static VcsTreeModelData selectedUnderTag(@NotNull JTree tree, @NotNull Object tag) {
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(7);
        }
        if (tag == null) {
            VcsTreeModelData.$$$reportNull$$$0(8);
        }
        assert (tree.getModel().getRoot() instanceof ChangesBrowserNode);
        return new SelectedTagData(tree, tag);
    }

    @NotNull
    public static VcsTreeModelData includedUnderTag(@NotNull ChangesTree tree, @NotNull Object tag) {
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(9);
        }
        if (tag == null) {
            VcsTreeModelData.$$$reportNull$$$0(10);
        }
        assert (tree.getModel().getRoot() instanceof ChangesBrowserNode);
        ChangesBrowserNode<?> tagNode = VcsTreeModelData.findTagNode((JTree)((Object)tree), tag);
        if (tagNode == null) {
            return new EmptyData();
        }
        return new IncludedUnderData(tree, tagNode);
    }

    @NotNull
    public abstract Stream<ChangesBrowserNode<?>> rawNodesStream();

    @NotNull
    public Stream<ChangesBrowserNode<?>> nodesStream() {
        Stream<ChangesBrowserNode<?>> stream = this.rawNodesStream().filter(ChangesBrowserNode::isMeaningfulNode);
        if (stream == null) {
            VcsTreeModelData.$$$reportNull$$$0(11);
        }
        return stream;
    }

    @NotNull
    public Stream<Object> rawUserObjectsStream() {
        Stream<Object> stream = this.rawUserObjectsStream(Object.class);
        if (stream == null) {
            VcsTreeModelData.$$$reportNull$$$0(12);
        }
        return stream;
    }

    @NotNull
    public <U> Stream<U> rawUserObjectsStream(@NotNull Class<U> clazz) {
        if (clazz == null) {
            VcsTreeModelData.$$$reportNull$$$0(13);
        }
        Stream<Object> stream = this.rawNodesStream().map(ChangesBrowserNode::getUserObject).filter(clazz::isInstance);
        if (stream == null) {
            VcsTreeModelData.$$$reportNull$$$0(14);
        }
        return stream;
    }

    @NotNull
    public Stream<Object> userObjectsStream() {
        Stream<Object> stream = this.userObjectsStream(Object.class);
        if (stream == null) {
            VcsTreeModelData.$$$reportNull$$$0(15);
        }
        return stream;
    }

    @NotNull
    public <U> Stream<U> userObjectsStream(@NotNull Class<U> clazz) {
        if (clazz == null) {
            VcsTreeModelData.$$$reportNull$$$0(16);
        }
        Stream<Object> stream = this.nodesStream().map(ChangesBrowserNode::getUserObject).filter(clazz::isInstance);
        if (stream == null) {
            VcsTreeModelData.$$$reportNull$$$0(17);
        }
        return stream;
    }

    @NotNull
    public List<Object> userObjects() {
        List<Object> list = this.userObjectsStream().collect(Collectors.toList());
        if (list == null) {
            VcsTreeModelData.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    public <U> List<U> userObjects(@NotNull Class<U> clazz) {
        if (clazz == null) {
            VcsTreeModelData.$$$reportNull$$$0(19);
        }
        List list = this.userObjectsStream(clazz).collect(Collectors.toList());
        if (list == null) {
            VcsTreeModelData.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    public static ListSelection<Object> getListSelectionOrAll(@NotNull JTree tree) {
        List<Object> allEntries;
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(21);
        }
        List<Object> entries = VcsTreeModelData.selected(tree).userObjects();
        Object selection = ContainerUtil.getFirstItem(entries);
        if (entries.size() < 2 && ((allEntries = VcsTreeModelData.all(tree).userObjects()).size() > 1 || entries.isEmpty())) {
            entries = allEntries;
        }
        int index = ContainerUtil.indexOfIdentity(entries, (Object)selection);
        ListSelection listSelection = ListSelection.createAt(entries, (int)index);
        if (listSelection == null) {
            VcsTreeModelData.$$$reportNull$$$0(22);
        }
        return listSelection;
    }

    @Nullable
    public static Object getData(@Nullable Project project, @NotNull JTree tree, @NotNull String dataId) {
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(23);
        }
        if (dataId == null) {
            VcsTreeModelData.$$$reportNull$$$0(24);
        }
        if (VcsDataKeys.CHANGES.is(dataId)) {
            Change[] changes = (Change[])VcsTreeModelData.mapToChange(VcsTreeModelData.selected(tree)).toArray(Change[]::new);
            if (changes.length != 0) {
                return changes;
            }
            return VcsTreeModelData.mapToChange(VcsTreeModelData.all(tree)).toArray(Change[]::new);
        }
        if (VcsDataKeys.SELECTED_CHANGES.is(dataId) || VcsDataKeys.SELECTED_CHANGES_IN_DETAILS.is(dataId)) {
            return VcsTreeModelData.mapToChange(VcsTreeModelData.selected(tree)).toArray(Change[]::new);
        }
        if (VcsDataKeys.CHANGES_SELECTION.is(dataId)) {
            return VcsTreeModelData.getListSelectionOrAll(tree).map(entry -> (Change)ObjectUtils.tryCast((Object)entry, Change.class));
        }
        if (VcsDataKeys.CHANGE_LEAD_SELECTION.is(dataId)) {
            return VcsTreeModelData.mapToChange(VcsTreeModelData.exactlySelected(tree)).limit(1L).toArray(Change[]::new);
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            return VcsTreeModelData.mapToVirtualFile(VcsTreeModelData.selected(tree)).toArray(VirtualFile[]::new);
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            if (project == null) {
                return null;
            }
            return ChangesUtil.getNavigatableArray((Project)project, VcsTreeModelData.mapToNavigatableFile(VcsTreeModelData.selected(tree)));
        }
        if (VcsDataKeys.IO_FILE_ARRAY.is(dataId)) {
            return VcsTreeModelData.mapToIoFile(VcsTreeModelData.selected(tree)).toArray(File[]::new);
        }
        return null;
    }

    @NotNull
    private static Stream<Change> mapToChange(@NotNull VcsTreeModelData data) {
        if (data == null) {
            VcsTreeModelData.$$$reportNull$$$0(25);
        }
        Stream<Change> stream = data.userObjectsStream().filter(it -> it instanceof Change).map(entry -> (Change)entry);
        if (stream == null) {
            VcsTreeModelData.$$$reportNull$$$0(26);
        }
        return stream;
    }

    @NotNull
    private static Stream<VirtualFile> mapToNavigatableFile(@NotNull VcsTreeModelData data) {
        if (data == null) {
            VcsTreeModelData.$$$reportNull$$$0(27);
        }
        Stream<VirtualFile> stream = data.userObjectsStream().flatMap(entry -> {
            if (entry instanceof Change) {
                return ChangesUtil.getPathsCaseSensitive((Change)((Change)entry)).map(FilePath::getVirtualFile);
            }
            if (entry instanceof VirtualFile) {
                return Stream.of((VirtualFile)entry);
            }
            if (entry instanceof FilePath) {
                return Stream.of(((FilePath)entry).getVirtualFile());
            }
            return Stream.empty();
        }).filter(Objects::nonNull);
        if (stream == null) {
            VcsTreeModelData.$$$reportNull$$$0(28);
        }
        return stream;
    }

    @NotNull
    private static Stream<VirtualFile> mapToVirtualFile(@NotNull VcsTreeModelData data) {
        if (data == null) {
            VcsTreeModelData.$$$reportNull$$$0(29);
        }
        Stream<VirtualFile> stream = data.userObjectsStream().map(entry -> {
            if (entry instanceof Change) {
                FilePath path2 = ChangesUtil.getAfterPath((Change)((Change)entry));
                return path2 != null ? path2.getVirtualFile() : null;
            }
            if (entry instanceof VirtualFile) {
                return (VirtualFile)entry;
            }
            if (entry instanceof FilePath) {
                return ((FilePath)entry).getVirtualFile();
            }
            return null;
        }).filter(Objects::nonNull);
        if (stream == null) {
            VcsTreeModelData.$$$reportNull$$$0(30);
        }
        return stream;
    }

    @NotNull
    private static Stream<File> mapToIoFile(@NotNull VcsTreeModelData data) {
        if (data == null) {
            VcsTreeModelData.$$$reportNull$$$0(31);
        }
        Stream<File> stream = data.userObjectsStream().map(entry -> {
            if (entry instanceof Change) {
                FilePath path2 = ChangesUtil.getAfterPath((Change)((Change)entry));
                return path2 != null ? path2.getIOFile() : null;
            }
            return null;
        }).filter(Objects::nonNull);
        if (stream == null) {
            VcsTreeModelData.$$$reportNull$$$0(32);
        }
        return stream;
    }

    @Nullable
    private static ChangesBrowserNode<?> findTagNode(@NotNull JTree tree, @NotNull Object tag) {
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(33);
        }
        if (tag == null) {
            VcsTreeModelData.$$$reportNull$$$0(34);
        }
        ChangesBrowserNode root = (ChangesBrowserNode)tree.getModel().getRoot();
        Iterator iterator = ContainerUtil.iterate(root.children());
        return (ChangesBrowserNode)ContainerUtil.find((Iterator)iterator, node -> tag.equals(node.getUserObject()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 26: 
            case 28: 
            case 30: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 26: 
            case 28: 
            case 30: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 26: 
            case 28: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData";
                break;
            }
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 25: 
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "nodesStream";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "rawUserObjectsStream";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "userObjectsStream";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "userObjects";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getListSelectionOrAll";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToChange";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToNavigatableFile";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToVirtualFile";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToIoFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "all";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "selected";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exactlySelected";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "included";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "children";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "allUnderTag";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "selectedUnderTag";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "includedUnderTag";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 26: 
            case 28: 
            case 30: 
            case 32: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "rawUserObjectsStream";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "userObjectsStream";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "userObjects";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getListSelectionOrAll";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "mapToChange";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "mapToNavigatableFile";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "mapToVirtualFile";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "mapToIoFile";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findTagNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 26: 
            case 28: 
            case 30: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IncludedUnderData
    extends VcsTreeModelData {
        @NotNull
        private final ChangesTree myTree;
        @NotNull
        private final ChangesBrowserNode<?> myNode;

        IncludedUnderData(@NotNull ChangesTree tree, @NotNull ChangesBrowserNode<?> node) {
            if (tree == null) {
                IncludedUnderData.$$$reportNull$$$0(0);
            }
            if (node == null) {
                IncludedUnderData.$$$reportNull$$$0(1);
            }
            this.myTree = tree;
            this.myNode = node;
        }

        @Override
        @NotNull
        public Stream<ChangesBrowserNode<?>> rawNodesStream() {
            Set<Object> included = this.myTree.getIncludedSet();
            Stream<ChangesBrowserNode<?>> stream = this.myNode.getNodesUnderStream().filter(node -> included.contains(node.getUserObject()));
            if (stream == null) {
                IncludedUnderData.$$$reportNull$$$0(2);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$IncludedUnderData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$IncludedUnderData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rawNodesStream";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SelectedTagData
    extends ExactlySelectedTagData {
        SelectedTagData(@NotNull JTree tree, @NotNull Object tag) {
            if (tree == null) {
                SelectedTagData.$$$reportNull$$$0(0);
            }
            if (tag == null) {
                SelectedTagData.$$$reportNull$$$0(1);
            }
            super(tree, tag);
        }

        @Override
        @NotNull
        public Stream<ChangesBrowserNode<?>> rawNodesStream() {
            Stream<ChangesBrowserNode<?>> stream = super.rawNodesStream().flatMap(ChangesBrowserNode::getNodesUnderStream).distinct();
            if (stream == null) {
                SelectedTagData.$$$reportNull$$$0(2);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$SelectedTagData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$SelectedTagData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rawNodesStream";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ExactlySelectedTagData
    extends VcsTreeModelData {
        @NotNull
        private final JTree myTree;
        @NotNull
        private final Object myTag;

        ExactlySelectedTagData(@NotNull JTree tree, @NotNull Object tag) {
            if (tree == null) {
                ExactlySelectedTagData.$$$reportNull$$$0(0);
            }
            if (tag == null) {
                ExactlySelectedTagData.$$$reportNull$$$0(1);
            }
            this.myTree = tree;
            this.myTag = tag;
        }

        @Override
        @NotNull
        public Stream<ChangesBrowserNode<?>> rawNodesStream() {
            ChangesBrowserNode tagNode = VcsTreeModelData.findTagNode(this.myTree, this.myTag);
            if (tagNode == null) {
                Stream<ChangesBrowserNode<?>> stream = Stream.empty();
                if (stream == null) {
                    ExactlySelectedTagData.$$$reportNull$$$0(2);
                }
                return stream;
            }
            TreePath[] paths = this.myTree.getSelectionPaths();
            if (paths == null) {
                Stream<ChangesBrowserNode<?>> stream = Stream.empty();
                if (stream == null) {
                    ExactlySelectedTagData.$$$reportNull$$$0(3);
                }
                return stream;
            }
            Stream<ChangesBrowserNode<?>> stream = Stream.of(paths).filter(path2 -> path2.getPathCount() <= 1 || path2.getPathComponent(1) == tagNode).map(path2 -> (ChangesBrowserNode)path2.getLastPathComponent());
            if (stream == null) {
                ExactlySelectedTagData.$$$reportNull$$$0(4);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$ExactlySelectedTagData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$ExactlySelectedTagData";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rawNodesStream";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ExactlySelectedData
    extends VcsTreeModelData {
        @NotNull
        private final JTree myTree;

        ExactlySelectedData(@NotNull JTree tree) {
            if (tree == null) {
                ExactlySelectedData.$$$reportNull$$$0(0);
            }
            this.myTree = tree;
        }

        @Override
        @NotNull
        public Stream<ChangesBrowserNode<?>> rawNodesStream() {
            TreePath[] paths = this.myTree.getSelectionPaths();
            if (paths == null) {
                Stream<ChangesBrowserNode<?>> stream = Stream.empty();
                if (stream == null) {
                    ExactlySelectedData.$$$reportNull$$$0(1);
                }
                return stream;
            }
            Stream<ChangesBrowserNode<?>> stream = Stream.of(paths).map(path2 -> (ChangesBrowserNode)path2.getLastPathComponent());
            if (stream == null) {
                ExactlySelectedData.$$$reportNull$$$0(2);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$ExactlySelectedData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$ExactlySelectedData";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rawNodesStream";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SelectedData
    extends ExactlySelectedData {
        SelectedData(@NotNull JTree tree) {
            if (tree == null) {
                SelectedData.$$$reportNull$$$0(0);
            }
            super(tree);
        }

        @Override
        @NotNull
        public Stream<ChangesBrowserNode<?>> rawNodesStream() {
            Stream<ChangesBrowserNode<?>> stream = super.rawNodesStream().flatMap(ChangesBrowserNode::getNodesUnderStream).distinct();
            if (stream == null) {
                SelectedData.$$$reportNull$$$0(1);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$SelectedData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$SelectedData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rawNodesStream";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AllUnderData
    extends VcsTreeModelData {
        @NotNull
        private final ChangesBrowserNode<?> myNode;

        AllUnderData(@NotNull ChangesBrowserNode<?> node) {
            if (node == null) {
                AllUnderData.$$$reportNull$$$0(0);
            }
            this.myNode = node;
        }

        @Override
        @NotNull
        public Stream<ChangesBrowserNode<?>> rawNodesStream() {
            Stream<ChangesBrowserNode<?>> stream = this.myNode.getNodesUnderStream();
            if (stream == null) {
                AllUnderData.$$$reportNull$$$0(1);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$AllUnderData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$AllUnderData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "rawNodesStream";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class EmptyData
    extends VcsTreeModelData {
        EmptyData() {
        }

        @Override
        @NotNull
        public Stream<ChangesBrowserNode<?>> rawNodesStream() {
            Stream<ChangesBrowserNode<?>> stream = Stream.empty();
            if (stream == null) {
                EmptyData.$$$reportNull$$$0(0);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$EmptyData", "rawNodesStream"));
        }
    }
}

