/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManagerImpl;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsDirtyScopeImpl
extends VcsModifiableDirtyScope {
    private final Map<VirtualFile, THashSet<FilePath>> myDirtyFiles;
    private final Map<VirtualFile, THashSet<FilePath>> myDirtyDirectoriesRecursively;
    private final Set<VirtualFile> myAffectedContentRoots;
    @NotNull
    private final Project myProject;
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final AbstractVcs myVcs;
    private final boolean myWasEverythingDirty;
    @NotNull
    private final TObjectHashingStrategy<FilePath> myHashingStrategy;

    public VcsDirtyScopeImpl(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(0);
        }
        this(vcs, false);
    }

    public VcsDirtyScopeImpl(@NotNull AbstractVcs vcs, boolean wasEverythingDirty) {
        if (vcs == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(1);
        }
        this.myDirtyFiles = new HashMap<VirtualFile, THashSet<FilePath>>();
        this.myDirtyDirectoriesRecursively = new HashMap<VirtualFile, THashSet<FilePath>>();
        this.myAffectedContentRoots = new THashSet();
        this.myVcs = vcs;
        this.myProject = vcs.getProject();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myWasEverythingDirty = wasEverythingDirty;
        this.myHashingStrategy = VcsDirtyScopeManagerImpl.getDirtyScopeHashingStrategy(this.myVcs);
    }

    public Collection<VirtualFile> getAffectedContentRoots() {
        return this.myAffectedContentRoots;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(2);
        }
        return project;
    }

    @NotNull
    public AbstractVcs getVcs() {
        AbstractVcs abstractVcs = this.myVcs;
        if (abstractVcs == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(3);
        }
        return abstractVcs;
    }

    public Set<FilePath> getDirtyFiles() {
        THashSet<FilePath> result2 = this.newFilePathsSet();
        for (THashSet<FilePath> paths : this.myDirtyFiles.values()) {
            result2.addAll(paths);
        }
        for (THashSet<FilePath> paths : this.myDirtyFiles.values()) {
            for (FilePath filePath : paths) {
                VirtualFile vFile = filePath.getVirtualFile();
                if (vFile == null || !vFile.isValid() || !vFile.isDirectory()) continue;
                for (VirtualFile child : vFile.getChildren()) {
                    result2.add((Object)VcsUtil.getFilePath((VirtualFile)child));
                }
            }
        }
        return result2;
    }

    public Set<FilePath> getDirtyFilesNoExpand() {
        THashSet<FilePath> paths = this.newFilePathsSet();
        for (THashSet<FilePath> filePaths : this.myDirtyFiles.values()) {
            paths.addAll(filePaths);
        }
        return paths;
    }

    public Set<FilePath> getRecursivelyDirtyDirectories() {
        THashSet<FilePath> result2 = this.newFilePathsSet();
        for (THashSet<FilePath> dirsByRoot : this.myDirtyDirectoriesRecursively.values()) {
            result2.addAll(dirsByRoot);
        }
        return result2;
    }

    public void addDirtyData(@NotNull Collection<? extends FilePath> dirs, @NotNull Collection<? extends FilePath> files) {
        if (dirs == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(4);
        }
        if (files == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(5);
        }
        HashMap<VirtualFile, THashSet<FilePath>> perRootDirs = new HashMap<VirtualFile, THashSet<FilePath>>();
        HashMap<VirtualFile, THashSet<FilePath>> perRootFiles = new HashMap<VirtualFile, THashSet<FilePath>>();
        for (Map.Entry<VirtualFile, THashSet<FilePath>> entry : this.myDirtyDirectoriesRecursively.entrySet()) {
            perRootDirs.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<VirtualFile, THashSet<FilePath>> entry : this.myDirtyFiles.entrySet()) {
            perRootFiles.put(entry.getKey(), entry.getValue());
        }
        this.addFilePathsToMap(dirs, perRootDirs);
        this.addFilePathsToMap(files, perRootFiles);
        this.myAffectedContentRoots.addAll(perRootDirs.keySet());
        this.myAffectedContentRoots.addAll(perRootFiles.keySet());
        for (VirtualFile root : this.myAffectedContentRoots) {
            Set rootDirs = ContainerUtil.notNullize((Set)((Set)perRootDirs.get(root)));
            Set rootFiles = ContainerUtil.notNullize((Set)((Set)perRootFiles.get(root)));
            THashSet<FilePath> filteredDirs = this.removeAncestorsRecursive(rootDirs);
            THashSet<FilePath> filteredFiles = this.removeAncestorsNonRecursive((Set<? extends FilePath>)filteredDirs, rootFiles);
            this.myDirtyDirectoriesRecursively.put(root, filteredDirs);
            this.myDirtyFiles.put(root, filteredFiles);
        }
    }

    private void addFilePathsToMap(@NotNull Collection<? extends FilePath> paths, @NotNull Map<VirtualFile, THashSet<FilePath>> pathsMap) {
        if (paths == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(6);
        }
        if (pathsMap == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(7);
        }
        for (FilePath filePath : paths) {
            VirtualFile vcsRoot = this.myVcsManager.getVcsRootFor(filePath);
            if (vcsRoot == null) continue;
            THashSet<FilePath> set = pathsMap.get(vcsRoot);
            if (set == null) {
                set = this.newFilePathsSet();
                pathsMap.put(vcsRoot, set);
            }
            set.add((Object)filePath);
        }
    }

    @NotNull
    private THashSet<FilePath> removeAncestorsRecursive(@NotNull Collection<? extends FilePath> dirs) {
        if (dirs == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(8);
        }
        List paths = ContainerUtil.sorted(dirs, Comparator.comparingInt(it -> it.getPath().length()));
        THashSet<FilePath> result2 = this.newFilePathsSet();
        for (FilePath path2 : paths) {
            if (VcsDirtyScopeImpl.hasAncestor(result2, path2)) continue;
            result2.add((Object)path2);
        }
        THashSet<FilePath> tHashSet = result2;
        if (tHashSet == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(9);
        }
        return tHashSet;
    }

    @NotNull
    private THashSet<FilePath> removeAncestorsNonRecursive(@NotNull Set<? extends FilePath> dirs, @NotNull Set<? extends FilePath> files) {
        if (dirs == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(10);
        }
        if (files == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(11);
        }
        THashSet<FilePath> result2 = this.newFilePathsSet();
        for (FilePath filePath : files) {
            if (VcsDirtyScopeImpl.hasAncestor(dirs, filePath) || !filePath.isDirectory() && files.contains(filePath.getParentPath())) continue;
            result2.add((Object)filePath);
        }
        THashSet<FilePath> tHashSet = result2;
        if (tHashSet == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(12);
        }
        return tHashSet;
    }

    private static boolean hasAncestor(@NotNull Set<? extends FilePath> dirs, @NotNull FilePath filePath) {
        if (dirs == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(13);
        }
        if (filePath == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(14);
        }
        for (FilePath filePath2 : dirs) {
            if (!VcsFileUtil.isAncestor(filePath2, filePath, false)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private THashSet<FilePath> newFilePathsSet() {
        return new THashSet(this.myHashingStrategy);
    }

    public void addDirtyDirRecursively(FilePath newcomer) {
        VirtualFile vcsRoot = this.myVcsManager.getVcsRootFor(newcomer);
        if (vcsRoot == null) {
            return;
        }
        this.myAffectedContentRoots.add(vcsRoot);
        for (Map.Entry<VirtualFile, THashSet<FilePath>> entry : this.myDirtyFiles.entrySet()) {
            THashSet<FilePath> files;
            VirtualFile groupRoot = entry.getKey();
            if (groupRoot == null || !VfsUtilCore.isAncestor((VirtualFile)vcsRoot, (VirtualFile)groupRoot, (boolean)false) || (files = entry.getValue()) == null) continue;
            Iterator it = files.iterator();
            while (it.hasNext()) {
                FilePath oldBoy = (FilePath)it.next();
                if (!VcsFileUtil.isAncestor(newcomer, oldBoy, false)) continue;
                it.remove();
            }
        }
        THashSet<FilePath> dirsByRoot = this.myDirtyDirectoriesRecursively.get(vcsRoot);
        if (dirsByRoot == null) {
            dirsByRoot = this.newFilePathsSet();
            this.myDirtyDirectoriesRecursively.put(vcsRoot, dirsByRoot);
        } else {
            Iterator it = dirsByRoot.iterator();
            while (it.hasNext()) {
                FilePath oldBoy = (FilePath)it.next();
                if (VcsFileUtil.isAncestor(oldBoy, newcomer, false)) {
                    return;
                }
                if (!VcsFileUtil.isAncestor(newcomer, oldBoy, false)) continue;
                it.remove();
            }
        }
        dirsByRoot.add((Object)newcomer);
    }

    public void addDirtyFile(FilePath newcomer) {
        FilePath parent;
        VirtualFile vcsRoot = this.myVcsManager.getVcsRootFor(newcomer);
        if (vcsRoot == null) {
            return;
        }
        this.myAffectedContentRoots.add(vcsRoot);
        THashSet<FilePath> dirsByRoot = this.myDirtyDirectoriesRecursively.get(vcsRoot);
        if (dirsByRoot != null && VcsDirtyScopeImpl.hasAncestor(dirsByRoot, newcomer)) {
            return;
        }
        THashSet<FilePath> dirtyFiles = this.myDirtyFiles.get(vcsRoot);
        if (dirtyFiles == null) {
            dirtyFiles = this.newFilePathsSet();
            this.myDirtyFiles.put(vcsRoot, dirtyFiles);
        } else if (newcomer.isDirectory()) {
            Iterator iterator = dirtyFiles.iterator();
            while (iterator.hasNext()) {
                FilePath oldBoy = (FilePath)iterator.next();
                if (oldBoy.isDirectory() || !this.myHashingStrategy.equals((Object)oldBoy.getParentPath(), (Object)newcomer)) continue;
                iterator.remove();
            }
        } else if (!dirtyFiles.isEmpty() && (parent = newcomer.getParentPath()) != null && dirtyFiles.contains((Object)parent)) {
            return;
        }
        dirtyFiles.add((Object)newcomer);
    }

    public void iterate(Processor<? super FilePath> iterator) {
        VirtualFile vFile;
        if (this.myProject.isDisposed()) {
            return;
        }
        for (VirtualFile root : this.myAffectedContentRoots) {
            THashSet<FilePath> dirsByRoot = this.myDirtyDirectoriesRecursively.get(root);
            if (dirsByRoot == null) continue;
            for (FilePath dir : dirsByRoot) {
                vFile = dir.getVirtualFile();
                if (vFile == null || !vFile.isValid()) continue;
                this.myVcsManager.iterateVcsRoot(vFile, iterator);
            }
        }
        for (VirtualFile root : this.myAffectedContentRoots) {
            THashSet<FilePath> files = this.myDirtyFiles.get(root);
            if (files == null) continue;
            for (FilePath file : files) {
                iterator.process((Object)file);
                vFile = file.getVirtualFile();
                if (vFile == null || !vFile.isValid() || !vFile.isDirectory()) continue;
                for (VirtualFile child : vFile.getChildren()) {
                    iterator.process((Object)VcsUtil.getFilePath((VirtualFile)child));
                }
            }
        }
    }

    public void iterateExistingInsideScope(Processor<? super VirtualFile> processor) {
        VirtualFile vFile;
        if (this.myProject.isDisposed()) {
            return;
        }
        for (VirtualFile root : this.myAffectedContentRoots) {
            THashSet<FilePath> dirsByRoot = this.myDirtyDirectoriesRecursively.get(root);
            if (dirsByRoot == null) continue;
            for (FilePath dir : dirsByRoot) {
                vFile = VcsDirtyScopeImpl.obtainVirtualFile(dir);
                if (vFile == null || !vFile.isValid()) continue;
                this.myVcsManager.iterateVfUnderVcsRoot(vFile, processor);
            }
        }
        for (VirtualFile root : this.myAffectedContentRoots) {
            THashSet<FilePath> files = this.myDirtyFiles.get(root);
            if (files == null) continue;
            for (FilePath file : files) {
                vFile = VcsDirtyScopeImpl.obtainVirtualFile(file);
                if (vFile == null || !vFile.isValid()) continue;
                processor.process((Object)vFile);
                if (!vFile.isDirectory()) continue;
                for (VirtualFile child : vFile.getChildren()) {
                    processor.process((Object)child);
                }
            }
        }
    }

    @Nullable
    private static VirtualFile obtainVirtualFile(FilePath file) {
        VirtualFile vFile = file.getVirtualFile();
        return vFile == null ? VfsUtil.findFileByIoFile((File)file.getIOFile(), (boolean)false) : vFile;
    }

    public boolean isEmpty() {
        return this.myDirtyDirectoriesRecursively.isEmpty() && this.myDirtyFiles.isEmpty();
    }

    public boolean belongsTo(FilePath path2) {
        if (this.myProject.isDisposed()) {
            return false;
        }
        VcsRoot rootObject = this.myVcsManager.getVcsRootObjectFor(path2);
        if (rootObject == null || rootObject.getVcs() != this.myVcs) {
            return false;
        }
        VirtualFile vcsRoot = rootObject.getPath();
        boolean pathIsRoot = vcsRoot.equals(path2.getVirtualFile());
        for (VirtualFile contentRoot : this.myDirtyDirectoriesRecursively.keySet()) {
            THashSet<FilePath> dirsByRoot;
            boolean strict;
            if (!VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)vcsRoot, (boolean)(strict = pathIsRoot && !this.myVcs.areDirectoriesVersionedItems())) || !VcsDirtyScopeImpl.hasAncestor(dirsByRoot = this.myDirtyDirectoriesRecursively.get(contentRoot), path2)) continue;
            return true;
        }
        if (!this.myDirtyFiles.isEmpty()) {
            if (this.isInDirtyFiles(path2, vcsRoot)) {
                return true;
            }
            FilePath parent = path2.getParentPath();
            if (parent != null && this.isInDirtyFiles(parent, (VirtualFile)(!pathIsRoot ? vcsRoot : null))) {
                return true;
            }
        }
        return false;
    }

    private boolean isInDirtyFiles(@NotNull FilePath path2, @Nullable VirtualFile vcsRoot) {
        THashSet<FilePath> files;
        if (path2 == null) {
            VcsDirtyScopeImpl.$$$reportNull$$$0(15);
        }
        if (vcsRoot == null) {
            VcsRoot rootObject = this.myVcsManager.getVcsRootObjectFor(path2);
            if (rootObject == null || !this.myVcs.equals((Object)rootObject.getVcs())) {
                return false;
            }
            vcsRoot = rootObject.getPath();
        }
        return (files = this.myDirtyFiles.get(vcsRoot)) != null && files.contains((Object)path2);
    }

    @NonNls
    public String toString() {
        StringBuilder result2 = new StringBuilder("VcsDirtyScope[");
        if (!this.myDirtyFiles.isEmpty()) {
            result2.append(" files: ");
            for (THashSet<FilePath> paths : this.myDirtyFiles.values()) {
                for (FilePath file : paths) {
                    result2.append(file).append(" ");
                }
            }
        }
        if (!this.myDirtyDirectoriesRecursively.isEmpty()) {
            result2.append("\ndirs: ");
            for (THashSet<FilePath> dirsByRoot : this.myDirtyDirectoriesRecursively.values()) {
                for (FilePath file : dirsByRoot) {
                    result2.append(file).append(" ");
                }
            }
        }
        result2.append("\naffected roots: ");
        for (VirtualFile contentRoot : this.myAffectedContentRoots) {
            result2.append(contentRoot.getPath()).append(" ");
        }
        result2.append("]");
        return result2.toString();
    }

    public boolean wasEveryThingDirty() {
        return this.myWasEverythingDirty;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/VcsDirtyScopeImpl";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirs";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathsMap";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/VcsDirtyScopeImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcs";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "removeAncestorsRecursive";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "removeAncestorsNonRecursive";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 12: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addDirtyData";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addFilePathsToMap";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeAncestorsRecursive";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeAncestorsNonRecursive";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasAncestor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isInDirtyFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

