/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.google.common.collect.Iterables;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwitchedFileHolder
implements FileHolder {
    private final Project myProject;
    private final ProjectLevelVcsManager myVcsManager;
    private final TreeMap<VirtualFile, Pair<Boolean, String>> myMap;

    public SwitchedFileHolder(Project project) {
        this.myProject = project;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myMap = new TreeMap(FilePathComparator.getInstance());
    }

    @Override
    public void cleanAll() {
        this.myMap.clear();
    }

    @Override
    public synchronized SwitchedFileHolder copy() {
        SwitchedFileHolder copyHolder = new SwitchedFileHolder(this.myProject);
        copyHolder.myMap.putAll(this.myMap);
        return copyHolder;
    }

    @Override
    public void cleanAndAdjustScope(@NotNull VcsModifiableDirtyScope scope) {
        if (scope == null) {
            SwitchedFileHolder.$$$reportNull$$$0(0);
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        Iterator<VirtualFile> iterator = this.myMap.keySet().iterator();
        while (iterator.hasNext()) {
            VirtualFile file = iterator.next();
            if (!this.isFileDirty((VcsDirtyScope)scope, file)) continue;
            iterator.remove();
        }
    }

    private boolean isFileDirty(VcsDirtyScope scope, VirtualFile file) {
        if (scope == null) {
            return true;
        }
        if (this.fileDropped(file)) {
            return true;
        }
        return scope.belongsTo(VcsUtil.getFilePath((VirtualFile)file));
    }

    private boolean fileDropped(VirtualFile file) {
        return !file.isValid() || this.myVcsManager.getVcsFor(file) == null;
    }

    public Map<VirtualFile, String> getFilesMapCopy() {
        HashMap<VirtualFile, String> result2 = new HashMap<VirtualFile, String>();
        for (VirtualFile vf : this.myMap.keySet()) {
            result2.put(vf, (String)this.myMap.get(vf).getSecond());
        }
        return result2;
    }

    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @NotNull
    public Collection<VirtualFile> values() {
        Set<VirtualFile> set = this.myMap.keySet();
        if (set == null) {
            SwitchedFileHolder.$$$reportNull$$$0(1);
        }
        return set;
    }

    public void addFile(VirtualFile file, String branch, boolean recursive) {
        this.myMap.put(file, (Pair<Boolean, String>)new Pair((Object)recursive, (Object)branch));
    }

    public void removeFile(@NotNull VirtualFile file) {
        if (file == null) {
            SwitchedFileHolder.$$$reportNull$$$0(2);
        }
        this.myMap.remove(file);
    }

    public synchronized MultiMap<String, VirtualFile> getBranchToFileMap() {
        MultiMap result2 = new MultiMap();
        for (VirtualFile vf : this.myMap.keySet()) {
            result2.putValue(this.myMap.get(vf).getSecond(), (Object)vf);
        }
        return result2;
    }

    public synchronized boolean containsFile(@NotNull VirtualFile file) {
        VirtualFile floor;
        if (file == null) {
            SwitchedFileHolder.$$$reportNull$$$0(3);
        }
        if ((floor = this.myMap.floorKey(file)) == null) {
            return false;
        }
        NavigableMap<VirtualFile, Pair<Boolean, String>> floorMap = this.myMap.headMap(floor, true);
        for (VirtualFile parent : floorMap.keySet()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)file, (boolean)false)) continue;
            Pair value = (Pair)floorMap.get(parent);
            return parent.equals(file) || (Boolean)value.getFirst() != false;
        }
        return false;
    }

    @Nullable
    public String getBranchForFile(VirtualFile file) {
        VirtualFile floor = this.myMap.floorKey(file);
        if (floor == null) {
            return null;
        }
        SortedMap<VirtualFile, Pair<Boolean, String>> floorMap = this.myMap.headMap(floor);
        for (VirtualFile parent : floorMap.keySet()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)file, (boolean)false)) continue;
            return (String)((Pair)floorMap.get(parent)).getSecond();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SwitchedFileHolder that = (SwitchedFileHolder)o;
        return Iterables.elementsEqual(this.myMap.entrySet(), that.myMap.entrySet());
    }

    public int hashCode() {
        return this.myMap.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/SwitchedFileHolder";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/SwitchedFileHolder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "cleanAndAdjustScope";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "containsFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

