/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.actions.AnnotateRevisionActionBase;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.UpToDateLineNumberListener;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.vcsUtil.VcsUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AnnotateRevisionAction
extends AnnotateRevisionActionBase
implements DumbAware,
UpToDateLineNumberListener {
    @NotNull
    protected final FileAnnotation myAnnotation;
    @NotNull
    private final AbstractVcs myVcs;
    private int currentLine;

    AnnotateRevisionAction(@Nullable String text2, @Nullable String description, @Nullable Icon icon, @NotNull FileAnnotation annotation, @NotNull AbstractVcs vcs) {
        if (annotation == null) {
            AnnotateRevisionAction.$$$reportNull$$$0(0);
        }
        if (vcs == null) {
            AnnotateRevisionAction.$$$reportNull$$$0(1);
        }
        super(text2, description, icon);
        this.myAnnotation = annotation;
        this.myVcs = vcs;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AnnotateRevisionAction.$$$reportNull$$$0(2);
        }
        if (Boolean.TRUE.equals(e.getData(PlatformDataKeys.IS_MODAL_CONTEXT))) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (this.myAnnotation.getFile() == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        super.update(e);
    }

    @Nullable
    protected abstract VcsFileRevision getRevision(int var1);

    @Override
    @Nullable
    protected AbstractVcs getVcs(@NotNull AnActionEvent e) {
        if (e == null) {
            AnnotateRevisionAction.$$$reportNull$$$0(3);
        }
        return this.myVcs;
    }

    @Override
    @Nullable
    protected VirtualFile getFile(@NotNull AnActionEvent e) {
        VcsFileRevision revision;
        if (e == null) {
            AnnotateRevisionAction.$$$reportNull$$$0(4);
        }
        if ((revision = this.getFileRevision(e)) == null) {
            return null;
        }
        FileType currentFileType = this.myAnnotation.getFile().getFileType();
        FilePath filePath = revision instanceof VcsFileRevisionEx ? ((VcsFileRevisionEx)revision).getPath() : VcsUtil.getFilePath((VirtualFile)this.myAnnotation.getFile());
        return new MyVcsVirtualFile(filePath, revision, currentFileType);
    }

    @Override
    @Nullable
    protected VcsFileRevision getFileRevision(@NotNull AnActionEvent e) {
        if (e == null) {
            AnnotateRevisionAction.$$$reportNull$$$0(5);
        }
        return this.getRevision(this.currentLine);
    }

    @Override
    protected int getAnnotatedLine(@NotNull AnActionEvent e) {
        if (e == null) {
            AnnotateRevisionAction.$$$reportNull$$$0(6);
        }
        if (this.currentLine < 0) {
            return super.getAnnotatedLine(e);
        }
        return this.currentLine;
    }

    @Override
    @Nullable
    protected Editor getEditor(@NotNull AnActionEvent e) {
        if (e == null) {
            AnnotateRevisionAction.$$$reportNull$$$0(7);
        }
        return (Editor)e.getData(CommonDataKeys.EDITOR);
    }

    public void consume(Integer integer) {
        this.currentLine = integer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/actions/AnnotateRevisionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getVcs";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileRevision";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnnotatedLine";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyVcsVirtualFile
    extends VcsVirtualFile {
        @NotNull
        private final FileType myCurrentFileType;

        MyVcsVirtualFile(@NotNull FilePath filePath, @NotNull VcsFileRevision revision, @NotNull FileType currentFileType) {
            if (filePath == null) {
                MyVcsVirtualFile.$$$reportNull$$$0(0);
            }
            if (revision == null) {
                MyVcsVirtualFile.$$$reportNull$$$0(1);
            }
            if (currentFileType == null) {
                MyVcsVirtualFile.$$$reportNull$$$0(2);
            }
            super(filePath.getPath(), revision, (VirtualFileSystem)VcsFileSystem.getInstance());
            this.myCurrentFileType = currentFileType;
        }

        @NotNull
        public FileType getFileType() {
            FileType type = super.getFileType();
            if (!type.isBinary()) {
                FileType fileType = type;
                if (fileType == null) {
                    MyVcsVirtualFile.$$$reportNull$$$0(3);
                }
                return fileType;
            }
            if (!this.myCurrentFileType.isBinary()) {
                FileType fileType = this.myCurrentFileType;
                if (fileType == null) {
                    MyVcsVirtualFile.$$$reportNull$$$0(4);
                }
                return fileType;
            }
            PlainTextFileType plainTextFileType = PlainTextFileType.INSTANCE;
            if (plainTextFileType == null) {
                MyVcsVirtualFile.$$$reportNull$$$0(5);
            }
            return plainTextFileType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentFileType";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/actions/AnnotateRevisionAction$MyVcsVirtualFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/actions/AnnotateRevisionAction$MyVcsVirtualFile";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

