/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.status.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.status.HgChangesetStatus;
import org.zmlx.hg4idea.status.ui.HgHideableWidget;

public class HgIncomingOutgoingWidget
extends EditorBasedWidget
implements StatusBarWidget.IconPresentation,
StatusBarWidget.Multiframe,
HgUpdater,
HgHideableWidget {
    @NotNull
    private final HgVcs myVcs;
    @NotNull
    final Project myProject;
    @NotNull
    private final HgProjectSettings myProjectSettings;
    @NotNull
    private final HgChangesetStatus myChangesStatus;
    private final boolean myIsIncoming;
    private boolean isAlreadyShown;
    @NotNull
    private final Icon myEnabledIcon;
    @NotNull
    private final Icon myDisabledIcon;
    private volatile String myTooltip;
    private Icon myCurrentIcon;

    public HgIncomingOutgoingWidget(@NotNull HgVcs vcs, @NotNull Project project, @NotNull HgProjectSettings projectSettings, boolean isIncoming) {
        if (vcs == null) {
            HgIncomingOutgoingWidget.$$$reportNull$$$0(0);
        }
        if (project == null) {
            HgIncomingOutgoingWidget.$$$reportNull$$$0(1);
        }
        if (projectSettings == null) {
            HgIncomingOutgoingWidget.$$$reportNull$$$0(2);
        }
        super(project);
        this.myTooltip = "";
        this.myProject = project;
        this.myIsIncoming = isIncoming;
        this.myVcs = vcs;
        this.myProjectSettings = projectSettings;
        this.myChangesStatus = new HgChangesetStatus(isIncoming ? "In" : "Out");
        this.isAlreadyShown = false;
        this.myEnabledIcon = this.myIsIncoming ? AllIcons.Ide.IncomingChangesOn : AllIcons.Ide.OutgoingChangesOn;
        this.myCurrentIcon = this.myDisabledIcon = IconLoader.getDisabledIcon((Icon)this.myEnabledIcon);
        Disposer.register((Disposable)project, (Disposable)this);
    }

    public StatusBarWidget copy() {
        return new HgIncomingOutgoingWidget(this.myVcs, this.myProject, this.myProjectSettings, this.myIsIncoming);
    }

    @NotNull
    public String ID() {
        String name = HgIncomingOutgoingWidget.class.getName();
        String string = this.myIsIncoming ? "In" + name : "Out" + name;
        if (string == null) {
            HgIncomingOutgoingWidget.$$$reportNull$$$0(3);
        }
        return string;
    }

    public StatusBarWidget.WidgetPresentation getPresentation() {
        return this;
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            HgIncomingOutgoingWidget.$$$reportNull$$$0(4);
        }
        this.update();
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            HgIncomingOutgoingWidget.$$$reportNull$$$0(5);
        }
        if (file == null) {
            HgIncomingOutgoingWidget.$$$reportNull$$$0(6);
        }
        this.update();
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            HgIncomingOutgoingWidget.$$$reportNull$$$0(7);
        }
        if (file == null) {
            HgIncomingOutgoingWidget.$$$reportNull$$$0(8);
        }
        this.update();
    }

    public String getTooltipText() {
        return this.myTooltip;
    }

    public Consumer<MouseEvent> getClickConsumer() {
        return mouseEvent -> this.update();
    }

    public boolean isVisible() {
        return this.myProjectSettings.isCheckIncomingOutgoing();
    }

    @Override
    public void update(Project project, @Nullable VirtualFile root) {
        if (!this.isVisible()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project == null || project.isDisposed()) {
                this.emptyTooltip();
                return;
            }
            boolean changesAvailable = this.myChangesStatus.getNumChanges() > 0;
            this.myCurrentIcon = changesAvailable ? this.myEnabledIcon : this.myDisabledIcon;
            String string = this.myTooltip = changesAvailable ? "\n" + this.myChangesStatus.getToolTip() : "No changes available";
            if (!this.isVisible() || !this.isAlreadyShown) {
                return;
            }
            if (this.myStatusBar != null) {
                this.myStatusBar.updateWidget(this.ID());
            }
        });
    }

    public void activate() {
        MessageBusConnection busConnection = this.myProject.getMessageBus().connect();
        busConnection.subscribe(HgVcs.STATUS_TOPIC, (Object)this);
        busConnection.subscribe(HgVcs.INCOMING_OUTGOING_CHECK_TOPIC, (Object)this);
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.myProject);
        if (null != statusBar && this.isVisible()) {
            statusBar.addWidget((StatusBarWidget)this, (Disposable)this.myProject);
            this.isAlreadyShown = true;
        }
    }

    public void deactivate() {
        if (!this.isAlreadyShown) {
            return;
        }
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.myProject);
        if (null != statusBar) {
            statusBar.removeWidget(this.ID());
            this.isAlreadyShown = false;
        }
    }

    @Override
    public void show() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.isAlreadyShown) {
                return;
            }
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.myProject);
            if (null != statusBar && this.isVisible()) {
                statusBar.addWidget((StatusBarWidget)this, (Disposable)this.myProject);
                this.isAlreadyShown = true;
                ((HgUpdater)BackgroundTaskUtil.syncPublisher((Project)this.myProject, HgVcs.REMOTE_TOPIC)).update(this.myProject, null);
            }
        }, ModalityState.any());
    }

    @Override
    public void hide() {
        ApplicationManager.getApplication().invokeLater(() -> this.deactivate(), ModalityState.any());
    }

    @Override
    public void update() {
        this.update(this.myProject, null);
    }

    private void emptyTooltip() {
        this.myTooltip = "";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = this.myCurrentIcon;
        if (icon == null) {
            HgIncomingOutgoingWidget.$$$reportNull$$$0(9);
        }
        return icon;
    }

    public HgChangesetStatus getChangesetStatus() {
        return this.myChangesStatus;
    }

    public void dispose() {
        if (!this.isDisposed()) {
            super.dispose();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSettings";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/status/ui/HgIncomingOutgoingWidget";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/status/ui/HgIncomingOutgoingWidget";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "ID";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectionChanged";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fileOpened";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fileClosed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

