/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.SingletonNotificationManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.terminal.TerminalShellCommandHandler;
import com.intellij.util.Alarm;
import com.jediterm.terminal.StyledTextConsumer;
import com.jediterm.terminal.StyledTextConsumerAdapter;
import com.jediterm.terminal.SubstringFinder;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.TerminalTextBuffer;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.arrangement.TerminalWorkingDirectoryManager;

public class TerminalShellCommandHandlerHelper {
    private static final Logger LOG = Logger.getInstance(TerminalShellCommandHandler.class);
    @NonNls
    private static final String TERMINAL_CUSTOM_COMMANDS_GOT_IT = "TERMINAL_CUSTOM_COMMANDS_GOT_IT";
    @NonNls
    private static final String GOT_IT = "got_it";
    @NonNls
    private static final String FEATURE_ID = "terminal.shell.command.handling";
    private static Experiments ourExperiments;
    private final ShellTerminalWidget myWidget;
    private final Alarm myAlarm;
    private volatile String myWorkingDirectory;
    private volatile Boolean myHasRunningCommands;
    private PropertiesComponent myPropertiesComponent;

    TerminalShellCommandHandlerHelper(@NotNull ShellTerminalWidget widget) {
        if (widget == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(0);
        }
        this.myWidget = widget;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)widget);
    }

    public void processKeyPressed() {
        if (TerminalShellCommandHandlerHelper.isFeatureEnabled()) {
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(() -> this.highlightMatchedCommand(this.myWidget.getProject()), 50);
        }
    }

    public static boolean isFeatureEnabled() {
        Experiments experiments = ourExperiments;
        if (experiments == null) {
            ourExperiments = experiments = (Experiments)ReadAction.compute(() -> ApplicationManager.getApplication().isDisposed() ? null : Experiments.getInstance());
        }
        return experiments != null && experiments.isFeatureEnabled(FEATURE_ID);
    }

    private void highlightMatchedCommand(@NotNull Project project) {
        if (project == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(1);
        }
        if (!this.isEnabledForProject()) {
            this.myWidget.getTerminalPanel().setFindResult(null);
            return;
        }
        String command = this.myWidget.getTypedShellCommand();
        SubstringFinder.FindResult result = TerminalShellCommandHandler.Companion.matches(project, this.getWorkingDirectory(), !this.hasRunningCommands(), command) ? this.searchMatchedCommand(command, true) : null;
        this.myWidget.getTerminalPanel().setFindResult(result);
        if (this.getPropertiesComponent().getBoolean(TERMINAL_CUSTOM_COMMANDS_GOT_IT, false)) {
            return;
        }
        if (result != null) {
            String title = TerminalBundle.message("smart_command_execution.notification.title", new Object[0]);
            String content = TerminalBundle.message("smart_command_execution.notification.text", GOT_IT);
            new SingletonNotificationManager(NotificationGroup.toolWindowGroup((String)"Terminal", (String)"Terminal"), NotificationType.INFORMATION, null).notify(title, content, project, (NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                    if (notification == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (TerminalShellCommandHandlerHelper.GOT_IT.equals(e.getDescription())) {
                        TerminalShellCommandHandlerHelper.this.getPropertiesComponent().setValue(TerminalShellCommandHandlerHelper.TERMINAL_CUSTOM_COMMANDS_GOT_IT, true, false);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/plugins/terminal/TerminalShellCommandHandlerHelper$1";
                    objectArray[2] = "hyperlinkActivated";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private boolean isEnabledForProject() {
        return this.getPropertiesComponent().getBoolean("terminalCustomCommandExecutionTurnOff", true);
    }

    @NotNull
    private PropertiesComponent getPropertiesComponent() {
        PropertiesComponent propertiesComponent = this.myPropertiesComponent;
        if (propertiesComponent == null) {
            this.myPropertiesComponent = propertiesComponent = (PropertiesComponent)ReadAction.compute(() -> PropertiesComponent.getInstance((Project)this.myWidget.getProject()));
        }
        PropertiesComponent propertiesComponent2 = propertiesComponent;
        if (propertiesComponent2 == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(2);
        }
        return propertiesComponent2;
    }

    @Nullable
    private String getWorkingDirectory() {
        String workingDirectory = this.myWorkingDirectory;
        if (workingDirectory == null) {
            this.myWorkingDirectory = workingDirectory = StringUtil.notNullize((String)TerminalWorkingDirectoryManager.getWorkingDirectory(this.myWidget, null));
        }
        return StringUtil.nullize((String)workingDirectory);
    }

    private boolean hasRunningCommands() {
        Boolean hasRunningCommands = this.myHasRunningCommands;
        if (hasRunningCommands == null) {
            this.myHasRunningCommands = hasRunningCommands = Boolean.valueOf(this.myWidget.hasRunningCommands());
        }
        return hasRunningCommands;
    }

    @Nullable
    private SubstringFinder.FindResult searchMatchedCommand(@NotNull String pattern, boolean ignoreCase) {
        if (pattern == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(3);
        }
        if (pattern.length() == 0) {
            return null;
        }
        final SubstringFinder finder = new SubstringFinder(pattern, ignoreCase);
        StyledTextConsumerAdapter consumer = new StyledTextConsumerAdapter(){

            public void consume(int x, int y, @NotNull TextStyle style, @NotNull CharBuffer characters, int startRow) {
                if (style == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (characters == null) {
                    2.$$$reportNull$$$0(1);
                }
                for (int i = 0; i < characters.length(); ++i) {
                    finder.nextChar(x, y - startRow, characters, i);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "style";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "characters";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/terminal/TerminalShellCommandHandlerHelper$2";
                objectArray[2] = "consume";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myWidget.processTerminalBuffer(arg_0 -> this.lambda$searchMatchedCommand$3((StyledTextConsumer)consumer, arg_0));
        return finder.getResult();
    }

    public boolean processEnterKeyPressed(@NotNull String command, @NotNull KeyEvent keyPressed) {
        if (command == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(4);
        }
        if (keyPressed == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(5);
        }
        if (!TerminalShellCommandHandlerHelper.isFeatureEnabled() || !this.isEnabledForProject()) {
            this.onShellCommandExecuted();
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("typed shell command to execute: " + command);
        }
        this.myAlarm.cancelAllRequests();
        if ((keyPressed.getModifiers() & 2) == 0) {
            this.onShellCommandExecuted();
            return false;
        }
        if (!TerminalShellCommandHandler.Companion.matches(this.myWidget.getProject(), this.getWorkingDirectory(), !this.hasRunningCommands(), command)) {
            this.onShellCommandExecuted();
            return false;
        }
        TerminalShellCommandHandler.Companion.executeShellCommandHandler(this.myWidget.getProject(), this.getWorkingDirectory(), !this.hasRunningCommands(), command);
        this.clearTypedCommand(command);
        return true;
    }

    private void onShellCommandExecuted() {
        this.myWorkingDirectory = null;
        this.myHasRunningCommands = null;
    }

    private void clearTypedCommand(@NotNull String command) {
        if (command == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(6);
        }
        TtyConnector connector = this.myWidget.getTtyConnector();
        byte[] array = new byte[command.length()];
        Arrays.fill(array, (byte)8);
        try {
            connector.write(array);
        }
        catch (IOException e) {
            LOG.info("Cannot clear shell command " + command, (Throwable)e);
        }
    }

    private /* synthetic */ Void lambda$searchMatchedCommand$3(StyledTextConsumer consumer, TerminalTextBuffer textBuffer) {
        textBuffer.processScreenLines(this.myWidget.getLineNumberAtCursor(), 1, consumer);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widget";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/TerminalShellCommandHandlerHelper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyPressed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/TerminalShellCommandHandlerHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "highlightMatchedCommand";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "searchMatchedCommand";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processEnterKeyPressed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "clearTypedCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

