/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NullableNotNullManager {
    protected static final Logger LOG = Logger.getInstance(NullableNotNullManager.class);
    protected final Project myProject;

    protected NullableNotNullManager(Project project) {
        this.myProject = project;
    }

    @NotNull
    abstract List<String> getDefaultNullables();

    @NotNull
    abstract List<String> getDefaultNotNulls();

    @NotNull
    abstract List<String> getAllDefaultAnnotations();

    public static NullableNotNullManager getInstance(Project project) {
        return (NullableNotNullManager)ServiceManager.getService((Project)project, NullableNotNullManager.class);
    }

    public boolean hasNullability(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(0);
        }
        return this.isNullable(owner, false) || this.isNotNull(owner, false);
    }

    public abstract void setNotNulls(String ... var1);

    public abstract void setNullables(String ... var1);

    @NotNull
    public abstract String getDefaultNullable();

    @Nullable
    public PsiAnnotation getNullableAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(1);
        }
        return this.findNullityAnnotationWithDefault(owner, checkBases, true);
    }

    public abstract void setDefaultNullable(@NotNull String var1);

    @NotNull
    public abstract String getDefaultNotNull();

    @Nullable
    public PsiAnnotation getNotNullAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(2);
        }
        return this.findNullityAnnotationWithDefault(owner, checkBases, false);
    }

    @Nullable
    public PsiAnnotation copyNotNullAnnotation(@NotNull PsiModifierListOwner original, @NotNull PsiModifierListOwner generated) {
        NullabilityAnnotationInfo info;
        if (original == null) {
            NullableNotNullManager.$$$reportNull$$$0(3);
        }
        if (generated == null) {
            NullableNotNullManager.$$$reportNull$$$0(4);
        }
        if ((info = this.findOwnNullabilityInfo(original)) == null || info.getNullability() != Nullability.NOT_NULL) {
            return null;
        }
        return NullableNotNullManager.copyAnnotation(info.getAnnotation(), generated);
    }

    @Nullable
    public PsiAnnotation copyNullableAnnotation(@NotNull PsiModifierListOwner original, @NotNull PsiModifierListOwner generated) {
        NullabilityAnnotationInfo info;
        if (original == null) {
            NullableNotNullManager.$$$reportNull$$$0(5);
        }
        if (generated == null) {
            NullableNotNullManager.$$$reportNull$$$0(6);
        }
        if ((info = this.findOwnNullabilityInfo(original)) == null || info.getNullability() != Nullability.NULLABLE) {
            return null;
        }
        return NullableNotNullManager.copyAnnotation(info.getAnnotation(), generated);
    }

    @Nullable
    public PsiAnnotation copyNullableOrNotNullAnnotation(@NotNull PsiModifierListOwner original, @NotNull PsiModifierListOwner generated) {
        NullabilityAnnotationInfo src;
        if (original == null) {
            NullableNotNullManager.$$$reportNull$$$0(7);
        }
        if (generated == null) {
            NullableNotNullManager.$$$reportNull$$$0(8);
        }
        if ((src = this.findOwnNullabilityInfo(original)) == null) {
            return null;
        }
        NullabilityAnnotationInfo effective = this.findEffectiveNullabilityInfo(generated);
        if (effective != null && effective.getNullability() == src.getNullability()) {
            return null;
        }
        return NullableNotNullManager.copyAnnotation(src.getAnnotation(), generated);
    }

    @Nullable
    private static PsiAnnotation copyAnnotation(@NotNull PsiAnnotation annotation, @NotNull PsiModifierListOwner target) {
        String qualifiedName;
        if (annotation == null) {
            NullableNotNullManager.$$$reportNull$$$0(9);
        }
        if (target == null) {
            NullableNotNullManager.$$$reportNull$$$0(10);
        }
        if ((qualifiedName = annotation.getQualifiedName()) != null) {
            PsiModifierList modifierList;
            if (JavaPsiFacade.getInstance(annotation.getProject()).findClass(qualifiedName, target.getResolveScope()) == null) {
                return null;
            }
            if (!AnnotationTargetUtil.isTypeAnnotation(annotation) && (modifierList = target.getModifierList()) != null && !modifierList.hasAnnotation(qualifiedName)) {
                return modifierList.addAnnotation(qualifiedName);
            }
        }
        return null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public PsiAnnotation copyNotNullAnnotation(@NotNull PsiModifierListOwner owner) {
        NullabilityAnnotationInfo info;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(11);
        }
        if ((info = this.findOwnNullabilityInfo(owner)) == null || info.getNullability() != Nullability.NOT_NULL) {
            return null;
        }
        String qualifiedName = info.getAnnotation().getQualifiedName();
        return qualifiedName != null ? JavaPsiFacade.getElementFactory(owner.getProject()).createAnnotationFromText("@" + qualifiedName, owner) : null;
    }

    public abstract void setDefaultNotNull(@NotNull String var1);

    @Nullable
    private PsiAnnotation findNullityAnnotationWithDefault(@NotNull PsiModifierListOwner owner, boolean checkBases, boolean nullable) {
        List<PsiParameter> superParameters;
        int flags;
        PsiAnnotation annotation;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(12);
        }
        if ((annotation = this.findPlainNullityAnnotation(owner, checkBases)) != null) {
            List<String> contradictory;
            String qName = annotation.getQualifiedName();
            if (qName == null) {
                return null;
            }
            List<String> list = contradictory = nullable ? this.getNotNullsWithNickNames() : this.getNullablesWithNickNames();
            if (contradictory.contains(qName)) {
                return null;
            }
            return annotation;
        }
        PsiType type = NullableNotNullManager.getOwnerType(owner);
        if (type == null || TypeConversionUtil.isPrimitiveAndNotNull(type)) {
            return null;
        }
        List<String> annotations = nullable ? this.getDefaultNotNulls() : this.getDefaultNullables();
        if (AnnotationUtil.isAnnotated(owner, annotations, flags = (checkBases ? 1 : 0) | 2 | 4 | 8)) {
            return null;
        }
        if (!nullable && this.hasHardcodedContracts(owner)) {
            return null;
        }
        if (owner instanceof PsiParameter && !nullable && checkBases && !(superParameters = AnnotationUtil.getSuperAnnotationOwners((PsiParameter)owner)).isEmpty()) {
            return this.takeAnnotationFromSuperParameters((PsiParameter)owner, superParameters);
        }
        NullabilityAnnotationInfo nullityDefault = this.findNullityDefaultInHierarchy(owner);
        Nullability wantedNullability = nullable ? Nullability.NULLABLE : Nullability.NOT_NULL;
        return nullityDefault != null && nullityDefault.getNullability() == wantedNullability ? nullityDefault.getAnnotation() : null;
    }

    @Nullable
    public NullabilityAnnotationInfo findOwnNullabilityInfo(@NotNull PsiModifierListOwner owner) {
        PsiType type;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(13);
        }
        if ((type = NullableNotNullManager.getOwnerType(owner)) == null || TypeConversionUtil.isPrimitiveAndNotNull(type)) {
            return null;
        }
        List<String> nullables = this.getNullablesWithNickNames();
        PsiAnnotation annotation = this.findPlainNullityAnnotation(owner, false);
        if (annotation != null) {
            return new NullabilityAnnotationInfo(annotation, nullables.contains(annotation.getQualifiedName()) ? Nullability.NULLABLE : Nullability.NOT_NULL, false);
        }
        return null;
    }

    @Nullable
    public NullabilityAnnotationInfo findExplicitNullability(PsiModifierListOwner owner) {
        PsiAnnotation annotation = NullableNotNullManager.findPlainAnnotation(owner, this.getAllNullabilityAnnotationsWithNickNames(), false, true);
        if (annotation != null) {
            Nullability nullability = this.getNullablesWithNickNames().contains(annotation.getQualifiedName()) ? Nullability.NULLABLE : Nullability.NOT_NULL;
            return new NullabilityAnnotationInfo(annotation, nullability, false);
        }
        return this.findNullityDefaultInHierarchy(owner);
    }

    @Nullable
    public NullabilityAnnotationInfo findEffectiveNullabilityInfo(@NotNull PsiModifierListOwner owner) {
        PsiType type;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(14);
        }
        if ((type = NullableNotNullManager.getOwnerType(owner)) == null || TypeConversionUtil.isPrimitiveAndNotNull(type)) {
            return null;
        }
        return (NullabilityAnnotationInfo)CachedValuesManager.getCachedValue((PsiElement)owner, () -> CachedValueProvider.Result.create((Object)this.doFindEffectiveNullabilityAnnotation(owner), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private NullabilityAnnotationInfo doFindEffectiveNullabilityAnnotation(@NotNull PsiModifierListOwner owner) {
        List<PsiParameter> superParameters;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(15);
        }
        Set<String> annotationNames = this.getAllNullabilityAnnotationsWithNickNames();
        HashSet<String> extraAnnotations = new HashSet<String>(this.getAllDefaultAnnotations());
        extraAnnotations.addAll(annotationNames);
        PsiAnnotation annotation = NullableNotNullManager.findPlainAnnotation(owner, extraAnnotations, true, false);
        if (annotation != null) {
            if (!annotationNames.contains(annotation.getQualifiedName())) {
                return null;
            }
            List<String> nullables = this.getNullablesWithNickNames();
            return new NullabilityAnnotationInfo(annotation, nullables.contains(annotation.getQualifiedName()) ? Nullability.NULLABLE : Nullability.NOT_NULL, false);
        }
        if (owner instanceof PsiParameter && !(superParameters = AnnotationUtil.getSuperAnnotationOwners((PsiParameter)owner)).isEmpty()) {
            for (PsiParameter parameter : superParameters) {
                PsiAnnotation plain = NullableNotNullManager.findPlainAnnotation(parameter, extraAnnotations, false, false);
                if (plain != null) {
                    return null;
                }
                NullabilityAnnotationInfo defaultInfo = this.findNullityDefaultInHierarchy(parameter);
                if (defaultInfo == null) continue;
                return defaultInfo.getNullability() == Nullability.NOT_NULL ? defaultInfo : null;
            }
            return null;
        }
        NullabilityAnnotationInfo defaultInfo = this.findNullityDefaultInHierarchy(owner);
        if (!(defaultInfo == null || defaultInfo.getNullability() != Nullability.NULLABLE && this.hasHardcodedContracts(owner))) {
            return defaultInfo;
        }
        return null;
    }

    private PsiAnnotation takeAnnotationFromSuperParameters(@NotNull PsiParameter owner, @NotNull List<? extends PsiParameter> superOwners) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(16);
        }
        if (superOwners == null) {
            NullableNotNullManager.$$$reportNull$$$0(17);
        }
        return (PsiAnnotation)RecursionManager.doPreventingRecursion((Object)owner, (boolean)true, () -> {
            for (PsiParameter superOwner : superOwners) {
                PsiAnnotation anno = this.findNullityAnnotationWithDefault(superOwner, false, false);
                if (anno == null) continue;
                return anno;
            }
            return null;
        });
    }

    private PsiAnnotation findPlainNullityAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(18);
        }
        Set<String> qNames = this.getAllNullabilityAnnotationsWithNickNames();
        return NullableNotNullManager.findPlainAnnotation(owner, qNames, checkBases, false);
    }

    @Nullable
    public PsiAnnotation findExplicitNullabilityAnnotation(@NotNull PsiModifierListOwner owner, @NotNull Nullability nullability) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(19);
        }
        if (nullability == null) {
            NullableNotNullManager.$$$reportNull$$$0(20);
        }
        if (nullability == Nullability.UNKNOWN) {
            return null;
        }
        List<String> names = nullability == Nullability.NULLABLE ? this.getNullablesWithNickNames() : this.getNotNullsWithNickNames();
        return NullableNotNullManager.findPlainAnnotation(owner, new HashSet<String>(names), false, false);
    }

    @Nullable
    private static PsiAnnotation findPlainAnnotation(@NotNull PsiModifierListOwner owner, @NotNull Set<String> qualifiedNames, boolean checkBases, boolean skipExternal) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(21);
        }
        if (qualifiedNames == null) {
            NullableNotNullManager.$$$reportNull$$$0(22);
        }
        PsiAnnotation memberAnno = checkBases && owner instanceof PsiMethod ? AnnotationUtil.findAnnotationInHierarchy(owner, qualifiedNames, skipExternal) : AnnotationUtil.findAnnotation(owner, qualifiedNames, skipExternal);
        PsiType type = NullableNotNullManager.getOwnerType(owner);
        if (memberAnno != null && type instanceof PsiArrayType && AnnotationTargetUtil.isTypeAnnotation(memberAnno)) {
            memberAnno = null;
        }
        if (memberAnno != null) {
            PsiAnnotation annotation = NullableNotNullManager.preferTypeAnnotation(memberAnno, type);
            if (annotation != memberAnno && !qualifiedNames.contains(annotation.getQualifiedName())) {
                return null;
            }
            return annotation;
        }
        if (type instanceof PsiPrimitiveType) {
            return null;
        }
        return AnnotationUtil.findAnnotationInTypeHierarchy(type, qualifiedNames);
    }

    @NotNull
    private static PsiAnnotation preferTypeAnnotation(@NotNull PsiAnnotation memberAnno, @Nullable PsiType type) {
        if (memberAnno == null) {
            NullableNotNullManager.$$$reportNull$$$0(23);
        }
        if (type != null) {
            for (PsiAnnotation typeAnno : type.getApplicableAnnotations()) {
                if (!NullableNotNullManager.areDifferentNullityAnnotations(memberAnno, typeAnno)) continue;
                PsiAnnotation psiAnnotation = typeAnno;
                if (psiAnnotation == null) {
                    NullableNotNullManager.$$$reportNull$$$0(24);
                }
                return psiAnnotation;
            }
        }
        PsiAnnotation psiAnnotation = memberAnno;
        if (psiAnnotation == null) {
            NullableNotNullManager.$$$reportNull$$$0(25);
        }
        return psiAnnotation;
    }

    private static boolean areDifferentNullityAnnotations(@NotNull PsiAnnotation memberAnno, @NotNull PsiAnnotation typeAnno) {
        if (memberAnno == null) {
            NullableNotNullManager.$$$reportNull$$$0(26);
        }
        if (typeAnno == null) {
            NullableNotNullManager.$$$reportNull$$$0(27);
        }
        NullableNotNullManager manager = NullableNotNullManager.getInstance(memberAnno.getProject());
        List<String> notNulls = manager.getNotNullsWithNickNames();
        List<String> nullables = manager.getNullablesWithNickNames();
        return nullables.contains(typeAnno.getQualifiedName()) && notNulls.contains(memberAnno.getQualifiedName()) || nullables.contains(memberAnno.getQualifiedName()) && notNulls.contains(typeAnno.getQualifiedName());
    }

    @NotNull
    protected List<String> getNullablesWithNickNames() {
        List<String> list = this.getNullables();
        if (list == null) {
            NullableNotNullManager.$$$reportNull$$$0(28);
        }
        return list;
    }

    @NotNull
    protected List<String> getNotNullsWithNickNames() {
        List<String> list = this.getNotNulls();
        if (list == null) {
            NullableNotNullManager.$$$reportNull$$$0(29);
        }
        return list;
    }

    @NotNull
    protected Set<String> getAllNullabilityAnnotationsWithNickNames() {
        HashSet<String> qNames = new HashSet<String>(this.getNullablesWithNickNames());
        qNames.addAll(this.getNotNullsWithNickNames());
        Set<String> set = Collections.unmodifiableSet(qNames);
        if (set == null) {
            NullableNotNullManager.$$$reportNull$$$0(30);
        }
        return set;
    }

    protected boolean hasHardcodedContracts(@NotNull PsiElement element) {
        if (element == null) {
            NullableNotNullManager.$$$reportNull$$$0(31);
        }
        return false;
    }

    @Nullable
    private static PsiType getOwnerType(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(32);
        }
        if (owner instanceof PsiVariable) {
            return ((PsiVariable)owner).getType();
        }
        if (owner instanceof PsiMethod) {
            return ((PsiMethod)owner).getReturnType();
        }
        return null;
    }

    public boolean isNullable(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(33);
        }
        return this.findNullityAnnotationWithDefault(owner, checkBases, true) != null;
    }

    public boolean isNotNull(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(34);
        }
        return this.findNullityAnnotationWithDefault(owner, checkBases, false) != null;
    }

    @Nullable
    NullabilityAnnotationInfo findNullityDefaultInHierarchy(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(35);
        }
        PsiAnnotation.TargetType[] placeTargetTypes = AnnotationTargetUtil.getTargetsForLocation(owner.getModifierList());
        for (PsiElement element = owner.getParent(); element != null; element = element.getContext()) {
            NullabilityAnnotationInfo result;
            if (element instanceof PsiModifierListOwner && (result = this.getNullityDefault((PsiModifierListOwner)element, placeTargetTypes, owner, false)) != null) {
                return result;
            }
            if (!(element instanceof PsiClassOwner)) continue;
            String packageName = ((PsiClassOwner)element).getPackageName();
            return this.findNullityDefaultOnPackage(placeTargetTypes, JavaPsiFacade.getInstance(element.getProject()).findPackage(packageName), owner);
        }
        return null;
    }

    @Nullable
    private NullabilityAnnotationInfo findNullityDefaultOnPackage(PsiAnnotation.TargetType @NotNull [] placeTargetTypes, @Nullable PsiPackage psiPackage, PsiModifierListOwner owner) {
        if (placeTargetTypes == null) {
            NullableNotNullManager.$$$reportNull$$$0(36);
        }
        boolean superPackage = false;
        while (psiPackage != null) {
            NullabilityAnnotationInfo onPkg = this.getNullityDefault(psiPackage, placeTargetTypes, owner, superPackage);
            if (onPkg != null) {
                return onPkg;
            }
            superPackage = true;
            psiPackage = psiPackage.getParentPackage();
        }
        return null;
    }

    @Nullable
    abstract NullabilityAnnotationInfo getNullityDefault(@NotNull PsiModifierListOwner var1, PsiAnnotation.TargetType @NotNull [] var2, PsiModifierListOwner var3, boolean var4);

    @NotNull
    public abstract List<String> getNullables();

    @NotNull
    public abstract List<String> getNotNulls();

    public static boolean isNullable(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(37);
        }
        return NullableNotNullManager.getNullability(owner) == Nullability.NULLABLE;
    }

    public static boolean isNotNull(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(38);
        }
        return NullableNotNullManager.getNullability(owner) == Nullability.NOT_NULL;
    }

    @NotNull
    public static Nullability getNullability(@NotNull PsiModifierListOwner owner) {
        NullabilityAnnotationInfo info;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(39);
        }
        Nullability nullability = (info = NullableNotNullManager.getInstance(owner.getProject()).findEffectiveNullabilityInfo(owner)) == null ? Nullability.UNKNOWN : info.getNullability();
        if (nullability == null) {
            NullableNotNullManager.$$$reportNull$$$0(40);
        }
        return nullability;
    }

    @NotNull
    public abstract List<String> getInstrumentedNotNulls();

    public abstract void setInstrumentedNotNulls(@NotNull List<String> var1);

    public static boolean isNullabilityAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            NullableNotNullManager.$$$reportNull$$$0(41);
        }
        return NullableNotNullManager.getInstance(annotation.getProject()).getAllNullabilityAnnotationsWithNickNames().contains(annotation.getQualifiedName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generated";
                break;
            }
            case 9: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superOwners";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullability";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedNames";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberAnno";
                break;
            }
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/NullableNotNullManager";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAnno";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeTargetTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/NullableNotNullManager";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "preferTypeAnnotation";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullablesWithNickNames";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullsWithNickNames";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllNullabilityAnnotationsWithNickNames";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullability";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasNullability";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNullableAnnotation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNotNullAnnotation";
                break;
            }
            case 3: 
            case 4: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "copyNotNullAnnotation";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyNullableAnnotation";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyNullableOrNotNullAnnotation";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copyAnnotation";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findNullityAnnotationWithDefault";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findOwnNullabilityInfo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findEffectiveNullabilityInfo";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doFindEffectiveNullabilityAnnotation";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "takeAnnotationFromSuperParameters";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findPlainNullityAnnotation";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findExplicitNullabilityAnnotation";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findPlainAnnotation";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "preferTypeAnnotation";
                break;
            }
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 40: {
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "areDifferentNullityAnnotations";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "hasHardcodedContracts";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getOwnerType";
                break;
            }
            case 33: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isNullable";
                break;
            }
            case 34: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isNotNull";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findNullityDefaultInHierarchy";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findNullityDefaultOnPackage";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getNullability";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isNullabilityAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

