/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.CollectionComponentParameter;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public final class ComponentParameter
implements Parameter {
    public static final ComponentParameter DEFAULT = new ComponentParameter();
    public static final ComponentParameter ARRAY = new ComponentParameter(false);
    private final Parameter collectionParameter;
    private final Object componentKey;

    public ComponentParameter(Object componentKey) {
        this(componentKey, null);
    }

    public ComponentParameter() {
        this(false);
    }

    public ComponentParameter(boolean emptyCollection) {
        this(null, emptyCollection ? CollectionComponentParameter.ARRAY_ALLOW_EMPTY : CollectionComponentParameter.ARRAY);
    }

    public ComponentParameter(Class componentValueType, boolean emptyCollection) {
        this(null, new CollectionComponentParameter(componentValueType, emptyCollection));
    }

    public ComponentParameter(Class componentKeyType, Class componentValueType, boolean emptyCollection) {
        this(null, new CollectionComponentParameter(componentKeyType, componentValueType, emptyCollection));
    }

    private ComponentParameter(Object componentKey, Parameter collectionParameter) {
        this.componentKey = componentKey;
        this.collectionParameter = collectionParameter;
    }

    @Override
    public Object resolveInstance(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        Object result = null;
        ComponentAdapter componentAdapter = this.resolveAdapter(container, adapter, expectedType);
        if (componentAdapter != null) {
            result = container.getComponentInstance(componentAdapter.getComponentKey());
        }
        if (result == null && this.collectionParameter != null) {
            result = this.collectionParameter.resolveInstance(container, adapter, expectedType);
        }
        return result;
    }

    @Override
    public boolean isResolvable(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        if (this.resolveAdapter(container, adapter, expectedType) == null) {
            if (this.collectionParameter != null) {
                return this.collectionParameter.isResolvable(container, adapter, expectedType);
            }
            return false;
        }
        return true;
    }

    @Override
    public void verify(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        try {
            ComponentAdapter componentAdapter = this.resolveAdapter(container, adapter, expectedType);
            if (componentAdapter == null) {
                throw new UnsatisfiableDependenciesException(adapter, Collections.singleton(expectedType), container);
            }
        }
        catch (UnsatisfiableDependenciesException e) {
            if (this.collectionParameter != null) {
                this.collectionParameter.verify(container, adapter, expectedType);
                return;
            }
            throw e;
        }
    }

    private ComponentAdapter resolveAdapter(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        ComponentAdapter result = this.getTargetAdapter(container, expectedType, adapter);
        if (result == null) {
            return null;
        }
        if (!expectedType.isAssignableFrom(result.getComponentImplementation())) {
            if (expectedType.isPrimitive()) {
                try {
                    Field field = result.getComponentImplementation().getField("TYPE");
                    Class type = (Class)field.get(result.getComponentInstance(null));
                    if (expectedType.isAssignableFrom(type)) {
                        return result;
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return null;
        }
        return result;
    }

    private ComponentAdapter getTargetAdapter(PicoContainer container, Class expectedType, ComponentAdapter excludeAdapter) {
        if (this.componentKey != null) {
            return container.getComponentAdapter(this.componentKey);
        }
        if (excludeAdapter == null) {
            return container.getComponentAdapterOfType(expectedType);
        }
        Object excludeKey = excludeAdapter.getComponentKey();
        ComponentAdapter byKey = container.getComponentAdapter(expectedType);
        if (byKey != null && !excludeKey.equals(byKey.getComponentKey())) {
            return byKey;
        }
        List<ComponentAdapter> found = container.getComponentAdaptersOfType(expectedType);
        ComponentAdapter exclude = null;
        for (ComponentAdapter o : found) {
            ComponentAdapter work = o;
            if (!work.getComponentKey().equals(excludeKey)) continue;
            exclude = work;
        }
        found.remove(exclude);
        if (found.size() == 0) {
            if (container.getParent() != null) {
                return container.getParent().getComponentAdapterOfType(expectedType);
            }
            return null;
        }
        if (found.size() == 1) {
            return found.get(0);
        }
        Object[] foundClasses = new Class[found.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            foundClasses[i] = found.get(i).getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(expectedType, foundClasses);
    }
}

