/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetIndex;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BuildListener;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompileContextImpl;
import org.jetbrains.jps.incremental.messages.FileDeletedEvent;
import org.jetbrains.jps.incremental.messages.FileGeneratedEvent;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.FileStampStorage;
import org.jetbrains.jps.incremental.storage.MurmurHashingService;
import org.jetbrains.jps.incremental.storage.ProjectStamps;
import org.jetbrains.jps.incremental.storage.StampsStorage;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaProjectExtension;
import org.jetbrains.jps.util.JpsPathUtil;

@ApiStatus.Experimental
public class BuildTargetSourcesState
implements BuildListener {
    private static final Logger LOG = Logger.getInstance(BuildTargetSourcesState.class);
    private static final String TARGET_SOURCES_STATE_FILE_NAME = "target_sources_state.json";
    private final Map<String, BuildTarget<?>> myChangedBuildTargets;
    private final PathRelativizerService myRelativizer;
    private final BuildTargetIndex myBuildTargetIndex;
    private final BuildRootIndex myBuildRootIndex;
    private final ProjectStamps myProjectStamps;
    private final CompileContextImpl myContext;
    private final String myOutputFolderPath;
    private final File myTargetStateStorage;
    private final Type myTokenType;
    private final Gson gson;

    public BuildTargetSourcesState(@NotNull CompileContextImpl context) {
        if (context == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(0);
        }
        this.gson = new Gson();
        this.myContext = context;
        this.myChangedBuildTargets = new ConcurrentHashMap();
        ProjectDescriptor pd = this.myContext.getProjectDescriptor();
        this.myProjectStamps = pd.getProjectStamps();
        this.myBuildRootIndex = pd.getBuildRootIndex();
        this.myBuildTargetIndex = pd.getBuildTargetIndex();
        this.myRelativizer = pd.dataManager.getRelativizer();
        this.myOutputFolderPath = BuildTargetSourcesState.getOutputFolderPath(pd.getProject());
        BuildDataPaths dataPaths = pd.getTargetsState().getDataPaths();
        this.myTargetStateStorage = new File(dataPaths.getDataStorageRoot(), TARGET_SOURCES_STATE_FILE_NAME);
        this.myTokenType = new TypeToken<Map<String, Map<String, BuildTargetState>>>(){}.getType();
        this.myContext.addBuildListener(this);
    }

    public void reportSourcesState() {
        List<BuildTarget<?>> buildTargets;
        if (this.reportStateUnavailable()) {
            return;
        }
        long start = System.nanoTime();
        Map<String, Map<String, BuildTargetState>> targetTypeHashMap = this.loadCurrentTargetState();
        if (targetTypeHashMap.isEmpty()) {
            buildTargets = this.myBuildTargetIndex.getAllTargets();
        } else {
            ArrayList changedBuildTargets = new ArrayList(this.myChangedBuildTargets.values());
            LOG.info("List of changed build targets: " + changedBuildTargets);
            buildTargets = changedBuildTargets;
        }
        buildTargets.forEach(target -> {
            BuildTargetType buildTargetType = target.getTargetType();
            String typeTypeId = buildTargetType.getTypeId();
            this.getBuildTargetHash((BuildTarget<?>)target, this.myContext).ifPresent(buildTargetHash -> {
                String hexString = StringUtil.toHexString((byte[])buildTargetHash);
                String relativePath = target.getOutputRoots(this.myContext).stream().map(file -> this.myRelativizer.toRelative(file.getAbsolutePath())).findFirst().orElse("");
                targetTypeHashMap.computeIfAbsent(typeTypeId, key -> new HashMap()).put(target.getId(), new BuildTargetState(hexString, relativePath));
            });
        });
        try {
            FileUtil.writeToFile((File)this.myTargetStateStorage, (String)this.gson.toJson(targetTypeHashMap));
        }
        catch (IOException e) {
            LOG.warn("Unable to save sources state", (Throwable)e);
        }
        LOG.info("Build target sources report took: " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) + " ms");
    }

    public void clearSourcesState() {
        if (this.reportStateUnavailable()) {
            return;
        }
        if (this.myTargetStateStorage.exists()) {
            LOG.info("Clear build target sources report");
            FileUtil.delete((File)this.myTargetStateStorage);
        }
    }

    @Override
    public void filesGenerated(@NotNull FileGeneratedEvent event) {
        if (event == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(1);
        }
        if (this.reportStateUnavailable()) {
            return;
        }
        BuildTarget<?> sourceTarget = event.getSourceTarget();
        String key = sourceTarget.getTargetType().getTypeId() + " " + sourceTarget.getId();
        this.myChangedBuildTargets.put(key, sourceTarget);
    }

    @Override
    public void filesDeleted(@NotNull FileDeletedEvent event) {
        if (event == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(2);
        }
        if (this.reportStateUnavailable()) {
            return;
        }
        event.getFilePaths().stream().map(path -> new File(FileUtil.toSystemDependentName((String)path))).map(file -> this.myBuildRootIndex.findAllParentDescriptors((File)file, this.myContext)).flatMap(collection -> collection.stream()).forEach(buildRootDesc -> {
            BuildTarget<?> target = buildRootDesc.getTarget();
            String key = target.getTargetType().getTypeId() + target.getId();
            this.myChangedBuildTargets.put(key, target);
        });
    }

    @NotNull
    private Optional<byte[]> getBuildTargetHash(final @NotNull BuildTarget<?> target, @NotNull CompileContext context) {
        if (target == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(3);
        }
        if (context == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(4);
        }
        Optional<byte[]> optional = this.myBuildRootIndex.getTargetRoots(target, context).stream().map(rootDescriptor -> {
            try {
                final File rootFile = rootDescriptor.getRootFile();
                if (!rootFile.exists() || rootFile.getAbsolutePath().startsWith(this.myOutputFolderPath)) {
                    return null;
                }
                final ArrayList targetRootHashes = new ArrayList();
                Files.walkFileTree(rootFile.toPath(), EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                        return BuildTargetSourcesState.this.myBuildRootIndex.isDirectoryAccepted(dir.toFile(), rootDescriptor) ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                        File file = path.toFile();
                        if (!BuildTargetSourcesState.this.myBuildRootIndex.isFileAccepted(file, rootDescriptor)) {
                            return FileVisitResult.CONTINUE;
                        }
                        BuildTargetSourcesState.this.getFileHash(target, file, rootFile).ifPresent(targetRootHashes::add);
                        return FileVisitResult.CONTINUE;
                    }
                });
                return targetRootHashes;
            }
            catch (IOException e) {
                LOG.warn("Couldn't calculate build target hash for : " + target.getPresentableName(), (Throwable)e);
                return null;
            }
        }).filter(it -> !ContainerUtil.isEmpty((Collection)it)).flatMap(Collection::stream).reduce((acc, value) -> BuildTargetSourcesState.sum(acc, value));
        if (optional == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(5);
        }
        return optional;
    }

    @NotNull
    private Optional<byte[]> getFileHash(@NotNull BuildTarget<?> target, @NotNull File file, @NotNull File rootPath) throws IOException {
        if (target == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(6);
        }
        if (file == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(7);
        }
        if (rootPath == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(8);
        }
        StampsStorage<? extends StampsStorage.Stamp> storage = this.myProjectStamps.getStampStorage();
        assert (storage instanceof FileStampStorage);
        FileStampStorage fileStampStorage = (FileStampStorage)storage;
        byte[] fileHash = fileStampStorage.getStoredFileHash(file, target);
        if (fileHash == null) {
            Optional<byte[]> optional = Optional.empty();
            if (optional == null) {
                BuildTargetSourcesState.$$$reportNull$$$0(9);
            }
            return optional;
        }
        byte[] stringHash = MurmurHashingService.getStringHash(BuildTargetSourcesState.toRelative(file, rootPath));
        Optional<byte[]> optional = Optional.of(BuildTargetSourcesState.sum(stringHash, fileHash));
        if (optional == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(10);
        }
        return optional;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private Map<String, Map<String, BuildTargetState>> loadCurrentTargetState() {
        Throwable throwable;
        BufferedReader bufferedReader;
        block16: {
            Map map;
            if (!this.myTargetStateStorage.exists()) {
                return new HashMap<String, Map<String, BuildTargetState>>();
            }
            try {
                Map map2;
                block17: {
                    block18: {
                        bufferedReader = new BufferedReader(new FileReader(this.myTargetStateStorage));
                        throwable = null;
                        try {
                            Map result = (Map)this.gson.fromJson((Reader)bufferedReader, this.myTokenType);
                            if (result == null) break block16;
                            map2 = result;
                            if (bufferedReader == null) break block17;
                            if (throwable == null) break block18;
                        }
                        catch (Throwable throwable4) {
                            try {
                                throwable = throwable4;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (bufferedReader == null) throw throwable5;
                                if (throwable == null) {
                                    bufferedReader.close();
                                    throw throwable5;
                                }
                                try {
                                    bufferedReader.close();
                                    throw throwable5;
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                    throw throwable5;
                                }
                            }
                        }
                        try {
                            bufferedReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block17;
                    }
                    bufferedReader.close();
                }
                map = map2;
            }
            catch (IOException e) {
                LOG.warn("Couldn't parse current build target state", (Throwable)e);
                return new HashMap<String, Map<String, BuildTargetState>>();
            }
            if (map != null) return map;
            BuildTargetSourcesState.$$$reportNull$$$0(11);
            return map;
        }
        if (bufferedReader == null) return new HashMap<String, Map<String, BuildTargetState>>();
        if (throwable == null) {
            bufferedReader.close();
            return new HashMap<String, Map<String, BuildTargetState>>();
        }
        try {
            bufferedReader.close();
            return new HashMap<String, Map<String, BuildTargetState>>();
        }
        catch (Throwable throwable3) {
            throwable.addSuppressed(throwable3);
            return new HashMap<String, Map<String, BuildTargetState>>();
        }
    }

    private boolean reportStateUnavailable() {
        return !ProjectStamps.PORTABLE_CACHES || this.myProjectStamps == null;
    }

    @NotNull
    private static String toRelative(@NotNull File target, @NotNull File rootPath) {
        if (target == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(12);
        }
        if (rootPath == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(13);
        }
        String string = FileUtilRt.toSystemIndependentName((String)Paths.get(rootPath.getPath(), new String[0]).relativize(Paths.get(target.getPath(), new String[0])).toString());
        if (string == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    private static String getOutputFolderPath(JpsProject project) {
        JpsJavaProjectExtension projectExtension = JpsJavaExtensionService.getInstance().getProjectExtension(project);
        if (projectExtension == null) {
            return "";
        }
        String url = projectExtension.getOutputUrl();
        if (StringUtil.isEmpty((String)url)) {
            return "";
        }
        String string = JpsPathUtil.urlToFile((String)url).getAbsolutePath();
        if (string == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static byte @NotNull [] sum(byte[] firstHash, byte[] secondHash) {
        byte[] result = firstHash != null ? firstHash : new byte[16];
        for (int i = 0; i < result.length; ++i) {
            int n = i;
            result[n] = (byte)(result[n] + secondHash[i]);
        }
        if (result == null) {
            BuildTargetSourcesState.$$$reportNull$$$0(16);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/incremental/storage/BuildTargetSourcesState";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/incremental/storage/BuildTargetSourcesState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildTargetHash";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileHash";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "loadCurrentTargetState";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "toRelative";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputFolderPath";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "sum";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "filesGenerated";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "filesDeleted";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBuildTargetHash";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFileHash";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "toRelative";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BuildTargetState {
        private final String hash;
        private final String relativePath;

        private BuildTargetState(String hash, String relativePath) {
            this.hash = hash;
            this.relativePath = relativePath;
        }
    }
}

