/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.java;

import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.dependencyView.Callbacks;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.javac.ast.api.JavacDef;
import org.jetbrains.jps.javac.ast.api.JavacFileReferencesRegistrar;
import org.jetbrains.jps.javac.ast.api.JavacRef;
import org.jetbrains.jps.javac.ast.api.JavacTypeCast;

public class JpsReferenceDependenciesRegistrar
implements JavacFileReferencesRegistrar {
    @Override
    public void initialize() {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void registerFile(CompileContext context, String filePath, TObjectIntHashMap<? extends JavacRef> refs, Collection<? extends JavacDef> defs, Collection<? extends JavacTypeCast> casts, Collection<? extends JavacRef> implicitToString) {
        HashSet<String> definedClasses = new HashSet<String>();
        for (JavacDef javacDef : defs) {
            JavacRef element;
            if (!(javacDef instanceof JavacDef.JavacClassDef) || !((element = javacDef.getDefinedElement()) instanceof JavacRef.JavacClass)) continue;
            definedClasses.add(element.getName());
        }
        if (definedClasses.isEmpty()) {
            return;
        }
        if (!refs.isEmpty()) {
            Callbacks.Backend reg;
            HashSet<String> classImports = new HashSet<String>();
            HashSet<String> hashSet = new HashSet<String>();
            HashMap cRefs = new HashMap();
            refs.forEachKey(ref -> {
                JavacRef.JavacField fieldRef;
                String descriptor;
                JavacRef.ImportProperties importProps = ref.getImportProperties();
                if (importProps != null) {
                    if (ref instanceof JavacRef.JavacClass) {
                        classImports.add(ref.getName());
                        if (importProps.isStatic() && importProps.isOnDemand()) {
                            staticImports.add(ref.getName() + ".*");
                        }
                    } else if (ref instanceof JavacRef.JavacField || ref instanceof JavacRef.JavacMethod) {
                        staticImports.add(ref.getOwnerName() + "." + ref.getName());
                    }
                } else if (ref instanceof JavacRef.JavacField && ref.getModifiers().contains((Object)Modifier.FINAL) && (descriptor = (fieldRef = (JavacRef.JavacField)ref).getDescriptor()) != null && definedClasses.contains(fieldRef.getContainingClass()) && !definedClasses.contains(fieldRef.getOwnerName())) {
                    ArrayList<Callbacks.ConstantRef> refsList = (ArrayList<Callbacks.ConstantRef>)cRefs.get(fieldRef.getContainingClass());
                    if (refsList == null) {
                        refsList = new ArrayList<Callbacks.ConstantRef>();
                        cRefs.put(fieldRef.getContainingClass(), refsList);
                    }
                    refsList.add(Callbacks.createConstantReference(fieldRef.getOwnerName(), fieldRef.getName(), descriptor));
                }
                return true;
            });
            if (!classImports.isEmpty() || !hashSet.isEmpty()) {
                reg = JavaBuilderUtil.getDependenciesRegistrar(context);
                for (String aClass : definedClasses) {
                    reg.registerImports(aClass, classImports, hashSet);
                }
            }
            if (!cRefs.isEmpty()) {
                reg = JavaBuilderUtil.getDependenciesRegistrar(context);
                Iterator iterator = definedClasses.iterator();
                while (iterator.hasNext()) {
                    String aClass;
                    List<Callbacks.ConstantRef> classCRefs = (List<Callbacks.ConstantRef>)cRefs.get(aClass = (String)iterator.next());
                    reg.registerConstantReferences(aClass, classCRefs != null ? classCRefs : Collections.emptyList());
                }
            }
        }
    }
}

