/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.InfoCommandRepositoryProvider;
import org.jetbrains.idea.svn.api.Repository;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.api.UrlMappingRepositoryProvider;
import org.jetbrains.idea.svn.commandLine.BaseCommandRuntimeModule;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandRuntime;
import org.jetbrains.idea.svn.commandLine.CommandUtil;

public class CommandParametersResolutionModule
extends BaseCommandRuntimeModule {
    public CommandParametersResolutionModule(@NotNull CommandRuntime runtime) {
        if (runtime == null) {
            CommandParametersResolutionModule.$$$reportNull$$$0(0);
        }
        super(runtime);
    }

    @Override
    public void onStart(@NotNull Command command) {
        if (command == null) {
            CommandParametersResolutionModule.$$$reportNull$$$0(1);
        }
        if (command.getRepositoryUrl() == null) {
            command.setRepositoryUrl(this.resolveRepositoryUrl(command));
        }
        if (command.getWorkingDirectory() == null) {
            command.setWorkingDirectory(this.resolveWorkingDirectory(command));
        }
        command.setConfigDir(this.myAuthenticationService.getSpecialConfigDir().toFile());
        command.saveOriginalParameters();
    }

    @Nullable
    private Url resolveRepositoryUrl(@NotNull Command command) {
        if (command == null) {
            CommandParametersResolutionModule.$$$reportNull$$$0(2);
        }
        UrlMappingRepositoryProvider urlMappingProvider = new UrlMappingRepositoryProvider(this.myVcs, command.getTarget());
        InfoCommandRepositoryProvider infoCommandProvider = new InfoCommandRepositoryProvider(this.myVcs, command.getTarget());
        Repository repository = urlMappingProvider.get();
        if (repository == null && !command.isLocalInfo()) {
            repository = infoCommandProvider.get();
        }
        return repository != null ? repository.getUrl() : null;
    }

    @NotNull
    private File resolveWorkingDirectory(@NotNull Command command) {
        Target target;
        if (command == null) {
            CommandParametersResolutionModule.$$$reportNull$$$0(3);
        }
        File workingDirectory = (target = command.getTarget()).isFile() ? target.getFile() : null;
        workingDirectory = CommandUtil.findExistingParent(workingDirectory);
        return workingDirectory != null ? workingDirectory : CommandParametersResolutionModule.getDefaultWorkingDirectory(this.myVcs.getProject());
    }

    @NotNull
    public static File getDefaultWorkingDirectory(@NotNull Project project) {
        VirtualFile baseDir;
        if (project == null) {
            CommandParametersResolutionModule.$$$reportNull$$$0(4);
        }
        File file = (baseDir = project.getBaseDir()) != null ? VfsUtilCore.virtualToIoFile((VirtualFile)baseDir) : CommandUtil.getHomeDirectory();
        if (file == null) {
            CommandParametersResolutionModule.$$$reportNull$$$0(5);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtime";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/commandLine/CommandParametersResolutionModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/commandLine/CommandParametersResolutionModule";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultWorkingDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onStart";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveRepositoryUrl";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveWorkingDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultWorkingDirectory";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

