/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.LineCommandListener;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.properties.PropertyValue;

public class Command {
    @NotNull
    private final List<String> myParameters;
    @NotNull
    private final List<String> myOriginalParameters;
    @NotNull
    private final SvnCommandName myName;
    private File workingDirectory;
    @Nullable
    private File myConfigDir;
    @Nullable
    private LineCommandListener myResultBuilder;
    @Nullable
    private volatile Url myRepositoryUrl;
    @NotNull
    private Target myTarget;
    @Nullable
    private Collection<File> myTargets;
    @Nullable
    private PropertyValue myPropertyValue;
    @Nullable
    private ProgressTracker myCanceller;

    public Command(@NotNull SvnCommandName name) {
        if (name == null) {
            Command.$$$reportNull$$$0(0);
        }
        this.myParameters = new ArrayList<String>();
        this.myOriginalParameters = new ArrayList<String>();
        this.myName = name;
    }

    public void put(@Nullable Depth depth) {
        CommandUtil.put(this.myParameters, depth, false);
    }

    public void put(@NotNull Target target) {
        if (target == null) {
            Command.$$$reportNull$$$0(1);
        }
        CommandUtil.put(this.myParameters, target);
    }

    public void put(@Nullable Revision revision) {
        CommandUtil.put(this.myParameters, revision);
    }

    public void put(@NotNull String parameter, boolean condition) {
        if (parameter == null) {
            Command.$$$reportNull$$$0(2);
        }
        CommandUtil.put(this.myParameters, condition, parameter);
    }

    public void put(String ... parameters) {
        if (parameters == null) {
            Command.$$$reportNull$$$0(3);
        }
        this.put(Arrays.asList(parameters));
    }

    public void put(@NotNull List<String> parameters) {
        if (parameters == null) {
            Command.$$$reportNull$$$0(4);
        }
        this.myParameters.addAll(parameters);
    }

    public void putIfNotPresent(@NotNull String parameter) {
        if (parameter == null) {
            Command.$$$reportNull$$$0(5);
        }
        if (!this.myParameters.contains(parameter)) {
            this.myParameters.add(parameter);
        }
    }

    @Nullable
    public ProgressTracker getCanceller() {
        return this.myCanceller;
    }

    public void setCanceller(@Nullable ProgressTracker canceller) {
        this.myCanceller = canceller;
    }

    @Nullable
    public File getConfigDir() {
        return this.myConfigDir;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Nullable
    public LineCommandListener getResultBuilder() {
        return this.myResultBuilder;
    }

    @Nullable
    public Url getRepositoryUrl() {
        return this.myRepositoryUrl;
    }

    @NotNull
    public Url requireRepositoryUrl() {
        Url result = this.getRepositoryUrl();
        assert (result != null);
        Url url = result;
        if (url == null) {
            Command.$$$reportNull$$$0(6);
        }
        return url;
    }

    @NotNull
    public Target getTarget() {
        Target target = this.myTarget;
        if (target == null) {
            Command.$$$reportNull$$$0(7);
        }
        return target;
    }

    @Nullable
    public List<String> getTargetsPaths() {
        return ContainerUtil.isEmpty(this.myTargets) ? null : ContainerUtil.map(this.myTargets, file -> CommandUtil.format(file.getAbsolutePath(), null));
    }

    @Nullable
    public PropertyValue getPropertyValue() {
        return this.myPropertyValue;
    }

    @NotNull
    public SvnCommandName getName() {
        SvnCommandName svnCommandName = this.myName;
        if (svnCommandName == null) {
            Command.$$$reportNull$$$0(8);
        }
        return svnCommandName;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setConfigDir(@Nullable File configDir) {
        this.myConfigDir = configDir;
    }

    public void setResultBuilder(@Nullable LineCommandListener resultBuilder) {
        this.myResultBuilder = resultBuilder;
    }

    public void setRepositoryUrl(@Nullable Url repositoryUrl) {
        this.myRepositoryUrl = repositoryUrl;
    }

    public void setTarget(@NotNull Target target) {
        if (target == null) {
            Command.$$$reportNull$$$0(9);
        }
        this.myTarget = target;
    }

    public void setTargets(@Nullable Collection<File> targets) {
        this.myTargets = targets;
    }

    public void setPropertyValue(@Nullable PropertyValue propertyValue) {
        this.myPropertyValue = propertyValue;
    }

    public void saveOriginalParameters() {
        this.myOriginalParameters.clear();
        this.myOriginalParameters.addAll(this.myParameters);
    }

    @NotNull
    public List<String> getParameters() {
        return new ArrayList<String>(this.myParameters);
    }

    public String getText() {
        ArrayList<String> data = new ArrayList<String>();
        if (this.myConfigDir != null) {
            data.add("--config-dir");
            data.add(this.myConfigDir.getPath());
        }
        data.add(this.myName.getName());
        data.addAll(this.myOriginalParameters);
        List<String> targetsPaths = this.getTargetsPaths();
        if (!ContainerUtil.isEmpty(targetsPaths)) {
            data.addAll(targetsPaths);
        }
        return StringUtil.join(data, (String)" ");
    }

    public boolean isLocalInfo() {
        return this.is(SvnCommandName.info) && this.hasLocalTarget() && !this.myParameters.contains("--revision");
    }

    public boolean isLocalStatus() {
        return this.is(SvnCommandName.st) && this.hasLocalTarget() && !this.myParameters.contains("-u");
    }

    public boolean isLocalProperty() {
        boolean isPropertyCommand = this.is(SvnCommandName.proplist) || this.is(SvnCommandName.propget) || this.is(SvnCommandName.propset) || this.is(SvnCommandName.propdel);
        return isPropertyCommand && this.hasLocalTarget() && Command.isLocal(this.getRevision());
    }

    public boolean isLocalCat() {
        return this.is(SvnCommandName.cat) && this.hasLocalTarget() && Command.isLocal(this.getRevision());
    }

    @Nullable
    private Revision getRevision() {
        int index = this.myParameters.indexOf("--revision");
        return index >= 0 && index + 1 < this.myParameters.size() ? Revision.parse(this.myParameters.get(index + 1)) : null;
    }

    public boolean is(@NotNull SvnCommandName name) {
        if (name == null) {
            Command.$$$reportNull$$$0(10);
        }
        return name.equals((Object)this.myName);
    }

    private boolean hasLocalTarget() {
        return this.myTarget.isFile() && Command.isLocal(this.myTarget.getPegRevision());
    }

    private static boolean isLocal(@Nullable Revision revision) {
        return revision == null || Revision.UNDEFINED.equals(revision) || Revision.BASE.equals(revision) || Revision.WORKING.equals(revision);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/commandLine/Command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/commandLine/Command";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "requireRepositoryUrl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "putIfNotPresent";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setTarget";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "is";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

