/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.annotate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.AnnotationSource;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspectAdapter;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.annotate.AnnotationTooltipBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.checkin.CommitInfo;
import org.jetbrains.idea.svn.history.SvnFileRevision;

public abstract class BaseSvnFileAnnotation
extends FileAnnotation {
    protected final String myContents;
    protected final VcsRevisionNumber myBaseRevision;
    private final MyPartiallyCreatedInfos myInfos;
    protected final SvnVcs myVcs;
    private final Map<Long, SvnFileRevision> myRevisionMap;
    private final LineAnnotationAspect DATE_ASPECT;
    private final LineAnnotationAspect REVISION_ASPECT;
    private final LineAnnotationAspect ORIGINAL_REVISION_ASPECT;
    private final LineAnnotationAspect AUTHOR_ASPECT;
    private final SvnConfiguration myConfiguration;
    private final boolean myShowMergeSources;
    private SvnRevisionNumber myFirstRevisionNumber;

    public void setRevision(long revision, SvnFileRevision svnRevision) {
        this.myRevisionMap.put(revision, svnRevision);
    }

    public SvnFileRevision getRevision(long revision) {
        return this.myRevisionMap.get(revision);
    }

    public void setFirstRevision(Revision revision) {
        this.myFirstRevisionNumber = new SvnRevisionNumber(revision);
    }

    public SvnRevisionNumber getFirstRevisionNumber() {
        return this.myFirstRevisionNumber;
    }

    public BaseSvnFileAnnotation(@NotNull SvnVcs vcs, String contents, VcsRevisionNumber baseRevision) {
        if (vcs == null) {
            BaseSvnFileAnnotation.$$$reportNull$$$0(0);
        }
        super(vcs.getProject());
        this.myRevisionMap = new HashMap<Long, SvnFileRevision>();
        this.DATE_ASPECT = new SvnAnnotationAspect(LineAnnotationAspect.DATE, true){

            @Override
            public String getValue(@NotNull CommitInfo info2) {
                if (info2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return FileAnnotation.formatDate((Date)info2.getDate());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/annotate/BaseSvnFileAnnotation$1", "getValue"));
            }
        };
        this.REVISION_ASPECT = new SvnAnnotationAspect(LineAnnotationAspect.REVISION, false){

            @Override
            public String getValue(@NotNull CommitInfo info2) {
                if (info2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return String.valueOf(info2.getRevisionNumber());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/annotate/BaseSvnFileAnnotation$2", "getValue"));
            }
        };
        this.ORIGINAL_REVISION_ASPECT = new SvnAnnotationAspect(SvnBundle.message("annotation.original.revision", new Object[0]), false){

            @Override
            public String getValue(int lineNumber) {
                long value = BaseSvnFileAnnotation.this.myInfos.originalRevision(lineNumber);
                return value == -1L ? "" : String.valueOf(value);
            }

            @Override
            protected long getRevision(int lineNum) {
                return BaseSvnFileAnnotation.this.myInfos.originalRevision(lineNum);
            }

            public String getTooltipText(int lineNumber) {
                if (!BaseSvnFileAnnotation.this.myInfos.isValid(lineNumber)) {
                    return "";
                }
                CommitInfo info2 = BaseSvnFileAnnotation.this.myInfos.get(lineNumber);
                if (info2 == null) {
                    return null;
                }
                SvnFileRevision revision = (SvnFileRevision)BaseSvnFileAnnotation.this.myRevisionMap.get(info2.getRevisionNumber());
                return revision != null ? XmlStringUtil.escapeString((String)("Revision " + info2.getRevisionNumber() + ": " + revision.getCommitMessage())) : "";
            }
        };
        this.AUTHOR_ASPECT = new SvnAnnotationAspect(LineAnnotationAspect.AUTHOR, true){

            @Override
            public String getValue(@NotNull CommitInfo info2) {
                if (info2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                return info2.getAuthor();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/annotate/BaseSvnFileAnnotation$4", "getValue"));
            }
        };
        this.myVcs = vcs;
        this.myContents = contents;
        this.myBaseRevision = baseRevision;
        this.myConfiguration = vcs.getSvnConfiguration();
        this.myShowMergeSources = this.myConfiguration.isShowMergeSourcesInAnnotate();
        this.myInfos = new MyPartiallyCreatedInfos();
    }

    public LineAnnotationAspect[] getAspects() {
        return new LineAnnotationAspect[]{this.REVISION_ASPECT, this.DATE_ASPECT, this.AUTHOR_ASPECT};
    }

    @Nullable
    public String getToolTip(int lineNumber) {
        return this.getToolTip(lineNumber, false);
    }

    @Nullable
    public String getHtmlToolTip(int lineNumber) {
        return this.getToolTip(lineNumber, true);
    }

    @Nullable
    private String getToolTip(int lineNumber, boolean asHtml) {
        CommitInfo info2 = this.myInfos.getOrNull(lineNumber);
        if (info2 == null) {
            return null;
        }
        SvnFileRevision revision = this.myRevisionMap.get(info2.getRevisionNumber());
        if (revision == null) {
            return null;
        }
        String prefix = this.myInfos.getAnnotationSource(lineNumber).showMerged() ? "Merge source revision" : "Revision";
        return AnnotationTooltipBuilder.buildSimpleTooltip((Project)this.getProject(), (boolean)asHtml, (String)prefix, (String)String.valueOf(info2.getRevisionNumber()), (String)revision.getCommitMessage());
    }

    public String getAnnotatedContent() {
        return this.myContents;
    }

    public void setLineInfo(int lineNumber, @NotNull CommitInfo info2, @Nullable CommitInfo mergeInfo) {
        if (info2 == null) {
            BaseSvnFileAnnotation.$$$reportNull$$$0(1);
        }
        this.myInfos.appendNumberedLineInfo(lineNumber, info2, mergeInfo);
    }

    @Nullable
    public VcsRevisionNumber originalRevision(int lineNumber) {
        SvnFileRevision revision = this.myInfos.isValid(lineNumber) ? this.myRevisionMap.get(this.myInfos.originalRevision(lineNumber)) : null;
        return revision != null ? revision.getRevisionNumber() : null;
    }

    public VcsRevisionNumber getLineRevisionNumber(int lineNumber) {
        CommitInfo info2 = this.myInfos.getOrNull(lineNumber);
        return info2 != null && info2.getRevisionNumber() >= 0L ? new SvnRevisionNumber(Revision.of(info2.getRevisionNumber())) : null;
    }

    public Date getLineDate(int lineNumber) {
        CommitInfo info2 = this.myInfos.getOrNull(lineNumber);
        return info2 != null ? info2.getDate() : null;
    }

    public List<VcsFileRevision> getRevisions() {
        ArrayList<VcsFileRevision> result = new ArrayList<VcsFileRevision>(this.myRevisionMap.values());
        Collections.sort(result, (o1, o2) -> o2.getRevisionNumber().compareTo((Object)o1.getRevisionNumber()));
        return result;
    }

    @Nullable
    public AnnotationSourceSwitcher getAnnotationSourceSwitcher() {
        if (!this.myShowMergeSources) {
            return null;
        }
        return new AnnotationSourceSwitcher(){

            @NotNull
            public AnnotationSource getAnnotationSource(int lineNumber) {
                AnnotationSource annotationSource = BaseSvnFileAnnotation.this.myInfos.getAnnotationSource(lineNumber);
                if (annotationSource == null) {
                    5.$$$reportNull$$$0(0);
                }
                return annotationSource;
            }

            public boolean mergeSourceAvailable(int lineNumber) {
                return BaseSvnFileAnnotation.this.myInfos.mergeSourceAvailable(lineNumber);
            }

            @NotNull
            public LineAnnotationAspect getRevisionAspect() {
                LineAnnotationAspect lineAnnotationAspect = BaseSvnFileAnnotation.this.ORIGINAL_REVISION_ASPECT;
                if (lineAnnotationAspect == null) {
                    5.$$$reportNull$$$0(1);
                }
                return lineAnnotationAspect;
            }

            @NotNull
            public AnnotationSource getDefaultSource() {
                AnnotationSource annotationSource = AnnotationSource.getInstance((boolean)BaseSvnFileAnnotation.this.myShowMergeSources);
                if (annotationSource == null) {
                    5.$$$reportNull$$$0(2);
                }
                return annotationSource;
            }

            public void switchTo(AnnotationSource source) {
                BaseSvnFileAnnotation.this.myInfos.setShowMergeSource(source.showMerged());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/jetbrains/idea/svn/annotate/BaseSvnFileAnnotation$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAnnotationSource";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRevisionAspect";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDefaultSource";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    public int getLineCount() {
        return this.myInfos.size();
    }

    public VcsKey getVcsKey() {
        return SvnVcs.getKey();
    }

    protected abstract void showAllAffectedPaths(SvnRevisionNumber var1);

    @Nullable
    public VcsRevisionNumber getCurrentRevision() {
        return this.myBaseRevision;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/annotate/BaseSvnFileAnnotation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setLineInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyPartiallyCreatedInfos {
        private boolean myShowMergeSource;
        private final Map<Integer, CommitInfo> myMappedLineInfo;
        private final Map<Integer, CommitInfo> myMergeSourceInfos = new HashMap<Integer, CommitInfo>();
        private int myMaxIdx = 0;

        private MyPartiallyCreatedInfos() {
            this.myMappedLineInfo = new HashMap<Integer, CommitInfo>();
        }

        void setShowMergeSource(boolean showMergeSource) {
            this.myShowMergeSource = showMergeSource;
        }

        int size() {
            return this.myMaxIdx + 1;
        }

        void appendNumberedLineInfo(int lineNumber, @NotNull CommitInfo info2, @Nullable CommitInfo mergeInfo) {
            if (info2 == null) {
                MyPartiallyCreatedInfos.$$$reportNull$$$0(0);
            }
            if (this.myMappedLineInfo.get(lineNumber) != null) {
                return;
            }
            this.myMaxIdx = this.myMaxIdx < lineNumber ? lineNumber : this.myMaxIdx;
            this.myMappedLineInfo.put(lineNumber, info2);
            if (mergeInfo != null) {
                this.myMergeSourceInfos.put(lineNumber, mergeInfo);
            }
        }

        CommitInfo get(int idx) {
            CommitInfo lineInfo;
            if (this.myShowMergeSource && (lineInfo = this.myMergeSourceInfos.get(idx)) != null) {
                return lineInfo;
            }
            return this.myMappedLineInfo.get(idx);
        }

        @Nullable
        CommitInfo getOrNull(int lineNumber) {
            return this.isValid(lineNumber) ? this.get(lineNumber) : null;
        }

        private boolean isValid(int lineNumber) {
            return lineNumber >= 0 && lineNumber < this.size();
        }

        AnnotationSource getAnnotationSource(int line) {
            return this.myShowMergeSource ? AnnotationSource.getInstance((boolean)this.myMergeSourceInfos.containsKey(line)) : AnnotationSource.LOCAL;
        }

        public long originalRevision(int line) {
            CommitInfo info2 = line < this.size() ? this.myMappedLineInfo.get(line) : null;
            return info2 == null ? -1L : info2.getRevisionNumber();
        }

        public boolean mergeSourceAvailable(int lineNumber) {
            return this.myMergeSourceInfos.containsKey(lineNumber);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/annotate/BaseSvnFileAnnotation$MyPartiallyCreatedInfos", "appendNumberedLineInfo"));
        }
    }

    private abstract class SvnAnnotationAspect
    extends LineAnnotationAspectAdapter {
        SvnAnnotationAspect(String id, boolean showByDefault) {
            super(id, showByDefault);
        }

        protected long getRevision(int lineNum) {
            CommitInfo lineInfo = BaseSvnFileAnnotation.this.myInfos.get(lineNum);
            return lineInfo == null ? -1L : lineInfo.getRevisionNumber();
        }

        protected void showAffectedPaths(int lineNum) {
            long revision;
            if (BaseSvnFileAnnotation.this.myInfos.isValid(lineNum) && (revision = this.getRevision(lineNum)) >= 0L) {
                BaseSvnFileAnnotation.this.showAllAffectedPaths(new SvnRevisionNumber(Revision.of(revision)));
            }
        }

        public String getValue(int lineNumber) {
            CommitInfo info2 = BaseSvnFileAnnotation.this.myInfos.getOrNull(lineNumber);
            return info2 == null ? "" : this.getValue(info2);
        }

        public String getValue(@NotNull CommitInfo info2) {
            if (info2 == null) {
                SvnAnnotationAspect.$$$reportNull$$$0(0);
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/idea/svn/annotate/BaseSvnFileAnnotation$SvnAnnotationAspect", "getValue"));
        }
    }
}

