/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data;

import com.intellij.codeInsight.ExternalAnnotationsArtifactsResolver;
import com.intellij.codeInsight.externalAnnotation.location.AnnotationsLocation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.data.ExternalAnnotationsDataServiceKt;

@Order(value=1000)
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00172\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0016J6\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00100\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/data/ExternalAnnotationsDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lcom/intellij/openapi/externalSystem/model/project/LibraryData;", "Lcom/intellij/openapi/roots/libraries/Library;", "()V", "resolvers", "", "Lcom/intellij/codeInsight/ExternalAnnotationsArtifactsResolver;", "getResolvers", "()Ljava/util/Collection;", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "onSuccessImport", "", "imported", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModelsProvider;", "Companion", "intellij.gradle.java"})
public final class ExternalAnnotationsDataService
extends AbstractProjectDataService<LibraryData, Library> {
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public Key<LibraryData> getTargetDataKey() {
        Key key = ProjectKeys.LIBRARY;
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"ProjectKeys.LIBRARY");
        return key;
    }

    private final Collection<ExternalAnnotationsArtifactsResolver> getResolvers() {
        ExtensionPointName extensionPointName = ExternalAnnotationsArtifactsResolver.EP_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionPointName, (String)"ExternalAnnotationsArtifactsResolver.EP_NAME");
        List list = extensionPointName.getExtensionList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ExternalAnnotationsArtif\u2026ver.EP_NAME.extensionList");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public void onSuccessImport(@NotNull Collection<DataNode<LibraryData>> imported, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModelsProvider modelsProvider) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(imported, (String)"imported");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
        if (!ExternalAnnotationsDataServiceKt.shouldImportExternalAnnotations(projectData, project)) {
            return;
        }
        Iterable $this$mapNotNull$iv = imported;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair<Library, Collection<AnnotationsLocation>> pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DataNode it = (DataNode)element$iv$iv;
            boolean bl2 = false;
            Object object = it.getData();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.data");
            LibraryData libData = (LibraryData)object;
            if (modelsProvider.getLibraryByName(libData.getInternalName()) == null) {
                pair = null;
            } else {
                Library lib;
                Intrinsics.checkExpressionValueIsNotNull((Object)lib, (String)"modelsProvider.getLibrar\u2026?: return@mapNotNull null");
                pair = ExternalAnnotationsDataServiceKt.lookForLocations(project, lib, libData);
            }
            if (pair == null) continue;
            Pair<Library, Collection<AnnotationsLocation>> pair2 = pair;
            boolean bl3 = false;
            boolean bl4 = false;
            Pair<Library, Collection<AnnotationsLocation>> it$iv$iv = pair2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map providedAnnotations = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        ExternalAnnotationsDataServiceKt.resolveProvidedAnnotations(providedAnnotations, this.getResolvers(), project);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(ExternalAnnotationsDataService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Exter\u2026sDataService::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/data/ExternalAnnotationsDataService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gradle.java"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

