/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.findUsages;

import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class GradlePropertyReferencesSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    private static final String[] GRADLE_PROPERTY_FILES = new String[]{"gradle.properties"};
    private static final String GRADLE_DSL_EXTENSION = "gradle";

    public GradlePropertyReferencesSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        PsiElement element;
        if (queryParameters == null) {
            GradlePropertyReferencesSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            GradlePropertyReferencesSearcher.$$$reportNull$$$0(1);
        }
        if ((element = queryParameters.getElementToSearch()) instanceof Property && GradlePropertyReferencesSearcher.isContainingFileGradlePropertyFile(element.getContainingFile()) && queryParameters.getEffectiveSearchScope() instanceof GlobalSearchScope) {
            Property property = (Property)element;
            if (property.getName() == null) {
                return;
            }
            FileByExtensionSearchScope gradleSearchScope = new FileByExtensionSearchScope((GlobalSearchScope)queryParameters.getEffectiveSearchScope(), GRADLE_DSL_EXTENSION);
            int searchContext = 5;
            MyProcessor processor = new MyProcessor((PsiElement)property);
            queryParameters.getOptimizer().searchWord(property.getName(), (SearchScope)gradleSearchScope, (short)5, false, (PsiElement)property, (RequestResultProcessor)processor);
        }
    }

    private static boolean isContainingFileGradlePropertyFile(PsiFile file) {
        for (String filename : GRADLE_PROPERTY_FILES) {
            if (!file.getName().equalsIgnoreCase(filename)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/gradle/findUsages/GradlePropertyReferencesSearcher";
        objectArray[2] = "processQuery";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class FileByExtensionSearchScope
    extends DelegatingGlobalSearchScope {
        @NotNull
        private final String extension;

        FileByExtensionSearchScope(GlobalSearchScope scope2, @NotNull String extension) {
            if (extension == null) {
                FileByExtensionSearchScope.$$$reportNull$$$0(0);
            }
            super(scope2);
            this.extension = extension;
        }

        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                FileByExtensionSearchScope.$$$reportNull$$$0(1);
            }
            return super.contains(file) && this.extension.equalsIgnoreCase(file.getExtension());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/gradle/findUsages/GradlePropertyReferencesSearcher$FileByExtensionSearchScope";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyProcessor
    extends RequestResultProcessor {
        final PsiElement target;

        MyProcessor(PsiElement target) {
            super(new Object[]{target});
            this.target = target;
        }

        public boolean processTextOccurrence(@NotNull PsiElement element, int offsetInElement, @NotNull Processor<? super PsiReference> consumer) {
            if (element == null) {
                MyProcessor.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                MyProcessor.$$$reportNull$$$0(1);
            }
            return !(element instanceof PsiReference) || consumer.process((Object)((PsiReference)element));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/gradle/findUsages/GradlePropertyReferencesSearcher$MyProcessor";
            objectArray[2] = "processTextOccurrence";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

