/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventResult;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXmlView;

public class AfterTestEvent
extends AbstractTestEvent {
    public AfterTestEvent(GradleTestsExecutionConsole executionConsole) {
        super(executionConsole);
    }

    @Override
    public void process(@NotNull TestEventXmlView eventXml) throws TestEventXmlView.XmlParserException {
        if (eventXml == null) {
            AfterTestEvent.$$$reportNull$$$0(0);
        }
        String testId = eventXml.getTestId();
        String startTime = eventXml.getEventTestResultStartTime();
        String endTime = eventXml.getEventTestResultEndTime();
        String exceptionMsg = this.decode(eventXml.getEventTestResultErrorMsg());
        String stackTrace = this.decode(eventXml.getEventTestResultStackTrace());
        SMTestProxy testProxy = this.findTestProxy(testId);
        if (testProxy == null) {
            return;
        }
        try {
            testProxy.setDuration(Long.valueOf(endTime) - Long.valueOf(startTime));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        TestEventResult result = TestEventResult.fromValue(eventXml.getTestEventResultType());
        switch (result) {
            case SUCCESS: {
                testProxy.setFinished();
                break;
            }
            case FAILURE: {
                String failureType = eventXml.getEventTestResultFailureType();
                if ("comparison".equals(failureType)) {
                    String actualText = this.decode(eventXml.getEventTestResultActual());
                    String expectedText = this.decode(eventXml.getEventTestResultExpected());
                    Condition emptyString = StringUtil::isEmpty;
                    String filePath = (String)ObjectUtils.nullizeByCondition((Object)this.decode(eventXml.getEventTestResultFilePath()), (Condition)emptyString);
                    String actualFilePath = (String)ObjectUtils.nullizeByCondition((Object)this.decode(eventXml.getEventTestResultActualFilePath()), (Condition)emptyString);
                    testProxy.setTestComparisonFailed(exceptionMsg, stackTrace, actualText, expectedText, filePath, actualFilePath, true);
                } else {
                    Couple<String> comparisonPair = GradleRunnerUtil.parseComparisonMessage(exceptionMsg);
                    if (comparisonPair != null) {
                        testProxy.setTestComparisonFailed(exceptionMsg, stackTrace, (String)comparisonPair.second, (String)comparisonPair.first);
                    } else {
                        testProxy.setTestFailed(exceptionMsg, stackTrace, "error".equals(failureType));
                    }
                }
                this.getResultsViewer().onTestFailed(testProxy);
                break;
            }
            case SKIPPED: {
                testProxy.setTestIgnored(null, null);
                this.getResultsViewer().onTestIgnored(testProxy);
                break;
            }
        }
        this.getResultsViewer().onTestFinished(testProxy);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventXml", "org/jetbrains/plugins/gradle/execution/test/runner/events/AfterTestEvent", "process"));
    }
}

