/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index.treeview;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.sonatype.nexus.index.treeview.IndexTreeView;
import org.sonatype.nexus.index.treeview.TreeNode;
import org.sonatype.nexus.index.treeview.TreeNodeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeNode
implements TreeNode {
    private String type;
    private boolean leaf;
    private String nodeName;
    private String path;
    private List<TreeNode> children;
    private String groupId;
    private String artifactId;
    private String version;
    private String repositoryId;
    private final transient IndexTreeView treeView;
    private final transient TreeNodeFactory factory;

    public AbstractTreeNode(IndexTreeView tview, TreeNodeFactory factory) {
        this.treeView = tview;
        this.factory = factory;
    }

    @Override
    public TreeNode.Type getType() {
        return TreeNode.Type.valueOf(this.type);
    }

    @Override
    public void setType(TreeNode.Type type) {
        this.type = type.name();
    }

    @Override
    public boolean isLeaf() {
        return this.leaf;
    }

    @Override
    public void setLeaf(boolean leaf) {
        this.leaf = leaf;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getRepositoryId() {
        return this.repositoryId;
    }

    @Override
    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    @Override
    public List<TreeNode> getChildren() {
        if (this.children == null && !this.isLeaf()) {
            this.children = new ArrayList<TreeNode>();
        }
        return this.children;
    }

    @Override
    public List<TreeNode> listChildren() throws IOException {
        if (!this.isLeaf() && this.getChildren().isEmpty() && !this.isLeaf()) {
            this.children = this.treeView.listNodes(this.factory, this.getPath()).getChildren();
        }
        return this.children;
    }

    @Override
    public TreeNode findChildByPath(String path, TreeNode.Type type) throws IOException {
        for (TreeNode child : this.getChildren()) {
            if (!path.equals(child.getPath()) || !type.equals((Object)child.getType())) continue;
            return child;
        }
        return null;
    }
}

