/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.annotation;

import com.intellij.psi.xml.XmlFile;
import gnu.trove.TIntArrayList;
import java.util.List;
import org.intellij.plugins.relaxNG.model.CommonElement;
import org.intellij.plugins.relaxNG.model.Define;
import org.intellij.plugins.relaxNG.model.Div;
import org.intellij.plugins.relaxNG.model.Grammar;
import org.intellij.plugins.relaxNG.model.Include;

class OverriddenDefineSearcher
extends CommonElement.Visitor {
    private final Define myDefine;
    private final TIntArrayList myIncludes = new TIntArrayList();
    private final XmlFile myLocalFile;
    private final List<? super Define> myResult;

    OverriddenDefineSearcher(Define define, XmlFile localFile, List<? super Define> result) {
        this.myLocalFile = localFile;
        this.myResult = result;
        this.myDefine = define;
    }

    @Override
    public void visitInclude(Include inc) {
        this.myIncludes.add(inc.getInclude() == this.myLocalFile ? 1 : 0);
        try {
            inc.acceptChildren(this);
        }
        finally {
            this.myIncludes.remove(this.myIncludes.size() - 1);
        }
    }

    @Override
    public void visitDiv(Div ref) {
        ref.acceptChildren(this);
    }

    @Override
    public void visitDefine(Define d) {
        if (this.myIncludes.size() > 0 && this.myIncludes.get(this.myIncludes.size() - 1) == 1 && d.getName().equals(this.myDefine.getName())) {
            this.myResult.add(d);
        }
        d.acceptChildren(this);
    }

    @Override
    public void visitGrammar(Grammar pattern) {
        pattern.acceptChildren(this);
    }
}

