/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.ConfigurableWebBrowser;
import com.intellij.ide.browsers.DefaultBrowserPolicy;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="WebBrowsersConfiguration", storages={@Storage(value="web-browsers.xml")})
public class WebBrowserManager
extends SimpleModificationTracker
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(WebBrowserManager.class);
    private static final UUID PREDEFINED_CHROME_ID = UUID.fromString("98CA6316-2F89-46D9-A9E5-FA9E2B0625B3");
    @ApiStatus.Internal
    public static final UUID PREDEFINED_FIREFOX_ID = UUID.fromString("A7BB68E0-33C0-4D6F-A81A-AAC1FDB870C8");
    private static final UUID PREDEFINED_SAFARI_ID = UUID.fromString("E5120D43-2C3F-47EF-9F26-65E539E05186");
    private static final UUID PREDEFINED_OPERA_ID = UUID.fromString("53E2F627-B1A7-4DFA-BFA7-5B83CC034776");
    private static final UUID PREDEFINED_YANDEX_ID = UUID.fromString("B1B2EC2C-20BD-4EE2-89C4-616DB004BCD4");
    private static final UUID PREDEFINED_EXPLORER_ID = UUID.fromString("16BF23D4-93E0-4FFC-BFD6-CB13575177B0");
    private static final UUID PREDEFINED_EDGE_ID = UUID.fromString("B2A9DCA7-9D0B-4E1E-98A8-AFB19C1328D2");
    private static final UUID[] PREDEFINED_BROWSER_IDS = new UUID[]{PREDEFINED_CHROME_ID, PREDEFINED_FIREFOX_ID, PREDEFINED_SAFARI_ID, PREDEFINED_OPERA_ID, PREDEFINED_YANDEX_ID, PREDEFINED_EXPLORER_ID, PREDEFINED_EDGE_ID};
    private static final String EDGE_COMMAND = "microsoft-edge";
    private List<ConfigurableWebBrowser> browsers;
    private boolean myShowBrowserHover = true;
    private boolean myShowBrowserHoverXml = false;
    DefaultBrowserPolicy defaultBrowserPolicy = DefaultBrowserPolicy.SYSTEM;

    private static List<ConfigurableWebBrowser> getPredefinedBrowsers() {
        return Arrays.asList(new ConfigurableWebBrowser(PREDEFINED_CHROME_ID, BrowserFamily.CHROME), new ConfigurableWebBrowser(PREDEFINED_FIREFOX_ID, BrowserFamily.FIREFOX), new ConfigurableWebBrowser(PREDEFINED_SAFARI_ID, BrowserFamily.SAFARI), new ConfigurableWebBrowser(PREDEFINED_OPERA_ID, BrowserFamily.OPERA), new ConfigurableWebBrowser(PREDEFINED_YANDEX_ID, BrowserFamily.CHROME, "Yandex", SystemInfo.isWindows ? "browser" : (SystemInfo.isMac ? "Yandex" : "yandex"), false, BrowserFamily.CHROME.createBrowserSpecificSettings()), new ConfigurableWebBrowser(PREDEFINED_EXPLORER_ID, BrowserFamily.EXPLORER), new ConfigurableWebBrowser(PREDEFINED_EDGE_ID, BrowserFamily.EXPLORER, "Edge", SystemInfo.isWindows ? EDGE_COMMAND : null, true, null));
    }

    public WebBrowserManager() {
        this.browsers = new ArrayList<ConfigurableWebBrowser>(WebBrowserManager.getPredefinedBrowsers());
    }

    public static WebBrowserManager getInstance() {
        return (WebBrowserManager)((Object)ServiceManager.getService(WebBrowserManager.class));
    }

    public static boolean isYandexBrowser(@NotNull WebBrowser browser2) {
        if (browser2 == null) {
            WebBrowserManager.$$$reportNull$$$0(0);
        }
        return browser2.getFamily().equals((Object)BrowserFamily.CHROME) && (browser2.getId().equals(PREDEFINED_YANDEX_ID) || WebBrowserManager.checkNameAndPath("Yandex", browser2));
    }

    public static boolean isDartium(@NotNull WebBrowser browser2) {
        if (browser2 == null) {
            WebBrowserManager.$$$reportNull$$$0(1);
        }
        return browser2.getFamily().equals((Object)BrowserFamily.CHROME) && WebBrowserManager.checkNameAndPath("Dartium", browser2);
    }

    public static boolean isEdge(@NotNull WebBrowser browser2) {
        if (browser2 == null) {
            WebBrowserManager.$$$reportNull$$$0(2);
        }
        return browser2.getFamily() == BrowserFamily.EXPLORER && (browser2.getId().equals(PREDEFINED_EDGE_ID) || WebBrowserManager.checkNameAndPath(EDGE_COMMAND, browser2) || WebBrowserManager.checkNameAndPath("MicrosoftEdge", browser2));
    }

    static boolean checkNameAndPath(@NotNull String what, @NotNull WebBrowser browser2) {
        if (what == null) {
            WebBrowserManager.$$$reportNull$$$0(3);
        }
        if (browser2 == null) {
            WebBrowserManager.$$$reportNull$$$0(4);
        }
        if (StringUtil.containsIgnoreCase((String)browser2.getName(), (String)what)) {
            return true;
        }
        String path = browser2.getPath();
        if (path != null) {
            int index = path.lastIndexOf(47);
            return index > 0 ? path.indexOf(what, index + 1) != -1 : path.contains(what);
        }
        return false;
    }

    boolean isPredefinedBrowser(@NotNull ConfigurableWebBrowser browser2) {
        if (browser2 == null) {
            WebBrowserManager.$$$reportNull$$$0(5);
        }
        UUID id = browser2.getId();
        for (UUID predefinedBrowserId : PREDEFINED_BROWSER_IDS) {
            if (!id.equals(predefinedBrowserId)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public DefaultBrowserPolicy getDefaultBrowserPolicy() {
        DefaultBrowserPolicy defaultBrowserPolicy = this.defaultBrowserPolicy;
        if (defaultBrowserPolicy == null) {
            WebBrowserManager.$$$reportNull$$$0(6);
        }
        return defaultBrowserPolicy;
    }

    public Element getState() {
        Element state = new Element("state");
        if (this.defaultBrowserPolicy != DefaultBrowserPolicy.SYSTEM) {
            state.setAttribute("default", StringUtil.toLowerCase((String)this.defaultBrowserPolicy.name()));
        }
        if (!this.myShowBrowserHover) {
            state.setAttribute("showHover", "false");
        }
        if (this.myShowBrowserHoverXml) {
            state.setAttribute("showHoverXml", "true");
        }
        if (!this.browsers.equals(WebBrowserManager.getPredefinedBrowsers())) {
            for (ConfigurableWebBrowser browser2 : this.browsers) {
                BrowserSpecificSettings specificSettings;
                Element entry = new Element("browser");
                entry.setAttribute("id", browser2.getId().toString());
                entry.setAttribute("name", browser2.getName());
                entry.setAttribute("family", browser2.getFamily().name());
                String path = browser2.getPath();
                if (path != null && !path.equals(browser2.getFamily().getExecutionPath())) {
                    entry.setAttribute("path", path);
                }
                if (!browser2.isActive()) {
                    entry.setAttribute("active", "false");
                }
                if ((specificSettings = browser2.getSpecificSettings()) != null) {
                    Element settingsElement = new Element("settings");
                    XmlSerializer.serializeInto((Object)specificSettings, (Element)settingsElement, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
                    if (!JDOMUtil.isEmpty((Element)settingsElement)) {
                        entry.addContent(settingsElement);
                    }
                }
                state.addContent(entry);
            }
        }
        return state;
    }

    @Nullable
    private static BrowserFamily readFamily(String value) {
        try {
            return BrowserFamily.valueOf((String)value);
        }
        catch (RuntimeException e) {
            LOG.warn((Throwable)e);
            for (BrowserFamily family : BrowserFamily.values()) {
                if (!family.getName().equalsIgnoreCase(value)) continue;
                return family;
            }
            return null;
        }
    }

    @Nullable
    private static UUID readId(String value, @NotNull BrowserFamily family, @NotNull List<ConfigurableWebBrowser> existingBrowsers) {
        if (family == null) {
            WebBrowserManager.$$$reportNull$$$0(7);
        }
        if (existingBrowsers == null) {
            WebBrowserManager.$$$reportNull$$$0(8);
        }
        if (StringUtil.isEmpty((String)value)) {
            UUID id;
            switch (family) {
                case CHROME: {
                    id = PREDEFINED_CHROME_ID;
                    break;
                }
                case EXPLORER: {
                    id = PREDEFINED_EXPLORER_ID;
                    break;
                }
                case FIREFOX: {
                    id = PREDEFINED_FIREFOX_ID;
                    break;
                }
                case OPERA: {
                    id = PREDEFINED_OPERA_ID;
                    break;
                }
                case SAFARI: {
                    id = PREDEFINED_SAFARI_ID;
                    break;
                }
                default: {
                    return null;
                }
            }
            for (ConfigurableWebBrowser browser2 : existingBrowsers) {
                if (browser2.getId() != id) continue;
                return null;
            }
            return id;
        }
        try {
            return UUID.fromString(value);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    public void loadState(@NotNull Element element) {
        String defaultValue;
        if (element == null) {
            WebBrowserManager.$$$reportNull$$$0(9);
        }
        if (!StringUtil.isEmpty((String)(defaultValue = element.getAttributeValue("default")))) {
            try {
                this.defaultBrowserPolicy = DefaultBrowserPolicy.valueOf(StringUtil.toUpperCase((String)defaultValue));
            }
            catch (IllegalArgumentException e) {
                LOG.warn((Throwable)e);
            }
        }
        this.myShowBrowserHover = !"false".equals(element.getAttributeValue("showHover"));
        ArrayList<ConfigurableWebBrowser> list = new ArrayList<ConfigurableWebBrowser>();
        for (Element child : element.getChildren("browser")) {
            UUID id;
            BrowserFamily family = WebBrowserManager.readFamily(child.getAttributeValue("family"));
            if (family == null || (id = WebBrowserManager.readId(child.getAttributeValue("id"), family, list)) == null) continue;
            Element settingsElement = child.getChild("settings");
            BrowserSpecificSettings specificSettings = family.createBrowserSpecificSettings();
            if (specificSettings != null && settingsElement != null) {
                try {
                    XmlSerializer.deserializeInto((Object)specificSettings, (Element)settingsElement);
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            }
            String activeValue = child.getAttributeValue("active");
            String path = StringUtil.nullize((String)child.getAttributeValue("path"), (boolean)true);
            if (path == null) {
                path = family.getExecutionPath();
            }
            list.add(new ConfigurableWebBrowser(id, family, StringUtil.notNullize((String)child.getAttributeValue("name"), (String)family.getName()), path, activeValue == null || Boolean.parseBoolean(activeValue), specificSettings));
        }
        Map idToBrowser = null;
        int n = list.size();
        block5: for (UUID predefinedBrowserId : PREDEFINED_BROWSER_IDS) {
            for (int i = 0; i < n; ++i) {
                if (((ConfigurableWebBrowser)((Object)list.get(i))).getId().equals(predefinedBrowserId)) continue block5;
            }
            if (idToBrowser == null) {
                idToBrowser = ContainerUtil.newMapFromValues(WebBrowserManager.getPredefinedBrowsers().iterator(), it -> it.getId());
            }
            list.add((ConfigurableWebBrowser)((Object)idToBrowser.get(predefinedBrowserId)));
        }
        this.setList(list);
    }

    @NotNull
    public List<WebBrowser> getBrowsers() {
        List<WebBrowser> list = Collections.unmodifiableList(this.browsers);
        if (list == null) {
            WebBrowserManager.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    List<ConfigurableWebBrowser> getList() {
        List<ConfigurableWebBrowser> list = this.browsers;
        if (list == null) {
            WebBrowserManager.$$$reportNull$$$0(11);
        }
        return list;
    }

    void setList(@NotNull List<ConfigurableWebBrowser> value) {
        if (value == null) {
            WebBrowserManager.$$$reportNull$$$0(12);
        }
        this.browsers = value;
        this.incModificationCount();
    }

    @NotNull
    public List<WebBrowser> getActiveBrowsers() {
        List<WebBrowser> list = this.getBrowsers((Condition<? super WebBrowser>)Conditions.alwaysTrue(), true);
        if (list == null) {
            WebBrowserManager.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public List<WebBrowser> getBrowsers(@NotNull Condition<? super WebBrowser> condition) {
        if (condition == null) {
            WebBrowserManager.$$$reportNull$$$0(14);
        }
        List<WebBrowser> list = this.getBrowsers(condition, true);
        if (list == null) {
            WebBrowserManager.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    public List<WebBrowser> getBrowsers(@NotNull Condition<? super WebBrowser> condition, boolean onlyActive) {
        if (condition == null) {
            WebBrowserManager.$$$reportNull$$$0(16);
        }
        SmartList result = new SmartList();
        for (ConfigurableWebBrowser browser2 : this.browsers) {
            if (onlyActive && !browser2.isActive() || !condition.value((Object)browser2)) continue;
            result.add(browser2);
        }
        SmartList smartList = result;
        if (smartList == null) {
            WebBrowserManager.$$$reportNull$$$0(17);
        }
        return smartList;
    }

    public void setBrowserSpecificSettings(@NotNull WebBrowser browser2, @NotNull BrowserSpecificSettings specificSettings) {
        if (browser2 == null) {
            WebBrowserManager.$$$reportNull$$$0(18);
        }
        if (specificSettings == null) {
            WebBrowserManager.$$$reportNull$$$0(19);
        }
        ((ConfigurableWebBrowser)browser2).setSpecificSettings(specificSettings);
    }

    public void setBrowserPath(@NotNull WebBrowser browser2, @Nullable String path, boolean isActive) {
        if (browser2 == null) {
            WebBrowserManager.$$$reportNull$$$0(20);
        }
        ((ConfigurableWebBrowser)browser2).setPath(path);
        ((ConfigurableWebBrowser)browser2).setActive(isActive);
        this.incModificationCount();
    }

    public WebBrowser addBrowser(@NotNull UUID id, @NotNull BrowserFamily family, @NotNull String name, @Nullable String path, boolean active, BrowserSpecificSettings specificSettings) {
        if (id == null) {
            WebBrowserManager.$$$reportNull$$$0(21);
        }
        if (family == null) {
            WebBrowserManager.$$$reportNull$$$0(22);
        }
        if (name == null) {
            WebBrowserManager.$$$reportNull$$$0(23);
        }
        ConfigurableWebBrowser browser2 = new ConfigurableWebBrowser(id, family, name, path, active, specificSettings);
        this.browsers.add(browser2);
        this.incModificationCount();
        return browser2;
    }

    @Nullable
    private static UUID parseUuid(@NotNull String id) {
        if (id == null) {
            WebBrowserManager.$$$reportNull$$$0(24);
        }
        if (id.indexOf(45) == -1) {
            return null;
        }
        try {
            return UUID.fromString(id);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    @Nullable
    public WebBrowser findBrowserById(@Nullable String idOrFamilyName) {
        if (StringUtil.isEmpty((String)idOrFamilyName)) {
            return null;
        }
        UUID id = WebBrowserManager.parseUuid(idOrFamilyName);
        if (id == null) {
            for (ConfigurableWebBrowser browser2 : this.browsers) {
                if (!browser2.getFamily().name().equalsIgnoreCase(idOrFamilyName) && !browser2.getFamily().getName().equalsIgnoreCase(idOrFamilyName)) continue;
                return browser2;
            }
            return null;
        }
        for (ConfigurableWebBrowser browser3 : this.browsers) {
            if (!browser3.getId().equals(id)) continue;
            return browser3;
        }
        return null;
    }

    @Nullable
    public WebBrowser getFirstBrowserOrNull(@NotNull BrowserFamily family) {
        if (family == null) {
            WebBrowserManager.$$$reportNull$$$0(25);
        }
        for (ConfigurableWebBrowser browser2 : this.browsers) {
            if (!browser2.isActive() || !family.equals((Object)browser2.getFamily())) continue;
            return browser2;
        }
        for (ConfigurableWebBrowser browser2 : this.browsers) {
            if (!family.equals((Object)browser2.getFamily())) continue;
            return browser2;
        }
        return null;
    }

    @NotNull
    public WebBrowser getFirstBrowser(@NotNull BrowserFamily family) {
        WebBrowser result;
        if (family == null) {
            WebBrowserManager.$$$reportNull$$$0(26);
        }
        if ((result = this.getFirstBrowserOrNull(family)) == null) {
            throw new IllegalStateException("Must be at least one browser per family");
        }
        WebBrowser webBrowser = result;
        if (webBrowser == null) {
            WebBrowserManager.$$$reportNull$$$0(27);
        }
        return webBrowser;
    }

    public boolean isActive(@NotNull WebBrowser browser2) {
        if (browser2 == null) {
            WebBrowserManager.$$$reportNull$$$0(28);
        }
        return !(browser2 instanceof ConfigurableWebBrowser) || ((ConfigurableWebBrowser)browser2).isActive();
    }

    @Nullable
    public WebBrowser getFirstActiveBrowser() {
        for (ConfigurableWebBrowser browser2 : this.browsers) {
            if (!browser2.isActive() || browser2.getPath() == null) continue;
            return browser2;
        }
        return null;
    }

    public void setShowBrowserHover(boolean showBrowserHover) {
        this.myShowBrowserHover = showBrowserHover;
    }

    public void setShowBrowserHoverXml(boolean showBrowserHover) {
        this.myShowBrowserHoverXml = showBrowserHover;
    }

    public boolean isShowBrowserHover() {
        return this.myShowBrowserHover;
    }

    public boolean isShowBrowserHoverXml() {
        return this.myShowBrowserHoverXml;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/browsers/WebBrowserManager";
                break;
            }
            case 7: 
            case 22: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingBrowsers";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specificSettings";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/browsers/WebBrowserManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultBrowserPolicy";
                break;
            }
            case 10: 
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrowsers";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getList";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveBrowsers";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstBrowser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isYandexBrowser";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isDartium";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEdge";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkNameAndPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isPredefinedBrowser";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 27: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readId";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setList";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getBrowsers";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setBrowserSpecificSettings";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setBrowserPath";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addBrowser";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "parseUuid";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getFirstBrowserOrNull";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getFirstBrowser";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

