/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.testng;

import com.intellij.rt.execution.junit.ComparisonFailureData;
import com.intellij.rt.execution.junit.MapSerializerUtil;
import com.intellij.rt.testng.TestNGExpectedPatterns;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.testng.IClass;
import org.testng.IInvokedMethod;
import org.testng.ISuite;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.annotations.Test;
import org.testng.internal.ConstructorOrMethod;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDEATestNGRemoteListener {
    private final PrintStream myPrintStream;
    private final List<String> myCurrentSuites = new ArrayList<String>();
    private final Map<String, Integer> myInvocationCounts = new HashMap<String, Integer>();
    private final Map<ExposedTestResult, String> myParamsMap = new HashMap<ExposedTestResult, String>();
    private final Map<ExposedTestResult, DelegatedResult> myResults = new HashMap<ExposedTestResult, DelegatedResult>();
    private int mySkipped = 0;

    public IDEATestNGRemoteListener() {
        this(System.out);
    }

    public IDEATestNGRemoteListener(PrintStream printStream) {
        this.myPrintStream = printStream;
        this.myPrintStream.println("##teamcity[enteredTheMatrix]");
    }

    public synchronized void onStart(ISuite suite) {
        if (suite != null) {
            try {
                List allMethods = suite.getAllMethods();
                if (allMethods != null) {
                    int count = 0;
                    for (ITestNGMethod method : allMethods) {
                        if (!method.isTest()) continue;
                        count += method.getInvocationCount();
                    }
                    this.myPrintStream.println("##teamcity[testCount count = '" + count + "']");
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            this.myPrintStream.println("##teamcity[rootName name = '" + suite.getName() + "' location = 'file://" + suite.getXmlSuite().getFileName() + "']");
        }
    }

    public synchronized void onFinish(ISuite suite) {
        block5: {
            try {
                if (suite == null || suite.getAllInvokedMethods().size() + this.mySkipped >= suite.getAllMethods().size()) break block5;
                for (ITestNGMethod method : suite.getAllMethods()) {
                    if (!method.isTest()) continue;
                    boolean found = false;
                    for (IInvokedMethod invokedMethod : suite.getAllInvokedMethods()) {
                        if (invokedMethod.getTestMethod() != method) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    String fullEscapedMethodName = IDEATestNGRemoteListener.escapeName(IDEATestNGRemoteListener.getShortName(method.getTestClass().getName()) + "/" + method.getMethodName());
                    this.myPrintStream.println("##teamcity[testStarted name='" + fullEscapedMethodName + "']");
                    this.myPrintStream.println("##teamcity[testIgnored name='" + fullEscapedMethodName + "']");
                    this.myPrintStream.println("##teamcity[testFinished name='" + fullEscapedMethodName + "']");
                    break;
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        for (int i = this.myCurrentSuites.size() - 1; i >= 0; --i) {
            this.onSuiteFinish(this.myCurrentSuites.remove(i));
        }
        this.myCurrentSuites.clear();
    }

    public synchronized void onConfigurationSuccess(ITestResult result, boolean start) {
        DelegatedResult delegatedResult = this.createDelegated(result);
        if (start) {
            this.onConfigurationStart(delegatedResult);
        }
        this.onConfigurationSuccess(delegatedResult);
    }

    public synchronized void onConfigurationFailure(ITestResult result, boolean start) {
        DelegatedResult delegatedResult = this.createDelegated(result);
        if (start) {
            this.onConfigurationStart(delegatedResult);
        }
        this.onConfigurationFailure(delegatedResult);
    }

    public synchronized void onConfigurationSkip(ITestResult itr) {
    }

    public synchronized void onTestStart(ITestResult result) {
        this.onTestStart(this.createDelegated(result));
    }

    public synchronized void onTestSuccess(ITestResult result) {
        this.onTestFinished(this.createDelegated(result));
    }

    public synchronized void onTestFailure(ITestResult result) {
        this.onTestFailure(this.createDelegated(result));
    }

    public synchronized void onTestSkipped(ITestResult result) {
        this.onTestSkipped(this.createDelegated(result));
    }

    public synchronized void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        Throwable throwable = result.getThrowable();
        if (throwable != null) {
            throwable.printStackTrace();
        }
        this.onTestSuccess(result);
    }

    public synchronized void onStart(ITestContext context) {
    }

    public synchronized void onFinish(ITestContext context) {
    }

    public void onTestStart(ExposedTestResult result) {
        this.onStartWithParameters(result, false);
    }

    public void onStartWithParameters(ExposedTestResult result, boolean config) {
        Object[] parameters = result.getParameters();
        String qualifiedName = result.getClassName() + result.getDisplayMethodName();
        Integer invocationCount = this.myInvocationCounts.get(qualifiedName);
        if (invocationCount == null) {
            invocationCount = 0;
        }
        Integer normalizedIndex = IDEATestNGRemoteListener.normalizeInvocationCountInsideIncludedMethods(invocationCount, result);
        String paramString = IDEATestNGRemoteListener.getParamsString(parameters, config, normalizedIndex);
        this.onTestStart(result, paramString, normalizedIndex, config);
        this.myInvocationCounts.put(qualifiedName, invocationCount + 1);
    }

    private static Integer normalizeInvocationCountInsideIncludedMethods(Integer invocationCount, ExposedTestResult result) {
        List<Integer> includeMethods = result.getIncludeMethods();
        if (includeMethods == null || invocationCount >= includeMethods.size()) {
            return invocationCount;
        }
        return includeMethods.get(invocationCount);
    }

    public void onConfigurationStart(ExposedTestResult result) {
        this.onStartWithParameters(result, true);
    }

    public void onConfigurationSuccess(ExposedTestResult result) {
        this.onTestFinished(result);
    }

    public void onConfigurationFailure(ExposedTestResult result) {
        this.onTestFailure(result);
    }

    public boolean onSuiteStart(String classFQName, boolean provideLocation) {
        return this.onSuiteStart(Collections.singletonList(classFQName), null, provideLocation);
    }

    public boolean onSuiteStart(List<String> parentsHierarchy, ExposedTestResult result, boolean provideLocation) {
        int i;
        String currentParent;
        String currentClass;
        int idx;
        for (idx = 0; idx < this.myCurrentSuites.size() && idx < parentsHierarchy.size() && (currentClass = this.myCurrentSuites.get(idx)).equals(IDEATestNGRemoteListener.getShortName(currentParent = parentsHierarchy.get(parentsHierarchy.size() - 1 - idx))); ++idx) {
        }
        for (i = this.myCurrentSuites.size() - 1; i >= idx; --i) {
            currentClass = this.myCurrentSuites.remove(i);
            this.myPrintStream.println("##teamcity[testSuiteFinished name='" + IDEATestNGRemoteListener.escapeName(currentClass) + "']");
        }
        for (i = idx; i < parentsHierarchy.size(); ++i) {
            String fileName;
            String testName;
            String fqName = parentsHierarchy.get(parentsHierarchy.size() - 1 - i);
            String currentClassName = IDEATestNGRemoteListener.getShortName(fqName);
            String location = "java:suite://" + IDEATestNGRemoteListener.escapeName(fqName);
            if (result != null && fqName.equals(testName = result.getXmlTestName()) && (fileName = result.getFileName()) != null) {
                location = "file://" + fileName;
            }
            this.myPrintStream.println("\n##teamcity[testSuiteStarted name ='" + IDEATestNGRemoteListener.escapeName(currentClassName) + (provideLocation ? "' locationHint = '" + location : "") + "']");
            this.myCurrentSuites.add(currentClassName);
        }
        return false;
    }

    public void onSuiteFinish(String suiteName) {
        this.myPrintStream.println("##teamcity[testSuiteFinished name='" + IDEATestNGRemoteListener.escapeName(suiteName) + "']");
    }

    private void onTestStart(ExposedTestResult result, String paramString, Integer invocationCount, boolean config) {
        this.myParamsMap.put(result, paramString);
        this.onSuiteStart(result.getTestHierarchy(), result, true);
        String className = result.getClassName();
        String methodName = result.getDisplayMethodName();
        String location = className + "/" + result.getMethodName() + (invocationCount >= 0 ? "[" + invocationCount + "]" : "");
        this.myPrintStream.println("\n##teamcity[testStarted name='" + IDEATestNGRemoteListener.escapeName(IDEATestNGRemoteListener.getShortName(className) + "." + methodName + (paramString != null ? paramString : "")) + "' locationHint='java:test://" + IDEATestNGRemoteListener.escapeName(location) + (config ? "' config='true" : "") + "']");
    }

    public void onTestFailure(ExposedTestResult result) {
        String failureMessage;
        if (!this.myParamsMap.containsKey(result)) {
            this.onTestStart(result);
        }
        Throwable ex = result.getThrowable();
        String methodName = this.getTestMethodNameWithParams(result);
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        attrs.put("name", methodName);
        String string = failureMessage = ex != null ? ex.getMessage() : null;
        if (ex != null) {
            ComparisonFailureData notification;
            try {
                notification = ComparisonFailureData.create((Throwable)ex);
            }
            catch (Throwable e) {
                notification = null;
            }
            if (notification == null) {
                try {
                    notification = TestNGExpectedPatterns.createExceptionNotification(failureMessage);
                }
                catch (Throwable e) {
                    notification = null;
                }
            }
            ComparisonFailureData.registerSMAttributes((ComparisonFailureData)notification, (String)this.getTrace(ex), (String)failureMessage, attrs, (Throwable)ex);
        } else {
            attrs.put("message", "");
        }
        this.myPrintStream.println();
        this.myPrintStream.println(MapSerializerUtil.asString((String)"testFailed", attrs));
        this.onTestFinished(result);
    }

    public void onTestSkipped(ExposedTestResult result) {
        if (!this.myParamsMap.containsKey(result)) {
            this.onTestStart(result);
            ++this.mySkipped;
        }
        this.myPrintStream.println("\n##teamcity[testIgnored name='" + IDEATestNGRemoteListener.escapeName(this.getTestMethodNameWithParams(result)) + "']");
        this.onTestFinished(result);
    }

    public void onTestFinished(ExposedTestResult result) {
        long duration = result.getDuration();
        this.myPrintStream.println("\n##teamcity[testFinished name='" + IDEATestNGRemoteListener.escapeName(this.getTestMethodNameWithParams(result)) + (duration > 0L ? "' duration='" + duration : "") + "']");
    }

    private synchronized String getTestMethodNameWithParams(ExposedTestResult result) {
        String methodName = IDEATestNGRemoteListener.getShortName(result.getClassName()) + "." + result.getDisplayMethodName();
        String paramString = this.myParamsMap.get(result);
        if (paramString != null) {
            methodName = methodName + paramString;
        }
        return methodName;
    }

    private static String getParamsString(Object[] parameters, boolean config, int invocationCount) {
        String paramString = "";
        if (parameters.length > 0) {
            if (config) {
                Object parameter = parameters[0];
                if (parameter != null) {
                    Class<?> parameterClass = parameter.getClass();
                    if (ITestResult.class.isAssignableFrom(parameterClass) || ITestContext.class.isAssignableFrom(parameterClass) || Method.class.isAssignableFrom(parameterClass)) {
                        try {
                            paramString = "[" + parameterClass.getMethod("getName", new Class[0]).invoke(parameter, new Object[0]) + "]";
                        }
                        catch (Throwable e) {
                            paramString = "";
                        }
                    } else {
                        paramString = "[" + parameter.toString() + "]";
                    }
                }
            } else {
                paramString = Arrays.deepToString(parameters);
            }
        }
        if (invocationCount > 0) {
            paramString = paramString + " (" + invocationCount + ")";
        }
        return paramString.length() > 0 ? paramString : null;
    }

    protected String getTrace(Throwable tr) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        tr.printStackTrace(writer);
        StringBuffer buffer = stringWriter.getBuffer();
        return buffer.toString();
    }

    protected static String getShortName(String fqName) {
        int lastPointIdx = fqName.lastIndexOf(46);
        if (lastPointIdx >= 0) {
            return fqName.substring(lastPointIdx + 1);
        }
        return fqName;
    }

    private static String escapeName(String str) {
        return MapSerializerUtil.escapeStr((String)str, (MapSerializerUtil.EscapeInfoProvider)MapSerializerUtil.STD_ESCAPER);
    }

    protected DelegatedResult createDelegated(ITestResult result) {
        DelegatedResult newResult = new DelegatedResult(result);
        DelegatedResult oldResult = this.myResults.get(newResult);
        if (oldResult != null) {
            return oldResult;
        }
        this.myResults.put(newResult, newResult);
        return newResult;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DelegatedResult
    implements ExposedTestResult {
        private final ITestResult myResult;
        private final String myTestName;

        public DelegatedResult(ITestResult result) {
            this.myResult = result;
            this.myTestName = this.calculateDisplayName();
        }

        private String calculateDisplayName() {
            String name = this.myResult.getTestName();
            if (name != null && !name.equals(this.myResult.getTestClass().getTestName())) {
                return name;
            }
            ITestNGMethod method = this.myResult.getMethod();
            ConstructorOrMethod constructorOrMethod = method.getConstructorOrMethod();
            Executable member = null;
            if (constructorOrMethod.getMethod() != null) {
                member = constructorOrMethod.getMethod();
            }
            if (constructorOrMethod.getConstructor() != null) {
                member = constructorOrMethod.getConstructor();
            }
            if (member == null) {
                return method.getMethodName();
            }
            Test annotation = ((AccessibleObject)member).getAnnotation(Test.class);
            if (annotation == null) {
                return method.getMethodName();
            }
            String testNameFromAnnotation = annotation.testName();
            return testNameFromAnnotation == null || testNameFromAnnotation.length() == 0 ? method.getMethodName() : testNameFromAnnotation;
        }

        @Override
        public Object[] getParameters() {
            return this.myResult.getParameters();
        }

        @Override
        public String getMethodName() {
            return this.myResult.getMethod().getMethodName();
        }

        @Override
        public String getDisplayMethodName() {
            return this.myTestName;
        }

        @Override
        public String getClassName() {
            return this.myResult.getMethod().getTestClass().getName();
        }

        @Override
        public long getDuration() {
            return this.myResult.getEndMillis() - this.myResult.getStartMillis();
        }

        @Override
        public List<String> getTestHierarchy() {
            XmlTest xmlTest = this.myResult.getTestClass().getXmlTest();
            List<String> hierarchy = xmlTest != null ? Arrays.asList(this.getClassName(), xmlTest.getName()) : Collections.singletonList(this.getClassName());
            return hierarchy;
        }

        @Override
        public String getFileName() {
            XmlTest xmlTest = this.myResult.getTestClass().getXmlTest();
            return xmlTest != null ? xmlTest.getSuite().getFileName() : null;
        }

        @Override
        public String getXmlTestName() {
            XmlTest xmlTest = this.myResult.getTestClass().getXmlTest();
            return xmlTest != null ? xmlTest.getName() : null;
        }

        @Override
        public Throwable getThrowable() {
            return this.myResult.getThrowable();
        }

        @Override
        public List<Integer> getIncludeMethods() {
            IClass testClass = this.myResult.getTestClass();
            if (testClass == null) {
                return null;
            }
            XmlClass xmlClass = testClass.getXmlClass();
            if (xmlClass == null) {
                return null;
            }
            List includedMethods = xmlClass.getIncludedMethods();
            if (includedMethods.isEmpty()) {
                return null;
            }
            return ((XmlInclude)includedMethods.get(0)).getInvocationNumbers();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.myResult.equals(((DelegatedResult)o).myResult);
        }

        public int hashCode() {
            return this.myResult.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ExposedTestResult {
        public Object[] getParameters();

        public String getMethodName();

        public String getDisplayMethodName();

        public String getClassName();

        public long getDuration();

        public List<String> getTestHierarchy();

        public String getFileName();

        public String getXmlTestName();

        public Throwable getThrowable();

        public List<Integer> getIncludeMethods();
    }
}

