/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.kotlin;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.testFramework.fixtures.MavenDependencyUtil;
import com.intellij.util.text.VersionComparatorUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.Assume;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0004J\b\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/testFramework/fixtures/kotlin/KotlinTester;", "", "()V", "KOTLIN_VERSION", "", "KT_STD_JDK_8_MAVEN_ID", "KT_STD_MAVEN_ID", "assumeCanUseKotlin", "", "assumeKotlinPluginVersion", "version", "canUseKotlin", "", "configureKotlinStdLib", "model", "Lcom/intellij/openapi/roots/ModifiableRootModel;", "intellij.java.testFramework"})
public final class KotlinTester {
    @NotNull
    public static final String KOTLIN_VERSION = "1.3.70";
    @NotNull
    public static final String KT_STD_JDK_8_MAVEN_ID = "org.jetbrains.kotlin:kotlin-stdlib-jdk8:1.3.70";
    @NotNull
    public static final String KT_STD_MAVEN_ID = "org.jetbrains.kotlin:kotlin-stdlib:1.3.70";
    public static final KotlinTester INSTANCE;

    private final boolean canUseKotlin() {
        boolean bl;
        try {
            Class.forName("org.jetbrains.kotlin.idea.JvmPluginStartupComponent");
            bl = true;
        }
        catch (ClassNotFoundException e) {
            bl = false;
        }
        return bl;
    }

    public final void assumeCanUseKotlin() {
        Assume.assumeTrue((String)"Kotlin plugin JARs aren't found in the classpath; run 'setupKotlinPlugin' task in community/build/dependencies Gradle project to download Kotlin plugin JARs.", (boolean)this.canUseKotlin());
    }

    public final void assumeKotlinPluginVersion(@NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)"org.jetbrains.kotlin"));
        String actualKotlinVersion = ideaPluginDescriptor != null ? ideaPluginDescriptor.getVersion() : null;
        Assume.assumeTrue((String)("Kotlin plugin version should be at least " + version + " but was: " + actualKotlinVersion), (VersionComparatorUtil.compare((String)version, (String)actualKotlinVersion) <= 0 ? 1 : 0) != 0);
    }

    public final void configureKotlinStdLib(@NotNull ModifiableRootModel model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        MavenDependencyUtil.addFromMaven(model, KT_STD_MAVEN_ID);
        MavenDependencyUtil.addFromMaven(model, KT_STD_JDK_8_MAVEN_ID);
    }

    private KotlinTester() {
    }

    static {
        KotlinTester kotlinTester;
        INSTANCE = kotlinTester = new KotlinTester();
    }
}

