/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.testFramework.JavaProjectTestCase;
import com.intellij.testFramework.ProjectViewTestUtil;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestSourceBasedTestCase
extends JavaProjectTestCase {
    private File myTempDirectory;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myTempDirectory = FileUtil.createTempDirectory((String)this.getTestName(true), (String)"test", (boolean)false);
        this.myFilesToDelete.add(this.myTempDirectory);
        String testPath = this.getTestPath();
        if (testPath != null) {
            File testRoot = new File(this.getTestDataPath(), testPath);
            TestSourceBasedTestCase.assertTrue((String)testRoot.getAbsolutePath(), (boolean)testRoot.isDirectory());
            File currentTestRoot = new File(testRoot, this.getTestDirectoryName());
            TestSourceBasedTestCase.assertTrue((String)currentTestRoot.getAbsolutePath(), (boolean)currentTestRoot.isDirectory());
            FileUtil.copyDir((File)currentTestRoot, (File)new File(this.myTempDirectory, this.getTestDirectoryName()));
            ApplicationManager.getApplication().runWriteAction(this::setupContentRoot);
        }
        ProjectViewTestUtil.setupImpl((Project)this.getProject(), (boolean)true);
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            FileEditorManagerEx.getInstanceEx((Project)this.getProject()).closeAllFiles();
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath(((Object)((Object)this)).getClass());
    }

    @Nullable
    protected abstract String getTestPath();

    private File getTestContentFile() {
        return new File(this.myTempDirectory, this.getTestDirectoryName());
    }

    private void setupContentRoot() {
        PsiTestUtil.addContentRoot((Module)this.myModule, (VirtualFile)this.getContentRoot());
        VirtualFile src = this.getContentRoot().findChild("src");
        if (src != null) {
            PsiTestUtil.addSourceRoot((Module)this.myModule, (VirtualFile)src);
        }
    }

    protected VirtualFile getContentRoot() {
        File file = this.getTestContentFile();
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
    }

    @NotNull
    protected String getTestDirectoryName() {
        String string = this.getTestName(true);
        if (string == null) {
            TestSourceBasedTestCase.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected PsiDirectory getPackageDirectory(String packageRelativePath) {
        return this.getPsiManager().findDirectory(this.getContentRoot().findFileByRelativePath("src/" + packageRelativePath));
    }

    protected PsiDirectory getSrcDirectory() {
        return this.getPsiManager().findDirectory(this.getContentRoot().findFileByRelativePath("src"));
    }

    protected PsiDirectory getContentDirectory() {
        return this.getPsiManager().findDirectory(this.getContentRoot());
    }

    protected String getRootFiles() {
        return " " + PathUtil.getFileName((String)this.myModule.getModuleFilePath()) + "\n";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/TestSourceBasedTestCase", "getTestDirectoryName"));
    }
}

