/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui;

import com.intellij.openapi.Disposable;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.StatusText;
import com.intellij.vcs.log.ui.frame.ProgressStripe;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.pullrequest.ui.GHLoadingErrorHandler;
import org.jetbrains.plugins.github.pullrequest.ui.GHLoadingModel;
import org.jetbrains.plugins.github.util.GithubUIUtilKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000*\f\b\u0000\u0010\u0001*\u00020\u0002*\u00020\u00032\u00020\u0004:\u0001\u0018B'\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0016\u001a\u00020\u0017H\u0002R\u0010\u0010\u0007\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingPanel;", "T", "Ljavax/swing/JComponent;", "Lcom/intellij/util/ui/ComponentWithEmptyText;", "Lcom/intellij/ui/components/JBLoadingPanel;", "model", "Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingModel;", "content", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "textBundle", "Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingPanel$EmptyTextBundle;", "(Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingModel;Ljavax/swing/JComponent;Lcom/intellij/openapi/Disposable;Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingPanel$EmptyTextBundle;)V", "Ljavax/swing/JComponent;", "errorHandler", "Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingErrorHandler;", "getErrorHandler", "()Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingErrorHandler;", "setErrorHandler", "(Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingErrorHandler;)V", "updateLoadingPanel", "Lcom/intellij/vcs/log/ui/frame/ProgressStripe;", "update", "", "EmptyTextBundle", "intellij.vcs.github"})
public final class GHLoadingPanel<T extends JComponent>
extends JBLoadingPanel {
    private final ProgressStripe updateLoadingPanel;
    @Nullable
    private GHLoadingErrorHandler errorHandler;
    private final GHLoadingModel model;
    private final T content;
    private final EmptyTextBundle textBundle;

    @Nullable
    public final GHLoadingErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public final void setErrorHandler(@Nullable GHLoadingErrorHandler gHLoadingErrorHandler) {
        this.errorHandler = gHLoadingErrorHandler;
    }

    private final void update() {
        if (this.model.getLoading()) {
            this.setFocusable(true);
            ((ComponentWithEmptyText)this.content).getEmptyText().clear();
            if (this.model.getResultAvailable()) {
                this.updateLoadingPanel.startLoading();
            } else {
                this.startLoading();
            }
        } else {
            this.stopLoading();
            this.updateLoadingPanel.stopLoading();
            if (this.model.getResultAvailable()) {
                this.setFocusable(false);
                this.resetKeyboardActions();
                StatusText statusText2 = ((ComponentWithEmptyText)this.content).getEmptyText();
                Intrinsics.checkExpressionValueIsNotNull((Object)statusText2, (String)"content.emptyText");
                statusText2.setText(this.textBundle.getEmpty());
            } else {
                Throwable error = this.model.getError();
                if (error != null) {
                    StatusText statusText3 = ((ComponentWithEmptyText)this.content).getEmptyText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)statusText3, (String)"content.emptyText");
                    StatusText emptyText2 = statusText3;
                    StatusText statusText4 = emptyText2.clear().appendText(this.textBundle.getErrorPrefix(), SimpleTextAttributes.ERROR_ATTRIBUTES);
                    String string = error.getMessage();
                    if (string == null) {
                        string = "Unknown error";
                    }
                    statusText4.appendSecondaryText(string, SimpleTextAttributes.ERROR_ATTRIBUTES, null);
                    Object object = this.errorHandler;
                    if (object != null && (object = object.getActionForError(error)) != null) {
                        Object object2 = object;
                        boolean bl = false;
                        boolean bl2 = false;
                        Object it = object2;
                        boolean bl3 = false;
                        emptyText2.appendSecondaryText(' ' + GithubUIUtilKt.getName((Action)it), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, (ActionListener)it);
                        this.registerKeyboardAction((ActionListener)it, KeyStroke.getKeyStroke(10, 0), 0);
                    }
                } else {
                    StatusText statusText5 = ((ComponentWithEmptyText)this.content).getEmptyText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)statusText5, (String)"content.emptyText");
                    statusText5.setText(this.textBundle.getDefault());
                }
            }
        }
    }

    public GHLoadingPanel(@NotNull GHLoadingModel model2, @NotNull T content2, @NotNull Disposable parentDisposable, @NotNull EmptyTextBundle textBundle) {
        ProgressStripe progressStripe;
        Intrinsics.checkParameterIsNotNull((Object)model2, (String)"model");
        Intrinsics.checkParameterIsNotNull(content2, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkParameterIsNotNull((Object)textBundle, (String)"textBundle");
        super((LayoutManager)new BorderLayout(), parentDisposable, 300);
        this.model = model2;
        this.content = content2;
        this.textBundle = textBundle;
        ProgressStripe progressStripe2 = new ProgressStripe(this.content, parentDisposable, 300);
        GHLoadingPanel gHLoadingPanel = this;
        boolean bl = false;
        boolean bl2 = false;
        ProgressStripe $this$apply = progressStripe2;
        boolean bl3 = false;
        $this$apply.setOpaque(false);
        gHLoadingPanel.updateLoadingPanel = progressStripe = progressStripe2;
        this.setOpaque(false);
        this.add((Component)this.updateLoadingPanel, "Center");
        this.model.addStateChangeListener(new GHLoadingModel.StateChangeListener(){

            @Override
            public void onLoadingStarted() {
                this.update();
            }

            @Override
            public void onLoadingCompleted() {
                this.update();
            }

            @Override
            public void onReset() {
                this.update();
            }
        });
        this.update();
    }

    public /* synthetic */ GHLoadingPanel(GHLoadingModel gHLoadingModel, JComponent jComponent, Disposable disposable, EmptyTextBundle emptyTextBundle, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            emptyTextBundle = EmptyTextBundle.Default.INSTANCE;
        }
        this(gHLoadingModel, jComponent, disposable, emptyTextBundle);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\bf\u0018\u00002\u00020\u0001:\u0002\n\u000bR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0012\u0010\b\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingPanel$EmptyTextBundle;", "", "default", "", "getDefault", "()Ljava/lang/String;", "empty", "getEmpty", "errorPrefix", "getErrorPrefix", "Default", "Simple", "intellij.vcs.github"})
    public static interface EmptyTextBundle {
        @NotNull
        public String getDefault();

        @NotNull
        public String getEmpty();

        @NotNull
        public String getErrorPrefix();

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingPanel$EmptyTextBundle$Simple;", "Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingPanel$EmptyTextBundle;", "default", "", "errorPrefix", "empty", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDefault", "()Ljava/lang/String;", "getEmpty", "getErrorPrefix", "intellij.vcs.github"})
        public static final class Simple
        implements EmptyTextBundle {
            @NotNull
            private final String default;
            @NotNull
            private final String errorPrefix;
            @NotNull
            private final String empty;

            @Override
            @NotNull
            public String getDefault() {
                return this.default;
            }

            @Override
            @NotNull
            public String getErrorPrefix() {
                return this.errorPrefix;
            }

            @Override
            @NotNull
            public String getEmpty() {
                return this.empty;
            }

            public Simple(@NotNull String string, @NotNull String errorPrefix, @NotNull String empty) {
                Intrinsics.checkParameterIsNotNull((Object)string, (String)"default");
                Intrinsics.checkParameterIsNotNull((Object)errorPrefix, (String)"errorPrefix");
                Intrinsics.checkParameterIsNotNull((Object)empty, (String)"empty");
                this.default = string;
                this.errorPrefix = errorPrefix;
                this.empty = empty;
            }

            public /* synthetic */ Simple(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    string3 = "";
                }
                this(string, string2, string3);
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingPanel$EmptyTextBundle$Default;", "Lorg/jetbrains/plugins/github/pullrequest/ui/GHLoadingPanel$EmptyTextBundle;", "()V", "default", "", "getDefault", "()Ljava/lang/String;", "empty", "getEmpty", "errorPrefix", "getErrorPrefix", "intellij.vcs.github"})
        public static final class Default
        implements EmptyTextBundle {
            @NotNull
            private static final String default = "";
            @NotNull
            private static final String empty = "";
            @NotNull
            private static final String errorPrefix = "Can't load data";
            public static final Default INSTANCE;

            @Override
            @NotNull
            public String getDefault() {
                return default;
            }

            @Override
            @NotNull
            public String getEmpty() {
                return empty;
            }

            @Override
            @NotNull
            public String getErrorPrefix() {
                return errorPrefix;
            }

            private Default() {
            }

            static {
                Default default_;
                INSTANCE = default_ = new Default();
                default = "";
                empty = "";
                errorPrefix = errorPrefix;
            }
        }
    }
}

