/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data.service;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.GHRepositoryPermission;
import org.jetbrains.plugins.github.api.data.GHRepositoryPermissionLevel;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.GithubUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHTeam;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRSecurityService;
import org.jetbrains.plugins.github.util.GithubSharedProjectSettings;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u000fH\u0016J\b\u0010\u0017\u001a\u00020\u000fH\u0016J\b\u0010\u0018\u001a\u00020\u000fH\u0016J\b\u0010\u0019\u001a\u00020\u000fH\u0016J\u0016\u0010\u001a\u001a\u00020\u000f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0007H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityServiceImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;", "sharedProjectSettings", "Lorg/jetbrains/plugins/github/util/GithubSharedProjectSettings;", "currentUser", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "currentUserTeams", "", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHTeam;", "repo", "Lorg/jetbrains/plugins/github/api/data/GHRepositoryPermission;", "(Lorg/jetbrains/plugins/github/util/GithubSharedProjectSettings;Lorg/jetbrains/plugins/github/api/data/GHUser;Ljava/util/List;Lorg/jetbrains/plugins/github/api/data/GHRepositoryPermission;)V", "getCurrentUser", "()Lorg/jetbrains/plugins/github/api/data/GHUser;", "currentUserCanEditPullRequestsMetadata", "", "currentUserHasPermissionLevel", "level", "Lorg/jetbrains/plugins/github/api/data/GHRepositoryPermissionLevel;", "isCurrentUser", "user", "Lorg/jetbrains/plugins/github/api/data/GithubUser;", "isMergeAllowed", "isMergeForbiddenForProject", "isRebaseMergeAllowed", "isSquashMergeAllowed", "isUserInAnyTeam", "slugs", "", "intellij.vcs.github"})
public final class GHPRSecurityServiceImpl
implements GHPRSecurityService {
    private final GithubSharedProjectSettings sharedProjectSettings;
    @NotNull
    private final GHUser currentUser;
    private final List<GHTeam> currentUserTeams;
    private final GHRepositoryPermission repo;

    @Override
    public boolean isCurrentUser(@NotNull GithubUser user) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        return Intrinsics.areEqual((Object)user.getNodeId(), (Object)this.getCurrentUser().getId());
    }

    @Override
    public boolean currentUserCanEditPullRequestsMetadata() {
        return this.currentUserHasPermissionLevel(GHRepositoryPermissionLevel.TRIAGE);
    }

    @Override
    public boolean currentUserHasPermissionLevel(@NotNull GHRepositoryPermissionLevel level) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)level), (String)"level");
        GHRepositoryPermissionLevel gHRepositoryPermissionLevel = this.repo.getViewerPermission();
        return (gHRepositoryPermissionLevel != null ? gHRepositoryPermissionLevel.ordinal() : -1) >= level.ordinal();
    }

    @Override
    public boolean isUserInAnyTeam(@NotNull List<String> slugs) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull(slugs, (String)"slugs");
            Iterable $this$any$iv = this.currentUserTeams;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GHTeam it = (GHTeam)element$iv;
                    boolean bl2 = false;
                    if (!slugs.contains(it.getSlug())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean isMergeAllowed() {
        return this.repo.getMergeCommitAllowed();
    }

    @Override
    public boolean isRebaseMergeAllowed() {
        return this.repo.getRebaseMergeAllowed();
    }

    @Override
    public boolean isSquashMergeAllowed() {
        return this.repo.getSquashMergeAllowed();
    }

    @Override
    public boolean isMergeForbiddenForProject() {
        return this.sharedProjectSettings.getPullRequestMergeForbidden();
    }

    @Override
    @NotNull
    public GHUser getCurrentUser() {
        return this.currentUser;
    }

    public GHPRSecurityServiceImpl(@NotNull GithubSharedProjectSettings sharedProjectSettings, @NotNull GHUser currentUser, @NotNull List<GHTeam> currentUserTeams2, @NotNull GHRepositoryPermission repo) {
        Intrinsics.checkParameterIsNotNull((Object)sharedProjectSettings, (String)"sharedProjectSettings");
        Intrinsics.checkParameterIsNotNull((Object)currentUser, (String)"currentUser");
        Intrinsics.checkParameterIsNotNull(currentUserTeams2, (String)"currentUserTeams");
        Intrinsics.checkParameterIsNotNull((Object)repo, (String)"repo");
        this.sharedProjectSettings = sharedProjectSettings;
        this.currentUser = currentUser;
        this.currentUserTeams = currentUserTeams2;
        this.repo = repo;
    }
}

