/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.ui;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.components.panels.Wrapper;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.ui.GithubCredentialsUI;
import org.jetbrains.plugins.github.authentication.ui.GithubLoginPanel;
import org.jetbrains.plugins.github.ui.util.DialogValidationUtils;
import org.jetbrains.plugins.github.util.GithubAsyncUtil;
import org.jetbrains.plugins.github.util.GithubAsyncUtilKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\n\u0018\u00002\u00020\u0001BY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00126\u0010\u0004\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0005\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000fJ \u0010!\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060#0\"2\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0012H\u0002J\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001e0*J\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020\tJ\u001c\u0010.\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u001e0/j\u0002`02\u0006\u00101\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020'2\u0006\u00104\u001a\u00020\u000bH\u0002J\u000e\u00105\u001a\u00020'2\u0006\u00106\u001a\u00020\u000bJ\u000e\u00107\u001a\u00020'2\u0006\u00108\u001a\u000209J(\u0010:\u001a\u00020'2\n\b\u0002\u0010;\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010<\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010=\u001a\u00020\u000bJ\u000e\u0010>\u001a\u00020'2\u0006\u0010?\u001a\u00020@J\u000e\u0010A\u001a\u00020'2\u0006\u00106\u001a\u00020\u000bJ\u000e\u0010B\u001a\u00020'2\u0006\u00108\u001a\u000209J\u0018\u0010C\u001a\u00020'2\u0006\u0010D\u001a\u00020\u00062\b\b\u0002\u0010E\u001a\u00020\u000bJ\u0012\u0010F\u001a\u00020'2\n\b\u0002\u0010G\u001a\u0004\u0018\u00010\u0006J\b\u0010H\u001a\u00020'H\u0002J\b\u0010I\u001a\u00020'H\u0002R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GithubLoginPanel;", "Lcom/intellij/ui/components/panels/Wrapper;", "executorFactory", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;", "isAccountUnique", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "server", "", "project", "Lcom/intellij/openapi/project/Project;", "isDialogMode", "(Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;Lkotlin/jvm/functions/Function2;Lcom/intellij/openapi/project/Project;Z)V", "clientName", "currentUi", "Lorg/jetbrains/plugins/github/authentication/ui/GithubCredentialsUI;", "passwordUi", "Lorg/jetbrains/plugins/github/authentication/ui/GithubCredentialsUI$PasswordUI;", "progressExtension", "Lcom/intellij/ui/components/fields/ExtendableTextComponent$Extension;", "progressIcon", "Lcom/intellij/ui/AnimatedIcon$Default;", "getProject", "()Lcom/intellij/openapi/project/Project;", "serverTextField", "Lcom/intellij/ui/components/fields/ExtendableTextField;", "tokenAcquisitionError", "Lcom/intellij/openapi/ui/ValidationInfo;", "tokenUi", "Lorg/jetbrains/plugins/github/authentication/ui/GithubCredentialsUI$TokenUI;", "acquireLoginAndToken", "Ljava/util/concurrent/CompletableFuture;", "Lkotlin/Pair;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "applyUi", "", "ui", "doValidateAll", "", "getPreferredFocus", "Ljavax/swing/JComponent;", "getServer", "serverPathValidator", "Lkotlin/Function0;", "Lorg/jetbrains/plugins/github/ui/util/Validator;", "textField", "Ljavax/swing/JTextField;", "setBusy", "busy", "setCancelButtonVisible", "visible", "setCancelListener", "listener", "Ljava/awt/event/ActionListener;", "setCredentials", "login", "password", "editableLogin", "setError", "exception", "", "setLoginButtonVisible", "setLoginListener", "setServer", "path", "editable", "setToken", "token", "switchToPasswordUI", "switchToTokenUI", "intellij.vcs.github"})
public final class GithubLoginPanel
extends Wrapper {
    private String clientName;
    private final ExtendableTextField serverTextField;
    private ValidationInfo tokenAcquisitionError;
    private GithubCredentialsUI currentUi;
    private GithubCredentialsUI.PasswordUI passwordUi;
    private GithubCredentialsUI.TokenUI tokenUi;
    private final AnimatedIcon.Default progressIcon;
    private final ExtendableTextComponent.Extension progressExtension;
    @Nullable
    private final Project project;

    private final void switchToPasswordUI() {
        this.applyUi(this.passwordUi);
    }

    private final void switchToTokenUI() {
        this.applyUi(this.tokenUi);
    }

    private final void applyUi(GithubCredentialsUI ui) {
        GithubCredentialsUI githubCredentialsUI = this.currentUi = ui;
        if (githubCredentialsUI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        this.setContent(githubCredentialsUI.getPanel());
        GithubCredentialsUI githubCredentialsUI2 = this.currentUi;
        if (githubCredentialsUI2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        githubCredentialsUI2.getPreferredFocus().requestFocus();
        this.tokenAcquisitionError = null;
    }

    @NotNull
    public final JComponent getPreferredFocus() {
        GithubCredentialsUI githubCredentialsUI = this.currentUi;
        if (githubCredentialsUI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        return githubCredentialsUI.getPreferredFocus();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ValidationInfo> doValidateAll() {
        void $this$mapNotNullTo$iv$iv;
        Object[] objectArray = new Function0[2];
        Function0[] function0Array = new Function0[2];
        function0Array[0] = DialogValidationUtils.INSTANCE.chain((Function0)new Function0<ValidationInfo>(this){
            final /* synthetic */ GithubLoginPanel this$0;

            @Nullable
            public final ValidationInfo invoke() {
                return DialogValidationUtils.INSTANCE.notBlank((JTextField)GithubLoginPanel.access$getServerTextField$p(this.this$0), "Server cannot be empty");
            }
            {
                this.this$0 = githubLoginPanel;
                super(0);
            }
        }, this.serverPathValidator((JTextField)this.serverTextField));
        GithubCredentialsUI githubCredentialsUI = this.currentUi;
        if (githubCredentialsUI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        function0Array[1] = githubCredentialsUI.getValidator();
        objectArray[0] = DialogValidationUtils.INSTANCE.chain(function0Array);
        objectArray[1] = (Function0)new Function0<ValidationInfo>(this){
            final /* synthetic */ GithubLoginPanel this$0;

            @Nullable
            public final ValidationInfo invoke() {
                return GithubLoginPanel.access$getTokenAcquisitionError$p(this.this$0);
            }
            {
                this.this$0 = githubLoginPanel;
                super(0);
            }
        };
        Iterable $this$mapNotNull$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ValidationInfo validationInfo;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Function0 it = (Function0)element$iv$iv;
            boolean bl2 = false;
            if ((ValidationInfo)it.invoke() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            ValidationInfo it$iv$iv = validationInfo;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Function0<ValidationInfo> serverPathValidator(JTextField textField) {
        return (Function0)new Function0<ValidationInfo>(textField){
            final /* synthetic */ JTextField $textField;

            @Nullable
            public final ValidationInfo invoke() {
                ValidationInfo validationInfo;
                String text = this.$textField.getText();
                try {
                    GithubServerPath.from(text);
                    validationInfo = null;
                }
                catch (Exception e) {
                    validationInfo = new ValidationInfo(text + " is not a valid server path:\n" + e.getMessage(), (JComponent)this.$textField);
                }
                return validationInfo;
            }
            {
                this.$textField = jTextField;
                super(0);
            }
        };
    }

    private final void setBusy(boolean busy) {
        if (busy) {
            if (!this.serverTextField.getExtensions().contains(this.progressExtension)) {
                this.serverTextField.addExtension(this.progressExtension);
            }
        } else {
            this.serverTextField.removeExtension(this.progressExtension);
        }
        this.serverTextField.setEnabled(!busy);
        GithubCredentialsUI githubCredentialsUI = this.currentUi;
        if (githubCredentialsUI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        githubCredentialsUI.setBusy(busy);
    }

    @NotNull
    public final CompletableFuture<Pair<String, String>> acquireLoginAndToken(@NotNull ProgressIndicator progressIndicator) {
        Intrinsics.checkParameterIsNotNull((Object)progressIndicator, (String)"progressIndicator");
        this.setBusy(true);
        this.tokenAcquisitionError = null;
        GithubServerPath server = this.getServer();
        GithubCredentialsUI githubCredentialsUI = this.currentUi;
        if (githubCredentialsUI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        GithubApiRequestExecutor executor = githubCredentialsUI.createExecutor();
        boolean $i$f$service = false;
        Object object = ApplicationManager.getApplication().getService(ProgressManager.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
        CompletionStage completionStage = GithubAsyncUtilKt.submitBackgroundTask((ProgressManager)object, this.project, "Not Visible", true, progressIndicator, (Function1)new Function1<ProgressIndicator, Pair<? extends String, ? extends String>>(this, server, executor){
            final /* synthetic */ GithubLoginPanel this$0;
            final /* synthetic */ GithubServerPath $server;
            final /* synthetic */ GithubApiRequestExecutor $executor;

            @NotNull
            public final Pair<String, String> invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return GithubLoginPanel.access$getCurrentUi$p(this.this$0).acquireLoginAndToken(this.$server, this.$executor, it);
            }
            {
                this.this$0 = githubLoginPanel;
                this.$server = githubServerPath;
                this.$executor = githubApiRequestExecutor;
                super(1);
            }
        }).whenComplete(new BiConsumer<Pair<? extends String, ? extends String>, Throwable>(this){
            final /* synthetic */ GithubLoginPanel this$0;

            public final void accept(Pair<String, String> $noName_0, Throwable throwable) {
                Application app$iv;
                ModalityState modalityState$iv = null;
                boolean $i$f$runInEdt = false;
                Application application = app$iv = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
                if (application.isDispatchThread()) {
                    boolean bl = false;
                    GithubLoginPanel.access$setBusy(this.this$0, false);
                    if (throwable != null && !GithubAsyncUtil.INSTANCE.isCancellation(throwable)) {
                        GithubLoginPanel.access$setTokenAcquisitionError$p(this.this$0, GithubLoginPanel.access$getCurrentUi$p(this.this$0).handleAcquireError(throwable));
                    }
                } else {
                    boolean $i$f$invokeLater = false;
                    ApplicationManager.getApplication().invokeLater(new Runnable(this, throwable){
                        final /* synthetic */ acquireLoginAndToken.2 this$0;
                        final /* synthetic */ Throwable $throwable$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$throwable$inlined = throwable;
                        }

                        public final void run() {
                            boolean bl = false;
                            GithubLoginPanel.access$setBusy(this.this$0.this$0, false);
                            if (this.$throwable$inlined != null && !GithubAsyncUtil.INSTANCE.isCancellation(this.$throwable$inlined)) {
                                GithubLoginPanel.access$setTokenAcquisitionError$p(this.this$0.this$0, GithubLoginPanel.access$getCurrentUi$p(this.this$0.this$0).handleAcquireError(this.$throwable$inlined));
                            }
                        }
                    }, ModalityState.defaultModalityState());
                }
            }
            {
                this.this$0 = githubLoginPanel;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"service<ProgressManager>\u2026      }\n        }\n      }");
        return completionStage;
    }

    @NotNull
    public final GithubServerPath getServer() {
        String string = this.serverTextField.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"serverTextField.text");
        String string2 = string;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        GithubServerPath githubServerPath = GithubServerPath.from(((Object)StringsKt.trim((CharSequence)string3)).toString());
        Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath, (String)"GithubServerPath.from(\n \u2026verTextField.text.trim())");
        return githubServerPath;
    }

    public final void setServer(@NotNull String path, boolean editable) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        ExtendableTextField extendableTextField = this.serverTextField;
        boolean bl = false;
        boolean bl2 = false;
        ExtendableTextField $this$apply = extendableTextField;
        boolean bl3 = false;
        $this$apply.setText(path);
        $this$apply.setEditable(editable);
    }

    public static /* synthetic */ void setServer$default(GithubLoginPanel githubLoginPanel, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        githubLoginPanel.setServer(string, bl);
    }

    public final void setCredentials(@Nullable String login, @Nullable String password, boolean editableLogin) {
        if (login != null) {
            this.passwordUi.setLogin(login, editableLogin);
            this.tokenUi.setFixedLogin(editableLogin ? null : login);
        }
        if (password != null) {
            this.passwordUi.setPassword(password);
        }
        this.applyUi(this.passwordUi);
    }

    public static /* synthetic */ void setCredentials$default(GithubLoginPanel githubLoginPanel, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        githubLoginPanel.setCredentials(string, string2, bl);
    }

    public final void setToken(@Nullable String token) {
        if (token != null) {
            this.tokenUi.setToken(token);
        }
        this.applyUi(this.tokenUi);
    }

    public static /* synthetic */ void setToken$default(GithubLoginPanel githubLoginPanel, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        githubLoginPanel.setToken(string);
    }

    public final void setError(@NotNull Throwable exception) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        GithubCredentialsUI githubCredentialsUI = this.currentUi;
        if (githubCredentialsUI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        this.tokenAcquisitionError = githubCredentialsUI.handleAcquireError(exception);
    }

    public final void setLoginListener(@NotNull ActionListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.passwordUi.setLoginAction(listener);
        this.tokenUi.setLoginAction(listener);
    }

    public final void setCancelListener(@NotNull ActionListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.passwordUi.setCancelAction(listener);
        this.tokenUi.setCancelAction(listener);
    }

    public final void setLoginButtonVisible(boolean visible) {
        this.passwordUi.setLoginButtonVisible(visible);
        this.tokenUi.setLoginButtonVisible(visible);
    }

    public final void setCancelButtonVisible(boolean visible) {
        this.passwordUi.setCancelButtonVisible(visible);
        this.tokenUi.setCancelButtonVisible(visible);
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    public GithubLoginPanel(@NotNull GithubApiRequestExecutor.Factory executorFactory, @NotNull Function2<? super String, ? super GithubServerPath, Boolean> isAccountUnique, @Nullable Project project, boolean isDialogMode) {
        Intrinsics.checkParameterIsNotNull((Object)executorFactory, (String)"executorFactory");
        Intrinsics.checkParameterIsNotNull(isAccountUnique, (String)"isAccountUnique");
        this.project = project;
        this.clientName = "Github Integration Plugin";
        this.serverTextField = new ExtendableTextField("github.com", 0);
        this.passwordUi = new GithubCredentialsUI.PasswordUI(this.serverTextField, this.clientName, (Function0<Unit>)((Function0)new Function0<Unit>(this){

            public final void invoke() {
                GithubLoginPanel.access$switchToTokenUI((GithubLoginPanel)((Object)this.receiver));
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(GithubLoginPanel.class);
            }

            public final String getName() {
                return "switchToTokenUI";
            }

            public final String getSignature() {
                return "switchToTokenUI()V";
            }
        }), executorFactory, isAccountUnique, isDialogMode);
        this.tokenUi = new GithubCredentialsUI.TokenUI(executorFactory, isAccountUnique, this.serverTextField, (Function0<Unit>)((Function0)new Function0<Unit>(this){

            public final void invoke() {
                GithubLoginPanel.access$switchToPasswordUI((GithubLoginPanel)((Object)this.receiver));
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(GithubLoginPanel.class);
            }

            public final String getName() {
                return "switchToPasswordUI";
            }

            public final String getSignature() {
                return "switchToPasswordUI()V";
            }
        }), isDialogMode);
        this.progressIcon = new AnimatedIcon.Default();
        this.progressExtension = new ExtendableTextComponent.Extension(this){
            final /* synthetic */ GithubLoginPanel this$0;

            @NotNull
            public final AnimatedIcon.Default getIcon(boolean it) {
                return GithubLoginPanel.access$getProgressIcon$p(this.this$0);
            }
            {
                this.this$0 = githubLoginPanel;
            }
        };
        this.applyUi(this.passwordUi);
    }

    public /* synthetic */ GithubLoginPanel(GithubApiRequestExecutor.Factory factory2, Function2 function2, Project project, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        this(factory2, (Function2<? super String, ? super GithubServerPath, Boolean>)function2, project, bl);
    }

    public static final /* synthetic */ ExtendableTextField access$getServerTextField$p(GithubLoginPanel $this) {
        return $this.serverTextField;
    }

    public static final /* synthetic */ ValidationInfo access$getTokenAcquisitionError$p(GithubLoginPanel $this) {
        return $this.tokenAcquisitionError;
    }

    public static final /* synthetic */ void access$setTokenAcquisitionError$p(GithubLoginPanel $this, ValidationInfo validationInfo) {
        $this.tokenAcquisitionError = validationInfo;
    }

    public static final /* synthetic */ GithubCredentialsUI access$getCurrentUi$p(GithubLoginPanel $this) {
        GithubCredentialsUI githubCredentialsUI = $this.currentUi;
        if (githubCredentialsUI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUi");
        }
        return githubCredentialsUI;
    }

    public static final /* synthetic */ void access$setCurrentUi$p(GithubLoginPanel $this, GithubCredentialsUI githubCredentialsUI) {
        $this.currentUi = githubCredentialsUI;
    }

    public static final /* synthetic */ void access$setBusy(GithubLoginPanel $this, boolean busy) {
        $this.setBusy(busy);
    }

    public static final /* synthetic */ void access$switchToTokenUI(GithubLoginPanel $this) {
        $this.switchToTokenUI();
    }

    public static final /* synthetic */ void access$switchToPasswordUI(GithubLoginPanel $this) {
        $this.switchToPasswordUI();
    }

    public static final /* synthetic */ AnimatedIcon.Default access$getProgressIcon$p(GithubLoginPanel $this) {
        return $this.progressIcon;
    }
}

