/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.ui;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.layout.CCFlags;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.GrowPolicy;
import com.intellij.ui.layout.InnerCell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.net.UnknownHostException;
import java.util.function.Supplier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.authentication.ui.GithubCredentialsUI;
import org.jetbrains.plugins.github.authentication.ui.GithubCredentialsUIKt;
import org.jetbrains.plugins.github.authentication.ui.GithubCredentialsUIKt$sam$java_lang_Runnable$0;
import org.jetbrains.plugins.github.authentication.ui.LoginNotUniqueException;
import org.jetbrains.plugins.github.authentication.util.GHAccessTokenCreator;
import org.jetbrains.plugins.github.authentication.util.GHSecurityUtil;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.exceptions.GithubParseException;
import org.jetbrains.plugins.github.ui.util.DialogValidationUtils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002)*B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&J\b\u0010\u0012\u001a\u00020\u000fH&J\b\u0010\u0013\u001a\u00020\u0014H&J\b\u0010\u0015\u001a\u00020\u0016H&J\u0014\u0010\u0017\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018j\u0002`\u001aH&J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH&J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H&J\u000e\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020!J\u0010\u0010'\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$H\u0016J\u000e\u0010(\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020!R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u0082\u0001\u0002+,\u00a8\u0006-"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GithubCredentialsUI;", "", "()V", "cancelButton", "Ljavax/swing/JButton;", "getCancelButton", "()Ljavax/swing/JButton;", "loginButton", "getLoginButton", "acquireLoginAndToken", "Lkotlin/Pair;", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "executor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "createExecutor", "getPanel", "Ljavax/swing/JPanel;", "getPreferredFocus", "Ljavax/swing/JComponent;", "getValidator", "Lkotlin/Function0;", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lorg/jetbrains/plugins/github/ui/util/Validator;", "handleAcquireError", "error", "", "setBusy", "", "busy", "", "setCancelAction", "actionListener", "Ljava/awt/event/ActionListener;", "setCancelButtonVisible", "visible", "setLoginAction", "setLoginButtonVisible", "PasswordUI", "TokenUI", "Lorg/jetbrains/plugins/github/authentication/ui/GithubCredentialsUI$PasswordUI;", "Lorg/jetbrains/plugins/github/authentication/ui/GithubCredentialsUI$TokenUI;", "intellij.vcs.github"})
public abstract class GithubCredentialsUI {
    @NotNull
    private final JButton loginButton;
    @NotNull
    private final JButton cancelButton;

    @NotNull
    public abstract JPanel getPanel();

    @NotNull
    public abstract JComponent getPreferredFocus();

    @NotNull
    public abstract Function0<ValidationInfo> getValidator();

    @NotNull
    public abstract GithubApiRequestExecutor createExecutor();

    @NotNull
    public abstract Pair<String, String> acquireLoginAndToken(@NotNull GithubServerPath var1, @NotNull GithubApiRequestExecutor var2, @NotNull ProgressIndicator var3);

    @NotNull
    public abstract ValidationInfo handleAcquireError(@NotNull Throwable var1);

    public abstract void setBusy(boolean var1);

    @NotNull
    protected final JButton getLoginButton() {
        return this.loginButton;
    }

    @NotNull
    protected final JButton getCancelButton() {
        return this.cancelButton;
    }

    public void setLoginAction(@NotNull ActionListener actionListener) {
        Intrinsics.checkParameterIsNotNull((Object)actionListener, (String)"actionListener");
        this.loginButton.addActionListener(actionListener);
        this.loginButton.setMnemonic('l');
    }

    public final void setCancelAction(@NotNull ActionListener actionListener) {
        Intrinsics.checkParameterIsNotNull((Object)actionListener, (String)"actionListener");
        this.cancelButton.addActionListener(actionListener);
        this.cancelButton.setMnemonic('c');
    }

    public final void setLoginButtonVisible(boolean visible) {
        this.loginButton.setVisible(visible);
    }

    public final void setCancelButtonVisible(boolean visible) {
        this.cancelButton.setVisible(visible);
    }

    private GithubCredentialsUI() {
        JButton jButton;
        JButton jButton2 = new JButton("Log In");
        GithubCredentialsUI githubCredentialsUI = this;
        boolean bl = false;
        boolean bl2 = false;
        JButton $this$apply = jButton2;
        boolean bl3 = false;
        $this$apply.setVisible(false);
        githubCredentialsUI.loginButton = jButton = jButton2;
        jButton2 = new JButton("Cancel");
        githubCredentialsUI = this;
        bl = false;
        bl2 = false;
        $this$apply = jButton2;
        boolean bl4 = false;
        $this$apply.setVisible(false);
        githubCredentialsUI.cancelButton = jButton = jButton2;
    }

    public /* synthetic */ GithubCredentialsUI(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001Bk\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00126\u0010\u000b\u001a2\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\f\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0014J,\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001d2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016J\u0014\u0010(\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010)0\u0007j\u0002`*H\u0016J\u0010\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u00020\u0012H\u0016J\u0018\u00100\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00052\b\b\u0002\u00101\u001a\u00020\u0012J\u0010\u00102\u001a\u00020\b2\u0006\u00103\u001a\u000204H\u0016J\u000e\u00105\u001a\u00020\b2\u0006\u00106\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u000b\u001a2\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0019\u001a\u000b\u0012\u0002\b\u00030\u001a\u00a2\u0006\u0002\b\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GithubCredentialsUI$PasswordUI;", "Lorg/jetbrains/plugins/github/authentication/ui/GithubCredentialsUI;", "serverTextField", "Lcom/intellij/ui/components/fields/ExtendableTextField;", "clientName", "", "switchUi", "Lkotlin/Function0;", "", "executorFactory", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;", "isAccountUnique", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "login", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "server", "", "dialogMode", "(Lcom/intellij/ui/components/fields/ExtendableTextField;Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;Lkotlin/jvm/functions/Function2;Z)V", "loginTextField", "Lcom/intellij/ui/components/JBTextField;", "passwordField", "Ljavax/swing/JPasswordField;", "switchUiLink", "Lcom/intellij/ui/components/labels/LinkLabel;", "Lorg/jetbrains/annotations/NotNull;", "acquireLoginAndToken", "Lkotlin/Pair;", "executor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "createExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$WithBasicAuth;", "getPanel", "Ljavax/swing/JPanel;", "getPreferredFocus", "Ljavax/swing/JTextField;", "getValidator", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lorg/jetbrains/plugins/github/ui/util/Validator;", "handleAcquireError", "error", "", "setBusy", "busy", "setLogin", "editable", "setLoginAction", "actionListener", "Ljava/awt/event/ActionListener;", "setPassword", "password", "intellij.vcs.github"})
    public static final class PasswordUI
    extends GithubCredentialsUI {
        private final JBTextField loginTextField;
        private final JPasswordField passwordField;
        private final LinkLabel<?> switchUiLink;
        private final ExtendableTextField serverTextField;
        private final String clientName;
        private final GithubApiRequestExecutor.Factory executorFactory;
        private final Function2<String, GithubServerPath, Boolean> isAccountUnique;
        private final boolean dialogMode;

        public final void setLogin(@NotNull String login, boolean editable) {
            Intrinsics.checkParameterIsNotNull((Object)login, (String)"login");
            this.loginTextField.setText(login);
            this.loginTextField.setEditable(editable);
        }

        public static /* synthetic */ void setLogin$default(PasswordUI passwordUI, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            passwordUI.setLogin(string, bl);
        }

        public final void setPassword(@NotNull String password) {
            Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
            this.passwordField.setText(password);
        }

        @Override
        public void setLoginAction(@NotNull ActionListener actionListener) {
            Intrinsics.checkParameterIsNotNull((Object)actionListener, (String)"actionListener");
            super.setLoginAction(actionListener);
            GithubCredentialsUIKt.access$setEnterPressedAction(this.passwordField, actionListener);
            GithubCredentialsUIKt.access$setEnterPressedAction((JComponent)this.loginTextField, actionListener);
            GithubCredentialsUIKt.access$setEnterPressedAction((JComponent)this.serverTextField, actionListener);
        }

        @Override
        @NotNull
        public JPanel getPanel() {
            LayoutBuilder builder$iv;
            LCFlags[] constraints$iv = new LCFlags[]{};
            String title$iv = null;
            boolean $i$f$panel = false;
            LayoutBuilder $this$panel = builder$iv = LayoutImplKt.createLayoutBuilder();
            boolean bl = false;
            GithubCredentialsUIKt.access$buildTitleAndLinkRow($this$panel, this.dialogMode, this.switchUiLink);
            RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, (String)"Server:", (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
                final /* synthetic */ PasswordUI this$0;
                {
                    this.this$0 = passwordUI;
                    super(1);
                }

                public final void invoke(@NotNull Row $this$row) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                    Cell.invoke$default((Cell)$this$row, (JComponent)((JComponent)PasswordUI.access$getServerTextField$p(this.this$0)), (CCFlags[])new CCFlags[]{$this$row.getPushX(), $this$row.getGrowX()}, null, null, (int)6, null);
                }
            }), (int)2, null);
            RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, (String)"Login:", (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
                final /* synthetic */ PasswordUI this$0;
                {
                    this.this$0 = passwordUI;
                    super(1);
                }

                public final void invoke(@NotNull Row $this$row) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                    Cell.invoke$default((Cell)$this$row, (JComponent)((JComponent)PasswordUI.access$getLoginTextField$p(this.this$0)), (CCFlags[])new CCFlags[]{$this$row.getPushX(), $this$row.getGrowX()}, null, null, (int)6, null);
                }
            }), (int)2, null);
            RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, (String)"Password:", (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
                final /* synthetic */ PasswordUI this$0;
                {
                    this.this$0 = passwordUI;
                    super(1);
                }

                public final void invoke(@NotNull Row $this$row) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                    CCFlags[] cCFlagsArray = new CCFlags[]{$this$row.getPushX(), $this$row.getGrowX()};
                    GrowPolicy growPolicy = null;
                    String string = "The password is not saved and is only used to generate a GitHub token";
                    Cell.invoke$default((Cell)$this$row, (JComponent)PasswordUI.access$getPasswordField$p(this.this$0), (CCFlags[])cCFlagsArray, growPolicy, (String)string, (int)2, null);
                }
            }), (int)2, null);
            RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, (String)"", (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
                final /* synthetic */ PasswordUI this$0;
                {
                    this.this$0 = passwordUI;
                    super(1);
                }

                public final void invoke(@NotNull Row $this$row) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                    Row this_$iv = $this$row;
                    boolean isVerticalFlow$iv = false;
                    boolean isFullWidth$iv = false;
                    boolean $i$f$cell = false;
                    this_$iv.setCellMode(true, isVerticalFlow$iv, isFullWidth$iv);
                    InnerCell $this$cell = new InnerCell((Cell)this_$iv);
                    boolean bl = false;
                    Cell.invoke$default((Cell)$this$cell, (JComponent)this.this$0.getLoginButton(), (CCFlags[])new CCFlags[0], null, null, (int)6, null);
                    Cell.invoke$default((Cell)$this$cell, (JComponent)this.this$0.getCancelButton(), (CCFlags[])new CCFlags[0], null, null, (int)6, null);
                    this_$iv.setCellMode(false, isVerticalFlow$iv, isFullWidth$iv);
                }
            }), (int)2, null);
            DialogPanel panel$iv = ComponentsKt.DialogPanel((String)title$iv, null);
            builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
            LayoutKt.initPanel((LayoutBuilder)builder$iv, (DialogPanel)panel$iv);
            DialogPanel dialogPanel = panel$iv;
            boolean bl2 = false;
            boolean bl3 = false;
            DialogPanel $this$apply = dialogPanel;
            boolean bl4 = false;
            $this$apply.setBorder((Border)new JBEmptyBorder((Insets)UIUtil.getRegularPanelInsets()));
            return (JPanel)dialogPanel;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public JTextField getPreferredFocus() {
            JTextField jTextField;
            if (this.loginTextField.isEditable()) {
                String string = this.loginTextField.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"loginTextField.text");
                CharSequence charSequence = string;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    jTextField = (JTextField)this.loginTextField;
                    return jTextField;
                }
            }
            jTextField = this.passwordField;
            return jTextField;
        }

        @Override
        @NotNull
        public Function0<ValidationInfo> getValidator() {
            return DialogValidationUtils.INSTANCE.chain((Function0)new Function0<ValidationInfo>(this){
                final /* synthetic */ PasswordUI this$0;

                @Nullable
                public final ValidationInfo invoke() {
                    return DialogValidationUtils.INSTANCE.notBlank((JTextField)PasswordUI.access$getLoginTextField$p(this.this$0), "Login cannot be empty");
                }
                {
                    this.this$0 = passwordUI;
                    super(0);
                }
            }, (Function0)new Function0<ValidationInfo>(this){
                final /* synthetic */ PasswordUI this$0;

                @Nullable
                public final ValidationInfo invoke() {
                    return DialogValidationUtils.INSTANCE.notBlank(PasswordUI.access$getPasswordField$p(this.this$0), "Password cannot be empty");
                }
                {
                    this.this$0 = passwordUI;
                    super(0);
                }
            });
        }

        @Override
        @NotNull
        public GithubApiRequestExecutor.WithBasicAuth createExecutor() {
            ModalityState modalityState = ModalityState.stateForComponent((Component)this.passwordField);
            Intrinsics.checkExpressionValueIsNotNull((Object)modalityState, (String)"ModalityState.stateForComponent(passwordField)");
            ModalityState modalityState2 = modalityState;
            String string = this.loginTextField.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"loginTextField.text");
            char[] cArray = this.passwordField.getPassword();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"passwordField.password");
            return this.executorFactory.create$intellij_vcs_github(string, cArray, new Supplier<String>(this, modalityState2){
                final /* synthetic */ PasswordUI this$0;
                final /* synthetic */ ModalityState $modalityState;

                @Nullable
                public final String get() {
                    return (String)ActionsKt.invokeAndWaitIfNeeded((ModalityState)this.$modalityState, (Function0)((Function0)new Function0<String>(this){
                        final /* synthetic */ createExecutor.1 this$0;

                        @Nullable
                        public final String invoke() {
                            return Messages.showInputDialog((Component)PasswordUI.access$getPasswordField$p(this.this$0.this$0), (String)"Authentication code:", (String)"GitHub Two-Factor Authentication", null);
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }));
                }
                {
                    this.this$0 = passwordUI;
                    this.$modalityState = modalityState;
                }
            });
        }

        @Override
        @NotNull
        public Pair<String, String> acquireLoginAndToken(@NotNull GithubServerPath server, @NotNull GithubApiRequestExecutor executor, @NotNull ProgressIndicator indicator) {
            Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
            Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
            Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
            String string = this.loginTextField.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"loginTextField.text");
            String string2 = string;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String login = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            if (!((Boolean)this.isAccountUnique.invoke((Object)login, (Object)server)).booleanValue()) {
                throw (Throwable)new LoginNotUniqueException(login);
            }
            String string4 = new GHAccessTokenCreator(server, executor, indicator).createMaster(this.clientName).getToken();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"GHAccessTokenCreator(ser\u2026eMaster(clientName).token");
            String token = string4;
            return TuplesKt.to((Object)login, (Object)token);
        }

        @Override
        @NotNull
        public ValidationInfo handleAcquireError(@NotNull Throwable error) {
            ValidationInfo validationInfo;
            Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
            Throwable throwable = error;
            if (throwable instanceof LoginNotUniqueException) {
                ValidationInfo validationInfo2 = new ValidationInfo("Account already added", (JComponent)this.loginTextField).withOKEnabled();
                validationInfo = validationInfo2;
                Intrinsics.checkExpressionValueIsNotNull((Object)validationInfo2, (String)"ValidationInfo(\"Account \u2026extField).withOKEnabled()");
            } else if (throwable instanceof UnknownHostException) {
                ValidationInfo validationInfo3 = new ValidationInfo("Server is unreachable").withOKEnabled();
                validationInfo = validationInfo3;
                Intrinsics.checkExpressionValueIsNotNull((Object)validationInfo3, (String)"ValidationInfo(\"Server i\u2026achable\").withOKEnabled()");
            } else if (throwable instanceof GithubAuthenticationException) {
                String string = error.getMessage();
                StringBuilder stringBuilder = new StringBuilder().append("Incorrect credentials. ");
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    string2 = "";
                }
                String string3 = string2;
                String string4 = stringBuilder.append(string3).toString();
                ValidationInfo validationInfo4 = new ValidationInfo(string4).withOKEnabled();
                validationInfo = validationInfo4;
                Intrinsics.checkExpressionValueIsNotNull((Object)validationInfo4, (String)"ValidationInfo(\"Incorrec\u2026mpty()}\").withOKEnabled()");
            } else if (throwable instanceof GithubParseException) {
                String string = error.getMessage();
                if (string == null) {
                    string = "Invalid server path";
                }
                validationInfo = new ValidationInfo(string, (JComponent)this.serverTextField);
            } else {
                ValidationInfo validationInfo5 = new ValidationInfo("Invalid authentication data.\n " + error.getMessage()).withOKEnabled();
                validationInfo = validationInfo5;
                Intrinsics.checkExpressionValueIsNotNull((Object)validationInfo5, (String)"ValidationInfo(\"Invalid \u2026essage}\").withOKEnabled()");
            }
            return validationInfo;
        }

        @Override
        public void setBusy(boolean busy) {
            this.loginTextField.setEnabled(!busy);
            this.passwordField.setEnabled(!busy);
            this.switchUiLink.setEnabled(!busy);
        }

        public PasswordUI(@NotNull ExtendableTextField serverTextField, @NotNull String clientName, @NotNull Function0<Unit> switchUi, @NotNull GithubApiRequestExecutor.Factory executorFactory, @NotNull Function2<? super String, ? super GithubServerPath, Boolean> isAccountUnique, boolean dialogMode) {
            Intrinsics.checkParameterIsNotNull((Object)serverTextField, (String)"serverTextField");
            Intrinsics.checkParameterIsNotNull((Object)clientName, (String)"clientName");
            Intrinsics.checkParameterIsNotNull(switchUi, (String)"switchUi");
            Intrinsics.checkParameterIsNotNull((Object)executorFactory, (String)"executorFactory");
            Intrinsics.checkParameterIsNotNull(isAccountUnique, (String)"isAccountUnique");
            super(null);
            this.serverTextField = serverTextField;
            this.clientName = clientName;
            this.executorFactory = executorFactory;
            this.isAccountUnique = isAccountUnique;
            this.dialogMode = dialogMode;
            this.loginTextField = new JBTextField();
            this.passwordField = new JPasswordField();
            Function0<Unit> function0 = switchUi;
            LinkLabel linkLabel = LinkLabel.create((String)"Use Token", (Runnable)new GithubCredentialsUIKt$sam$java_lang_Runnable$0(function0));
            Intrinsics.checkExpressionValueIsNotNull((Object)linkLabel, (String)"LinkLabel.create(\"Use Token\", switchUi)");
            this.switchUiLink = linkLabel;
        }

        public static final /* synthetic */ ExtendableTextField access$getServerTextField$p(PasswordUI $this) {
            return $this.serverTextField;
        }

        public static final /* synthetic */ JBTextField access$getLoginTextField$p(PasswordUI $this) {
            return $this.loginTextField;
        }

        public static final /* synthetic */ JPasswordField access$getPasswordField$p(PasswordUI $this) {
            return $this.passwordField;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001Bc\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00126\u0010\u0004\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0012J,\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u001d2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u001bH\u0016J\u0010\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0\u000fH\u0016J\u0010\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u000bH\u0016J\u0010\u0010.\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006J\u0010\u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u000201H\u0016J\u000e\u00102\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u0006R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000RA\u0010\u0004\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0017\u001a\u000b\u0012\u0002\b\u00030\u0018\u00a2\u0006\u0002\b\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/plugins/github/authentication/ui/GithubCredentialsUI$TokenUI;", "Lorg/jetbrains/plugins/github/authentication/ui/GithubCredentialsUI;", "factory", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;", "isAccountUnique", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "server", "", "serverTextField", "Lcom/intellij/ui/components/fields/ExtendableTextField;", "switchUi", "Lkotlin/Function0;", "", "dialogMode", "(Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;Lkotlin/jvm/functions/Function2;Lcom/intellij/ui/components/fields/ExtendableTextField;Lkotlin/jvm/functions/Function0;Z)V", "getFactory", "()Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;", "fixedLogin", "()Lkotlin/jvm/functions/Function2;", "switchUiLink", "Lcom/intellij/ui/components/labels/LinkLabel;", "Lorg/jetbrains/annotations/NotNull;", "tokenTextField", "Lcom/intellij/ui/components/JBTextField;", "acquireLoginAndToken", "Lkotlin/Pair;", "executor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "createExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$WithTokenAuth;", "getPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "getPreferredFocus", "getValidator", "Lcom/intellij/openapi/ui/ValidationInfo;", "handleAcquireError", "error", "", "setBusy", "busy", "setFixedLogin", "setLoginAction", "actionListener", "Ljava/awt/event/ActionListener;", "setToken", "token", "intellij.vcs.github"})
    public static final class TokenUI
    extends GithubCredentialsUI {
        private final JBTextField tokenTextField;
        private final LinkLabel<?> switchUiLink;
        private String fixedLogin;
        @NotNull
        private final GithubApiRequestExecutor.Factory factory;
        @NotNull
        private final Function2<String, GithubServerPath, Boolean> isAccountUnique;
        private final ExtendableTextField serverTextField;
        private final boolean dialogMode;

        public final void setToken(@NotNull String token) {
            Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
            this.tokenTextField.setText(token);
        }

        @NotNull
        public DialogPanel getPanel() {
            LayoutBuilder builder$iv;
            LCFlags[] constraints$iv = new LCFlags[]{};
            String title$iv = null;
            boolean $i$f$panel = false;
            LayoutBuilder $this$panel = builder$iv = LayoutImplKt.createLayoutBuilder();
            boolean bl = false;
            GithubCredentialsUIKt.access$buildTitleAndLinkRow($this$panel, this.dialogMode, this.switchUiLink);
            RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, (String)"Server:", (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
                final /* synthetic */ TokenUI this$0;
                {
                    this.this$0 = tokenUI;
                    super(1);
                }

                public final void invoke(@NotNull Row $this$row) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                    Cell.invoke$default((Cell)$this$row, (JComponent)((JComponent)TokenUI.access$getServerTextField$p(this.this$0)), (CCFlags[])new CCFlags[]{$this$row.getPushX(), $this$row.getGrowX()}, null, null, (int)6, null);
                }
            }), (int)2, null);
            RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, (String)"Token:", (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
                final /* synthetic */ TokenUI this$0;
                {
                    this.this$0 = tokenUI;
                    super(1);
                }

                public final void invoke(@NotNull Row $this$row) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                    CCFlags[] cCFlagsArray = new CCFlags[]{$this$row.getPushX(), $this$row.getGrowX()};
                    GrowPolicy growPolicy = null;
                    String string = "The following scopes must be granted to the access token: " + GHSecurityUtil.INSTANCE.getMASTER_SCOPES();
                    Cell.invoke$default((Cell)$this$row, (JComponent)((JComponent)TokenUI.access$getTokenTextField$p(this.this$0)), (CCFlags[])cCFlagsArray, growPolicy, (String)string, (int)2, null);
                }
            }), (int)2, null);
            RowBuilder.DefaultImpls.row$default((RowBuilder)$this$panel, (String)"", (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
                final /* synthetic */ TokenUI this$0;
                {
                    this.this$0 = tokenUI;
                    super(1);
                }

                public final void invoke(@NotNull Row $this$row) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$row, (String)"$receiver");
                    Row this_$iv = $this$row;
                    boolean isVerticalFlow$iv = false;
                    boolean isFullWidth$iv = false;
                    boolean $i$f$cell = false;
                    this_$iv.setCellMode(true, isVerticalFlow$iv, isFullWidth$iv);
                    InnerCell $this$cell = new InnerCell((Cell)this_$iv);
                    boolean bl = false;
                    Cell.invoke$default((Cell)$this$cell, (JComponent)this.this$0.getLoginButton(), (CCFlags[])new CCFlags[0], null, null, (int)6, null);
                    Cell.invoke$default((Cell)$this$cell, (JComponent)this.this$0.getCancelButton(), (CCFlags[])new CCFlags[0], null, null, (int)6, null);
                    this_$iv.setCellMode(false, isVerticalFlow$iv, isFullWidth$iv);
                }
            }), (int)2, null);
            DialogPanel panel$iv = ComponentsKt.DialogPanel((String)title$iv, null);
            builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
            LayoutKt.initPanel((LayoutBuilder)builder$iv, (DialogPanel)panel$iv);
            DialogPanel dialogPanel = panel$iv;
            boolean bl2 = false;
            boolean bl3 = false;
            DialogPanel $this$apply = dialogPanel;
            boolean bl4 = false;
            $this$apply.setBorder((Border)new JBEmptyBorder((Insets)UIUtil.getRegularPanelInsets()));
            return dialogPanel;
        }

        @NotNull
        public JBTextField getPreferredFocus() {
            return this.tokenTextField;
        }

        @Override
        @NotNull
        public Function0<ValidationInfo> getValidator() {
            return (Function0)new Function0<ValidationInfo>(this){
                final /* synthetic */ TokenUI this$0;

                @Nullable
                public final ValidationInfo invoke() {
                    return DialogValidationUtils.INSTANCE.notBlank((JTextField)TokenUI.access$getTokenTextField$p(this.this$0), "Token cannot be empty");
                }
                {
                    this.this$0 = tokenUI;
                    super(0);
                }
            };
        }

        @Override
        @NotNull
        public GithubApiRequestExecutor.WithTokenAuth createExecutor() {
            String string = this.tokenTextField.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"tokenTextField.text");
            return this.factory.create(string);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Pair<String, String> acquireLoginAndToken(@NotNull GithubServerPath server, @NotNull GithubApiRequestExecutor executor, @NotNull ProgressIndicator indicator) {
            void details2;
            Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
            Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
            Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
            Pair<GithubAuthenticatedUser, String> pair = GHSecurityUtil.loadCurrentUserWithScopes$intellij_vcs_github(executor, indicator, server);
            GithubAuthenticatedUser githubAuthenticatedUser = (GithubAuthenticatedUser)pair.component1();
            String scopes = (String)pair.component2();
            if (scopes == null || !GHSecurityUtil.isEnoughScopes$intellij_vcs_github(scopes)) {
                throw (Throwable)new GithubAuthenticationException("Insufficient scopes granted to token.");
            }
            String string = details2.getLogin();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"details.login");
            String login = string;
            String string2 = this.fixedLogin;
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                if (Intrinsics.areEqual((Object)it, (Object)login) ^ true) {
                    throw (Throwable)new GithubAuthenticationException("Token should match username \"" + it + '\"');
                }
            }
            if (!((Boolean)this.isAccountUnique.invoke((Object)login, (Object)server)).booleanValue()) {
                throw (Throwable)new LoginNotUniqueException(login);
            }
            return TuplesKt.to((Object)login, (Object)this.tokenTextField.getText());
        }

        @Override
        @NotNull
        public ValidationInfo handleAcquireError(@NotNull Throwable error) {
            ValidationInfo validationInfo;
            Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
            Throwable throwable = error;
            if (throwable instanceof LoginNotUniqueException) {
                ValidationInfo validationInfo2 = new ValidationInfo("Account " + ((LoginNotUniqueException)error).getLogin() + " already added").withOKEnabled();
                validationInfo = validationInfo2;
                Intrinsics.checkExpressionValueIsNotNull((Object)validationInfo2, (String)"ValidationInfo(\"Account \u2026y added\").withOKEnabled()");
            } else if (throwable instanceof UnknownHostException) {
                ValidationInfo validationInfo3 = new ValidationInfo("Server is unreachable").withOKEnabled();
                validationInfo = validationInfo3;
                Intrinsics.checkExpressionValueIsNotNull((Object)validationInfo3, (String)"ValidationInfo(\"Server i\u2026achable\").withOKEnabled()");
            } else if (throwable instanceof GithubAuthenticationException) {
                String string = error.getMessage();
                StringBuilder stringBuilder = new StringBuilder().append("Incorrect credentials. ");
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    string2 = "";
                }
                String string3 = string2;
                String string4 = stringBuilder.append(string3).toString();
                ValidationInfo validationInfo4 = new ValidationInfo(string4).withOKEnabled();
                validationInfo = validationInfo4;
                Intrinsics.checkExpressionValueIsNotNull((Object)validationInfo4, (String)"ValidationInfo(\"Incorrec\u2026mpty()}\").withOKEnabled()");
            } else if (throwable instanceof GithubParseException) {
                String string = error.getMessage();
                if (string == null) {
                    string = "Invalid server path";
                }
                validationInfo = new ValidationInfo(string, (JComponent)this.serverTextField);
            } else {
                ValidationInfo validationInfo5 = new ValidationInfo("Invalid authentication data.\n " + error.getMessage()).withOKEnabled();
                validationInfo = validationInfo5;
                Intrinsics.checkExpressionValueIsNotNull((Object)validationInfo5, (String)"ValidationInfo(\"Invalid \u2026essage}\").withOKEnabled()");
            }
            return validationInfo;
        }

        @Override
        public void setBusy(boolean busy) {
            this.tokenTextField.setEnabled(!busy);
            this.switchUiLink.setEnabled(!busy);
        }

        public final void setFixedLogin(@Nullable String fixedLogin) {
            this.fixedLogin = fixedLogin;
        }

        @Override
        public void setLoginAction(@NotNull ActionListener actionListener) {
            Intrinsics.checkParameterIsNotNull((Object)actionListener, (String)"actionListener");
            super.setLoginAction(actionListener);
            GithubCredentialsUIKt.access$setEnterPressedAction((JComponent)this.tokenTextField, actionListener);
            GithubCredentialsUIKt.access$setEnterPressedAction((JComponent)this.serverTextField, actionListener);
        }

        @NotNull
        public final GithubApiRequestExecutor.Factory getFactory() {
            return this.factory;
        }

        @NotNull
        public final Function2<String, GithubServerPath, Boolean> isAccountUnique() {
            return this.isAccountUnique;
        }

        public TokenUI(@NotNull GithubApiRequestExecutor.Factory factory2, @NotNull Function2<? super String, ? super GithubServerPath, Boolean> isAccountUnique, @NotNull ExtendableTextField serverTextField, @NotNull Function0<Unit> switchUi, boolean dialogMode) {
            Intrinsics.checkParameterIsNotNull((Object)factory2, (String)"factory");
            Intrinsics.checkParameterIsNotNull(isAccountUnique, (String)"isAccountUnique");
            Intrinsics.checkParameterIsNotNull((Object)serverTextField, (String)"serverTextField");
            Intrinsics.checkParameterIsNotNull(switchUi, (String)"switchUi");
            super(null);
            this.factory = factory2;
            this.isAccountUnique = isAccountUnique;
            this.serverTextField = serverTextField;
            this.dialogMode = dialogMode;
            this.tokenTextField = new JBTextField();
            Function0<Unit> function0 = switchUi;
            LinkLabel linkLabel = LinkLabel.create((String)"Use Credentials", (Runnable)new GithubCredentialsUIKt$sam$java_lang_Runnable$0(function0));
            Intrinsics.checkExpressionValueIsNotNull((Object)linkLabel, (String)"LinkLabel.create(\"Use Credentials\", switchUi)");
            this.switchUiLink = linkLabel;
        }

        public static final /* synthetic */ ExtendableTextField access$getServerTextField$p(TokenUI $this) {
            return $this.serverTextField;
        }

        public static final /* synthetic */ JBTextField access$getTokenTextField$p(TokenUI $this) {
            return $this.tokenTextField;
        }
    }
}

