/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ui.ColumnInfo;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CoverageViewExtension {
    protected final Project myProject;
    protected final CoverageSuitesBundle mySuitesBundle;
    protected final CoverageViewManager.StateBean myStateBean;
    protected final CoverageDataManager myCoverageDataManager;
    protected final CoverageViewManager myCoverageViewManager;

    public CoverageViewExtension(@NotNull Project project, CoverageSuitesBundle suitesBundle, CoverageViewManager.StateBean stateBean) {
        if (project == null) {
            CoverageViewExtension.$$$reportNull$$$0(0);
        }
        assert (!project.isDefault()) : "Should not run coverage for default project";
        this.myProject = project;
        this.mySuitesBundle = suitesBundle;
        this.myStateBean = stateBean;
        this.myCoverageDataManager = CoverageDataManager.getInstance(this.myProject);
        this.myCoverageViewManager = CoverageViewManager.getInstance(this.myProject);
    }

    @Nullable
    public abstract String getSummaryForNode(AbstractTreeNode<?> var1);

    @Nullable
    public abstract String getSummaryForRootNode(AbstractTreeNode<?> var1);

    @Nullable
    public abstract String getPercentage(int var1, AbstractTreeNode<?> var2);

    public abstract List<AbstractTreeNode<?>> getChildrenNodes(AbstractTreeNode<?> var1);

    public abstract ColumnInfo[] createColumnInfos();

    @Nullable
    public abstract PsiElement getParentElement(PsiElement var1);

    @NotNull
    public abstract AbstractTreeNode<?> createRootNode();

    public boolean canSelectInCoverageView(Object object) {
        return object instanceof VirtualFile && PsiManager.getInstance((Project)this.myProject).findFile((VirtualFile)object) != null;
    }

    @Nullable
    public PsiElement getElementToSelect(Object object) {
        if (object instanceof PsiElement) {
            return (PsiElement)object;
        }
        return object instanceof VirtualFile ? PsiManager.getInstance((Project)this.myProject).findFile((VirtualFile)object) : null;
    }

    @Nullable
    public VirtualFile getVirtualFile(Object object) {
        if (object instanceof PsiElement) {
            if (object instanceof PsiDirectory) {
                return ((PsiDirectory)object).getVirtualFile();
            }
            PsiFile containingFile = ((PsiElement)object).getContainingFile();
            if (containingFile != null) {
                return containingFile.getVirtualFile();
            }
            return null;
        }
        return object instanceof VirtualFile ? (VirtualFile)object : null;
    }

    @NotNull
    public List<AbstractTreeNode<?>> createTopLevelNodes() {
        List<AbstractTreeNode<?>> list = Collections.emptyList();
        if (list == null) {
            CoverageViewExtension.$$$reportNull$$$0(1);
        }
        return list;
    }

    public boolean supportFlattenPackages() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/view/CoverageViewExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/view/CoverageViewExtension";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTopLevelNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

