/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.util.Url;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.FileBackedSourceMapData;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.Mappings;
import org.jetbrains.debugger.sourcemap.SourceMapBase;
import org.jetbrains.debugger.sourcemap.SourceMapData;
import org.jetbrains.debugger.sourcemap.SourceMapDataCache;
import org.jetbrains.debugger.sourcemap.SourceMapDataEx;
import org.jetbrains.debugger.sourcemap.SourceResolver;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/debugger/sourcemap/FileBackedSourceMap;", "Lorg/jetbrains/debugger/sourcemap/SourceMapBase;", "filePath", "Ljava/nio/file/Path;", "initialData", "Lorg/jetbrains/debugger/sourcemap/SourceMapDataEx;", "sourceResolver", "Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "(Ljava/nio/file/Path;Lorg/jetbrains/debugger/sourcemap/SourceMapDataEx;Lorg/jetbrains/debugger/sourcemap/SourceResolver;)V", "generatedMappings", "Lorg/jetbrains/debugger/sourcemap/Mappings;", "getGeneratedMappings", "()Lorg/jetbrains/debugger/sourcemap/Mappings;", "sourceIndexToMappings", "", "Lorg/jetbrains/debugger/sourcemap/MappingList;", "getSourceIndexToMappings", "()[Lorg/jetbrains/debugger/sourcemap/MappingList;", "Companion", "intellij.platform.scriptDebugger.backend"})
public final class FileBackedSourceMap
extends SourceMapBase {
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    protected MappingList[] getSourceIndexToMappings() {
        SourceMapData sourceMapData = this.getSourceMapData();
        if (sourceMapData == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.sourcemap.FileBackedSourceMapData");
        }
        return ((FileBackedSourceMapData)sourceMapData).getSourceIndexToMappings();
    }

    @Override
    @NotNull
    public Mappings getGeneratedMappings() {
        SourceMapData sourceMapData = this.getSourceMapData();
        if (sourceMapData == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.sourcemap.FileBackedSourceMapData");
        }
        return ((FileBackedSourceMapData)sourceMapData).getGeneratedMappings();
    }

    private FileBackedSourceMap(Path filePath, SourceMapDataEx initialData, SourceResolver sourceResolver) {
        super(new FileBackedSourceMapData(filePath, initialData), sourceResolver);
    }

    public /* synthetic */ FileBackedSourceMap(Path filePath, SourceMapDataEx initialData, SourceResolver sourceResolver, DefaultConstructorMarker $constructor_marker) {
        this(filePath, initialData, sourceResolver);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/debugger/sourcemap/FileBackedSourceMap$Companion;", "", "()V", "newFileBackedSourceMap", "Lorg/jetbrains/debugger/sourcemap/FileBackedSourceMap;", "filePath", "Ljava/nio/file/Path;", "trimFileScheme", "", "baseUrl", "Lcom/intellij/util/Url;", "baseUrlIsFile", "intellij.platform.scriptDebugger.backend"})
    public static final class Companion {
        @Nullable
        public final FileBackedSourceMap newFileBackedSourceMap(@NotNull Path filePath, boolean trimFileScheme, @Nullable Url baseUrl, boolean baseUrlIsFile) {
            Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
            String text2 = PathKt.readText((Path)filePath);
            SourceMapDataEx sourceMapDataEx = SourceMapDataCache.INSTANCE.getOrCreate(text2, ((Object)filePath).toString());
            if (sourceMapDataEx == null) {
                return null;
            }
            SourceMapDataEx data2 = sourceMapDataEx;
            return new FileBackedSourceMap(filePath, data2, new SourceResolver(data2.getSourceMapData().getSources(), trimFileScheme, baseUrl, baseUrlIsFile), null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

