/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.psi.impl;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.intellij.lang.regexp.RegExpLanguageHosts;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpProperty;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegExpPropertyImpl
extends RegExpElementImpl
implements RegExpProperty {
    private static final String[] UNICODE_BLOCKS;

    public RegExpPropertyImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    public PsiReference getReference() {
        ASTNode lbrace = this.getNode().findChildByType(RegExpTT.LBRACE);
        if (lbrace == null) {
            return null;
        }
        return new MyPsiReference();
    }

    @Override
    public boolean isNegated() {
        ASTNode node1 = this.getNode().findChildByType(RegExpTT.PROPERTY);
        ASTNode node2 = this.getNode().findChildByType(RegExpTT.CARET);
        return (node1 != null && node1.textContains('P')) ^ node2 != null;
    }

    @Override
    @Nullable
    public ASTNode getCategoryNode() {
        return this.getNode().findChildByType(RegExpTT.NAME);
    }

    @Override
    @Nullable
    public ASTNode getValueNode() {
        ASTNode node = this.getNode();
        ASTNode eq2 = node.findChildByType(RegExpTT.EQ);
        return eq2 != null ? node.findChildByType(RegExpTT.NAME, eq2) : null;
    }

    @Override
    public void accept(RegExpElementVisitor visitor) {
        visitor.visitRegExpProperty(this);
    }

    static {
        Field[] fields = Character.UnicodeBlock.class.getFields();
        ArrayList<String> unicodeBlocks = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            if (!field.getType().equals(Character.UnicodeBlock.class) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
            unicodeBlocks.add("In" + field.getName());
        }
        UNICODE_BLOCKS = ArrayUtilRt.toStringArray(unicodeBlocks);
    }

    private class MyPsiReference
    implements PsiReference {
        private MyPsiReference() {
        }

        @NotNull
        public PsiElement getElement() {
            RegExpPropertyImpl regExpPropertyImpl = RegExpPropertyImpl.this;
            if (regExpPropertyImpl == null) {
                MyPsiReference.$$$reportNull$$$0(0);
            }
            return regExpPropertyImpl;
        }

        @NotNull
        public TextRange getRangeInElement() {
            ASTNode node = RegExpPropertyImpl.this.getNode();
            ASTNode firstNode = node.findChildByType(RegExpTT.CARET);
            if (firstNode == null) {
                firstNode = node.findChildByType(RegExpTT.LBRACE);
            }
            assert (firstNode != null);
            ASTNode eq2 = node.findChildByType(RegExpTT.EQ);
            ASTNode rbrace = node.findChildByType(RegExpTT.RBRACE);
            int to = eq2 != null ? eq2.getTextRange().getEndOffset() - 1 : (rbrace != null ? rbrace.getTextRange().getEndOffset() - 1 : RegExpPropertyImpl.this.getTextRange().getEndOffset());
            TextRange t = new TextRange(firstNode.getStartOffset() + 1, to);
            TextRange textRange = t.shiftRight(-RegExpPropertyImpl.this.getTextRange().getStartOffset());
            if (textRange == null) {
                MyPsiReference.$$$reportNull$$$0(1);
            }
            return textRange;
        }

        @Nullable
        public PsiElement resolve() {
            return RegExpPropertyImpl.this;
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.getRangeInElement().substring(this.getElement().getText());
            if (string == null) {
                MyPsiReference.$$$reportNull$$$0(2);
            }
            return string;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                MyPsiReference.$$$reportNull$$$0(3);
            }
            throw new IncorrectOperationException();
        }

        public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
            if (element2 == null) {
                MyPsiReference.$$$reportNull$$$0(4);
            }
            throw new IncorrectOperationException();
        }

        public boolean isReferenceTo(@NotNull PsiElement element2) {
            if (element2 == null) {
                MyPsiReference.$$$reportNull$$$0(5);
            }
            return false;
        }

        public Object @NotNull [] getVariants() {
            ASTNode categoryNode = RegExpPropertyImpl.this.getCategoryNode();
            if (categoryNode != null && categoryNode.getText().startsWith("In") && !categoryNode.getText().startsWith("Intelli")) {
                Object[] objectArray = UNICODE_BLOCKS;
                if (objectArray == null) {
                    MyPsiReference.$$$reportNull$$$0(6);
                }
                return objectArray;
            }
            boolean startsWithIs = categoryNode != null && categoryNode.getText().startsWith("Is");
            ArrayList<LookupElement> result2 = new ArrayList<LookupElement>();
            for (Object[] objectArray : RegExpLanguageHosts.getInstance().getAllKnownProperties(this.getElement())) {
                String name = (String)ArrayUtil.getFirstElement((Object[])objectArray);
                if (name == null) continue;
                Object typeText = objectArray.length > 1 ? objectArray[1] : "Character.is" + name.substring("java".length()) + "()";
                result2.add(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)name).withPresentableText(startsWithIs ? "Is" + name : name).withIcon(PlatformIcons.PROPERTY_ICON).withTypeText((String)typeText), (double)this.getPriority(name)));
            }
            Object[] objectArray = ArrayUtil.toObjectArray(result2);
            if (objectArray == null) {
                MyPsiReference.$$$reportNull$$$0(7);
            }
            return objectArray;
        }

        private int getPriority(@NotNull String propertyName) {
            if (propertyName == null) {
                MyPsiReference.$$$reportNull$$$0(8);
            }
            if (propertyName.equals("all")) {
                return 3;
            }
            if (propertyName.startsWith("java")) {
                return 1;
            }
            if (propertyName.length() > 2) {
                return 2;
            }
            return 0;
        }

        public boolean isSoft() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/lang/regexp/psi/impl/RegExpPropertyImpl$MyPsiReference";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRangeInElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/lang/regexp/psi/impl/RegExpPropertyImpl$MyPsiReference";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isReferenceTo";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getPriority";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

