/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.packaging;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.ui.JBUI;
import com.intellij.webcore.packaging.PackageManagementService;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ManageRepoDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private final JBList<String> myList;
    private boolean myEnabled;
    private static final Logger LOG = Logger.getInstance(ManageRepoDialog.class);

    public ManageRepoDialog(Project project, PackageManagementService controller) {
        super(project, false);
        this.$$$setupUI$$$();
        this.init();
        this.setTitle("Manage Repositories");
        this.myList = new JBList();
        this.myList.setPaintBusy(true);
        final DefaultListModel repoModel = new DefaultListModel();
        controller.fetchAllRepositories((CatchingConsumer<? super List<String>, ? super Exception>)new CatchingConsumer<List<String>, Exception>(){

            public void consume(List<String> repoUrls) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (ManageRepoDialog.this.isDisposed()) {
                        return;
                    }
                    ManageRepoDialog.this.myList.setPaintBusy(false);
                    for (String repoUrl : repoUrls) {
                        repoModel.addElement(repoUrl);
                    }
                }, ModalityState.any());
            }

            public void consume(Exception e) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (ManageRepoDialog.this.isDisposed()) {
                        return;
                    }
                    ManageRepoDialog.this.myList.setPaintBusy(false);
                    LOG.warn((Throwable)e);
                });
            }
        });
        this.myList.setModel(repoModel);
        this.myList.setSelectionMode(0);
        this.myList.addListSelectionListener(event -> {
            String selected2 = (String)this.myList.getSelectedValue();
            this.myEnabled = controller.canModifyRepository(selected2);
        });
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myList).disableUpDownActions();
        decorator.setAddActionName("Add repository");
        decorator.setRemoveActionName("Remove repository from list");
        decorator.setEditActionName("Edit repository URL");
        decorator.setAddAction(button2 -> {
            String url = Messages.showInputDialog((String)"Please input repository URL", (String)"Repository URL", null);
            if (!StringUtil.isEmptyOrSpaces((String)url) && !repoModel.contains(url)) {
                repoModel.addElement(url);
                controller.addRepository(url);
            }
        });
        decorator.setEditAction(button2 -> {
            String oldValue = (String)this.myList.getSelectedValue();
            String url = Messages.showInputDialog((String)"Please edit repository URL", (String)"Repository URL", null, (String)oldValue, (InputValidator)new InputValidator(){

                public boolean checkInput(String inputString) {
                    return !repoModel.contains(inputString);
                }

                public boolean canClose(String inputString) {
                    return true;
                }
            });
            if (!StringUtil.isEmptyOrSpaces((String)url) && !oldValue.equals(url)) {
                repoModel.addElement(url);
                repoModel.removeElement(oldValue);
                controller.removeRepository(oldValue);
                controller.addRepository(url);
            }
        });
        decorator.setRemoveAction(button2 -> {
            String selected2 = (String)this.myList.getSelectedValue();
            controller.removeRepository(selected2);
            repoModel.removeElement(selected2);
            button2.setEnabled(false);
        });
        decorator.setRemoveActionUpdater(e -> this.myEnabled);
        decorator.setEditActionUpdater(e -> this.myEnabled);
        JPanel panel2 = decorator.createPanel();
        panel2.setPreferredSize((Dimension)JBUI.size((int)800, (int)600));
        this.myMainPanel.add(panel2);
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

