/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.tree;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.LanguagePerFileMappings;
import com.intellij.lang.PerFileMappings;
import com.intellij.lang.PerFileMappingsBase;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyWithDefaultValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Setter;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PerFileConfigurableBase<T>
implements SearchableConfigurable,
Configurable.NoScroll {
    protected static final Key<String> DESCRIPTION = KeyWithDefaultValue.create((String)"DESCRIPTION", (Object)"");
    protected static final Key<String> TARGET_TITLE = KeyWithDefaultValue.create((String)"TARGET_TITLE", (Object)"Path");
    protected static final Key<String> MAPPING_TITLE = KeyWithDefaultValue.create((String)"MAPPING_TITLE", (Object)"Mapping");
    protected static final Key<String> EMPTY_TEXT = KeyWithDefaultValue.create((String)"EMPTY_TEXT", (Object)"New Mapping $addShortcut");
    protected static final Key<String> OVERRIDE_QUESTION = Key.create((String)"OVERRIDE_QUESTION");
    protected static final Key<String> OVERRIDE_TITLE = Key.create((String)"OVERRIDE_TITLE");
    protected static final Key<String> NULL_TEXT = KeyWithDefaultValue.create((String)"NULL_TEXT", (Object)"<None>");
    protected static final Key<Boolean> ADD_PROJECT_MAPPING = KeyWithDefaultValue.create((String)"ADD_PROJECT_MAPPING", (Object)Boolean.TRUE);
    protected static final Key<Boolean> ONLY_DIRECTORIES = KeyWithDefaultValue.create((String)"ONLY_DIRECTORIES", (Object)Boolean.FALSE);
    protected static final Key<Boolean> SORT_VALUES = KeyWithDefaultValue.create((String)"SORT_VALUES", (Object)Boolean.TRUE);
    protected final Project myProject;
    protected final PerFileMappings<T> myMappings;
    private JPanel myPanel;
    private JBTable myTable;
    private MyModel<T> myModel;
    private final List<Runnable> myResetRunnables;
    private final Map<String, T> myDefaultVals;
    private final List<Trinity<String, Supplier<T>, Consumer<T>>> myDefaultProps;
    private VirtualFile myFileToSelect;

    protected PerFileConfigurableBase(@NotNull Project project, @NotNull PerFileMappings<T> mappings) {
        if (project == null) {
            PerFileConfigurableBase.$$$reportNull$$$0(0);
        }
        if (mappings == null) {
            PerFileConfigurableBase.$$$reportNull$$$0(1);
        }
        this.myResetRunnables = new ArrayList<Runnable>();
        this.myDefaultVals = new HashMap<String, T>();
        this.myDefaultProps = new ArrayList<Trinity<String, Supplier<T>, Consumer<T>>>();
        this.myProject = project;
        this.myMappings = mappings;
    }

    @NotNull
    public String getId() {
        String string = this.getDisplayName();
        if (string == null) {
            PerFileConfigurableBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    protected abstract <S> Object getParameter(@NotNull Key<S> var1);

    @NotNull
    protected List<Trinity<String, Supplier<T>, Consumer<T>>> getDefaultMappings() {
        List list2 = ContainerUtil.emptyList();
        if (list2 == null) {
            PerFileConfigurableBase.$$$reportNull$$$0(3);
        }
        return list2;
    }

    protected boolean canRemoveTarget(@Nullable Object target2) {
        return true;
    }

    protected boolean canEditTarget(@Nullable Object target2, T value2) {
        return true;
    }

    protected T adjustChosenValue(@Nullable Object target2, T chosen) {
        return chosen;
    }

    protected abstract void renderValue(@Nullable Object var1, @NotNull T var2, @NotNull ColoredTextContainer var3);

    protected void renderDefaultValue(@Nullable Object target2, @NotNull ColoredTextContainer renderer) {
        if (renderer == null) {
            PerFileConfigurableBase.$$$reportNull$$$0(4);
        }
    }

    private <S> S param(@NotNull Key<S> key) {
        Object o;
        if (key == null) {
            PerFileConfigurableBase.$$$reportNull$$$0(5);
        }
        if ((o = this.getParameter(key)) == null && key instanceof KeyWithDefaultValue) {
            return (S)((KeyWithDefaultValue)key).getDefaultValue();
        }
        return (S)o;
    }

    @NotNull
    public JComponent createComponent() {
        this.myPanel = new JPanel(new BorderLayout());
        this.myModel = new MyModel(this.param(TARGET_TITLE), this.param(MAPPING_TITLE));
        this.myTable = new JBTable(this.myModel){

            public String getToolTipText(@NotNull MouseEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                Point point = event.getPoint();
                int row = this.rowAtPoint(point);
                int col = this.columnAtPoint(point);
                if (row != -1 && col == 1) {
                    return PerFileConfigurableBase.this.getToolTipFor(this.getValueAt(this.convertRowIndexToModel(row), col));
                }
                return super.getToolTipText(event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/ui/tree/PerFileConfigurableBase$1", "getToolTipText"));
            }
        };
        this.setupPerFileTable();
        JPanel tablePanel = ToolbarDecorator.createDecorator((JTable)this.myTable).disableUpAction().disableDownAction().setAddAction(button2 -> this.doAddAction((AnActionButton)button2)).setRemoveAction(button2 -> this.doRemoveAction((AnActionButton)button2)).setEditAction(button2 -> this.doEditAction((AnActionButton)button2)).setEditActionUpdater(e -> this.myTable.getSelectedRows().length > 0).createPanel();
        this.myTable.getEmptyText().setText(this.param(EMPTY_TEXT).replace("$addShortcut", KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.ADD))));
        JBLabel label2 = new JBLabel(this.param(DESCRIPTION));
        label2.setBorder(BorderFactory.createEmptyBorder(7, 20, 10, 0));
        label2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        JComponent north = this.createDefaultMappingComponent();
        if (north != null) {
            this.myPanel.add((Component)north, "North");
        }
        this.myPanel.add((Component)label2, "South");
        this.myPanel.add((Component)tablePanel, "Center");
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            PerFileConfigurableBase.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    @Nullable
    protected String getToolTipFor(@Nullable T value2) {
        return null;
    }

    @Nullable
    protected JComponent createDefaultMappingComponent() {
        this.myDefaultProps.addAll(this.getDefaultMappings());
        if (this.myMappings instanceof LanguagePerFileMappings && this.param(ADD_PROJECT_MAPPING).booleanValue()) {
            this.myDefaultProps.add(Trinity.create((Object)("Project " + StringUtil.capitalize((String)this.param(MAPPING_TITLE))), () -> ((LanguagePerFileMappings)this.myMappings).getConfiguredMapping(null), o -> this.myMappings.setMapping(null, o)));
        }
        if (this.myDefaultProps.size() == 0) {
            return null;
        }
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints cons1 = new GridBagConstraints();
        cons1.fill = 2;
        cons1.weightx = 0.0;
        cons1.gridx = 0;
        cons1.insets = JBUI.insets((int)0, (int)0, (int)5, (int)10);
        GridBagConstraints cons2 = new GridBagConstraints();
        cons2.fill = 0;
        cons2.anchor = 17;
        cons2.weightx = 0.0;
        cons2.gridx = 1;
        cons2.insets = cons1.insets;
        panel2.add(Box.createGlue(), new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        for (final Trinity<String, Supplier<T>, Consumer<T>> prop : this.myDefaultProps) {
            this.myDefaultVals.put((String)prop.first, ((Supplier)prop.second).get());
            JPanel p = this.createActionPanel(null, new Value<T>(){

                @Override
                public void commit() {
                    PerFileConfigurableBase.this.myModel.fireTableDataChanged();
                }

                public T get() {
                    return PerFileConfigurableBase.this.myDefaultVals.get(prop.first);
                }

                public void set(T value2) {
                    PerFileConfigurableBase.this.myDefaultVals.put(prop.first, PerFileConfigurableBase.this.adjustChosenValue(null, value2));
                }
            });
            panel2.add((Component)new JBLabel((String)prop.first + ":"), cons1);
            panel2.add((Component)p, cons2);
        }
        return panel2;
    }

    private void doAddAction(@NotNull AnActionButton button2) {
        int row;
        TableCellEditor editor;
        if (button2 == null) {
            PerFileConfigurableBase.$$$reportNull$$$0(7);
        }
        if ((editor = this.myTable.getCellEditor()) != null) {
            editor.cancelCellEditing();
        }
        Object selectedTarget = (row = this.myTable.getSelectedRow()) >= 0 ? this.myModel.data.get((int)this.myTable.convertRowIndexToModel((int)row)).first : null;
        VirtualFile toSelect2 = this.myFileToSelect != null ? this.myFileToSelect : (VirtualFile)ObjectUtils.tryCast(selectedTarget, VirtualFile.class);
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(this.param(ONLY_DIRECTORIES) == false, true, true, true, true, true);
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)this.myProject, (Component)this.myTable, (VirtualFile)toSelect2, this::doAddFiles);
    }

    /*
     * WARNING - void declaration
     */
    private void doAddFiles(@NotNull List<? extends VirtualFile> files2) {
        void var5_7;
        HashSet<? extends VirtualFile> chosen;
        if (files2 == null) {
            PerFileConfigurableBase.$$$reportNull$$$0(8);
        }
        if ((chosen = new HashSet<VirtualFile>(files2)).isEmpty()) {
            return;
        }
        Set set = this.myModel.data.stream().map(o -> o.first).collect(Collectors.toSet());
        for (VirtualFile virtualFile : chosen) {
            if (!set.add(virtualFile)) continue;
            this.myModel.data.add(Pair.create((Object)virtualFile, this.getNewMapping(virtualFile)));
        }
        this.myModel.fireTableDataChanged();
        TIntArrayList rowList = new TIntArrayList();
        boolean bl = false;
        int size = this.myModel.data.size();
        while (var5_7 < size) {
            if (chosen.contains(this.myModel.data.get((int)var5_7).first)) {
                rowList.add((int)var5_7);
            }
            ++var5_7;
        }
        this.selectRows(rowList.toNativeArray(), true);
    }

    private void doRemoveAction(@NotNull AnActionButton button2) {
        int toSelect2;
        TableCellEditor editor;
        if (button2 == null) {
            PerFileConfigurableBase.$$$reportNull$$$0(9);
        }
        if ((editor = this.myTable.getCellEditor()) != null) {
            editor.cancelCellEditing();
        }
        int[] rows = this.myTable.getSelectedRows();
        int firstRow = rows[0];
        Object[] keys2 = new Object[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            keys2[i] = this.myModel.data.get((int)this.myTable.convertRowIndexToModel((int)rows[i])).first;
        }
        if (this.clearSubdirectoriesOnDemandOrCancel(true, keys2) == 0 && (toSelect2 = Math.min(this.myModel.data.size() - 1, firstRow)) >= 0) {
            this.selectRows(new int[]{toSelect2}, false);
        }
    }

    private void doEditAction(@NotNull AnActionButton button2) {
        if (button2 == null) {
            PerFileConfigurableBase.$$$reportNull$$$0(10);
        }
        TableUtil.editCellAt((JTable)this.myTable, (int)this.myTable.getSelectedRow(), (int)0);
        TextFieldWithBrowseButton panel2 = (TextFieldWithBrowseButton)ObjectUtils.tryCast((Object)this.myTable.getEditorComponent(), TextFieldWithBrowseButton.class);
        if (panel2 != null) {
            SwingUtilities.invokeLater(() -> {
                if (this.myTable.getEditorComponent() == panel2) {
                    panel2.getButton().doClick();
                }
            });
        }
    }

    @Nullable
    public T getNewMapping(@Nullable VirtualFile file2) {
        for (Pair p : ContainerUtil.reverse(this.myModel.data)) {
            if (!this.keyMatches(p.first, file2, false) || p.second == null) continue;
            return (T)p.second;
        }
        ProjectFileIndex index = ProjectFileIndex.getInstance((Project)this.myProject);
        for (Trinity prop : ContainerUtil.reverse(this.myDefaultProps)) {
            T t;
            if ((!((String)prop.first).startsWith("Project ") || file2 == null || !index.isInContent(file2)) && !((String)prop.first).startsWith("Global ") || (t = this.myDefaultVals.get(prop.first)) == null) continue;
            return t;
        }
        return (T)this.myMappings.getDefaultMapping(file2);
    }

    private boolean keyMatches(@Nullable Object key, @Nullable VirtualFile file2, boolean strict) {
        if (file2 == null) {
            return key == null;
        }
        if (key instanceof VirtualFile) {
            return VfsUtilCore.isAncestor((VirtualFile)((VirtualFile)key), (VirtualFile)file2, (boolean)strict);
        }
        return key == null;
    }

    public boolean isModified() {
        for (Trinity<String, Supplier<T>, Consumer<T>> prop : this.myDefaultProps) {
            if (Comparing.equal(((Supplier)prop.second).get(), this.myDefaultVals.get(prop.first))) continue;
            return true;
        }
        Map oldMapping = this.myMappings.getMappings();
        Map<VirtualFile, T> newMapping = this.getNewMappings();
        return !newMapping.equals(oldMapping);
    }

    public void apply() throws ConfigurationException {
        this.myMappings.setMappings(this.getNewMappings());
        for (Trinity<String, Supplier<T>, Consumer<T>> prop : this.myDefaultProps) {
            ((Consumer)prop.third).consume(this.myDefaultVals.get(prop.first));
        }
    }

    public void reset() {
        this.myModel.data.clear();
        for (Map.Entry entry : this.myMappings.getMappings().entrySet()) {
            if (this.myMappings instanceof LanguagePerFileMappings && entry.getKey() == null) continue;
            this.myModel.data.add(Pair.create(entry.getKey(), entry.getValue()));
        }
        for (Trinity trinity : this.myDefaultProps) {
            this.myDefaultVals.put((String)trinity.first, ((Supplier)trinity.second).get());
        }
        for (Runnable runnable2 : this.myResetRunnables) {
            runnable2.run();
        }
        int[] rows = this.myTable.getSelectedRows();
        this.myModel.fireTableDataChanged();
        this.selectRows(rows, false);
    }

    protected void selectRows(int[] rows, boolean convertModelRowsToView) {
        int[] viewRows;
        int[] nArray = viewRows = convertModelRowsToView ? new int[rows.length] : rows;
        if (convertModelRowsToView) {
            for (int i = 0; i < rows.length; ++i) {
                viewRows[i] = this.myTable.convertRowIndexToView(rows[i]);
            }
        }
        TableUtil.selectRows((JTable)this.myTable, (int[])viewRows);
        TableUtil.scrollSelectionToVisible((JTable)this.myTable);
    }

    protected Map<VirtualFile, T> getNewMappings() {
        HashMap<VirtualFile, Object> map2 = new HashMap<VirtualFile, Object>();
        for (Pair p : this.myModel.data) {
            if (p.second == null) continue;
            map2.put((VirtualFile)p.first, p.second);
        }
        if (this.myMappings instanceof LanguagePerFileMappings) {
            for (Trinity prop : ContainerUtil.reverse(this.myDefaultProps)) {
                if (!((String)prop.first).startsWith("Project ")) continue;
                T t = this.myDefaultVals.get(prop.first);
                if (t == null) break;
                map2.put(null, t);
                break;
            }
        }
        return map2;
    }

    public void selectFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            PerFileConfigurableBase.$$$reportNull$$$0(11);
        }
        this.selectFile(virtualFile, true);
    }

    public void selectFile(@NotNull VirtualFile virtualFile, boolean addIfMissing) {
        VirtualFile file2;
        int[] rows;
        if (virtualFile == null) {
            PerFileConfigurableBase.$$$reportNull$$$0(12);
        }
        if ((rows = this.findRow(file2 = virtualFile instanceof VirtualFileWindow ? ((VirtualFileWindow)virtualFile).getDelegate() : virtualFile, addIfMissing, false)).length == 0 && addIfMissing) {
            this.doAddFiles(Collections.singletonList(virtualFile));
        } else {
            this.selectRows(rows, true);
        }
        this.myFileToSelect = file2;
    }

    protected int[] findRow(VirtualFile file2, boolean strict, boolean all) {
        TIntArrayList rows = new TIntArrayList();
        List reversed = ContainerUtil.reverse(this.myModel.data);
        int size = reversed.size();
        for (int i = 0; i < size; ++i) {
            Pair p = (Pair)reversed.get(i);
            if (!this.keyMatches(p.first, file2, strict)) continue;
            rows.add(size - i - 1);
            if (!all) break;
        }
        return rows.toNativeArray();
    }

    private static String keyToString(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof VirtualFile) {
            return FileUtil.toSystemDependentName((String)((VirtualFile)o).getPath());
        }
        return String.valueOf(o);
    }

    private void setupPerFileTable() {
        this.myTable.setEnableAntialiasing(true);
        this.myTable.getSelectionModel().setSelectionMode(2);
        this.myTable.setRowSelectionAllowed(true);
        this.myTable.setShowGrid(false);
        this.myTable.getColumnModel().setColumnMargin(0);
        this.myTable.getTableHeader().setReorderingAllowed(false);
        TableRowSorter<MyModel<T>> sorter = new TableRowSorter<MyModel<T>>(this.myModel);
        sorter.setStringConverter(new TableStringConverter(){
            final SimpleColoredText text = new SimpleColoredText();

            @Override
            public String toString(TableModel model, int row, int column) {
                this.text.clear();
                Pair pair = ((PerFileConfigurableBase)PerFileConfigurableBase.this).myModel.data.get(row);
                if (column == 0) {
                    PerFileConfigurableBase.this.renderTarget(pair.first, (ColoredTextContainer)this.text);
                } else if (pair.second != null) {
                    PerFileConfigurableBase.this.renderValue(pair.first, pair.second, (ColoredTextContainer)this.text);
                } else {
                    PerFileConfigurableBase.this.renderDefaultValue(pair.first, (ColoredTextContainer)this.text);
                }
                return StringUtil.toLowerCase((String)this.text.toString());
            }
        });
        sorter.setSortable(0, true);
        sorter.setSortable(1, true);
        sorter.setSortsOnUpdates(true);
        this.myTable.setRowSorter(sorter);
        this.myTable.getRowSorter().setSortKeys(Collections.singletonList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        new TableSpeedSearch((JTable)this.myTable, (Convertor<Object, String>)((Convertor)o -> PerFileConfigurableBase.keyToString(o)));
        FontMetrics metrics = this.myTable.getFontMetrics(this.myTable.getFont());
        int maxValueWidth = 2 * metrics.stringWidth(this.myTable.getModel().getColumnName(1));
        SimpleColoredText text2 = new SimpleColoredText();
        for (T t : this.getValueVariants(null)) {
            text2.clear();
            this.renderValue(null, t, (ColoredTextContainer)text2);
            maxValueWidth = Math.max(metrics.stringWidth(text2.toString()), maxValueWidth);
        }
        if (maxValueWidth < 300) {
            this.myTable.getColumnModel().getColumn(1).setMinWidth(maxValueWidth);
        }
        this.myTable.getColumnModel().getColumn(0).setMinWidth(metrics.stringWidth(this.myTable.getModel().getColumnName(0)) * 2);
        this.myTable.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)new ColoredTableCellRenderer(){

            public void acquireState(JTable table, boolean isSelected, boolean hasFocus, int row, int column) {
                super.acquireState(table, isSelected, false, row, column);
            }

            protected void customizeCellRenderer(JTable table, @Nullable Object value2, boolean selected2, boolean hasFocus, int row, int column) {
                PerFileConfigurableBase.this.renderTarget(value2, (ColoredTextContainer)this);
                SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table, (SimpleColoredComponent)this, (boolean)false, (boolean)selected2);
            }
        });
        this.myTable.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)new ColoredTableCellRenderer(){

            public void acquireState(JTable table, boolean isSelected, boolean hasFocus, int row, int column) {
                super.acquireState(table, isSelected, false, row, column);
            }

            protected void customizeCellRenderer(JTable table, @Nullable Object value2, boolean selected2, boolean hasFocus, int row, int column) {
                Pair p = ((PerFileConfigurableBase)PerFileConfigurableBase.this).myModel.data.get(PerFileConfigurableBase.this.myTable.convertRowIndexToModel(row));
                if (p.second != null) {
                    this.setTransparentIconBackground(true);
                    PerFileConfigurableBase.this.renderValue(p.first, p.second, (ColoredTextContainer)this);
                } else {
                    PerFileConfigurableBase.this.renderDefaultValue(p.first, (ColoredTextContainer)this);
                }
            }
        });
        this.myTable.getColumnModel().getColumn(0).setCellEditor((TableCellEditor)new AbstractTableCellEditor(){
            VirtualFile startValue;
            String newPath;

            public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row, int column) {
                int modelRow = PerFileConfigurableBase.this.myTable.convertRowIndexToModel(row);
                Pair pair = ((PerFileConfigurableBase)PerFileConfigurableBase.this).myModel.data.get(modelRow);
                Object target2 = pair.first;
                if (!(target2 instanceof VirtualFile)) {
                    return null;
                }
                this.startValue = (VirtualFile)target2;
                this.newPath = null;
                final TextFieldWithBrowseButton panel2 = new TextFieldWithBrowseButton();
                panel2.setText(this.startValue.getPath());
                panel2.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                    protected void textChanged(@NotNull DocumentEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        newPath = panel2.getTextField().getText();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/tree/PerFileConfigurableBase$6$1", "textChanged"));
                    }
                });
                panel2.addBrowseFolderListener(new TextBrowseFolderListener(FileChooserDescriptorFactory.createSingleLocalFileDescriptor()));
                return panel2;
            }

            public Object getCellEditorValue() {
                if (this.newPath == null || this.newPath.equals(this.startValue.getPath())) {
                    return this.startValue;
                }
                VirtualFile newFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.newPath);
                return ObjectUtils.notNull((Object)newFile, (Object)this.startValue);
            }
        });
        this.myTable.getColumnModel().getColumn(1).setCellEditor((TableCellEditor)new AbstractTableCellEditor(){
            T editorValue;

            public Component getTableCellEditorComponent(JTable table, final Object value2, boolean isSelected, int row, final int column) {
                final int modelRow = PerFileConfigurableBase.this.myTable.convertRowIndexToModel(row);
                final Pair pair = ((PerFileConfigurableBase)PerFileConfigurableBase.this).myModel.data.get(modelRow);
                final Object target2 = pair.first;
                this.editorValue = pair.second;
                if (!PerFileConfigurableBase.this.canEditTarget(target2, this.editorValue)) {
                    return null;
                }
                JPanel panel2 = PerFileConfigurableBase.this.createActionPanel(target2, new Value<T>(){

                    public T get() {
                        return editorValue;
                    }

                    public void set(T value22) {
                        editorValue = PerFileConfigurableBase.this.adjustChosenValue(target2, value22);
                    }

                    @Override
                    public void commit() {
                        TableUtil.stopEditing((JTable)PerFileConfigurableBase.this.myTable);
                        PerFileConfigurableBase.this.selectRows(new int[]{modelRow}, true);
                        if (!Comparing.equal(editorValue, (Object)pair.second)) {
                            int ret = PerFileConfigurableBase.this.clearSubdirectoriesOnDemandOrCancel(false, new Object[]{target2});
                            if (ret == 2) {
                                PerFileConfigurableBase.this.myModel.setValueAt(value2, modelRow, column);
                            }
                            PerFileConfigurableBase.this.selectRows(new int[]{modelRow}, true);
                        }
                    }
                }, true);
                AbstractButton button2 = (AbstractButton)UIUtil.uiTraverser((Component)panel2).filter(JButton.class).first();
                if (button2 != null) {
                    AtomicInteger clickCount = new AtomicInteger();
                    button2.addActionListener(e -> clickCount.incrementAndGet());
                    SwingUtilities.invokeLater(() -> {
                        if (clickCount.get() == 0 && PerFileConfigurableBase.this.myTable.getEditorComponent() == panel2) {
                            button2.doClick();
                        }
                    });
                }
                return panel2;
            }

            public Object getCellEditorValue() {
                return this.editorValue;
            }
        });
    }

    @NotNull
    protected JPanel createActionPanel(@Nullable Object target2, @NotNull Value<T> value2) {
        if (value2 == null) {
            PerFileConfigurableBase.$$$reportNull$$$0(13);
        }
        return this.createActionPanel(target2, value2, false);
    }

    @NotNull
    private JPanel createActionPanel(@Nullable Object target2, @NotNull Value<T> value2, boolean editor) {
        if (value2 == null) {
            PerFileConfigurableBase.$$$reportNull$$$0(14);
        }
        AnAction changeAction = this.createValueAction(target2, value2);
        JComponent comboComponent = ((CustomComponentAction)changeAction).createCustomComponent(changeAction.getTemplatePresentation(), "unknown");
        JPanel panel2 = new JPanel(new BorderLayout()){

            @Override
            public Color getBackground() {
                Container parent = this.getParent();
                return parent instanceof JTable ? ((JTable)parent).getSelectionBackground() : super.getBackground();
            }
        };
        panel2.add((Component)comboComponent, "Center");
        comboComponent.setOpaque(false);
        DataContext dataContext = SimpleDataContext.getProjectContext(this.myProject);
        AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)changeAction, null, (String)"unknown", (DataContext)dataContext);
        changeAction.update(event);
        panel2.revalidate();
        if (!editor) {
            this.myResetRunnables.add(() -> changeAction.update(event));
        }
        JPanel jPanel = panel2;
        if (jPanel == null) {
            PerFileConfigurableBase.$$$reportNull$$$0(15);
        }
        return jPanel;
    }

    private int clearSubdirectoriesOnDemandOrCancel(boolean keysToo, Object ... keys2) {
        int ret;
        TIntArrayList rows = new TIntArrayList();
        boolean toOverride = false;
        int size = this.myModel.data.size();
        block0: for (int i = 0; i < size; ++i) {
            Pair p = this.myModel.data.get(i);
            if (!(p.first instanceof VirtualFile)) continue;
            Object[] objectArray = keys2;
            int n = objectArray.length;
            for (int j = 0; j < n; ++j) {
                Object key = objectArray[j];
                if (key == p.first) {
                    if (!keysToo) continue block0;
                    rows.add(-i - 1);
                    continue block0;
                }
                if (!this.keyMatches(key, (VirtualFile)p.first, true)) continue;
                toOverride = true;
                rows.add(i);
                continue block0;
            }
        }
        int n = ret = !toOverride ? 1 : this.askUserToOverrideSubdirectories();
        if (ret == 2) {
            return ret;
        }
        int count = 0;
        for (int i : rows.toNativeArray()) {
            if (i >= 0 && ret == 1) continue;
            int index = (i >= 0 ? i : -i - 1) - count;
            if (this.canRemoveTarget(this.myModel.data.get((int)index).first)) {
                this.myModel.data.remove(index);
                ++count;
                continue;
            }
            this.myModel.data.set(index, Pair.create((Object)this.myModel.data.get((int)0).first, null));
        }
        if (!rows.isEmpty()) {
            this.myModel.fireTableDataChanged();
        }
        return ret;
    }

    private int askUserToOverrideSubdirectories() {
        String question = this.param(OVERRIDE_QUESTION);
        String title = this.param(OVERRIDE_TITLE);
        if (question == null || title == null) {
            return 1;
        }
        return Messages.showYesNoCancelDialog((Project)this.myProject, (String)question, (String)title, (String)"Override", (String)"Do Not Override", (String)"Cancel", (Icon)Messages.getWarningIcon());
    }

    private String renderValue(@Nullable Object value2, @NotNull String nullValue) {
        if (nullValue == null) {
            PerFileConfigurableBase.$$$reportNull$$$0(16);
        }
        if (value2 == null) {
            return nullValue;
        }
        SimpleColoredText text2 = new SimpleColoredText();
        this.renderValue(null, value2, (ColoredTextContainer)text2);
        return text2.toString();
    }

    protected void renderTarget(@Nullable Object target2, @NotNull ColoredTextContainer renderer) {
        VirtualFile file2;
        if (renderer == null) {
            PerFileConfigurableBase.$$$reportNull$$$0(17);
        }
        VirtualFile virtualFile = file2 = target2 instanceof VirtualFile ? (VirtualFile)target2 : null;
        if (file2 != null) {
            renderer.setIcon(IconUtil.getIcon((VirtualFile)file2, (int)2, (Project)this.myProject));
            VirtualFile parent = file2.getParent();
            if (parent != null) {
                VirtualFile dir = this.myProject.getBaseDir();
                String projectPath = dir == null ? null : dir.getPath();
                String parentPath = parent.getPath();
                String relativePath = projectPath != null && parentPath.startsWith(projectPath) ? "..." + parentPath.substring(projectPath.length()) : parentPath;
                String presentablePath = FileUtil.toSystemDependentName((String)(relativePath + "/"));
                renderer.append(presentablePath, SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            renderer.append(file2.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        } else if (target2 == null) {
            renderer.append("Project", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @NotNull
    protected final AnAction createValueAction(final @Nullable Object target2, final @NotNull Value<T> value2) {
        if (value2 == null) {
            PerFileConfigurableBase.$$$reportNull$$$0(18);
        }
        return new ComboBoxAction(){

            void updateText(Presentation p) {
                String text2 = PerFileConfigurableBase.this.renderValue(value2.get(), StringUtil.notNullize((String)PerFileConfigurableBase.this.getNullValueText(target2)));
                p.setText(StringUtil.shortenTextWithEllipsis((String)text2, (int)40, (int)0));
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                this.updateText(this.getTemplatePresentation());
            }

            @NotNull
            protected DefaultActionGroup createPopupActionGroup(JComponent button2) {
                throw new UnsupportedOperationException();
            }

            protected ComboBoxAction.ComboBoxButton createComboBoxButton(final Presentation presentation) {
                return new ComboBoxAction.ComboBoxButton(presentation){

                    protected JBPopup createPopup(Runnable onDispose) {
                        JBPopup popup2 = PerFileConfigurableBase.this.createValueEditorPopup(target2, value2.get(), onDispose, this.getDataContext(), o -> {
                            value2.set(o);
                            this.updateText(presentation);
                        }, value2::commit);
                        popup2.setMinimumSize(new Dimension(this.getMinWidth(), this.getMinHeight()));
                        return popup2;
                    }

                    @Nullable
                    public String getToolTipText() {
                        boolean cellEditor = UIUtil.uiParents((Component)((Object)this), (boolean)true).take(4).filter(JBTable.class).first() != null;
                        return cellEditor ? null : PerFileConfigurableBase.this.getToolTipFor(value2.get());
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/tree/PerFileConfigurableBase$9", "update"));
            }
        };
    }

    @NotNull
    protected JBPopup createValueEditorPopup(@Nullable Object target2, @Nullable T value2, @Nullable Runnable onDispose, @NotNull DataContext dataContext, @NotNull Consumer<? super T> onChosen, @NotNull Runnable onCommit) {
        if (dataContext == null) {
            PerFileConfigurableBase.$$$reportNull$$$0(19);
        }
        if (onChosen == null) {
            PerFileConfigurableBase.$$$reportNull$$$0(20);
        }
        if (onCommit == null) {
            PerFileConfigurableBase.$$$reportNull$$$0(21);
        }
        return this.createValueEditorActionListPopup(target2, onDispose, dataContext, chosen -> {
            onChosen.consume(chosen);
            onCommit.run();
        });
    }

    @NotNull
    protected final JBPopup createValueEditorActionListPopup(@Nullable Object target2, @Nullable Runnable onDispose, @NotNull DataContext dataContext, @NotNull Consumer<? super T> onChosen) {
        if (dataContext == null) {
            PerFileConfigurableBase.$$$reportNull$$$0(22);
        }
        if (onChosen == null) {
            PerFileConfigurableBase.$$$reportNull$$$0(23);
        }
        ActionGroup group = this.createActionListGroup(target2, onChosen);
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, group, dataContext, false, false, false, onDispose, 30, null);
        if (listPopup == null) {
            PerFileConfigurableBase.$$$reportNull$$$0(24);
        }
        return listPopup;
    }

    @Nullable
    protected Icon getActionListIcon(@Nullable Object target2, T t) {
        return null;
    }

    @Nullable
    protected String getClearValueText(@Nullable Object target2) {
        return target2 == null ? this.getNullValueText(null) : null;
    }

    @Nullable
    protected String getNullValueText(@Nullable Object target2) {
        return this.param(NULL_TEXT);
    }

    @NotNull
    protected Collection<T> getValueVariants(@Nullable Object target2) {
        if (this.myMappings instanceof PerFileMappingsBase) {
            List list2 = ((PerFileMappingsBase)this.myMappings).getAvailableValues();
            if (list2 == null) {
                PerFileConfigurableBase.$$$reportNull$$$0(25);
            }
            return list2;
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected ActionGroup createActionListGroup(@Nullable Object target2, final @NotNull Consumer<? super T> onChosen) {
        if (onChosen == null) {
            PerFileConfigurableBase.$$$reportNull$$$0(26);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        String clearText = this.getClearValueText(target2);
        Function choseAction = t -> {
            String nullValue = StringUtil.notNullize((String)clearText);
            DumbAwareAction a = new DumbAwareAction(this.renderValue(t, nullValue), "", this.getActionListIcon(target2, t)){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        10.$$$reportNull$$$0(0);
                    }
                    onChosen.consume(t);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/tree/PerFileConfigurableBase$10", "actionPerformed"));
                }
            };
            a.getTemplatePresentation().setText(this.renderValue(t, nullValue));
            return a;
        };
        if (clearText != null) {
            group.add((AnAction)choseAction.fun(null));
        }
        SimpleColoredText text2 = new SimpleColoredText();
        ArrayList<T> values2 = new ArrayList<T>(this.getValueVariants(target2));
        if (this.param(SORT_VALUES).booleanValue()) {
            Function toString2 = o -> {
                text2.clear();
                this.renderValue(target2, o, (ColoredTextContainer)text2);
                return text2.toString();
            };
            Collections.sort(values2, (o1, o2) -> StringUtil.naturalCompare((String)((String)toString2.fun(o1)), (String)((String)toString2.fun(o2))));
        }
        for (Object t2 : values2) {
            group.add((AnAction)choseAction.fun(t2));
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            PerFileConfigurableBase.$$$reportNull$$$0(27);
        }
        return defaultActionGroup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 15: 
            case 24: 
            case 25: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 15: 
            case 24: 
            case 25: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 15: 
            case 24: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/tree/PerFileConfigurableBase";
                break;
            }
            case 4: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 13: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullValue";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 20: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChosen";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onCommit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/tree/PerFileConfigurableBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultMappings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionPanel";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createValueEditorActionListPopup";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueVariants";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionListGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 15: 
            case 24: 
            case 25: 
            case 27: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "renderDefaultValue";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "param";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doAddAction";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doAddFiles";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doRemoveAction";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doEditAction";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "selectFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createActionPanel";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "renderValue";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "renderTarget";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createValueAction";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createValueEditorPopup";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createValueEditorActionListPopup";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createActionListGroup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 15: 
            case 24: 
            case 25: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyModel<T>
    extends AbstractTableModel {
        final String[] columnNames;
        final List<Pair<Object, T>> data = new ArrayList<Pair<Object, T>>();

        MyModel(String ... names2) {
            this.columnNames = names2;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return columnIndex == 0 ? this.data.get((int)rowIndex).first : this.data.get((int)rowIndex).second;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Pair<Object, T> pair = this.data.get(rowIndex);
            if (columnIndex == 1) {
                if (Comparing.equal((Object)aValue, (Object)pair.second)) {
                    return;
                }
                this.data.set(rowIndex, Pair.create((Object)pair.first, (Object)aValue));
            } else {
                if (Comparing.equal((Object)aValue, (Object)pair.first)) {
                    return;
                }
                this.data.set(rowIndex, Pair.create((Object)aValue, (Object)pair.second));
            }
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }

        @Override
        public void fireTableDataChanged() {
            Collections.sort(this.data, (o1, o2) -> StringUtil.naturalCompare((String)PerFileConfigurableBase.keyToString(o1.first), (String)PerFileConfigurableBase.keyToString(o2.first)));
            super.fireTableDataChanged();
        }
    }

    protected static interface Value<T>
    extends Setter<T>,
    Getter<T> {
        public void commit();
    }
}

