/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.laf.PluggableLafInfo;
import com.intellij.ide.ui.laf.darcula.ui.DarculaEditorTextFieldBorder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.AbstractDelegatingToRootTraversalPolicy;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.EditorTextComponent;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.LineSeparator;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorTextField
extends NonOpaquePanel
implements EditorTextComponent,
DocumentListener,
DataProvider,
TextAccessor,
FocusListener,
MouseListener {
    public static final Key<Boolean> SUPPLEMENTARY_KEY = Key.create((String)"Supplementary");
    private static final Key<LineSeparator> LINE_SEPARATOR_KEY = Key.create((String)"ETF_LINE_SEPARATOR");
    private Document myDocument;
    private final Project myProject;
    private FileType myFileType;
    private EditorEx myEditor;
    private Component myNextFocusable;
    private boolean myWholeTextSelected;
    private final List<DocumentListener> myDocumentListeners;
    private final List<FocusListener> myFocusListeners;
    private final List<MouseListener> myMouseListeners;
    private boolean myIsListenerInstalled;
    private boolean myIsViewer;
    private boolean myIsSupplementary;
    private boolean myInheritSwingFont;
    private Color myEnforcedBgColor;
    private boolean myOneLineMode;
    private boolean myEnsureWillComputePreferredSize;
    private Dimension myPassivePreferredSize;
    private CharSequence myHintText;
    private boolean myIsRendererWithSelection;
    private Color myRendererBg;
    private Color myRendererFg;
    private int myPreferredWidth;
    private int myCaretPosition;
    private final List<EditorSettingsProvider> mySettingsProviders;
    private Disposable myDisposable;

    public EditorTextField() {
        this("");
    }

    public EditorTextField(@NotNull String text2) {
        if (text2 == null) {
            EditorTextField.$$$reportNull$$$0(0);
        }
        this(text2, null, (FileType)FileTypes.PLAIN_TEXT);
    }

    public EditorTextField(@NotNull String text2, Project project, FileType fileType) {
        if (text2 == null) {
            EditorTextField.$$$reportNull$$$0(1);
        }
        this(EditorFactory.getInstance().createDocument((CharSequence)StringUtil.convertLineSeparators((String)text2)), project, fileType);
        LINE_SEPARATOR_KEY.set((UserDataHolder)this.myDocument, (Object)EditorTextField.detectLineSeparators(this.myDocument, text2));
    }

    public EditorTextField(Document document, Project project, FileType fileType) {
        this(document, project, fileType, false);
    }

    public EditorTextField(Project project, FileType fileType) {
        this((Document)null, project, fileType);
    }

    public EditorTextField(Document document, Project project, FileType fileType, boolean isViewer) {
        this(document, project, fileType, isViewer, true);
    }

    public EditorTextField(Document document, Project project, FileType fileType, boolean isViewer, boolean oneLineMode) {
        this.myDocumentListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myFocusListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myMouseListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myInheritSwingFont = true;
        this.myPreferredWidth = -1;
        this.myCaretPosition = -1;
        this.mySettingsProviders = new ArrayList<EditorSettingsProvider>();
        this.myOneLineMode = oneLineMode;
        this.myIsViewer = isViewer;
        this.setDocument(document);
        this.myProject = project;
        this.myFileType = fileType;
        this.setLayout(new BorderLayout());
        this.enableEvents(8L);
        this.setFocusable(true);
        super.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                EditorTextField.this.requestFocus();
            }
        });
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new Jdk7DelegatingToRootTraversalPolicy());
        this.setFont(UIManager.getFont("TextField.font"));
    }

    public void setSupplementary(boolean supplementary) {
        this.myIsSupplementary = supplementary;
        if (this.myEditor != null) {
            this.myEditor.putUserData(SUPPLEMENTARY_KEY, supplementary);
        }
    }

    public void setFontInheritedFromLAF(boolean b) {
        this.myInheritSwingFont = b;
        this.setDocument(this.myDocument);
    }

    @NotNull
    public String getText() {
        String text2 = this.myDocument.getText();
        LineSeparator separator = (LineSeparator)LINE_SEPARATOR_KEY.get((UserDataHolder)this.myDocument);
        if (separator != null) {
            String string = StringUtil.convertLineSeparators((String)text2, (String)separator.getSeparatorString());
            if (string == null) {
                EditorTextField.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = text2;
        if (string == null) {
            EditorTextField.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.myEnforcedBgColor = bg;
        if (this.myEditor != null) {
            this.myEditor.setBackgroundColor(bg);
        }
    }

    public JComponent getComponent() {
        return this;
    }

    public void addDocumentListener(@NotNull DocumentListener listener2) {
        if (listener2 == null) {
            EditorTextField.$$$reportNull$$$0(4);
        }
        this.myDocumentListeners.add(listener2);
        this.installDocumentListener();
    }

    public void removeDocumentListener(@NotNull DocumentListener listener2) {
        if (listener2 == null) {
            EditorTextField.$$$reportNull$$$0(5);
        }
        this.myDocumentListeners.remove(listener2);
        this.uninstallDocumentListener(false);
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        if (event == null) {
            EditorTextField.$$$reportNull$$$0(6);
        }
        for (DocumentListener documentListener : this.myDocumentListeners) {
            documentListener.beforeDocumentChange(event);
        }
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        if (event == null) {
            EditorTextField.$$$reportNull$$$0(7);
        }
        for (DocumentListener documentListener : this.myDocumentListeners) {
            documentListener.documentChanged(event);
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public Document getDocument() {
        if (this.myDocument == null) {
            this.myDocument = this.createDocument();
        }
        Document document = this.myDocument;
        if (document == null) {
            EditorTextField.$$$reportNull$$$0(8);
        }
        return document;
    }

    public void setDocument(Document document) {
        if (this.myDocument != null) {
            this.uninstallDocumentListener(true);
        }
        this.myDocument = document;
        this.installDocumentListener();
        if (this.myEditor != null) {
            boolean isFocused = this.isFocusOwner();
            EditorEx newEditor = this.createEditor();
            this.releaseEditor(this.myEditor);
            this.myEditor = newEditor;
            this.add(this.myEditor.getComponent(), "Center");
            this.validate();
            if (isFocused) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)newEditor.getContentComponent(), true));
            }
        }
    }

    private void installDocumentListener() {
        if (this.myDocument != null && !this.myDocumentListeners.isEmpty() && !this.myIsListenerInstalled) {
            this.myIsListenerInstalled = true;
            this.myDocument.addDocumentListener((DocumentListener)this);
        }
    }

    private void uninstallDocumentListener(boolean force) {
        if (this.myDocument != null && this.myIsListenerInstalled && (force || this.myDocumentListeners.isEmpty())) {
            this.myIsListenerInstalled = false;
            this.myDocument.removeDocumentListener((DocumentListener)this);
        }
    }

    public void setText(@Nullable String text2) {
        CommandProcessor.getInstance().executeCommand(this.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> {
            CaretModel caretModel;
            LineSeparator separator = (LineSeparator)LINE_SEPARATOR_KEY.get((UserDataHolder)this.myDocument);
            if (separator == null) {
                separator = EditorTextField.detectLineSeparators(this.myDocument, text2);
            }
            LINE_SEPARATOR_KEY.set((UserDataHolder)this.myDocument, (Object)separator);
            this.myDocument.replaceString(0, this.myDocument.getTextLength(), (CharSequence)EditorTextField.normalize(text2, separator));
            if (this.myEditor != null && (caretModel = this.myEditor.getCaretModel()).getOffset() >= this.myDocument.getTextLength()) {
                caretModel.moveToOffset(this.myDocument.getTextLength());
            }
        }), null, null, UndoConfirmationPolicy.DEFAULT, this.getDocument());
    }

    @NotNull
    private static String normalize(@Nullable String text2, @Nullable LineSeparator separator) {
        if (text2 == null || separator == null) {
            String string = StringUtil.notNullize((String)text2);
            if (string == null) {
                EditorTextField.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = StringUtil.convertLineSeparators((String)text2);
        if (string == null) {
            EditorTextField.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    private static LineSeparator detectLineSeparators(@Nullable Document document, @Nullable String text2) {
        boolean doNotNormalizeDetect;
        if (text2 == null) {
            return null;
        }
        boolean bl = doNotNormalizeDetect = document instanceof DocumentImpl && ((DocumentImpl)document).acceptsSlashR();
        if (doNotNormalizeDetect) {
            return null;
        }
        return StringUtil.detectSeparators((CharSequence)text2);
    }

    public void setPlaceholder(@Nullable CharSequence text2) {
        this.myHintText = text2;
        if (this.myEditor != null) {
            this.myEditor.setPlaceholder(text2);
        }
    }

    public void selectAll() {
        if (this.myEditor != null) {
            EditorTextField.doSelectAll(this.myEditor);
        } else {
            this.myWholeTextSelected = true;
        }
    }

    private static void doSelectAll(@NotNull Editor editor) {
        if (editor == null) {
            EditorTextField.$$$reportNull$$$0(11);
        }
        editor.getCaretModel().removeSecondaryCarets();
        editor.getCaretModel().getPrimaryCaret().setSelection(0, editor.getDocument().getTextLength(), false);
    }

    public void removeSelection() {
        if (this.myEditor != null) {
            this.myEditor.getSelectionModel().removeSelection();
        } else {
            this.myWholeTextSelected = false;
        }
    }

    public void setCaretPosition(int position) {
        Document document = this.getDocument();
        if (position > document.getTextLength() || position < 0) {
            throw new IllegalArgumentException("bad position: " + position);
        }
        if (this.myEditor != null) {
            this.myEditor.getCaretModel().moveToOffset(position);
        } else {
            this.myCaretPosition = position;
        }
    }

    public CaretModel getCaretModel() {
        return this.myEditor.getCaretModel();
    }

    public boolean isFocusOwner() {
        if (this.myEditor != null) {
            return IJSwingUtilities.hasFocus(this.myEditor.getContentComponent());
        }
        return super.isFocusOwner();
    }

    public void addNotify() {
        this.myDisposable = Disposer.newDisposable((String)"ETF dispose");
        Disposer.register((Disposable)this.myDisposable, this::releaseEditorLater);
        if (this.myProject != null) {
            ProjectManagerListener listener2 = new ProjectManagerListener(){

                public void projectClosing(@NotNull Project project) {
                    if (project == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    EditorTextField.this.releaseEditor(EditorTextField.this.myEditor);
                    EditorTextField.this.myEditor = null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/EditorTextField$2", "projectClosing"));
                }
            };
            ProjectManager.getInstance().addProjectManagerListener(this.myProject, listener2);
            Disposer.register((Disposable)this.myDisposable, () -> ProjectManager.getInstance().removeProjectManagerListener(this.myProject, listener2));
        }
        if (this.myEditor != null) {
            this.releaseEditorLater();
        }
        boolean isFocused = this.isFocusOwner();
        this.initEditor();
        super.addNotify();
        if (this.myNextFocusable != null) {
            this.myEditor.getContentComponent().setNextFocusableComponent(this.myNextFocusable);
            this.myNextFocusable = null;
        }
        this.revalidate();
        if (isFocused) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> this.requestFocus());
        }
    }

    private void initEditor() {
        String tooltip;
        this.myEditor = this.createEditor();
        this.myEditor.getContentComponent().setEnabled(this.isEnabled());
        if (this.myCaretPosition >= 0) {
            this.myEditor.getCaretModel().moveToOffset(this.myCaretPosition);
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
        if (StringUtil.isNotEmpty((String)(tooltip = this.getToolTipText()))) {
            this.myEditor.getContentComponent().setToolTipText(tooltip);
        }
        this.add(this.myEditor.getComponent(), "Center");
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
        }
    }

    private void releaseEditor(Editor editor) {
        PsiFile psiFile;
        if (editor == null) {
            return;
        }
        if (this.myProject != null && !this.myProject.isDisposed() && this.myIsViewer && (psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument())) != null) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).setHighlightingEnabled(psiFile, true);
        }
        this.remove(editor.getComponent());
        editor.getContentComponent().removeFocusListener(this);
        editor.getContentComponent().removeMouseListener(this);
        if (!editor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor(editor);
        }
    }

    void releaseEditorLater() {
        EditorEx editor = this.myEditor;
        ApplicationManager.getApplication().invokeLater(() -> this.releaseEditor(editor), ModalityState.stateForComponent((Component)((Object)this)));
        this.myEditor = null;
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.myEditor != null) {
            this.setupEditorFont(this.myEditor);
        }
    }

    protected boolean isOneLineMode() {
        return this.myOneLineMode;
    }

    private void initOneLineMode(EditorEx editor) {
        boolean isOneLineMode = this.isOneLineMode();
        editor.setOneLineMode(isOneLineMode);
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        EditorColorsScheme customGlobalScheme = colorsManager.getSchemeForCurrentUITheme();
        editor.setColorsScheme(editor.createBoundColorSchemeDelegate((EditorColorsScheme)(isOneLineMode ? customGlobalScheme : null)));
        EditorColorsScheme colorsScheme = editor.getColorsScheme();
        editor.getSettings().setCaretRowShown(false);
        this.setupEditorFont(editor);
        this.updateBorder(editor);
        editor.setBackgroundColor(this.getBackgroundColor(this.isEnabled(), colorsScheme));
    }

    public void setOneLineMode(boolean oneLineMode) {
        this.myOneLineMode = oneLineMode;
    }

    protected Document createDocument() {
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)this.myProject);
        long stamp = LocalTimeCounter.currentTime();
        PsiFile psiFile = factory.createFileFromText("Dummy." + this.myFileType.getDefaultExtension(), this.myFileType, (CharSequence)"", stamp, true, false);
        return PsiDocumentManager.getInstance((Project)this.myProject).getDocument(psiFile);
    }

    protected EditorEx createEditor() {
        PsiFile psiFile;
        Document document = this.getDocument();
        EditorFactory factory = EditorFactory.getInstance();
        EditorEx editor = (EditorEx)(this.myIsViewer ? factory.createViewer(document, this.myProject) : factory.createEditor(document, this.myProject));
        EditorTextField.setupTextFieldEditor(editor);
        editor.setCaretEnabled(!this.myIsViewer);
        if (this.myProject != null && (psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile((Document)editor.getDocument())) != null) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).setHighlightingEnabled(psiFile, !this.myIsViewer);
        }
        if (this.myProject != null) {
            EditorHighlighter highlighter;
            VirtualFile virtualFile;
            EditorHighlighterFactory highlighterFactory = EditorHighlighterFactory.getInstance();
            VirtualFile virtualFile2 = virtualFile = this.myDocument == null ? null : FileDocumentManager.getInstance().getFile(this.myDocument);
            EditorHighlighter editorHighlighter = virtualFile != null ? highlighterFactory.createEditorHighlighter(this.myProject, virtualFile) : (highlighter = this.myFileType != null ? highlighterFactory.createEditorHighlighter(this.myProject, this.myFileType) : null);
            if (highlighter != null) {
                editor.setHighlighter(highlighter);
            }
        }
        editor.getSettings().setCaretRowShown(false);
        editor.setOneLineMode(this.myOneLineMode);
        editor.getCaretModel().moveToOffset(document.getTextLength());
        if (!this.shouldHaveBorder()) {
            editor.setBorder(null);
        }
        if (this.myIsViewer) {
            editor.getSelectionModel().removeSelection();
        } else if (this.myWholeTextSelected) {
            EditorTextField.doSelectAll(editor);
            this.myWholeTextSelected = false;
        }
        editor.putUserData(SUPPLEMENTARY_KEY, this.myIsSupplementary);
        editor.getContentComponent().setFocusCycleRoot(false);
        editor.getContentComponent().addFocusListener(this);
        editor.getContentComponent().addMouseListener(this);
        editor.setPlaceholder(this.myHintText);
        this.initOneLineMode(editor);
        if (this.myIsRendererWithSelection) {
            ((EditorImpl)editor).setPaintSelection(true);
            editor.getColorsScheme().setColor(EditorColors.SELECTION_BACKGROUND_COLOR, this.myRendererBg);
            editor.getColorsScheme().setColor(EditorColors.SELECTION_FOREGROUND_COLOR, this.myRendererFg);
            editor.getSelectionModel().setSelection(0, document.getTextLength());
            editor.setBackgroundColor(this.myRendererBg);
        }
        for (EditorSettingsProvider provider : this.mySettingsProviders) {
            provider.customizeSettings(editor);
        }
        return editor;
    }

    public static void setupTextFieldEditor(@NotNull EditorEx editor) {
        if (editor == null) {
            EditorTextField.$$$reportNull$$$0(12);
        }
        EditorSettings settings = editor.getSettings();
        settings.setAdditionalLinesCount(0);
        settings.setAdditionalColumnsCount(1);
        settings.setRightMarginShown(false);
        settings.setRightMargin(-1);
        settings.setFoldingOutlineShown(false);
        settings.setLineNumbersShown(false);
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setVirtualSpace(false);
        settings.setWheelFontChangeEnabled(false);
        settings.setAdditionalPageAtBottom(false);
        editor.setHorizontalScrollbarVisible(false);
        editor.setVerticalScrollbarVisible(false);
        settings.setLineCursorWidth(1);
    }

    protected void updateBorder(@NotNull EditorEx editor) {
        if (editor == null) {
            EditorTextField.$$$reportNull$$$0(13);
        }
        if (editor.isOneLineMode() && !Boolean.TRUE.equals(this.getClientProperty("JComboBox.isTableCellEditor")) && (SwingUtilities.getAncestorOfClass(JTable.class, (Component)((Object)this)) == null || Boolean.TRUE.equals(this.getClientProperty("JBListTable.isTableCellEditor")))) {
            Container parent = this.getParent();
            if (parent instanceof JTable || parent instanceof CellRendererPane) {
                return;
            }
            this.setupBorder(editor);
        }
    }

    protected void setupBorder(@NotNull EditorEx editor) {
        if (editor == null) {
            EditorTextField.$$$reportNull$$$0(14);
        }
        if (StartupUiUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()) {
            LafManager lafManager = LafManager.getInstance();
            UIManager.LookAndFeelInfo lafInfo = lafManager.getCurrentLookAndFeel();
            if (lafInfo instanceof PluggableLafInfo) {
                editor.setBorder(((PluggableLafInfo)lafInfo).createEditorTextFieldBorder(this, editor));
            } else {
                editor.setBorder(new DarculaEditorTextFieldBorder(this, editor));
            }
        } else {
            editor.setBorder(BorderFactory.createCompoundBorder(UIUtil.getTextFieldBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        }
    }

    private void setupEditorFont(EditorEx editor) {
        if (this.myInheritSwingFont) {
            ((EditorImpl)editor).setUseEditorAntialiasing(false);
            editor.getColorsScheme().setEditorFontName(this.getFont().getFontName());
            editor.getColorsScheme().setEditorFontSize(this.getFont().getSize());
            return;
        }
        UISettings settings = UISettings.getInstance();
        if (settings.getPresentationMode()) {
            editor.setFontSize(settings.getPresentationModeFontSize());
        }
    }

    protected boolean shouldHaveBorder() {
        return true;
    }

    public void setEnabled(boolean enabled) {
        if (this.isEnabled() != enabled) {
            super.setEnabled(enabled);
            this.setFocusTraversalPolicyProvider(enabled);
            this.setViewerEnabled(enabled);
            EditorEx editor = this.myEditor;
            if (editor != null) {
                this.releaseEditor(editor);
                this.initEditor();
                this.revalidate();
            }
        }
    }

    protected void setViewerEnabled(boolean enabled) {
        this.myIsViewer = !enabled;
    }

    public boolean isViewer() {
        return this.myIsViewer;
    }

    public Color getBackground() {
        Color color = this.getBackgroundColor(this.isEnabled(), EditorColorsUtil.getGlobalOrDefaultColorScheme());
        return color != null ? color : super.getBackground();
    }

    private Color getBackgroundColor(boolean enabled, EditorColorsScheme colorsScheme) {
        if (this.myEnforcedBgColor != null) {
            return this.myEnforcedBgColor;
        }
        if (ComponentUtil.getParentOfType(CellRendererPane.class, (Component)((Object)this)) != null && (StartupUiUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF())) {
            return this.getParent().getBackground();
        }
        if (StartupUiUtil.isUnderDarcula()) {
            return UIUtil.getTextFieldBackground();
        }
        return enabled ? colorsScheme.getDefaultBackground() : UIUtil.getInactiveTextFieldBackgroundColor();
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (this.myEditor == null || comp != this.myEditor.getComponent()) assert (false) : "You are not allowed to add anything to EditorTextField";
        super.addImpl(comp, constraints, index);
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        boolean toReleaseEditor = false;
        if (this.myEditor == null && this.myEnsureWillComputePreferredSize) {
            this.myEnsureWillComputePreferredSize = false;
            this.initEditor();
            toReleaseEditor = true;
        }
        Object size = JBUI.size((int)100, (int)10);
        if (this.myEditor != null) {
            Dimension preferredSize = this.myEditor.getComponent().getPreferredSize();
            if (this.myPreferredWidth != -1) {
                preferredSize.width = this.myPreferredWidth;
            }
            JBInsets.addTo((Dimension)preferredSize, (Insets)this.getInsets());
            size = preferredSize;
        } else if (this.myPassivePreferredSize != null) {
            size = this.myPassivePreferredSize;
        }
        if (toReleaseEditor) {
            this.releaseEditor(this.myEditor);
            this.myEditor = null;
            this.myPassivePreferredSize = size;
        }
        return size;
    }

    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        JBDimension size = JBUI.size((int)1, (int)10);
        if (this.myEditor != null) {
            size.height = this.myEditor.getLineHeight();
            if (StartupUiUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()) {
                size.height = Math.max(size.height, JBUIScale.scale((int)16));
            }
            JBInsets.addTo((Dimension)size, (Insets)this.getInsets());
            JBInsets.addTo((Dimension)size, (Insets)this.myEditor.getInsets());
        }
        return size;
    }

    public void setPreferredWidth(int preferredWidth) {
        this.myPreferredWidth = preferredWidth;
    }

    public Component getNextFocusableComponent() {
        if (this.myEditor == null && this.myNextFocusable == null) {
            return super.getNextFocusableComponent();
        }
        if (this.myEditor == null) {
            return this.myNextFocusable;
        }
        return this.myEditor.getContentComponent().getNextFocusableComponent();
    }

    public void setNextFocusableComponent(Component aComponent) {
        if (this.myEditor != null) {
            this.myEditor.getContentComponent().setNextFocusableComponent(aComponent);
            return;
        }
        this.myNextFocusable = aComponent;
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (e.isConsumed() || this.myEditor != null && !this.myEditor.processKeyTyped(e)) {
            return super.processKeyBinding(ks, e, condition, pressed);
        }
        return true;
    }

    public void requestFocus() {
        if (this.myEditor != null) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> {
                if (this.myEditor != null) {
                    IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myEditor.getContentComponent(), true);
                }
            });
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    public boolean requestFocusInWindow() {
        if (this.myEditor != null) {
            boolean b = this.myEditor.getContentComponent().requestFocusInWindow();
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            return b;
        }
        return super.requestFocusInWindow();
    }

    @Nullable
    public Editor getEditor() {
        return this.myEditor;
    }

    public FileType getFileType() {
        return this.myFileType;
    }

    @NotNull
    public JComponent getFocusTarget() {
        Object object = this.myEditor == null ? this : this.myEditor.getContentComponent();
        if (object == null) {
            EditorTextField.$$$reportNull$$$0(15);
        }
        return object;
    }

    public synchronized void addFocusListener(FocusListener l) {
        this.myFocusListeners.add(l);
    }

    public synchronized void removeFocusListener(FocusListener l) {
        this.myFocusListeners.remove(l);
    }

    @Override
    public void focusGained(FocusEvent e) {
        for (FocusListener listener2 : this.myFocusListeners) {
            listener2.focusGained(e);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        for (FocusListener listener2 : this.myFocusListeners) {
            listener2.focusLost(e);
        }
    }

    public void addMouseListener(MouseListener l) {
        this.myMouseListeners.add(l);
    }

    public void removeMouseListener(MouseListener l) {
        this.myMouseListeners.remove(l);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        for (MouseListener listener2 : this.myMouseListeners) {
            listener2.mouseClicked(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        for (MouseListener listener2 : this.myMouseListeners) {
            listener2.mousePressed(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        for (MouseListener listener2 : this.myMouseListeners) {
            listener2.mouseReleased(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        for (MouseListener listener2 : this.myMouseListeners) {
            listener2.mouseEntered(e);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        for (MouseListener listener2 : this.myMouseListeners) {
            listener2.mouseExited(e);
        }
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            EditorTextField.$$$reportNull$$$0(16);
        }
        if (this.myEditor != null && this.myEditor.isRendererMode()) {
            if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
                return this.myEditor.getCopyProvider();
            }
            return null;
        }
        if (CommonDataKeys.EDITOR.is(dataId)) {
            return this.myEditor;
        }
        return null;
    }

    public void setFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            EditorTextField.$$$reportNull$$$0(17);
        }
        this.setNewDocumentAndFileType(fileType, this.getDocument());
    }

    public void setNewDocumentAndFileType(@NotNull FileType fileType, Document document) {
        if (fileType == null) {
            EditorTextField.$$$reportNull$$$0(18);
        }
        this.myFileType = fileType;
        this.setDocument(document);
    }

    public void ensureWillComputePreferredSize() {
        this.myEnsureWillComputePreferredSize = true;
    }

    public void setAsRendererWithSelection(Color backgroundColor, Color foregroundColor) {
        this.myIsRendererWithSelection = true;
        this.myRendererBg = backgroundColor;
        this.myRendererFg = foregroundColor;
    }

    public void addSettingsProvider(@NotNull EditorSettingsProvider provider) {
        if (provider == null) {
            EditorTextField.$$$reportNull$$$0(19);
        }
        this.mySettingsProviders.add(provider);
    }

    public boolean removeSettingsProvider(@NotNull EditorSettingsProvider provider) {
        if (provider == null) {
            EditorTextField.$$$reportNull$$$0(20);
        }
        return this.mySettingsProviders.remove(provider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/EditorTextField";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/EditorTextField";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "normalize";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 15: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addDocumentListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeDocumentListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "beforeDocumentChange";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doSelectAll";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setupTextFieldEditor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateBorder";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setupBorder";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setFileType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setNewDocumentAndFileType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addSettingsProvider";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeSettingsProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Jdk7DelegatingToRootTraversalPolicy
    extends AbstractDelegatingToRootTraversalPolicy {
        private boolean invokedFromBeforeOrAfter;

        private Jdk7DelegatingToRootTraversalPolicy() {
        }

        @Override
        public Component getFirstComponent(Container aContainer) {
            return this.getDefaultComponent(aContainer);
        }

        @Override
        public Component getLastComponent(Container aContainer) {
            return this.getDefaultComponent(aContainer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            Component after2;
            this.invokedFromBeforeOrAfter = true;
            try {
                after2 = super.getComponentAfter(aContainer, aComponent);
            }
            finally {
                this.invokedFromBeforeOrAfter = false;
            }
            return after2 != aComponent ? after2 : null;
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            Component before = super.getComponentBefore(aContainer, aComponent);
            return before != aComponent ? before : null;
        }

        @Override
        public Component getDefaultComponent(Container aContainer) {
            Editor editor;
            if (this.invokedFromBeforeOrAfter) {
                return null;
            }
            Editor editor2 = editor = aContainer instanceof EditorTextField ? ((EditorTextField)((Object)aContainer)).getEditor() : null;
            if (editor != null) {
                return editor.getContentComponent();
            }
            return aContainer;
        }
    }
}

