/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.util.CloudServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class CloudRuntimeTask<T, DC extends DeploymentConfiguration, SR extends CloudServerRuntimeInstance<DC, ?, ?>> {
    private static final Logger LOG = Logger.getInstance(CloudRuntimeTask.class);
    private final Project myProject;
    private final String myTitle;
    private final AtomicReference<Boolean> mySuccess = new AtomicReference();
    private final AtomicReference<String> myErrorMessage = new AtomicReference();

    public CloudRuntimeTask(Project project, String title) {
        this.myProject = project;
        this.myTitle = title;
    }

    public T performSync() {
        return this.perform(true, null);
    }

    public void performAsync() {
        this.performAsync(null);
    }

    public void performAsync(Disposable disposable2) {
        this.perform(false, disposable2);
    }

    private T perform(boolean modal, Disposable disposable2) {
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        AtomicReference result2 = new AtomicReference();
        final Progressive progressive = indicator -> {
            indicator.setIndeterminate(true);
            while (!indicator.isCanceled()) {
                if (!semaphore.waitFor(500L)) continue;
                if (!this.mySuccess.get().booleanValue()) break;
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (disposable2 == null || !Disposer.isDisposed((Disposable)disposable2)) {
                        this.postPerform(result2.get());
                    }
                });
                break;
            }
        };
        boolean cancellable = this.isCancellable(modal);
        Object task2 = modal ? new Task.Modal(this.myProject, this.myTitle, cancellable){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                progressive.run(indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/remoteServer/util/CloudRuntimeTask$1", "run"));
            }
        } : new Task.Backgroundable(this.myProject, this.myTitle, cancellable){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                progressive.run(indicator);
            }

            public boolean shouldStartInBackground() {
                return CloudRuntimeTask.this.shouldStartInBackground();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/remoteServer/util/CloudRuntimeTask$2", "run"));
            }
        };
        this.mySuccess.set(false);
        this.myErrorMessage.set(null);
        this.run(semaphore, result2);
        task2.queue();
        return (T)result2.get();
    }

    protected boolean shouldStartInBackground() {
        return true;
    }

    protected void postPerform(T result2) {
    }

    protected boolean isCancellable(boolean modal) {
        return modal;
    }

    protected void run(Semaphore semaphore, AtomicReference<T> result2) {
        this.run(this.getServerRuntime(), semaphore, result2);
    }

    protected void run(SR serverRuntime, Semaphore semaphore, AtomicReference<T> result2) {
        ((CloudServerRuntimeInstance)((Object)serverRuntime)).getTaskExecutor().submit(() -> {
            try {
                result2.set(this.run(serverRuntime));
                this.mySuccess.set(true);
            }
            catch (ServerRuntimeException e) {
                this.runtimeErrorOccurred(e.getMessage());
            }
            finally {
                semaphore.up();
            }
        });
    }

    protected void runtimeErrorOccurred(@NotNull String errorMessage) {
        if (errorMessage == null) {
            CloudRuntimeTask.$$$reportNull$$$0(0);
        }
        this.myErrorMessage.set(errorMessage);
        LOG.info(errorMessage);
    }

    public void showMessageDialog(JComponent component2, String successMessage, String title) {
        if (this.mySuccess.get().booleanValue()) {
            Messages.showInfoMessage((Component)component2, (String)successMessage, (String)title);
            return;
        }
        String errorMessage = this.myErrorMessage.get();
        if (errorMessage != null) {
            Messages.showErrorDialog((Component)component2, (String)errorMessage, (String)title);
        }
    }

    protected abstract SR getServerRuntime();

    protected abstract T run(SR var1) throws ServerRuntimeException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/remoteServer/util/CloudRuntimeTask", "runtimeErrorOccurred"));
    }
}

