/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ClassMapCachingNulls<T> {
    private final Map<Class<?>, T[]> myBackingMap;
    private final T[] myEmptyArray;
    private final List<? extends T> myOrderingArray;
    private final Map<Class<?>, T[]> myMap;

    ClassMapCachingNulls(@NotNull Map<Class<?>, T[]> backingMap, T[] emptyArray, @NotNull List<? extends T> orderingArray) {
        if (backingMap == null) {
            ClassMapCachingNulls.$$$reportNull$$$0(0);
        }
        if (orderingArray == null) {
            ClassMapCachingNulls.$$$reportNull$$$0(1);
        }
        this.myMap = ContainerUtil.newConcurrentMap();
        this.myBackingMap = backingMap;
        this.myEmptyArray = emptyArray;
        this.myOrderingArray = orderingArray;
    }

    T @Nullable [] get(Class<?> aClass) {
        T[] value2 = this.myMap.get(aClass);
        if (value2 != null) {
            if (value2 == this.myEmptyArray) {
                return null;
            }
            assert (value2.length != 0);
            return value2;
        }
        List<T> result2 = this.getFromBackingMap(aClass);
        return this.cache(aClass, result2);
    }

    private T[] cache(Class<?> aClass, List<T> result2) {
        T[] value2;
        if (result2 == null) {
            this.myMap.put(aClass, this.myEmptyArray);
            value2 = null;
        } else {
            assert (!result2.isEmpty());
            value2 = result2.toArray(this.myEmptyArray);
            this.myMap.put(aClass, value2);
        }
        return value2;
    }

    @Nullable
    private List<T> getFromBackingMap(Class<?> aClass) {
        Object[] value2 = this.myBackingMap.get(aClass);
        Set<T> result2 = null;
        if (value2 != null) {
            assert (value2.length != 0);
            result2 = ContainerUtil.set((Object[])value2);
        }
        for (Class superclass : JBIterable.of(aClass.getSuperclass()).append((Object[])aClass.getInterfaces())) {
            result2 = this.addFromUpper(result2, superclass);
        }
        if (result2 == null) {
            return null;
        }
        return ContainerUtil.filter(this.myOrderingArray, result2::contains);
    }

    private Set<T> addFromUpper(Set<T> value2, Class<?> superclass) {
        T[] fromUpper = this.get(superclass);
        if (fromUpper != null) {
            assert (fromUpper.length != 0);
            if (value2 == null) {
                value2 = new HashSet<T>(fromUpper.length);
            }
            Collections.addAll(value2, fromUpper);
            assert (!value2.isEmpty());
        }
        return value2;
    }

    Map<Class<?>, T[]> getBackingMap() {
        return this.myBackingMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "backingMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "orderingArray";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/impl/source/tree/injected/ClassMapCachingNulls";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

