/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.LanguageTokenSeparatorGenerators;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.TokenSeparatorGenerator;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.codeStyle.IndentHelper;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.NotNullFunction;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeEditUtil {
    private static final Key<Boolean> GENERATED_FLAG = new Key("GENERATED_FLAG");
    private static final Key<Integer> INDENT_INFO = new Key("INDENT_INFO");
    private static final Key<Boolean> REFORMAT_BEFORE_KEY = new Key("REFORMAT_BEFORE_KEY");
    private static final Key<Boolean> REFORMAT_KEY = new Key("REFORMAT_KEY");
    private static final ThreadLocal<Boolean> ALLOW_TO_MARK_NODES_TO_REFORMAT = ThreadLocal.withInitial(() -> Boolean.TRUE);
    private static final ThreadLocal<Boolean> ALLOW_NODES_REFORMATTING = ThreadLocal.withInitial(() -> Boolean.TRUE);
    private static final ThreadLocal<NotNullFunction<? super ASTNode, Boolean>> NODE_REFORMAT_STRATEGY = new ThreadLocal();

    private CodeEditUtil() {
    }

    public static void addChild(@NotNull ASTNode parent, @NotNull ASTNode child2, @Nullable ASTNode anchorBefore) {
        if (parent == null) {
            CodeEditUtil.$$$reportNull$$$0(0);
        }
        if (child2 == null) {
            CodeEditUtil.$$$reportNull$$$0(1);
        }
        CodeEditUtil.addChildren(parent, child2, child2, anchorBefore);
    }

    public static void removeChild(@NotNull ASTNode parent, @NotNull ASTNode child2) {
        if (parent == null) {
            CodeEditUtil.$$$reportNull$$$0(2);
        }
        if (child2 == null) {
            CodeEditUtil.$$$reportNull$$$0(3);
        }
        CodeEditUtil.removeChildren(parent, child2, child2);
    }

    public static ASTNode addChildren(@NotNull ASTNode parent, @NotNull ASTNode first, @NotNull ASTNode last, @Nullable ASTNode anchorBefore) {
        ASTNode anchorPrev;
        if (parent == null) {
            CodeEditUtil.$$$reportNull$$$0(4);
        }
        if (first == null) {
            CodeEditUtil.$$$reportNull$$$0(5);
        }
        if (last == null) {
            CodeEditUtil.$$$reportNull$$$0(6);
        }
        ASTNode lastChild = last.getTreeNext();
        for (ASTNode current2 = first; current2 != lastChild; current2 = current2.getTreeNext()) {
            CodeEditUtil.saveWhitespacesInfo(current2);
        }
        if (anchorBefore != null && CodeEditUtil.isComment(anchorBefore.getElementType()) && (anchorPrev = anchorBefore.getTreePrev()) != null && anchorPrev.getElementType() == TokenType.WHITE_SPACE) {
            anchorBefore = anchorPrev;
        }
        parent.addChildren(first, lastChild, anchorBefore);
        ASTNode firstAddedLeaf = CodeEditUtil.findFirstLeaf(first, last);
        ASTNode prevLeaf = TreeUtil.prevLeaf(first);
        ASTNode result2 = first;
        if (firstAddedLeaf != null) {
            ASTNode lastAddedLeaf;
            ASTNode placeHolderEnd = CodeEditUtil.makePlaceHolderBetweenTokens(prevLeaf, firstAddedLeaf, CodeEditUtil.isFormattingRequired(prevLeaf, first), false);
            if (placeHolderEnd != prevLeaf && first == firstAddedLeaf || result2.getTreeParent() != parent) {
                result2 = placeHolderEnd;
            }
            if ((placeHolderEnd = CodeEditUtil.makePlaceHolderBetweenTokens(lastAddedLeaf = CodeEditUtil.findLastLeaf(first, last), TreeUtil.nextLeaf(last), true, false)) != lastAddedLeaf && lastAddedLeaf == first) {
                result2 = placeHolderEnd;
            }
        } else {
            CodeEditUtil.makePlaceHolderBetweenTokens(prevLeaf, TreeUtil.nextLeaf(last), CodeEditUtil.isFormattingRequired(prevLeaf, first), false);
        }
        return result2;
    }

    private static boolean isComment(@NotNull IElementType type) {
        ParserDefinition def;
        if (type == null) {
            CodeEditUtil.$$$reportNull$$$0(7);
        }
        return (def = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(type.getLanguage())) != null && def.getCommentTokens().contains(type);
    }

    private static boolean isFormattingRequired(ASTNode prevLeaf, ASTNode first) {
        while (first != null) {
            for (ASTNode current2 = prevLeaf; current2 != null; current2 = current2.getTreeParent()) {
                if (current2.getTreeNext() != first) continue;
                return true;
            }
            ASTNode parent = first.getTreeParent();
            if (parent == null || !parent.getTextRange().equals((Object)first.getTextRange())) break;
            first = parent;
        }
        return false;
    }

    public static void saveWhitespacesInfo(ASTNode first) {
        if (first == null || CodeEditUtil.isNodeGenerated(first) || CodeEditUtil.getOldIndentation(first) >= 0) {
            return;
        }
        PsiElement psiElement = first.getPsi();
        if (psiElement == null) {
            return;
        }
        PsiFile file2 = psiElement.getContainingFile();
        CodeEditUtil.setOldIndentation((TreeElement)first, IndentHelper.getInstance().getIndent(file2, first));
    }

    public static int getOldIndentation(ASTNode node) {
        if (node == null) {
            return -1;
        }
        Integer stored = (Integer)node.getCopyableUserData(INDENT_INFO);
        return stored != null ? stored : -1;
    }

    public static void removeChildren(@NotNull ASTNode parent, @NotNull ASTNode first, @NotNull ASTNode last) {
        TreeElement child2;
        if (parent == null) {
            CodeEditUtil.$$$reportNull$$$0(8);
        }
        if (first == null) {
            CodeEditUtil.$$$reportNull$$$0(9);
        }
        if (last == null) {
            CodeEditUtil.$$$reportNull$$$0(10);
        }
        boolean tailingElement = last.getStartOffset() + last.getTextLength() == parent.getStartOffset() + parent.getTextLength();
        boolean forceReformat = CodeEditUtil.needToForceReformat(parent, first, last);
        CodeEditUtil.saveWhitespacesInfo(first);
        for (child2 = (TreeElement)first; child2 != null && child2 != last; child2 = child2.getTreeNext()) {
        }
        assert (child2 == last) : last + " is not a successor of " + first + " in the .getTreeNext() chain";
        ASTNode prevLeaf = TreeUtil.prevLeaf(first);
        ASTNode nextLeaf = TreeUtil.nextLeaf(last);
        parent.removeRange(first, last.getTreeNext());
        ASTNode nextLeafToAdjust = nextLeaf;
        if (nextLeafToAdjust != null && prevLeaf != null && nextLeafToAdjust.getTreeParent() == null) {
            nextLeafToAdjust = prevLeaf.getTreeNext();
        }
        CodeEditUtil.makePlaceHolderBetweenTokens(prevLeaf, nextLeafToAdjust, forceReformat, tailingElement);
    }

    private static boolean needToForceReformat(ASTNode parent, ASTNode first, ASTNode last) {
        return parent == null || first.getStartOffset() != parent.getStartOffset() || parent.getText().trim().length() == CodeEditUtil.getTrimmedTextLength(first, last) && CodeEditUtil.needToForceReformat(parent.getTreeParent(), parent, parent);
    }

    private static int getTrimmedTextLength(ASTNode first, ASTNode last) {
        StringBuilder buffer = new StringBuilder();
        while (first != last.getTreeNext()) {
            buffer.append(first.getText());
            first = first.getTreeNext();
        }
        return buffer.toString().trim().length();
    }

    public static void replaceChild(@NotNull ASTNode parent, @NotNull ASTNode oldChild, @NotNull ASTNode newChild) {
        if (parent == null) {
            CodeEditUtil.$$$reportNull$$$0(11);
        }
        if (oldChild == null) {
            CodeEditUtil.$$$reportNull$$$0(12);
        }
        if (newChild == null) {
            CodeEditUtil.$$$reportNull$$$0(13);
        }
        CodeEditUtil.saveWhitespacesInfo(oldChild);
        CodeEditUtil.saveWhitespacesInfo(newChild);
        LeafElement oldFirst = TreeUtil.findFirstLeaf(oldChild);
        parent.replaceChild(oldChild, newChild);
        LeafElement firstLeaf = TreeUtil.findFirstLeaf(newChild);
        ASTNode prevToken = TreeUtil.prevLeaf(newChild);
        if (firstLeaf != null) {
            ASTNode nextLeaf = TreeUtil.nextLeaf(newChild);
            CodeEditUtil.makePlaceHolderBetweenTokens(prevToken, firstLeaf, CodeEditUtil.isFormattingRequired(prevToken, newChild), false);
            if (nextLeaf != null && !CharArrayUtil.containLineBreaks((CharSequence)nextLeaf.getText())) {
                CodeEditUtil.makePlaceHolderBetweenTokens(TreeUtil.prevLeaf(nextLeaf), nextLeaf, false, false);
            }
        } else {
            ASTNode whitespaceNode;
            if (oldFirst != null && prevToken == null && (whitespaceNode = newChild.getTreeNext()) != null && whitespaceNode.getElementType() == TokenType.WHITE_SPACE) {
                parent.removeChild(whitespaceNode);
            }
            CodeEditUtil.makePlaceHolderBetweenTokens(prevToken, TreeUtil.nextLeaf(newChild), CodeEditUtil.isFormattingRequired(prevToken, newChild), false);
        }
    }

    @Nullable
    private static ASTNode findFirstLeaf(ASTNode first, ASTNode last) {
        do {
            LeafElement leaf;
            if ((leaf = TreeUtil.findFirstLeaf(first)) != null) {
                return leaf;
            }
            if ((first = first.getTreeNext()) != null) continue;
            return null;
        } while (first != last);
        return null;
    }

    @Nullable
    private static ASTNode findLastLeaf(ASTNode first, ASTNode last) {
        do {
            ASTNode leaf;
            if ((leaf = TreeUtil.findLastLeaf(last)) != null) {
                return leaf;
            }
            if ((last = last.getTreePrev()) != null) continue;
            return null;
        } while (first != last);
        return null;
    }

    @Nullable
    private static ASTNode makePlaceHolderBetweenTokens(ASTNode left, ASTNode right, boolean forceReformat, boolean normalizeTrailingWS) {
        if (right == null) {
            return left;
        }
        CodeEditUtil.markToReformatBefore(right, false);
        if (left == null) {
            CodeEditUtil.markToReformatBefore(right, true);
        } else if (left.getElementType() == TokenType.WHITE_SPACE && left.getTreeNext() == null && normalizeTrailingWS) {
            ASTNode prevLeaf = TreeUtil.prevLeaf(left);
            left.getTreeParent().removeChild(left);
            CodeEditUtil.markToReformatBeforeOrInsertWhitespace(prevLeaf, right);
            left = right;
        } else if (left.getElementType() == TokenType.WHITE_SPACE && right.getElementType() == TokenType.WHITE_SPACE) {
            int rightBlankLines;
            boolean leaveRightText;
            int leftBlankLines = CodeEditUtil.getBlankLines(left.getText());
            boolean bl = leaveRightText = leftBlankLines < (rightBlankLines = CodeEditUtil.getBlankLines(right.getText()));
            String text2 = leftBlankLines == 0 && rightBlankLines == 0 ? left.getText() + right.getText() : (leaveRightText ? right.getText() : left.getText());
            if (leaveRightText || forceReformat) {
                LeafElement merged = ASTFactory.whitespace(text2);
                if (!leaveRightText) {
                    left.getTreeParent().replaceChild(left, (ASTNode)merged);
                    right.getTreeParent().removeChild(right);
                } else {
                    right.getTreeParent().replaceChild(right, (ASTNode)merged);
                    left.getTreeParent().removeChild(left);
                }
                left = merged;
            } else {
                right.getTreeParent().removeChild(right);
            }
        } else if (left.getElementType() != TokenType.WHITE_SPACE || forceReformat) {
            if (right.getElementType() == TokenType.WHITE_SPACE) {
                CodeEditUtil.markWhitespaceForReformat(right);
            } else if (left.getElementType() == TokenType.WHITE_SPACE) {
                CodeEditUtil.markWhitespaceForReformat(left);
            } else {
                CodeEditUtil.markToReformatBeforeOrInsertWhitespace(left, right);
            }
        }
        return left;
    }

    private static void markWhitespaceForReformat(ASTNode right) {
        String text2 = right.getText();
        LeafElement merged = ASTFactory.whitespace(text2);
        right.getTreeParent().replaceChild(right, (ASTNode)merged);
    }

    private static void markToReformatBeforeOrInsertWhitespace(ASTNode left, @NotNull ASTNode right) {
        if (right == null) {
            CodeEditUtil.$$$reportNull$$$0(14);
        }
        Language leftLang = left != null ? PsiUtilCore.getNotAnyLanguage((ASTNode)left) : null;
        Language rightLang = PsiUtilCore.getNotAnyLanguage((ASTNode)right);
        ASTNode generatedWhitespace = null;
        if (leftLang != null && leftLang.isKindOf(rightLang)) {
            generatedWhitespace = ((TokenSeparatorGenerator)LanguageTokenSeparatorGenerators.INSTANCE.forLanguage(leftLang)).generateWhitespaceBetweenTokens(left, right);
        } else if (rightLang.isKindOf(leftLang)) {
            generatedWhitespace = ((TokenSeparatorGenerator)LanguageTokenSeparatorGenerators.INSTANCE.forLanguage(rightLang)).generateWhitespaceBetweenTokens(left, right);
        }
        if (generatedWhitespace != null) {
            TreeUtil.CommonParentState parentState = new TreeUtil.CommonParentState();
            TreeUtil.prevLeaf((TreeElement)right, parentState);
            parentState.nextLeafBranchStart.getTreeParent().addChild(generatedWhitespace, parentState.nextLeafBranchStart);
        } else {
            CodeEditUtil.markToReformatBefore(right, true);
        }
    }

    public static void markToReformatBefore(@NotNull ASTNode right, boolean value2) {
        if (right == null) {
            CodeEditUtil.$$$reportNull$$$0(15);
        }
        if (ALLOW_TO_MARK_NODES_TO_REFORMAT.get().booleanValue()) {
            right.putCopyableUserData(REFORMAT_BEFORE_KEY, (Object)(value2 ? Boolean.valueOf(true) : null));
        }
    }

    private static int getBlankLines(@NotNull String text2) {
        if (text2 == null) {
            CodeEditUtil.$$$reportNull$$$0(16);
        }
        int result2 = 0;
        int currentIndex = -1;
        while ((currentIndex = text2.indexOf(10, currentIndex + 1)) >= 0) {
            ++result2;
        }
        return result2;
    }

    public static boolean isNodeGenerated(ASTNode node) {
        return node == null || node.getCopyableUserData(GENERATED_FLAG) != null;
    }

    public static void setNodeGenerated(ASTNode next, boolean value2) {
        if (next == null) {
            return;
        }
        next.putCopyableUserData(GENERATED_FLAG, (Object)(value2 ? Boolean.valueOf(true) : null));
    }

    public static void setNodeGeneratedRecursively(ASTNode next, boolean value2) {
        if (next == null) {
            return;
        }
        CodeEditUtil.setNodeGenerated(next, value2);
        for (ASTNode child2 = next.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
            CodeEditUtil.setNodeGeneratedRecursively(child2, value2);
        }
    }

    public static void setOldIndentation(TreeElement treeElement, int oldIndentation) {
        if (treeElement == null) {
            return;
        }
        treeElement.putCopyableUserData(INDENT_INFO, oldIndentation >= 0 ? Integer.valueOf(oldIndentation) : null);
    }

    public static boolean isMarkedToReformatBefore(@NotNull TreeElement element2) {
        if (element2 == null) {
            CodeEditUtil.$$$reportNull$$$0(17);
        }
        return element2.getCopyableUserData(REFORMAT_BEFORE_KEY) != null;
    }

    @Nullable
    public static PsiElement createLineFeed(@NotNull PsiManager manager) {
        if (manager == null) {
            CodeEditUtil.$$$reportNull$$$0(18);
        }
        return Factory.createSingleLeafElement(TokenType.WHITE_SPACE, "\n", 0, 1, null, manager).getPsi();
    }

    public static boolean isMarkedToReformat(@NotNull ASTNode node) {
        if (node == null) {
            CodeEditUtil.$$$reportNull$$$0(19);
        }
        if (node.getCopyableUserData(REFORMAT_KEY) == null || !CodeEditUtil.isSuspendedNodesReformattingAllowed()) {
            return false;
        }
        NotNullFunction<? super ASTNode, Boolean> strategy = NODE_REFORMAT_STRATEGY.get();
        return strategy == null || (Boolean)strategy.fun((Object)node) != false;
    }

    public static void markToReformat(@NotNull ASTNode node, boolean value2) {
        if (node == null) {
            CodeEditUtil.$$$reportNull$$$0(20);
        }
        if (ALLOW_TO_MARK_NODES_TO_REFORMAT.get().booleanValue()) {
            node.putCopyableUserData(REFORMAT_KEY, (Object)(value2 ? Boolean.valueOf(true) : null));
        }
    }

    public static void allowToMarkNodesForPostponedFormatting(boolean allow) {
        ALLOW_TO_MARK_NODES_TO_REFORMAT.set(allow);
    }

    public static boolean isSuspendedNodesReformattingAllowed() {
        return ALLOW_NODES_REFORMATTING.get();
    }

    public static void setAllowSuspendNodesReformatting(boolean allow) {
        ALLOW_NODES_REFORMATTING.set(allow);
    }

    public static void setNodeReformatStrategy(@Nullable NotNullFunction<? super ASTNode, Boolean> strategy) {
        NODE_REFORMAT_STRATEGY.set(strategy);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldChild";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChild";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/CodeEditUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addChild";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeChild";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addChildren";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isComment";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "removeChildren";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceChild";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "markToReformatBeforeOrInsertWhitespace";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "markToReformatBefore";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "getBlankLines";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "isMarkedToReformatBefore";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "createLineFeed";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "isMarkedToReformat";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "markToReformat";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

