/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.ProjectGroup;
import com.intellij.ide.ProjectGroupActionGroup;
import com.intellij.ide.RecentProjectListActionProvider;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.ReopenProjectAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.UniqueNameBuilder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.BottomLineBorder;
import com.intellij.openapi.wm.impl.welcomeScreen.FlatWelcomeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenColors;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ListUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.IconUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecentProjectPanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance(RecentProjectPanel.class);
    public static final String RECENT_PROJECTS_LABEL = "Recent Projects";
    protected final JBList<AnAction> myList;
    protected final UniqueNameBuilder<ReopenProjectAction> myPathShortener;
    protected AnAction removeRecentProjectAction;
    protected Set<ReopenProjectAction> projectsWithLongPaths;
    protected FilePathChecker myChecker;
    private int myHoverIndex;

    public RecentProjectPanel(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            RecentProjectPanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.projectsWithLongPaths = new HashSet<ReopenProjectAction>();
        this.myHoverIndex = -1;
        List<AnAction> recentProjectActions = RecentProjectListActionProvider.getInstance().getActions(false, this.isUseGroups());
        this.myPathShortener = new UniqueNameBuilder(SystemProperties.getUserHome(), File.separator, 40);
        HashSet<String> pathsToCheck = new HashSet<String>();
        for (AnAction action2 : recentProjectActions) {
            if (!(action2 instanceof ReopenProjectAction)) continue;
            ReopenProjectAction item = (ReopenProjectAction)action2;
            this.myPathShortener.addPath((Object)item, item.getProjectPath());
            pathsToCheck.add(item.getProjectPath());
        }
        this.myList = this.createList(recentProjectActions.toArray(AnAction.EMPTY_ARRAY), this.getPreferredScrollableViewportSize());
        this.myList.setCellRenderer(this.createRenderer(this.myPathShortener));
        if (Registry.is((String)"autocheck.availability.welcome.screen.projects")) {
            this.myChecker = new FilePathChecker(new Runnable(){

                @Override
                public void run() {
                    if (RecentProjectPanel.this.myList.isShowing()) {
                        RecentProjectPanel.this.myList.revalidate();
                        RecentProjectPanel.this.myList.repaint();
                    }
                }
            }, pathsToCheck);
            Disposer.register((Disposable)parentDisposable, (Disposable)this.myChecker);
        }
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                AnAction selectedAction;
                AnAction selection;
                Rectangle cellBounds;
                int selectedIndex;
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((selectedIndex = RecentProjectPanel.this.myList.getSelectedIndex()) >= 0 && (cellBounds = RecentProjectPanel.this.myList.getCellBounds(selectedIndex, selectedIndex)).contains(event.getPoint()) && (selection = (AnAction)RecentProjectPanel.this.myList.getSelectedValue()) != null && (selectedAction = RecentProjectPanel.this.performSelectedAction(event, selection)) instanceof ReopenProjectAction && ((ReopenProjectAction)selectedAction).isRemoved()) {
                    ListUtil.removeSelectedItems(RecentProjectPanel.this.myList);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/welcomeScreen/RecentProjectPanel$2", "onClick"));
            }
        }.installOn(this.myList);
        this.myList.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List selectedValues = RecentProjectPanel.this.myList.getSelectedValuesList();
                if (selectedValues != null) {
                    for (AnAction selectedAction : selectedValues) {
                        if (selectedAction == null) continue;
                        KeyEvent event = new KeyEvent((Component)RecentProjectPanel.this.myList, 401, e.getWhen(), e.getModifiers(), 10, '\r');
                        RecentProjectPanel.this.performSelectedAction(event, selectedAction);
                    }
                }
            }
        }, KeyStroke.getKeyStroke(10, 0), 1);
        this.removeRecentProjectAction = new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                RecentProjectPanel.this.removeRecentProject();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/RecentProjectPanel$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.removeRecentProjectAction.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"DELETE", "BACK_SPACE"}), this.myList, parentDisposable);
        this.addMouseMotionListener();
        this.myList.setSelectedIndex(0);
        JBScrollPane scroll = new JBScrollPane(this.myList, 20, 31);
        scroll.setBorder(null);
        JBList<AnAction> list2 = recentProjectActions.isEmpty() ? this.myList : ListWithFilter.wrap(this.myList, (JScrollPane)scroll, o -> {
            if (o instanceof ReopenProjectAction) {
                ReopenProjectAction item = (ReopenProjectAction)((Object)o);
                String home = SystemProperties.getUserHome();
                String path = item.getProjectPath();
                if (FileUtil.startsWith((String)path, (String)home)) {
                    path = path.substring(home.length());
                }
                return item.getProjectName() + " " + path;
            }
            if (o instanceof ProjectGroupActionGroup) {
                return ((ProjectGroupActionGroup)((Object)o)).getGroup().getName();
            }
            return o.toString();
        });
        this.add((Component)list2, "Center");
        JPanel title = this.createTitle();
        if (title != null) {
            this.add((Component)title, "North");
        }
        this.setBorder(new LineBorder(WelcomeScreenColors.BORDER_COLOR));
    }

    @NotNull
    private AnAction performSelectedAction(@NotNull InputEvent event, AnAction selection) {
        if (event == null) {
            RecentProjectPanel.$$$reportNull$$$0(1);
        }
        String actionPlace = UIUtil.uiParents(this.myList, (boolean)true).filter(FlatWelcomeFrame.class).isEmpty() ? "popup" : "WelcomeScreen";
        AnActionEvent actionEvent = AnActionEvent.createFromInputEvent((InputEvent)event, (String)actionPlace, (Presentation)selection.getTemplatePresentation(), (DataContext)DataManager.getInstance().getDataContext(this.myList), (boolean)false, (boolean)false);
        ActionUtil.performActionDumbAwareWithCallbacks((AnAction)selection, (AnActionEvent)actionEvent, (DataContext)actionEvent.getDataContext());
        AnAction anAction = selection;
        if (anAction == null) {
            RecentProjectPanel.$$$reportNull$$$0(2);
        }
        return anAction;
    }

    private void removeRecentProject() {
        List selection = this.myList.getSelectedValuesList();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        int rc = Messages.showOkCancelDialog((Component)this, (String)IdeBundle.message((String)"dialog.message.remove.0.from.recent.projects.list", (Object[])new Object[]{StringUtil.join((Collection)selection, action2 -> action2.getTemplatePresentation().getText(), (String)"'\n'")}), (String)IdeBundle.message((String)"dialog.title.remove.recent.project", (Object[])new Object[0]), (String)CommonBundle.getOkButtonText(), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
        if (rc == 0) {
            for (AnAction projectAction : selection) {
                RecentProjectPanel.removeRecentProjectElement(projectAction);
            }
            ListUtil.removeSelectedItems(this.myList);
        }
    }

    protected boolean isPathValid(String path) {
        return this.myChecker == null || this.myChecker.isValid(path);
    }

    protected static void removeRecentProjectElement(@NotNull Object element2) {
        if (element2 == null) {
            RecentProjectPanel.$$$reportNull$$$0(3);
        }
        RecentProjectsManager manager = RecentProjectsManager.getInstance();
        if (element2 instanceof ReopenProjectAction) {
            manager.removePath(((ReopenProjectAction)((Object)element2)).getProjectPath());
        } else if (element2 instanceof ProjectGroupActionGroup) {
            manager.removeGroup(((ProjectGroupActionGroup)((Object)element2)).getGroup());
        }
    }

    protected boolean isUseGroups() {
        return false;
    }

    protected Dimension getPreferredScrollableViewportSize() {
        return JBUI.size((int)250, (int)400);
    }

    protected void addMouseMotionListener() {
        MouseAdapter mouseAdapter2 = new MouseAdapter(){
            boolean myIsEngaged = false;

            @Override
            public void mouseMoved(MouseEvent e) {
                Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (focusOwner == null) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(RecentProjectPanel.this.myList, true));
                }
                if (RecentProjectPanel.this.myList.getSelectedIndices().length > 1) {
                    return;
                }
                if (!this.myIsEngaged || UIUtil.isSelectionButtonDown((MouseEvent)e) || focusOwner instanceof JRootPane) {
                    this.myIsEngaged = true;
                    return;
                }
                Point point = e.getPoint();
                int index = RecentProjectPanel.this.myList.locationToIndex(point);
                RecentProjectPanel.this.myList.setSelectedIndex(index);
                Rectangle cellBounds = RecentProjectPanel.this.myList.getCellBounds(index, index);
                if (cellBounds != null && cellBounds.contains(point)) {
                    UIUtil.setCursor(RecentProjectPanel.this.myList, (Cursor)Cursor.getPredefinedCursor(12));
                    RecentProjectPanel.this.myHoverIndex = index;
                    RecentProjectPanel.this.myList.repaint(cellBounds);
                } else {
                    UIUtil.setCursor(RecentProjectPanel.this.myList, (Cursor)Cursor.getPredefinedCursor(0));
                    RecentProjectPanel.this.myHoverIndex = -1;
                    RecentProjectPanel.this.myList.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RecentProjectPanel.this.myHoverIndex = -1;
                RecentProjectPanel.this.myList.repaint();
            }
        };
        this.myList.addMouseMotionListener((MouseMotionListener)mouseAdapter2);
        this.myList.addMouseListener((MouseListener)mouseAdapter2);
    }

    protected JBList<AnAction> createList(AnAction[] recentProjectActions, Dimension size) {
        return new MyList(size, recentProjectActions);
    }

    protected ListCellRenderer<AnAction> createRenderer(UniqueNameBuilder<ReopenProjectAction> pathShortener) {
        return new RecentProjectItemRenderer();
    }

    @Nullable
    protected JPanel createTitle() {
        JPanel title = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, JBUIScale.scale((int)28));
            }
        };
        title.setBorder(new BottomLineBorder());
        JLabel titleLabel = new JLabel(RECENT_PROJECTS_LABEL);
        title.add(titleLabel);
        titleLabel.setHorizontalAlignment(0);
        titleLabel.setForeground(WelcomeScreenColors.CAPTION_FOREGROUND);
        title.setBackground(WelcomeScreenColors.CAPTION_BACKGROUND);
        return title;
    }

    private static boolean isPathAvailable(String pathStr) {
        Path path = Paths.get(pathStr, new String[0]);
        Path pathRoot = path.getRoot();
        if (pathRoot == null) {
            return false;
        }
        if (SystemInfo.isWindows && pathRoot.toString().startsWith("\\\\")) {
            return true;
        }
        for (Path fsRoot : pathRoot.getFileSystem().getRootDirectories()) {
            if (!pathRoot.equals(fsRoot)) continue;
            return Files.exists(path, new LinkOption[0]);
        }
        return false;
    }

    @NotNull
    private static Icon toSize(@NotNull Icon icon2) {
        if (icon2 == null) {
            RecentProjectPanel.$$$reportNull$$$0(4);
        }
        Icon icon3 = IconUtil.toSize((Icon)icon2, (int)((int)ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.getWidth()), (int)((int)ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.getHeight()));
        if (icon3 == null) {
            RecentProjectPanel.$$$reportNull$$$0(5);
        }
        return icon3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/welcomeScreen/RecentProjectPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/RecentProjectPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "performSelectedAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "performSelectedAction";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeRecentProjectElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toSize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FilePathChecker
    implements Disposable,
    ApplicationActivationListener,
    PowerSaveMode.Listener {
        private static final int MIN_AUTO_UPDATE_MILLIS = 2500;
        private ScheduledExecutorService myService = null;
        private final Set<String> myInvalidPaths = Collections.synchronizedSet(new HashSet());
        private final Runnable myCallback;
        private final Collection<String> myPaths;

        FilePathChecker(Runnable callback2, Collection<String> paths) {
            this.myCallback = callback2;
            this.myPaths = paths;
            MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
            connection.subscribe(ApplicationActivationListener.TOPIC, (Object)this);
            connection.subscribe(PowerSaveMode.TOPIC, (Object)this);
            this.onAppStateChanged();
        }

        boolean isValid(String path) {
            return !this.myInvalidPaths.contains(path);
        }

        public void applicationActivated(@NotNull IdeFrame ideFrame) {
            if (ideFrame == null) {
                FilePathChecker.$$$reportNull$$$0(0);
            }
            this.onAppStateChanged();
        }

        public void delayedApplicationDeactivated(@NotNull Window ideFrame) {
            if (ideFrame == null) {
                FilePathChecker.$$$reportNull$$$0(1);
            }
            this.onAppStateChanged();
        }

        public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
            if (ideFrame == null) {
                FilePathChecker.$$$reportNull$$$0(2);
            }
        }

        public void powerSaveStateChanged() {
            this.onAppStateChanged();
        }

        private void onAppStateChanged() {
            boolean everythingIsOK;
            boolean settingsAreOK = Registry.is((String)"autocheck.availability.welcome.screen.projects") && !PowerSaveMode.isEnabled();
            boolean bl = everythingIsOK = settingsAreOK && ApplicationManager.getApplication().isActive();
            if (this.myService == null && everythingIsOK) {
                this.myService = AppExecutorUtil.createBoundedScheduledExecutorService((String)"CheckRecentProjectPaths Service", (int)2);
                for (String path : this.myPaths) {
                    this.scheduleCheck(path, 0L);
                }
                ApplicationManager.getApplication().invokeLater(this.myCallback);
            }
            if (this.myService != null && !everythingIsOK) {
                if (!settingsAreOK) {
                    this.myInvalidPaths.clear();
                }
                if (!this.myService.isShutdown()) {
                    this.myService.shutdown();
                    this.myService = null;
                }
                ApplicationManager.getApplication().invokeLater(this.myCallback);
            }
        }

        public void dispose() {
            if (this.myService != null) {
                this.myService.shutdownNow();
            }
        }

        private void scheduleCheck(String path, long delay) {
            if (this.myService == null || this.myService.isShutdown()) {
                return;
            }
            this.myService.schedule(() -> {
                boolean pathIsValid;
                long startTime = System.currentTimeMillis();
                try {
                    pathIsValid = !RecentProjectsManagerBase.isFileSystemPath(path) || RecentProjectPanel.isPathAvailable(path);
                }
                catch (Exception e) {
                    pathIsValid = false;
                }
                if (this.myInvalidPaths.contains(path) == pathIsValid) {
                    if (pathIsValid) {
                        this.myInvalidPaths.remove(path);
                    } else {
                        this.myInvalidPaths.add(path);
                    }
                    ApplicationManager.getApplication().invokeLater(this.myCallback);
                }
                this.scheduleCheck(path, Math.max(2500L, 10L * (System.currentTimeMillis() - startTime)));
            }, delay, TimeUnit.MILLISECONDS);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "ideFrame";
            objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/RecentProjectPanel$FilePathChecker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applicationActivated";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "delayedApplicationDeactivated";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applicationDeactivated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class RecentProjectItemRenderer
    extends JPanel
    implements ListCellRenderer<AnAction> {
        protected final JLabel myName;
        protected final JLabel myPath;
        protected boolean myHovered;

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
        protected RecentProjectItemRenderer(UniqueNameBuilder<ReopenProjectAction> pathShortener) {
            this();
        }

        protected RecentProjectItemRenderer() {
            super((LayoutManager)new VerticalFlowLayout());
            this.myName = new JLabel();
            this.myPath = new JLabel();
            this.myPath.setFont((Font)JBUI.Fonts.label((float)(SystemInfo.isMac ? 10.0f : 11.0f)));
            this.setFocusable(true);
            this.layoutComponents();
        }

        protected void layoutComponents() {
            this.add(this.myName);
            this.add(this.myPath);
        }

        protected Color getListBackground(boolean isSelected, boolean hasFocus) {
            return UIUtil.getListBackground((boolean)isSelected, (boolean)true);
        }

        protected Color getListForeground(boolean isSelected, boolean hasFocus) {
            return UIUtil.getListForeground((boolean)isSelected, (boolean)true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends AnAction> list2, AnAction value2, int index, boolean selected2, boolean focused) {
            this.myHovered = RecentProjectPanel.this.myHoverIndex == index;
            Color fore = this.getListForeground(selected2, list2.hasFocus());
            Color back = this.getListBackground(selected2, list2.hasFocus());
            this.myName.setForeground(fore);
            this.myPath.setForeground(selected2 ? fore : UIUtil.getInactiveTextColor());
            this.setBackground(back);
            if (value2 instanceof ReopenProjectAction) {
                ReopenProjectAction item = (ReopenProjectAction)value2;
                this.myName.setText(item.getTemplatePresentation().getText());
                this.myPath.setText(this.getTitle2Text(item, this.myPath, JBUIScale.scale((int)40)));
            } else if (value2 instanceof ProjectGroupActionGroup) {
                ProjectGroupActionGroup group = (ProjectGroupActionGroup)value2;
                this.myName.setText(group.getGroup().getName());
                this.myPath.setText("");
            }
            AccessibleContextUtil.setCombinedName((Component)this, (Component)this.myName, (String)" - ", (Component)this.myPath);
            AccessibleContextUtil.setCombinedDescription((Component)this, (Component)this.myName, (String)" - ", (Component)this.myPath);
            return this;
        }

        protected String getTitle2Text(ReopenProjectAction action2, JComponent pathLabel, int leftOffset) {
            String fullText = action2.getProjectPath();
            if (fullText == null || fullText.length() == 0) {
                return " ";
            }
            fullText = FileUtil.getLocationRelativeToUserHome((String)PathUtil.toSystemDependentName((String)fullText), (boolean)false);
            try {
                FontMetrics fm = pathLabel.getFontMetrics(pathLabel.getFont());
                int maxWidth = RecentProjectPanel.this.getWidth() - leftOffset - (int)ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.getWidth() - JBUIScale.scale((int)10);
                if (maxWidth > 0 && fm.stringWidth(fullText) > maxWidth) {
                    return this.truncateDescription(fullText, fm, maxWidth, this.isTutorial(action2));
                }
            }
            catch (Exception e) {
                LOG.error("Path label font: " + pathLabel.getFont());
                LOG.error("Panel width: " + RecentProjectPanel.this.getWidth());
                LOG.error((Throwable)e);
            }
            return fullText;
        }

        private boolean isTutorial(ReopenProjectAction action2) {
            List groups = RecentProjectsManager.getInstance().getGroups();
            for (ProjectGroup group : groups) {
                if (!group.isTutorials()) continue;
                for (String project : group.getProjects()) {
                    if (!project.contains(action2.getProjectPath())) continue;
                    return true;
                }
            }
            return false;
        }

        @NotNull
        private String truncateDescription(String fullText, FontMetrics fm, int maxWidth, boolean isTutorial) {
            if (isTutorial) {
                String tutorialTruncated = fullText;
                while (fm.stringWidth(tutorialTruncated) > maxWidth) {
                    tutorialTruncated = tutorialTruncated.substring(0, tutorialTruncated.length() - 1);
                }
                String string = tutorialTruncated + "...";
                if (string == null) {
                    RecentProjectItemRenderer.$$$reportNull$$$0(0);
                }
                return string;
            }
            int left = 1;
            int right = 1;
            int center = fullText.length() / 2;
            String s = fullText.substring(0, center - left) + "..." + fullText.substring(center + right);
            while (fm.stringWidth(s) > maxWidth) {
                if (left == right) {
                    ++left;
                } else {
                    ++right;
                }
                if (center - left < 0 || center + right >= fullText.length()) {
                    return "";
                }
                s = fullText.substring(0, center - left) + "..." + fullText.substring(center + right);
            }
            String string = s;
            if (string == null) {
                RecentProjectItemRenderer.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.min(size.width, JBUIScale.scale((int)245)), size.height);
        }

        @Override
        @NotNull
        public Dimension getSize() {
            Dimension dimension = this.getPreferredSize();
            if (dimension == null) {
                RecentProjectItemRenderer.$$$reportNull$$$0(2);
            }
            return dimension;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/openapi/wm/impl/welcomeScreen/RecentProjectPanel$RecentProjectItemRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "truncateDescription";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSize";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private class MyList
    extends JBList<AnAction> {
        private final Dimension mySize;
        private Point myMousePoint;

        private MyList(@NotNull Dimension size, AnAction[] listData) {
            if (listData == null) {
                MyList.$$$reportNull$$$0(0);
            }
            super((Object[])listData);
            this.mySize = size;
            this.setExpandableItemsEnabled(false);
            this.setEmptyText(IdeBundle.message((String)"empty.text.no.project.open.yet", (Object[])new Object[0]));
            this.setSelectionMode(2);
            this.getAccessibleContext().setAccessibleName(RecentProjectPanel.RECENT_PROJECTS_LABEL);
            MouseHandler handler2 = new MouseHandler();
            this.addMouseListener(handler2);
            this.addMouseMotionListener(handler2);
        }

        public Rectangle getCloseIconRect(int index) {
            Rectangle bounds2 = this.getCellBounds(index, index);
            Icon icon2 = RecentProjectPanel.toSize(AllIcons.Welcome.Project.Remove);
            return new Rectangle(bounds2.width - icon2.getIconWidth() - JBUIScale.scale((int)10), bounds2.y + (bounds2.height - icon2.getIconHeight()) / 2, icon2.getIconWidth(), icon2.getIconHeight());
        }

        public void paint(Graphics g) {
            int index;
            super.paint(g);
            if (this.myMousePoint != null && (index = this.locationToIndex(this.myMousePoint)) != -1) {
                Rectangle iconRect = this.getCloseIconRect(index);
                Icon icon2 = RecentProjectPanel.toSize(iconRect.contains(this.myMousePoint) ? AllIcons.Welcome.Project.Remove_hover : AllIcons.Welcome.Project.Remove);
                icon2.paintIcon((Component)((Object)this), g, iconRect.x, iconRect.y);
            }
        }

        public String getToolTipText(MouseEvent event) {
            String path;
            boolean valid;
            Object elem;
            int i;
            int n = i = event != null ? this.locationToIndex(event.getPoint()) : -1;
            if (i != -1 && (elem = this.getModel().getElementAt(i)) instanceof ReopenProjectAction && (!(valid = RecentProjectPanel.this.isPathValid(path = ((ReopenProjectAction)((Object)elem)).getProjectPath())) || RecentProjectPanel.this.projectsWithLongPaths.contains(elem))) {
                String suffix = valid ? "" : " (unavailable)";
                return PathUtil.toSystemDependentName((String)path) + suffix;
            }
            return super.getToolTipText(event);
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.mySize == null ? super.getPreferredScrollableViewportSize() : this.mySize;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listData", "com/intellij/openapi/wm/impl/welcomeScreen/RecentProjectPanel$MyList", "<init>"));
        }

        class MouseHandler
        extends MouseAdapter {
            MouseHandler() {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                MyList.this.myMousePoint = e != null ? e.getPoint() : null;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MyList.this.myMousePoint = null;
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                MyList.this.myMousePoint = e != null ? e.getPoint() : null;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ProjectGroup group;
                int index;
                Point point = e != null ? e.getPoint() : null;
                int n = index = point != null ? MyList.this.locationToIndex(point) : -1;
                if (index == -1 || !MyList.this.getCloseIconRect(index).contains(point)) {
                    return;
                }
                e.consume();
                Object element2 = MyList.this.getModel().getElementAt(index);
                if (element2 instanceof ProjectGroupActionGroup && (group = ((ProjectGroupActionGroup)((Object)element2)).getGroup()).isTutorials()) {
                    this.removeTutorialChildren(group);
                }
                RecentProjectPanel.removeRecentProjectElement(element2);
                ListUtil.removeSelectedItems((JList)((Object)MyList.this));
            }

            private void removeTutorialChildren(ProjectGroup group) {
                int currentIndex = MyList.this.getSelectedIndex();
                List projects = group.getProjects();
                int[] childIndices = new int[projects.size()];
                for (int i = 0; i < projects.size(); ++i) {
                    childIndices[i] = currentIndex + 1;
                    ++currentIndex;
                }
                ListUtil.removeIndices((JList)((Object)MyList.this), (int[])childIndices);
                ApplicationManager.getApplication().invokeLater(() -> {
                    String title = "Tutorials have been removed from the recent list";
                    String content2 = "You can still find them in the Help menu";
                    Notifications.Bus.notify((Notification)new Notification(IdeBundle.message((String)"notification.group.tutorials", (Object[])new Object[0]), title, content2, NotificationType.INFORMATION));
                });
            }
        }
    }
}

