/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.util.EditorGotoLineNumberDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.BulkAwareDocumentListener;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.ui.UIBundle;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class PositionPanel
extends EditorBasedWidget
implements StatusBarWidget.Multiframe,
StatusBarWidget.TextPresentation,
CaretListener,
SelectionListener,
BulkAwareDocumentListener.Simple,
PropertyChangeListener {
    public static final Key<Object> DISABLE_FOR_EDITOR = new Key("positionPanel.disableForEditor");
    public static final String SPACE = "     ";
    public static final String SEPARATOR = ":";
    private static final int CHAR_COUNT_SYNC_LIMIT = 500000;
    private static final String CHAR_COUNT_UNKNOWN = "...";
    private Alarm myAlarm;
    private MergingUpdateQueue myQueue;
    private CodePointCountTask myCountTask;
    private String myText;

    public PositionPanel(@NotNull Project project) {
        if (project == null) {
            PositionPanel.$$$reportNull$$$0(0);
        }
        super(project);
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            PositionPanel.$$$reportNull$$$0(1);
        }
        this.updatePosition(this.getEditor());
    }

    @NotNull
    public String ID() {
        return "Position";
    }

    public StatusBarWidget copy() {
        return new PositionPanel(this.getProject());
    }

    public StatusBarWidget.WidgetPresentation getPresentation() {
        return this;
    }

    @NotNull
    public String getText() {
        String string = this.myText == null ? "" : this.myText;
        if (string == null) {
            PositionPanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    public float getAlignment() {
        return 0.5f;
    }

    public String getTooltipText() {
        String toolTip = UIBundle.message((String)"go.to.line.command.name", (Object[])new Object[0]);
        String shortcut = this.getShortcutText();
        if (!Registry.is((String)"ide.helptooltip.enabled") && StringUtil.isNotEmpty((String)shortcut)) {
            return toolTip + " (" + shortcut + ")";
        }
        return toolTip;
    }

    public String getShortcutText() {
        return KeymapUtil.getFirstKeyboardShortcutText((String)"GotoLine");
    }

    public Consumer<MouseEvent> getClickConsumer() {
        return mouseEvent -> {
            Project project = this.getProject();
            Editor editor = this.getFocusedEditor();
            if (editor == null) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(project, () -> {
                EditorGotoLineNumberDialog dialog2 = new EditorGotoLineNumberDialog(project, editor);
                dialog2.show();
                IdeDocumentHistory.getInstance(project).includeCurrentCommandAsNavigation();
            }, UIBundle.message((String)"go.to.line.command.name", (Object[])new Object[0]), null);
        };
    }

    @Override
    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            PositionPanel.$$$reportNull$$$0(3);
        }
        super.install(statusBar);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.myQueue = new MergingUpdateQueue("PositionPanel", 100, true, null, (Disposable)this);
        EditorEventMulticaster multicaster = EditorFactory.getInstance().getEventMulticaster();
        multicaster.addCaretListener((CaretListener)this, (Disposable)this);
        multicaster.addSelectionListener((SelectionListener)this, (Disposable)this);
        multicaster.addDocumentListener((DocumentListener)this, (Disposable)this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this);
        Disposer.register((Disposable)this, () -> KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this));
    }

    public void selectionChanged(@NotNull SelectionEvent e) {
        Editor editor;
        if (e == null) {
            PositionPanel.$$$reportNull$$$0(4);
        }
        if (this.isFocusedEditor(editor = e.getEditor())) {
            this.updatePosition(editor);
        }
    }

    public void caretPositionChanged(@NotNull CaretEvent e) {
        Editor editor;
        if (e == null) {
            PositionPanel.$$$reportNull$$$0(5);
        }
        if ((editor = e.getEditor()).getCaretModel().getCaretCount() == 1 && this.isFocusedEditor(editor)) {
            this.updatePosition(editor);
        }
    }

    public void caretAdded(@NotNull CaretEvent e) {
        if (e == null) {
            PositionPanel.$$$reportNull$$$0(6);
        }
        this.updatePosition(e.getEditor());
    }

    public void caretRemoved(@NotNull CaretEvent e) {
        if (e == null) {
            PositionPanel.$$$reportNull$$$0(7);
        }
        this.updatePosition(e.getEditor());
    }

    public void afterDocumentChange(@NotNull Document document) {
        Editor[] editors;
        if (document == null) {
            PositionPanel.$$$reportNull$$$0(8);
        }
        for (Editor editor : editors = EditorFactory.getInstance().getEditors(document)) {
            if (!this.isFocusedEditor(editor)) continue;
            this.updatePosition(editor);
            break;
        }
    }

    private boolean isFocusedEditor(Editor editor) {
        Component focusOwner = this.getFocusedComponent();
        return focusOwner == editor.getContentComponent();
    }

    private void updatePosition(Editor editor) {
        this.myQueue.queue(Update.create((Object)this, () -> {
            boolean empty;
            boolean bl = empty = editor == null || DISABLE_FOR_EDITOR.isIn((UserDataHolder)editor);
            if (!empty && !this.isOurEditor(editor)) {
                return;
            }
            String string = this.myText = empty ? "" : this.getPositionText(editor);
            if (this.myStatusBar != null) {
                this.myStatusBar.updateWidget(this.ID());
            }
        }));
    }

    private void updateTextWithCodePointCount(int codePointCount) {
        if (this.myText != null) {
            this.myText = this.myText.replace(CHAR_COUNT_UNKNOWN, Integer.toString(codePointCount));
            if (this.myStatusBar != null) {
                this.myStatusBar.updateWidget(this.ID());
            }
        }
    }

    private String getPositionText(@NotNull Editor editor) {
        if (editor == null) {
            PositionPanel.$$$reportNull$$$0(9);
        }
        this.myCountTask = null;
        if (!editor.isDisposed() && !this.myAlarm.isDisposed()) {
            StringBuilder message = new StringBuilder();
            SelectionModel selectionModel = editor.getSelectionModel();
            int caretCount = editor.getCaretModel().getCaretCount();
            if (caretCount > 1) {
                message.append(UIBundle.message((String)"position.panel.caret.count", (Object[])new Object[]{caretCount}));
            } else {
                if (selectionModel.hasSelection()) {
                    int selectionStart = selectionModel.getSelectionStart();
                    int selectionEnd = selectionModel.getSelectionEnd();
                    if (selectionEnd > selectionStart) {
                        CodePointCountTask countTask = new CodePointCountTask(editor.getDocument().getImmutableCharSequence(), selectionStart, selectionEnd);
                        if (countTask.isQuick()) {
                            int charCount = countTask.calculate();
                            message.append(charCount).append(' ').append(UIBundle.message((String)"position.panel.selected.chars.count", (Object[])new Object[]{charCount}));
                        } else {
                            message.append(CHAR_COUNT_UNKNOWN).append(' ').append(UIBundle.message((String)"position.panel.selected.chars.count", (Object[])new Object[]{2}));
                            this.myCountTask = countTask;
                            this.myAlarm.cancelAllRequests();
                            this.myAlarm.addRequest((Runnable)countTask, 0);
                        }
                        int selectionStartLine = editor.getDocument().getLineNumber(selectionStart);
                        int selectionEndLine = editor.getDocument().getLineNumber(selectionEnd);
                        if (selectionEndLine > selectionStartLine) {
                            message.append(", ");
                            message.append(UIBundle.message((String)"position.panel.selected.line.breaks.count", (Object[])new Object[]{selectionEndLine - selectionStartLine}));
                        }
                        message.append(SPACE);
                    }
                }
                LogicalPosition caret = editor.getCaretModel().getLogicalPosition();
                message.append(caret.line + 1).append(SEPARATOR).append(caret.column + 1);
            }
            return message.toString();
        }
        return "";
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.updatePosition(this.getFocusedEditor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/status/PositionPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/status/PositionPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectionChanged";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "caretPositionChanged";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "caretAdded";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "caretRemoved";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "afterDocumentChange";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPositionText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CodePointCountTask
    implements Runnable {
        private final CharSequence text;
        private final int startOffset;
        private final int endOffset;

        private CodePointCountTask(CharSequence text2, int startOffset, int endOffset) {
            this.text = text2;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        private boolean isQuick() {
            return this.endOffset - this.startOffset < 500000;
        }

        private int calculate() {
            return Character.codePointCount(this.text, this.startOffset, this.endOffset);
        }

        @Override
        public void run() {
            int count = this.calculate();
            SwingUtilities.invokeLater(() -> {
                if (this == PositionPanel.this.myCountTask) {
                    PositionPanel.this.updateTextWithCodePointCount(count);
                    PositionPanel.this.myCountTask = null;
                }
            });
        }
    }
}

