/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.WindowInfo;
import com.intellij.openapi.wm.impl.AnchoredButton;
import com.intellij.openapi.wm.impl.Stripe;
import com.intellij.openapi.wm.impl.StripeButtonUI;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowsPane;
import com.intellij.ui.MouseDragHelper;
import com.intellij.ui.PopupHandler;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StripeButton
extends AnchoredButton
implements DataProvider {
    private int myMnemonic;
    private boolean myPressedWhenSelected;
    private JLayeredPane myDragPane;
    private final ToolWindowsPane pane;
    final ToolWindowImpl toolWindow;
    private JLabel myDragButtonImage;
    private Point myPressedPoint;
    private Stripe myLastStripe;
    private KeyEventDispatcher myDragKeyEventDispatcher;
    private boolean myDragCancelled;

    StripeButton(@NotNull ToolWindowsPane pane2, final @NotNull ToolWindowImpl toolWindow) {
        if (pane2 == null) {
            StripeButton.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            StripeButton.$$$reportNull$$$0(1);
        }
        this.myDragCancelled = false;
        this.pane = pane2;
        this.toolWindow = toolWindow;
        this.setFocusable(false);
        this.setBorder((Border)JBUI.Borders.empty((int)5, (int)5, (int)0, (int)5));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String id2 = toolWindow.getId();
                if (StripeButton.this.myPressedWhenSelected) {
                    toolWindow.getToolWindowManager().hideToolWindow(id2, false);
                } else {
                    toolWindow.getToolWindowManager().activated$intellij_platform_ide_impl(toolWindow);
                }
                StripeButton.this.myPressedWhenSelected = false;
                FeatureUsageTracker.getInstance().triggerFeatureUsed("toolwindow.clickstat." + id2);
            }
        });
        this.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component component2, int x, int y) {
                StripeButton.this.showPopup(component2, x, y);
            }
        });
        this.setRolloverEnabled(true);
        this.setOpaque(false);
        this.enableEvents(16L);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                StripeButton.this.processDrag(e);
            }
        });
    }

    void init(@NotNull ToolWindowImpl toolWindow, @NotNull WindowInfo info) {
        if (toolWindow == null) {
            StripeButton.$$$reportNull$$$0(2);
        }
        if (info == null) {
            StripeButton.$$$reportNull$$$0(3);
        }
        this.updateState(toolWindow);
        this.updateText(toolWindow);
        this.updateIcon(toolWindow.getIcon());
        this.apply(info);
    }

    @NotNull
    public WindowInfo getWindowInfo() {
        WindowInfo windowInfo = this.toolWindow.getWindowInfo();
        if (windowInfo == null) {
            StripeButton.$$$reportNull$$$0(4);
        }
        return windowInfo;
    }

    @NotNull
    String getId() {
        String string = this.toolWindow.getId();
        if (string == null) {
            StripeButton.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            StripeButton.$$$reportNull$$$0(6);
        }
        if (PlatformDataKeys.TOOL_WINDOW.is(dataId)) {
            return this.toolWindow;
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.toolWindow.getToolWindowManager().getProject();
        }
        return null;
    }

    @Override
    public void setMnemonic(int mnemonic) {
        throw new UnsupportedOperationException("use setMnemonic2(int)");
    }

    private void setMnemonic2(int mnemonic) {
        this.myMnemonic = mnemonic;
        this.revalidate();
        this.repaint();
    }

    @Override
    public int getMnemonic2() {
        return this.myMnemonic;
    }

    @Override
    public ToolWindowAnchor getAnchor() {
        return this.toolWindow.getAnchor();
    }

    public boolean isFirst() {
        return this.is(true);
    }

    public boolean isLast() {
        return this.is(false);
    }

    private boolean is(boolean first) {
        Container parent = this.getParent();
        if (parent == null) {
            return false;
        }
        int max = first ? Integer.MAX_VALUE : 0;
        ToolWindowAnchor anchor2 = this.getAnchor();
        Component c = null;
        int count = parent.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component component2 = parent.getComponent(i);
            if (!component2.isVisible()) continue;
            Rectangle r = component2.getBounds();
            if (anchor2 == ToolWindowAnchor.LEFT || anchor2 == ToolWindowAnchor.RIGHT) {
                if ((!first || max <= r.y) && (first || max >= r.y)) continue;
                max = r.y;
                c = component2;
                continue;
            }
            if ((!first || max <= r.x) && (first || max >= r.x)) continue;
            max = r.x;
            c = component2;
        }
        return c == this;
    }

    private void processDrag(MouseEvent e) {
        if (this.myDragCancelled || !MouseDragHelper.checkModifiers((InputEvent)e)) {
            return;
        }
        if (!this.isDraggingNow()) {
            if (this.myPressedPoint == null || this.isWithinDeadZone(e)) {
                return;
            }
            this.myDragPane = StripeButton.findLayeredPane(e);
            if (this.myDragPane == null) {
                return;
            }
            int width = this.getWidth() - 1;
            int height = this.getHeight() - 1;
            BufferedImage image = UIUtil.createImage((Component)e.getComponent(), (int)width, (int)height, (int)1);
            Graphics graphics = image.getGraphics();
            graphics.setColor(UIUtil.getBgFillColor((Component)this.getParent()));
            graphics.fillRect(0, 0, width, height);
            this.paint(graphics);
            graphics.dispose();
            this.myDragButtonImage = new JLabel((Icon)IconUtil.createImageIcon((Image)image)){

                @Override
                public String toString() {
                    return "Image for: " + StripeButton.this.toString();
                }
            };
            this.myDragButtonImage.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    StripeButton.this.finishDragging();
                    StripeButton.this.myPressedPoint = null;
                    StripeButton.this.myDragButtonImage = null;
                    super.mouseReleased(e);
                }
            });
            this.myDragPane.add((Component)this.myDragButtonImage, JLayeredPane.POPUP_LAYER);
            this.myDragButtonImage.setSize(this.myDragButtonImage.getPreferredSize());
            this.setVisible(false);
            this.pane.startDrag();
            this.myDragKeyEventDispatcher = new DragKeyEventDispatcher();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.myDragKeyEventDispatcher);
        }
        if (!this.isDraggingNow()) {
            return;
        }
        Point xy = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.myDragPane);
        if (this.myPressedPoint != null) {
            xy.x -= this.myPressedPoint.x;
            xy.y -= this.myPressedPoint.y;
        }
        this.myDragButtonImage.setLocation(xy);
        SwingUtilities.convertPointToScreen(xy, this.myDragPane);
        Stripe stripe = this.pane.getStripeFor(new Rectangle(xy, this.myDragButtonImage.getSize()), (Stripe)this.getParent());
        if (stripe == null) {
            if (this.myLastStripe != null) {
                this.myLastStripe.resetDrop();
            }
        } else {
            if (this.myLastStripe != null && this.myLastStripe != stripe) {
                this.myLastStripe.resetDrop();
            }
            stripe.processDropButton(this, this.myDragButtonImage, xy);
        }
        this.myLastStripe = stripe;
    }

    @NotNull
    public ToolWindowImpl getToolWindow() {
        ToolWindowImpl toolWindowImpl = this.toolWindow;
        if (toolWindowImpl == null) {
            StripeButton.$$$reportNull$$$0(7);
        }
        return toolWindowImpl;
    }

    private boolean isWithinDeadZone(MouseEvent e) {
        return Math.abs(this.myPressedPoint.x - e.getPoint().x) < 7 && Math.abs(this.myPressedPoint.y - e.getPoint().y) < 7;
    }

    @Nullable
    private static JLayeredPane findLayeredPane(MouseEvent e) {
        if (!(e.getComponent() instanceof JComponent)) {
            return null;
        }
        JRootPane root = ((JComponent)e.getComponent()).getRootPane();
        return root.getLayeredPane();
    }

    @Override
    protected void processMouseEvent(@NotNull MouseEvent e) {
        if (e == null) {
            StripeButton.$$$reportNull$$$0(8);
        }
        if (e.isPopupTrigger() && e.getComponent().isShowing()) {
            super.processMouseEvent(e);
            return;
        }
        if (UIUtil.isCloseClick((MouseEvent)e)) {
            this.toolWindow.getToolWindowManager().hideToolWindow(this.toolWindow.getId(), true);
            return;
        }
        if (e.getButton() == 1) {
            if (501 == e.getID()) {
                this.myPressedPoint = e.getPoint();
                this.myPressedWhenSelected = this.isSelected();
                this.myDragCancelled = false;
            } else if (502 == e.getID()) {
                this.finishDragging();
                this.myPressedPoint = null;
                this.myDragButtonImage = null;
            }
        }
        super.processMouseEvent(e);
    }

    void apply(@NotNull WindowInfo info) {
        if (info == null) {
            StripeButton.$$$reportNull$$$0(9);
        }
        this.setSelected(info.isVisible());
        this.updateState(this.toolWindow);
    }

    private void showPopup(@Nullable Component component2, int x, int y) {
        ActionGroup group = this.toolWindow.createPopupGroup();
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("ToolwindowPopup", group);
        popupMenu.getComponent().show(component2, x, y);
    }

    @Override
    public void updateUI() {
        this.setUI(StripeButtonUI.createUI(this));
        this.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
    }

    void updatePresentation() {
        this.updateState(this.toolWindow);
        this.updateText(this.toolWindow);
        this.updateIcon(this.toolWindow.getIcon());
    }

    void updateIcon(@Nullable Icon icon2) {
        this.setIcon(icon2);
        this.setDisabledIcon(icon2 == null ? null : IconLoader.getDisabledIcon((Icon)icon2));
    }

    private void updateText(@NotNull ToolWindowImpl toolWindow) {
        if (toolWindow == null) {
            StripeButton.$$$reportNull$$$0(10);
        }
        String text2 = toolWindow.getStripeTitle();
        if (UISettings.getInstance().getShowToolWindowsNumbers()) {
            String toolWindowId = toolWindow.getId();
            int mnemonic = ActivateToolWindowAction.getMnemonicForToolWindow(toolWindowId);
            if (mnemonic != -1) {
                text2 = (char)mnemonic + ": " + text2;
                this.setMnemonic2(mnemonic);
            } else {
                this.setMnemonic2(0);
            }
        }
        this.setText(text2);
    }

    private void updateState(@NotNull ToolWindowImpl toolWindow) {
        boolean toShow;
        if (toolWindow == null) {
            StripeButton.$$$reportNull$$$0(11);
        }
        boolean bl = toShow = toolWindow.isAvailable() || toolWindow.isPlaceholderMode();
        if (UISettings.getInstance().getAlwaysShowWindowsButton()) {
            this.setVisible(toolWindow.isShowStripeButton() || this.isSelected());
        } else {
            this.setVisible(toShow && (toolWindow.isShowStripeButton() || this.isSelected()));
        }
        this.setEnabled(toolWindow.isAvailable());
    }

    private boolean isDraggingNow() {
        return this.myDragButtonImage != null;
    }

    private void finishDragging() {
        if (!this.isDraggingNow()) {
            return;
        }
        this.myDragPane.remove(this.myDragButtonImage);
        this.myDragButtonImage = null;
        this.pane.stopDrag();
        this.myDragPane.repaint();
        this.setVisible(true);
        if (this.myLastStripe != null) {
            this.myLastStripe.finishDrop(this.toolWindow.getToolWindowManager());
            this.myLastStripe = null;
        }
        if (this.myDragKeyEventDispatcher != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.myDragKeyEventDispatcher);
            this.myDragKeyEventDispatcher = null;
        }
    }

    @Override
    public String toString() {
        return StringUtil.getShortName((String)this.getClass().getName()) + " text: " + this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pane";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/StripeButton";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/StripeButton";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindowInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processMouseEvent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class DragKeyEventDispatcher
    implements KeyEventDispatcher {
        private DragKeyEventDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (StripeButton.this.isDraggingNow() && e.getKeyCode() == 27 && e.getID() == 401) {
                StripeButton.this.myDragCancelled = true;
                StripeButton.this.finishDragging();
                return true;
            }
            return false;
        }
    }
}

