/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginRepositoryRequests;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.Urls;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginDownloader {
    private static final Logger LOG = Logger.getInstance(PluginDownloader.class);
    private static final String FILENAME = "filename=";
    private final PluginId myPluginId;
    private final String myPluginName;
    @Nullable
    private final String myProductCode;
    private final Date myReleaseDate;
    private final int myReleaseVersion;
    private final boolean myLicenseOptional;
    private final String myDescription;
    private final List<PluginId> myDepends;
    private final String myPluginUrl;
    private final BuildNumber myBuildNumber;
    private String myPluginVersion;
    private IdeaPluginDescriptor myDescriptor;
    private File myFile;
    private File myOldFile;
    private boolean myShownErrors;

    private PluginDownloader(@NotNull IdeaPluginDescriptor descriptor2, @NotNull String url, @Nullable BuildNumber buildNumber) {
        if (descriptor2 == null) {
            PluginDownloader.$$$reportNull$$$0(0);
        }
        if (url == null) {
            PluginDownloader.$$$reportNull$$$0(1);
        }
        this.myPluginId = descriptor2.getPluginId();
        this.myPluginName = descriptor2.getName();
        this.myProductCode = descriptor2.getProductCode();
        this.myReleaseDate = descriptor2.getReleaseDate();
        this.myReleaseVersion = descriptor2.getReleaseVersion();
        this.myLicenseOptional = descriptor2.isLicenseOptional();
        this.myDescription = descriptor2.getDescription();
        this.myDepends = descriptor2 instanceof PluginNode ? ((PluginNode)descriptor2).getDepends() : Arrays.asList(descriptor2.getDependentPluginIds());
        this.myPluginUrl = url;
        this.myBuildNumber = buildNumber;
        this.myPluginVersion = descriptor2.getVersion();
        this.myDescriptor = descriptor2;
    }

    @Deprecated
    @NotNull
    public String getPluginId() {
        String string = this.myPluginId.getIdString();
        if (string == null) {
            PluginDownloader.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public PluginId getId() {
        PluginId pluginId = this.myPluginId;
        if (pluginId == null) {
            PluginDownloader.$$$reportNull$$$0(3);
        }
        return pluginId;
    }

    public String getPluginVersion() {
        return this.myPluginVersion;
    }

    @NotNull
    public String getPluginName() {
        String string = this.myPluginName != null ? this.myPluginName : this.myPluginId.getIdString();
        if (string == null) {
            PluginDownloader.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public String getProductCode() {
        return this.myProductCode;
    }

    public Date getReleaseDate() {
        return this.myReleaseDate;
    }

    public int getReleaseVersion() {
        return this.myReleaseVersion;
    }

    public boolean isLicenseOptional() {
        return this.myLicenseOptional;
    }

    @Nullable
    public BuildNumber getBuildNumber() {
        return this.myBuildNumber;
    }

    @NotNull
    public IdeaPluginDescriptor getDescriptor() {
        IdeaPluginDescriptor ideaPluginDescriptor = this.myDescriptor;
        if (ideaPluginDescriptor == null) {
            PluginDownloader.$$$reportNull$$$0(5);
        }
        return ideaPluginDescriptor;
    }

    public File getFile() {
        return this.myFile;
    }

    public boolean isShownErrors() {
        return this.myShownErrors;
    }

    public boolean prepareToInstall(@NotNull ProgressIndicator indicator) throws IOException {
        if (indicator == null) {
            PluginDownloader.$$$reportNull$$$0(6);
        }
        return this.prepareToInstallAndLoadDescriptor(indicator) != null;
    }

    @Nullable
    public IdeaPluginDescriptorImpl prepareToInstallAndLoadDescriptor(@NotNull ProgressIndicator indicator) throws IOException {
        if (indicator == null) {
            PluginDownloader.$$$reportNull$$$0(7);
        }
        this.myShownErrors = false;
        if (this.myFile != null) {
            IdeaPluginDescriptorImpl actualDescriptor = PluginManager.loadDescriptorFromArtifact(this.myFile.toPath(), this.myBuildNumber);
            this.myDescriptor = actualDescriptor;
            return actualDescriptor;
        }
        IdeaPluginDescriptor descriptor2 = null;
        if (!Boolean.getBoolean("StartupWizardMode") && PluginManagerCore.isPluginInstalled(this.myPluginId)) {
            descriptor2 = PluginManagerCore.getPlugin(this.myPluginId);
            LOG.assertTrue(descriptor2 != null);
            if (this.myPluginVersion != null && PluginDownloader.compareVersionsSkipBrokenAndIncompatible(descriptor2, this.myPluginVersion) <= 0) {
                LOG.info("Plugin " + this.myPluginId + ": current version (max) " + this.myPluginVersion);
                return null;
            }
            this.myOldFile = descriptor2.isBundled() ? null : descriptor2.getPath();
        }
        String errorMessage = null;
        try {
            this.myFile = this.downloadPlugin(indicator);
        }
        catch (IOException ex) {
            this.myFile = null;
            LOG.warn((Throwable)ex);
            errorMessage = ex.getMessage();
        }
        if (this.myFile == null) {
            Application app = ApplicationManager.getApplication();
            if (app != null) {
                this.myShownErrors = true;
                if (errorMessage == null) {
                    errorMessage = IdeBundle.message((String)"unknown.error", (Object[])new Object[0]);
                }
                String text2 = IdeBundle.message((String)"error.plugin.was.not.installed", (Object[])new Object[]{this.getPluginName(), errorMessage});
                String title = IdeBundle.message((String)"title.failed.to.download", (Object[])new Object[0]);
                app.invokeLater(() -> Messages.showErrorDialog((String)text2, (String)title), ModalityState.any());
            }
            return null;
        }
        IdeaPluginDescriptorImpl actualDescriptor = PluginManager.loadDescriptorFromArtifact(this.myFile.toPath(), this.myBuildNumber);
        if (actualDescriptor != null) {
            InstalledPluginsState state = InstalledPluginsState.getInstanceIfLoaded();
            if (state != null && state.wasUpdated(actualDescriptor.getPluginId())) {
                return null;
            }
            this.myPluginVersion = actualDescriptor.getVersion();
            if (descriptor2 != null && PluginDownloader.compareVersionsSkipBrokenAndIncompatible(descriptor2, this.myPluginVersion) <= 0) {
                LOG.info("Plugin " + this.myPluginId + ": current version (max) " + this.myPluginVersion);
                return null;
            }
            this.myDescriptor = actualDescriptor;
            if (PluginManagerCore.isIncompatible(actualDescriptor, this.myBuildNumber)) {
                LOG.info("Plugin " + this.myPluginId + " is incompatible with current installation (since:" + actualDescriptor.getSinceBuild() + " until:" + actualDescriptor.getUntilBuild() + ")");
                return null;
            }
        }
        return actualDescriptor;
    }

    public static int compareVersionsSkipBrokenAndIncompatible(@NotNull IdeaPluginDescriptor existingPlugin, String newPluginVersion) {
        int state;
        if (existingPlugin == null) {
            PluginDownloader.$$$reportNull$$$0(8);
        }
        if ((state = PluginDownloader.comparePluginVersions(newPluginVersion, existingPlugin.getVersion())) < 0 && (PluginManagerCore.isBrokenPlugin(existingPlugin) || PluginManagerCore.isIncompatible(existingPlugin))) {
            state = 1;
        }
        return state;
    }

    public static int comparePluginVersions(String newPluginVersion, String oldPluginVersion) {
        return VersionComparatorUtil.compare((String)newPluginVersion, (String)oldPluginVersion);
    }

    public void install() throws IOException {
        if (this.myFile == null) {
            throw new IOException("Plugin '" + this.getPluginName() + "' was not successfully downloaded");
        }
        PluginInstaller.installAfterRestart(this.myFile, true, this.myOldFile, this.myDescriptor);
        InstalledPluginsState state = InstalledPluginsState.getInstanceIfLoaded();
        if (state != null) {
            state.onPluginInstall(this.myDescriptor, PluginManagerCore.isPluginInstalled(this.myDescriptor.getPluginId()), true);
        } else {
            InstalledPluginsState.addPreInstalledPlugin(this.myDescriptor);
        }
    }

    public boolean tryInstallWithoutRestart(@Nullable JComponent ownerComponent) {
        IdeaPluginDescriptorImpl descriptorImpl = (IdeaPluginDescriptorImpl)this.myDescriptor;
        if (!DynamicPlugins.allowLoadUnloadWithoutRestart(descriptorImpl)) {
            return false;
        }
        if (this.myOldFile != null) {
            IdeaPluginDescriptor installedPlugin = PluginManagerCore.getPlugin(this.myDescriptor.getPluginId());
            if (installedPlugin == null) {
                return false;
            }
            IdeaPluginDescriptorImpl installedPluginDescriptor = PluginEnabler.tryLoadFullDescriptor((IdeaPluginDescriptorImpl)installedPlugin);
            if (installedPluginDescriptor == null || !DynamicPlugins.unloadPlugin(installedPluginDescriptor)) {
                return false;
            }
        }
        PluginInstaller.installAndLoadDynamicPlugin(this.myFile, ownerComponent, descriptorImpl);
        return true;
    }

    @NotNull
    private File downloadPlugin(@NotNull ProgressIndicator indicator) throws IOException {
        File pluginsTemp;
        if (indicator == null) {
            PluginDownloader.$$$reportNull$$$0(9);
        }
        if (!(pluginsTemp = new File(PathManager.getPluginTempPath())).exists() && !pluginsTemp.mkdirs()) {
            throw new IOException(IdeBundle.message((String)"error.cannot.create.temp.dir", (Object[])new Object[]{pluginsTemp}));
        }
        indicator.checkCanceled();
        indicator.setText2(IdeBundle.message((String)"progress.downloading.plugin", (Object[])new Object[]{this.getPluginName()}));
        File file2 = FileUtil.createTempFile((File)pluginsTemp, (String)"plugin_", (String)"_download", (boolean)true, (boolean)false);
        File file3 = (File)HttpRequests.request((String)this.myPluginUrl).gzip(false).productNameAsUserAgent().connect(request2 -> {
            request2.saveToFile(file2, indicator);
            String fileName = this.guessFileName(request2.getConnection(), file2);
            File newFile = new File(file2.getParentFile(), fileName);
            FileUtil.rename((File)file2, (File)newFile);
            return newFile;
        });
        if (file3 == null) {
            PluginDownloader.$$$reportNull$$$0(10);
        }
        return file3;
    }

    @NotNull
    private String guessFileName(@NotNull URLConnection connection, @NotNull File file2) throws IOException {
        if (connection == null) {
            PluginDownloader.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            PluginDownloader.$$$reportNull$$$0(12);
        }
        String fileName = null;
        String contentDisposition = connection.getHeaderField("Content-Disposition");
        LOG.debug("header: " + contentDisposition);
        if (contentDisposition != null && contentDisposition.contains(FILENAME)) {
            int startIdx = contentDisposition.indexOf(FILENAME);
            int endIdx = contentDisposition.indexOf(59, startIdx);
            fileName = contentDisposition.substring(startIdx + FILENAME.length(), endIdx > 0 ? endIdx : contentDisposition.length());
            if (StringUtil.startsWithChar((CharSequence)fileName, (char)'\"') && StringUtil.endsWithChar((CharSequence)fileName, (char)'\"')) {
                fileName = fileName.substring(1, fileName.length() - 1);
            }
        }
        if (fileName == null) {
            String usedURL = connection.getURL().toString();
            LOG.debug("url: " + usedURL);
            fileName = usedURL.substring(usedURL.lastIndexOf(47) + 1);
            if (fileName.length() == 0 || fileName.contains("?")) {
                fileName = this.myPluginUrl.substring(this.myPluginUrl.lastIndexOf(47) + 1);
            }
        }
        if (!PathUtil.isValidFileName(fileName)) {
            LOG.debug("fileName: " + fileName);
            FileUtil.delete((File)file2);
            throw new IOException("Invalid filename returned by a server");
        }
        String string = fileName;
        if (string == null) {
            PluginDownloader.$$$reportNull$$$0(13);
        }
        return string;
    }

    public static PluginDownloader createDownloader(@NotNull IdeaPluginDescriptor descriptor2) throws IOException {
        if (descriptor2 == null) {
            PluginDownloader.$$$reportNull$$$0(14);
        }
        return PluginDownloader.createDownloader(descriptor2, null, null);
    }

    @NotNull
    public static PluginDownloader createDownloader(@NotNull IdeaPluginDescriptor descriptor2, @Nullable String host, @Nullable BuildNumber buildNumber) throws IOException {
        String url;
        if (descriptor2 == null) {
            PluginDownloader.$$$reportNull$$$0(15);
        }
        try {
            if (host != null && descriptor2 instanceof PluginNode) {
                url = ((PluginNode)descriptor2).getDownloadUrl();
                if (!new URI(url).isAbsolute()) {
                    url = new URL(new URL(host), url).toExternalForm();
                }
            } else {
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("id", descriptor2.getPluginId().getIdString());
                parameters.put("build", PluginDownloader.getBuildNumberForDownload(buildNumber));
                parameters.put("uuid", PermanentInstallationID.get());
                url = Urls.newFromEncoded((String)ApplicationInfoImpl.getShadowInstance().getPluginsDownloadUrl()).addParameters(parameters).toExternalForm();
            }
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        return new PluginDownloader(descriptor2, url, buildNumber);
    }

    @NotNull
    public static String getBuildNumberForDownload(@Nullable BuildNumber buildNumber) {
        String string = buildNumber != null ? buildNumber.asString() : PluginRepositoryRequests.getBuildForPluginRepositoryRequests();
        if (string == null) {
            PluginDownloader.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public static PluginNode createPluginNode(@Nullable String host, @NotNull PluginDownloader downloader) {
        IdeaPluginDescriptor descriptor2;
        if (downloader == null) {
            PluginDownloader.$$$reportNull$$$0(17);
        }
        if ((descriptor2 = downloader.getDescriptor()) instanceof PluginNode) {
            PluginNode pluginNode = (PluginNode)descriptor2;
            if (pluginNode == null) {
                PluginDownloader.$$$reportNull$$$0(18);
            }
            return pluginNode;
        }
        PluginNode node = new PluginNode(downloader.myPluginId);
        node.setName(downloader.getPluginName());
        node.setProductCode(downloader.getProductCode());
        node.setReleaseDate(downloader.getReleaseDate());
        node.setReleaseVersion(downloader.getReleaseVersion());
        node.setLicenseOptional(downloader.isLicenseOptional());
        node.setVersion(downloader.getPluginVersion());
        node.setRepositoryName(host);
        node.setDownloadUrl(downloader.myPluginUrl);
        node.setDepends(downloader.myDepends, null);
        node.setDescription(downloader.myDescription);
        PluginNode pluginNode = node;
        if (pluginNode == null) {
            PluginDownloader.$$$reportNull$$$0(19);
        }
        return pluginNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/PluginDownloader";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingPlugin";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/PluginDownloader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "downloadPlugin";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "guessFileName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildNumberForDownload";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluginNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 19: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "prepareToInstall";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "prepareToInstallAndLoadDescriptor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compareVersionsSkipBrokenAndIncompatible";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "downloadPlugin";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "guessFileName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createDownloader";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createPluginNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

